/*
 * $Id:MandelbrotFractalConfigElementXMLExporter.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.fractal;

import net.sf.jame.core.xml.XMLExportException;
import net.sf.jame.core.xml.XMLExporter;
import net.sf.jame.core.xml.XMLNodeBuilder;
import net.sf.jame.mandelbrot.fractal.incolouring.IncolouringFormulaConfigElementXMLExporter;
import net.sf.jame.mandelbrot.fractal.outcolouring.OutcolouringFormulaConfigElementXMLExporter;
import net.sf.jame.mandelbrot.fractal.rendering.RenderingFormulaConfigElementXMLExporter;
import net.sf.jame.mandelbrot.fractal.transforming.TransformingFormulaConfigElementXMLExporter;

import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public class MandelbrotFractalConfigElementXMLExporter extends XMLExporter<MandelbrotFractalConfigElement> {
	/**
	 * @see net.sf.jame.core.xml.XMLExporter#exportToElement(java.lang.Object, net.sf.jame.core.xml.XMLNodeBuilder)
	 */
	@Override
	public Element exportToElement(final MandelbrotFractalConfigElement configElement, final XMLNodeBuilder builder) throws XMLExportException {
		final Element element = this.createElement(builder, MandelbrotFractalConfigElement.CLASS_ID);
		exportProperties(configElement, element, builder);
		return element;
	}

	/**
	 * @param configElement
	 * @param element
	 * @param builder
	 * @throws XMLExportException
	 */
	protected void exportProperties(final MandelbrotFractalConfigElement configElement, final Element element, final XMLNodeBuilder builder) throws XMLExportException {
		exportRenderingFormula(configElement, createProperty(builder, element, "renderingFormula"), builder);
		exportTransformingFormula(configElement, createProperty(builder, element, "transformingFormula"), builder);
		exportIncolouringFormulas(configElement, createProperty(builder, element, "incolouringFormulaList"), builder);
		exportOutcolouringFormulas(configElement, createProperty(builder, element, "outcolouringFormulaList"), builder);
	}

	/**
	 * @param configElement
	 * @param element
	 * @param builder
	 * @throws XMLExportException
	 */
	protected void exportRenderingFormula(final MandelbrotFractalConfigElement configElement, final Element element, final XMLNodeBuilder builder) throws XMLExportException {
		element.appendChild(new RenderingFormulaConfigElementXMLExporter().exportToElement(configElement.getRenderingFormulaConfigElement(), builder));
	}

	/**
	 * @param configElement
	 * @param element
	 * @param builder
	 * @throws XMLExportException
	 */
	protected void exportTransformingFormula(final MandelbrotFractalConfigElement configElement, final Element element, final XMLNodeBuilder builder) throws XMLExportException {
		element.appendChild(new TransformingFormulaConfigElementXMLExporter().exportToElement(configElement.getTransformingFormulaConfigElement(), builder));
	}

	/**
	 * @param configElement
	 * @param element
	 * @param builder
	 * @throws XMLExportException
	 */
	protected void exportIncolouringFormulas(final MandelbrotFractalConfigElement configElement, final Element element, final XMLNodeBuilder builder) throws XMLExportException {
		final IncolouringFormulaConfigElementXMLExporter filterExporter = new IncolouringFormulaConfigElementXMLExporter();
		for (int i = 0; i < configElement.getIncolouringFormulaConfigElementCount(); i++) {
			element.appendChild(filterExporter.exportToElement(configElement.getIncolouringFormulaConfigElement(i), builder));
		}
	}

	/**
	 * @param configElement
	 * @param element
	 * @param builder
	 * @throws XMLExportException
	 */
	protected void exportOutcolouringFormulas(final MandelbrotFractalConfigElement configElement, final Element element, final XMLNodeBuilder builder) throws XMLExportException {
		final OutcolouringFormulaConfigElementXMLExporter filterExporter = new OutcolouringFormulaConfigElementXMLExporter();
		for (int i = 0; i < configElement.getOutcolouringFormulaConfigElementCount(); i++) {
			element.appendChild(filterExporter.exportToElement(configElement.getOutcolouringFormulaConfigElement(i), builder));
		}
	}
}
