/*
 * $Id:Z5Runtime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.fractal.rendering;

import java.util.ArrayList;
import java.util.List;

import net.sf.jame.core.math.Complex;
import net.sf.jame.mandelbrot.renderer.RenderedPoint;

/**
 * @author Andrea Medeghini
 */
public class Z5Runtime extends AbstractRenderingFormulaRuntime<Z5Config> {
	private double ta;
	private double tb;
	private double tc;
	private double td;
	private double te;
	private double tf;

	/**
	 * @see net.sf.jame.mandelbrot.extensions.fractal.rendering.AbstractRenderingFormulaRuntime#isHorizontalSymetryAllowed()
	 */
	@Override
	public boolean isHorizontalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.extensions.fractal.rendering.AbstractRenderingFormulaRuntime#isVerticalSymetryAllowed()
	 */
	@Override
	public boolean isVerticalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.rendering.extension.RenderingFormulaExtensionRuntime#renderPoint(net.sf.jame.mandelbrot.renderer.RenderedPoint)
	 */
	@Override
	public int renderPoint(final RenderedPoint cp) {
		cp.time = 0;
		cp.zr = cp.xr;
		cp.zi = cp.xi;
		for (int k = 1; k <= iterations; k++) {
			ta = cp.zr * cp.zr;
			tb = cp.zi * cp.zi;
			tc = ta * cp.zr;
			td = tb * cp.zi;
			te = tc * cp.zr;
			tf = td * cp.zi;
			cp.zr = (te * cp.zr) - (10d * tc * tb) + (5d * cp.zr * tf) + cp.wr;
			cp.zi = (tf * cp.zi) - (10d * ta * td) + (5d * cp.zi * te) + cp.wi;
			tc = (cp.zr * cp.zr) + (cp.zi * cp.zi);
			if (tc > threshold) {
				cp.time = k;
				break;
			}
		}
		return cp.time;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.rendering.extension.RenderingFormulaExtensionRuntime#renderOrbit(net.sf.jame.mandelbrot.renderer.RenderedPoint)
	 */
	@Override
	public List<Complex> renderOrbit(final RenderedPoint cp) {
		final ArrayList<Complex> orbit = new ArrayList<Complex>();
		double ta = 0.0;
		double tb = 0.0;
		double tc = 0.0;
		double td = 0.0;
		double te = 0.0;
		double tf = 0.0;
		cp.zr = cp.xr;
		cp.zi = cp.xi;
		for (int k = 0; k < iterations; k++) {
			ta = cp.zr * cp.zr;
			tb = cp.zi * cp.zi;
			tc = ta * cp.zr;
			td = tb * cp.zi;
			te = tc * cp.zr;
			tf = td * cp.zi;
			cp.zr = (te * cp.zr) - (10d * tc * tb) + (5d * cp.zr * tf) + cp.wr;
			cp.zi = (tf * cp.zi) - (10d * ta * td) + (5d * cp.zi * te) + cp.wi;
			orbit.add(new Complex(cp.zr, cp.zi));
			tc = (cp.zr * cp.zr) + (cp.zi * cp.zi);
			if (tc > threshold) {
				break;
			}
		}
		return orbit;
	}
}
