/*
 * $Id:Launcher.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2007 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.launcher;

import java.lang.management.ManagementFactory;

import org.apache.log4j.Logger;

import net.sf.jame.runtime.LauncherContext;
import net.sf.jame.runtime.LauncherThreadFactory;

/**
 * @author Andrea Medeghini
 */
public class Launcher<T extends LauncherContext> {
	private static final Logger logger = Logger.getLogger(Launcher.class);
	private final LauncherThreadFactory<T> factory;
	private T context;
	private boolean running;
	private boolean restart;

	/**
	 * @param context
	 * @param factory
	 */
	public Launcher(final T context, final LauncherThreadFactory<T> factory) {
		this.context = context;
		this.factory = factory;
	}

	/**
	 * @throws Exception
	 */
	public void init() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void start() throws Exception {
		running = true;
		final String version = ManagementFactory.getRuntimeMXBean().getVmVersion();
		if (version.length() > 2  && "1.5".compareTo(version.substring(0, 3)) > 0) {
			logger.error("Could not launch the application because it requires Java 1.5 or later!");
			stop();
		}
		else {
			final Thread thread = factory.createThread(context);
			thread.start();
		}
	}

	/**
	 * 
	 */
	public void stop() {
		synchronized (this) {
			running = false;
			notify();
		}
	}

	/**
	 * @return
	 */
	public boolean dispatch() {
		while (running) {
			synchronized (this) {
				try {
					wait();
				}
				catch (final InterruptedException e) {
				}
			}
		}
		return restart;
	}

	/**
	 * 
	 */
	public void dispose() {
		context = null;
	}

	/**
	 * 
	 */
	public void restart() {
		restart = true;
		stop();
	}
}
