/*
 * $Id:Resources.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.core.util;

import java.util.ResourceBundle;

/**
 * Resource bundle wrapper.
 * 
 * @author Andrea Medeghini
 */
public class Resources {
	private final ResourceBundle bundle;

	/**
	 * Constructs a new instance.
	 * 
	 * @param bundle the bundle.
	 */
	public Resources(final ResourceBundle bundle) {
		this.bundle = bundle;
	}

	/**
	 * @see net.sf.jame.core.util.Resources#getString(java.lang.String)
	 */
	public String getString(final String key) {
		try {
			return bundle.getString(key);
		}
		catch (final Exception e) {
			return key;
		}
	}
}
