/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.peergroup.DefaultConfigurator;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.JxtaLoader;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;

public final class WorldPeerGroupFactory {
    private static final transient Logger LOG = Logger.getLogger(WorldPeerGroupFactory.class.getName());
    private final PeerGroup world;

    public WorldPeerGroupFactory() throws PeerGroupException {
        File jxta_home_dir;
        String jxta_home = System.getProperty("JXTA_HOME", ".jxta/");
        if (!jxta_home.endsWith(File.separator)) {
            jxta_home = jxta_home + File.separator;
        }
        if (!(jxta_home_dir = new File(jxta_home)).exists()) {
            jxta_home_dir.mkdirs();
        }
        URI storeHome = jxta_home_dir.toURI();
        try {
            DefaultConfigurator configurator = new DefaultConfigurator(storeHome);
            ConfigParams config = configurator.getConfigParams();
            this.world = this.newWorldPeerGroup(WorldPeerGroupFactory.getDefaultWorldPeerGroupClass(), config, storeHome);
            configurator.setConfigParams(config);
            configurator.save();
        }
        catch (ConfiguratorException configFailure) {
            LOG.severe("Failure while managing World Peer Group configuration");
            throw new PeerGroupException("Failure while managing World Peer Group configuration", configFailure);
        }
    }

    public WorldPeerGroupFactory(ConfigParams config, URI storeHome) throws PeerGroupException {
        this.world = this.newWorldPeerGroup(WorldPeerGroupFactory.getDefaultWorldPeerGroupClass(), config, storeHome);
    }

    public WorldPeerGroupFactory(Class worldPeerGroupClass, ConfigParams config, URI storeHome) throws PeerGroupException {
        this.world = this.newWorldPeerGroup(worldPeerGroupClass, config, storeHome);
    }

    public PeerGroup getInterface() {
        return (PeerGroup)this.world.getInterface();
    }

    public PeerGroup getWeakInterface() {
        return this.world.getWeakInterface();
    }

    private static Class getDefaultWorldPeerGroupClass() throws PeerGroupException {
        try {
            String unused = StdPeerGroup.STD_COMPAT.toString();
            JxtaLoader loader = GenericPeerGroup.getJxtaLoader();
            ModuleImplAdvertisement worldGroupImplAdv = loader.findModuleImplAdvertisement(PeerGroup.refPlatformSpecID);
            if (null == worldGroupImplAdv) {
                throw new PeerGroupException("Could not locate World PeerGroup Module Implementation.");
            }
            return Class.forName(worldGroupImplAdv.getCode());
        }
        catch (RuntimeException failed) {
            throw new PeerGroupException("Could not load World PeerGroup class.", failed);
        }
        catch (ClassNotFoundException failed) {
            throw new PeerGroupException("Could not load World PeerGroup class.", failed);
        }
    }

    private PeerGroup newWorldPeerGroup(Class worldPeerGroupClass, ConfigParams config, URI storeHome) throws PeerGroupException {
        if (!storeHome.isAbsolute()) {
            LOG.severe("storeHome must be an absolute URI.");
            throw new PeerGroupException("storeHome must be an absolute URI.");
        }
        if (storeHome.isOpaque()) {
            LOG.severe("Opaque storeHome is not currently supported.");
            throw new PeerGroupException("Opaque storeHome is not currently supported.");
        }
        PeerGroup.GlobalRegistry globalRegistry = PeerGroup.globalRegistry;
        synchronized (globalRegistry) {
            if (PeerGroup.globalRegistry.registeredInstance(PeerGroupID.worldPeerGroupID)) {
                throw new PeerGroupException("Only a single instance of the World Peer Group may be instantiated at a single time.");
            }
            PeerGroup result = null;
            try {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Making a new World Peer Group instance using : " + worldPeerGroupClass.getName());
                }
                Constructor twoParams = worldPeerGroupClass.getConstructor(ConfigParams.class, URI.class);
                try {
                    result = (PeerGroup)twoParams.newInstance(config, storeHome);
                }
                catch (InvocationTargetException failure) {
                    Throwable cause = failure.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw failure;
                }
                result.init(null, PeerGroupID.worldPeerGroupID, null);
                return result;
            }
            catch (RuntimeException e) {
                LOG.log(Level.SEVERE, "World Peer Group could not be instantiated.", e);
                if (null != result) {
                    result.unref();
                }
                throw e;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "World Peer Group could not be instantiated.", e);
                if (null != result) {
                    result.unref();
                }
                throw new PeerGroupException("World Peer Group could not be instantiated.", e);
            }
        }
    }
}

