/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.logging.Logging;
import net.jxta.pipe.OutputPipe;

public class OutgoingPipeAdaptor
implements Outgoing {
    private static final Logger LOG = Logger.getLogger(OutgoingPipeAdaptor.class.getName());
    private final OutputPipe pipe;
    private long lastAccessed = 0L;

    public OutgoingPipeAdaptor(OutputPipe pipe, int wsize) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe cannot be null.");
        }
        this.pipe = pipe;
        this.lastAccessed = TimeUtils.timeNow();
    }

    public String toString() {
        return this.pipe.toString() + " lastAccessed=" + Long.toString(this.lastAccessed);
    }

    public boolean send(Message msg) throws IOException {
        try {
            return this.pipe.send(msg);
        }
        catch (IOException ex) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to send message " + msg, ex);
            }
            return false;
        }
    }

    public void close() {
        this.pipe.close();
    }

    public long getMinIdleReconnectTime() {
        return 600000L;
    }

    public void setTimeout(int timeout) {
    }

    public long getIdleTimeout() {
        return Long.MAX_VALUE;
    }

    public long getMaxRetryAge() {
        return 120000L;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long time) {
        this.lastAccessed = time;
    }
}

