/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.PeerAdvertisement;

public class PeerAdv
extends PeerAdvertisement {
    private static final Logger LOG = Logger.getLogger(PeerAdv.class.getName());
    private static final String pidTag = "PID";
    private static final String gidTag = "GID";
    private static final String nameTag = "Name";
    private static final String descTag = "Desc";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String paramTag = "Parm";
    private static final String[] fields = new String[]{"Name", "PID"};

    private PeerAdv() {
    }

    private PeerAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PeerAdv.getAdvertisementType()) && !PeerAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (null == this.getPeerID()) {
            throw new IllegalArgumentException("Peer Advertisement did not contain a peer id.");
        }
        if (null == this.getPeerGroupID()) {
            throw new IllegalArgumentException("Peer Advertisement did not contain a peer group id.");
        }
    }

    public String getAdvType() {
        return PeerAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(pidTag)) {
            try {
                URI pID = new URI(elem.getTextValue());
                this.setPeerID((PeerID)IDFactory.fromURI(pID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(gidTag)) {
            try {
                URI gID = new URI(elem.getTextValue());
                this.setPeerGroupID((PeerGroupID)IDFactory.fromURI(gID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(nameTag)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(descTag)) {
            this.setDesc(elem);
            return true;
        }
        if (elem.getName().equals(svcTag)) {
            Enumeration elems = elem.getChildren();
            ModuleClassID classID = null;
            XMLElement param = null;
            while (elems.hasMoreElements()) {
                XMLElement e = (XMLElement)elems.nextElement();
                if (e.getName().equals(mcidTag)) {
                    try {
                        URI mcid = new URI(e.getTextValue());
                        classID = (ModuleClassID)IDFactory.fromURI(mcid);
                        continue;
                    }
                    catch (URISyntaxException badID) {
                        throw new IllegalArgumentException("Unusable ModuleClassID in advertisement: " + e.getTextValue());
                    }
                    catch (ClassCastException badID) {
                        throw new IllegalArgumentException("Id is not a ModuleClassID: " + e.getTextValue());
                    }
                }
                if (!e.getName().equals(paramTag)) continue;
                param = e;
            }
            if (classID != null && param != null) {
                this.putServiceParam(classID, param);
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument desc;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        PeerID peerID = this.getPeerID();
        if (null == peerID || ID.nullID.equals(peerID)) {
            throw new IllegalStateException("Cannot generate Peer Advertisement with no Peer ID!");
        }
        Object e = adv.createElement(pidTag, peerID.toString());
        adv.appendChild(e);
        PeerGroupID groupID = this.getPeerGroupID();
        if (null == groupID || ID.nullID.equals(groupID)) {
            throw new IllegalStateException("Cannot generate Peer Advertisement with no group ID!");
        }
        e = adv.createElement(gidTag, groupID.toString());
        adv.appendChild(e);
        if (this.getName() != null) {
            e = adv.createElement(nameTag, this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        Hashtable<ID, StructuredDocument> serviceParams = this.getServiceParams();
        Enumeration<ID> classIds = serviceParams.keys();
        while (classIds.hasMoreElements()) {
            ModuleClassID classId = (ModuleClassID)classIds.nextElement();
            Object s = adv.createElement(svcTag);
            adv.appendChild(s);
            e = adv.createElement(mcidTag, classId.toString());
            s.appendChild(e);
            e = serviceParams.get(classId);
            StructuredDocumentUtils.copyElements(adv, s, e, paramTag);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PeerAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PeerAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new PeerAdv((XMLElement)root);
        }
    }
}

