unit str;

interface

function stoi(s: string): longint;
function strupcase(s: string): string;
function scmp(s, s1: string): boolean;
function truncspace(str: string): string;
function truncstr(str: string): string;
function token(c: char; var s: string): string;

implementation

function stoi(s: string): longint;
var
  i: longint;
  {$IFDEF OS2}j: longint; {$ELSE}j: integer;{$ENDIF}
begin
  val(s, i, j);
  stoi:=i;
end;

function strupcase(s: string): string;
var
  i: integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  strupcase:=s;
end;

function scmp(s, s1: string): boolean;
begin
  if strupcase(s)=strupcase(s1) then
    scmp:=true else scmp:=false;
end;

function token(c: char; var s: string): string;
var tmp: string;
begin
  if (pos(c, s)<>0) then
    begin
      tmp:=copy(s, 1, pos(c, s)-1);
      delete(s, 1, pos(c, s));
    end else
    begin
      tmp:=copy(s, 1, length(s));
      delete(s, 1, length(s));
    end;
  token:=tmp;
end;

function truncspace(str: string): string;
var s: string;
begin
  while (str[1]=' ') and (length(str)>=1) do
    delete(str, 1, 1);
  if str = ' ' then str:='';
  truncspace:=str;
end;

function truncendspace(str: string): string;
var s: string;
begin
  while (str[length(str)]=' ') and (length(str)>=1) do
    delete(str, length(str), 1);
  if str = ' ' then str:='';
  truncendspace:=str;
end;

function truncstr(str: string): string;
begin
  str:=truncspace(str);
  str:=truncendspace(str);
  truncstr:=str;
end;

end.
