{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}

unit wishlist;

interface

uses crt, dos, overlay;

procedure add_request;
Procedure edit_request;
Procedure list_wishlist;
Procedure pack_wishlist(startpos:integer);
procedure delete_request;

implementation

uses common;

procedure add_request;
  var
    save:boolean;
    cmd,s:String;
    request1:String[70];
    rfile,rfile2:file of wishdat;
    i,j,p:Integer;
    Aa,Abort,Next:Boolean;
    r,request:wishdat;

  begin
    p:=0;
    j:=0;
    save:=TRUE;
    if exist (systat.gfilepath+'\WISHLIST.DAT') then
      begin
        assign(rfile,systat.gfilepath+'\WISHLIST.DAT');
        reset(rfile);
        assign(rfile2,systat.gfilepath+'\WISHLIST.TMP');
        rewrite(rfile2);
        nl;
        sprint(fstring.addwish);
        prt(': ');
        save:=TRUE;
        inputwc(request1,70);
        nl;
        if (request1='') then
          begin
            save:=FALSE;
            sprint(#3#7+'Aborted!');
            if (not save) then close(rfile);
          end;
        if (save) then
          begin
            sysoplog(#3#1+' '+#3#7+'Added request:');
            sysoplog(#3#4+'    '+request1);
            sprompt(#3#7+'Saving, please wait....');
            for i:=1 to 16 do
              begin
                sprompt(^H^H);
                sprompt(#3#7+'');
                sprompt(#3#0+'<');
                sprompt(^H' '^H); sprompt(^H' '^H);
              end;
            with request do
              begin
                name:=request1;
                from:=caps(thisuser.name);
                deleted:=false;
              end;
            i:=0;
            while not(eof(rfile)) do
              begin
                inc(i);
                seek(rfile,i);
              end;
            write(rfile,request);
            i:=i+1;
            if (filesize(rfile)>maxrequests) then
              begin
                sprompt(#3#7'Purging requests, please wait ... ');
                sprint(#3#7+'Done.');
                j:=(i-maxrequests)+4;
                i:=0;
                repeat
                  seek(rfile,j);
                  read(rfile,request);
                  if (not request.deleted) then
                    write(rfile2,request) else p:=p+1;
                  j:=j+1;
                until (eof(rfile));
                close(rfile); erase(rfile);
                close(rfile2);
                sprint(#3#7+'Done.');
                assign(rfile2,systat.gfilepath+'\WISHLIST.TMP');
                rename(rfile2,systat.gfilepath+'\WISHLIST.DAT');
                assign(rfile,systat.gfilepath+'\WISHLIST.DAT');
                reset(rfile);
                repeat
                  i:=i+1;
                  seek(rfile,i);
                until (eof(rfile));
                close(rfile);
              end
            else
              begin
                close(rfile);
                close(rfile2);
              end;
            lastcommandgood:=TRUE;
          end;
      end
    else
      begin
        nl;
        sprint(#3#7+'WISHLIST.DAT was NOT found!');
        nl;
      end;
End;

procedure edit_request;
  var rfile:file of wishdat;
      i,p,j:integer;
      done:boolean;
      s:string[70];
      c:char;
      request:wishdat;
      author:string[40];
      req_num:string[3];

  begin
    p:=-1;
    done:=false;
    nl;
    list_wishlist;
    nl;
    prt('Number of Request to edit: ');
    mpl(3);
    inu(p);
    assign(rfile,systat.gfilepath+'\wishlist.dat');
    reset(rfile);
    if (not badini) and (p in [1..filesize(rfile)]) then
      begin
        seek(rfile,p-1);
        read(rfile,request);
      end
    else
      begin
        sprint(#3#4+'*'+#3#0+' Invalid request.');
        done:=true;
      end;
    while (not done) and (not hangup) do
      begin
        if (thisuser.name=request.from) or (aacs(systat.sop)) then
          begin
            checkhangup;
            reset(rfile);
            seek(rfile,p-1);
            read(rfile,request);
            sprint(#3#9+'Request #'+cstr(p));
            nl;
            sprint(#3#4+'[1]. '+#3#3+'Filename'+#3#2+' : '+#3#0+caps(request.name));
            sprompt(#3#4+'[2]. '+#3#3+'Status'+#3#2+'   : ');
            if (request.deleted) then sprint(#3#8+'Uploaded')
              else sprint(#3#0+'Normal');
            if (aacs(systat.sop)) then sprint(#3#4+'[3]. '+#3#3+'From '+#3#2+'    : '+#3#0+caps(request.from));
            nl;
            if (aacs(systat.sop)) then prt('Enter Selection [1-3], [Q]uit : ')
              else prt('Enter Selection [1-2], [Q]uit : ');
            onek(c,'123Q'^M);
            case (upcase(c)) of
              '1':begin
                    nl;
                    sprint(#3#7+'Enter the program name you wish to request.  You may use color if you want.');
                    prt(': ');
                    mpl(70);
                    inputwc(s,70);
                    if (s<>'') then
                      begin
                        request.name:=s;
                        sysoplog('Changed request #'+cstr(p)+' to:');
                        sysoplog('  '+s);
                        reset(rfile);
                        seek(rfile,p-1);
                        write(rfile,request);
                      end
                    else sprint(#3#7+'Aborted.');
                    nl;
                  end;
              '2':begin
                    if (not(request.deleted)) then
                      begin
                        request.deleted:=true;
                        reset(rfile);
                        seek(rfile,p-1);
                        write(rfile,request);
                        sl1('Set "Upload" for request #'+cstr(p));
                      end
                    else
                      begin
                        request.deleted:=false;
                        reset(rfile);
                        seek(rfile,p-1);
                        write(rfile,request);
                        sl1('Unuploaded request #'+cstr(p));
                      end;
                  end;
              '3':begin
                    prt('Person who requested the file:');
                    mpl(36);
                    inputl(s,36);
                    if (s<>'') then
                      begin
                        sysoplog('Changed request #'+cstr(p)+'''s author from '+request.from+' to '+s);
                        request.from:=s;
                        reset(rfile);
                        seek(rfile,p-1);
                        write(rfile,request);
                      end
                    else
                      sprint(#3#1+'No change.');
                  end;
              'Q':done:=true;
              ^M:done:=true;
            end;
          end
        else
          begin
            sysoplog('Tried to edit request #'+cstr(p));
            sprint(#3#4+'* '+#3#0+'You didn''t write that request!');
            done:=true;
          end;
      end;
    close(rfile);
  end;

procedure list(i:integer);
  var rfile:file of wishdat;
      request:wishdat;
      p:integer;
      s:string;
      abort,next:boolean;

  begin
    abort:=false;
    next:=false;
    p:=1;
    assign(rfile,systat.gfilepath+'\wishlist.dat');
    reset(rfile);
    repeat
      seek(rfile,p-1);
      read(rfile,request);
      tc(3);
      if (not(request.deleted)) then s:=#3#5+mln(request.name,50)
      else s:=#3#5+mln(request.name+' - '+#3#7+'Uploaded',50);
      s:=s+#3#4+' ';
      if (not request.deleted) then s:=s+#3#0+mln(request.from,20);
      printacr(s,abort,next);
        p:=p+1;
    until (i+1=p);
    nl;
    close(rfile);
  end;

procedure pack_wishlist(startpos:integer);
  var p,i,actualrequests:integer;
      rfile:file of wishdat;    {Original WISHLIST.DAT}
      rfile2:file of wishdat;   {Second WISHLIST2.DAT}
      request:wishdat;           {Wish List Structure}

  begin
    nl;
    sprompt(#3#7'Purging requests, please wait ... ');
    i:=startpos;
    p:=0;
    assign(rfile,systat.gfilepath+'\wishlist.dat');
    assign(rfile2,systat.gfilepath+'\wishlist.tmp');
    rewrite(rfile2);
    reset(rfile);
    repeat
      seek(rfile,i);
      read(rfile,request);
      if (not request.deleted) then write(rfile2,request) else p:=p+1;
      i:=i+1;
    until eof(rfile);
    close(rfile); erase(rfile);
    close(rfile2);
    assign(rfile2,systat.gfilepath+'\wishlist.tmp');
    rename(rfile2,systat.gfilepath+'\wishlist.dat');
    sprint(#3#7+'Done.');
    nl;
  end;

procedure list_wishlist;
  var p,i:integer;
      s2n:string;
      rfile:file of wishdat;
      request:wishdat;

  begin
    if exist(systat.gfilepath+'\wishlist.dat') then
      begin
        redrawforansi;
        cls;
printf('wlist');
if (nofile) then begin
sprint(#27+'[0;1m');
sprint(#27+'[0;30;47m Genesis v1.2  File Request System                                        ');
sprint(#27+'[1;40m');
sprint(#3#4+'');
nl;
end;
        assign(rfile,systat.gfilepath+'\wishlist.dat');
        reset(rfile);
        i:=filesize(rfile);
        list(i);
        close(rfile);
      end;
  end;

procedure delete_request;
  var
    rfile,rfile2:file of wishdat;
    request:wishdat;
    b:byte;
    jobdone,ok:boolean;

  begin
    jobdone:=FALSE;
    ok:=FALSE;
    list_wishlist;
    sprompt(#3#4+'Number of the request you wish to delete: ');
    mpl(3);
    ini(b);
    if (badini) then ok:=FALSE else ok:=TRUE;
    assign(rfile,systat.gfilepath+'\wishlist.dat');
    reset(rfile);
    if ((ok) and (b in [1..(filesize(rfile))])) then
      begin
        seek(rfile,b-1);
        read(rfile,request);
        reset(rfile);
        if (thisuser.name=request.from) or (aacs(systat.sop)) then
          begin
            jobdone:=TRUE;
            sysoplog('Deleted request #'+cstr(b));
            assign(rfile2,systat.gfilepath+'\wishlist.tmp');
            rewrite(rfile2);
            while not eof(rfile) do
              begin
                if (filepos(rfile))<>b-1 then
                  begin
                    read(rfile,request);
                    write(rfile2,request);
                  end
                else seek(rfile,b);
              end;
            close(rfile);
            close(rfile2);
            assign(rfile,systat.gfilepath+'\wishlist.dat');
            erase(rfile);
            assign(rfile2,systat.gfilepath+'\wishlist.tmp');
            rename(rfile2,systat.gfilepath+'\wishlist.dat');
          end
        else
          begin
            sprint(#3#4+'*'+#3#0+' You didn''t write that request!');
            sysoplog('Tried to delete request #'+cstr(b));
          end;
      end
    else
      sprint(#3#4+'*'+#3#0+' Invalid request.');
    if not(jobdone) then close(rfile);
  end;

end.
