(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2Z .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "Z" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2z;

interface

uses
  crt, dos, overlay,
  cuser,
  common;

procedure pocolors;

implementation

procedure chatcolors;
  var s:astr;
      c,c1,c2:integer;
      ch:char;
      mcol,ocol:byte;
      ctyp,done,done1:boolean;

    function colo(n:integer):astr;
    begin
      case n of
        0:colo:='Black';
        1:colo:='Blue';
        2:colo:='Green';
        3:colo:='Cyan';
        4:colo:='Red';
        5:colo:='Magenta';
        6:colo:='Yellow';
        7:colo:='White';
      end;
    end;

    function dt(n:integer):astr;
    var s:astr;
    begin
      s:=colo(n and 7)+' on '+colo((n shr 4) and 7);
      if (n and 8)<>0 then s:=s+', High Intensity';
      if (n and 128)<>0 then s:=s+', Blinking';
      dt:=s;
    end;

    function stf(n:integer):astr;
    var s:astr;
    begin
      case n of
        1:s:='Color 1';
        2:s:='Color 2';
        3:s:='Color 3';
        4:s:='Color 4';
        5:s:='Color 5';
        6:s:='Color 6';
        7:s:='Color 7';
        8:s:='Color 8';
        9:s:='Color 9';
       10:s:='Color 10';
      end;
      stf:=cstr(n)+'. '+mln(s,20);
    end;

    procedure liststf;
    var c:integer;
    begin
      nl;
      for c:=1 to 9 do begin
        setc(7); prompt(stf(c));
        setc(systat.chatcols[ctyp][c]); print(dt(systat.chatcols[ctyp][c]));
      end;
    end;

  begin
    cls;
    ctyp:=true;
    setc(7);
    if (ctyp) then print('Set multiple chat colors.') else print('Set B&W colors.');
    ch:='?'; done:=FALSE;
    repeat
      case ch of
        'Q':done:=TRUE;
        'L':liststf;
        '0'..'9':begin
              nl; setc(7); print('Current:'); nl;
              c1:=value(ch);
              setc(7); prompt(stf(c1));
              setc(systat.chatcols[ctyp][c1]); print(dt(systat.chatcols[ctyp,c1]));
              nl; setc(7); print('Colors:'); nl;
              for c:=0 to 7 do begin
                setc(7); prompt(cstr(c)+'. '); setc(c); prompt(mln(colo(c),12));
                setc(7); prompt(mrn(cstr(c+8),2)+'. '); setc(c+8); print(mln(colo(c)+'!',9));
              end;
              ocol:=systat.chatcols[ctyp][c1]; nl;
              prt('Foreground: '); input(s,2);
              if (s='') then mcol:=ocol and 7 else mcol:=value(s);
              prt('Background: '); input(s,2);
              if (s='') then
                mcol:=mcol or (ocol and 112)
              else
                mcol:=mcol or (value(s) shl 4);
              if pynq('Blinking (No)? ') then mcol:=mcol or 128;
              nl; setc(7); prompt(stf(c1)); setc(mcol); print(dt(mcol)); nl;
              if pynq('Is this correct (No)? ') then systat.chatcols[ctyp][c1]:=mcol;
            end;
      end;
      if (not done) then begin
        nl; prt('Colors: (0-9) (L)ist (Q)uit :'); onek(ch,'QL0123456789');
      end;
    until done or hangup;
    done1:=TRUE;
  end;

procedure logoncolors;
  var s:astr;
      c,c1,c2:integer;
      ch:char;
      mcol,ocol:byte;
      ctyp,done,done1:boolean;

    function colo(n:integer):astr;
    begin
      case n of
        0:colo:='Black';
        1:colo:='Blue';
        2:colo:='Green';
        3:colo:='Cyan';
        4:colo:='Red';
        5:colo:='Magenta';
        6:colo:='Yellow';
        7:colo:='White';
      end;
    end;

    function dt(n:integer):astr;
    var s:astr;
    begin
      s:=colo(n and 7)+' on '+colo((n shr 4) and 7);
      if (n and 8)<>0 then s:=s+', High Intensity';
      if (n and 128)<>0 then s:=s+', Blinking';
      dt:=s;
    end;

    function stf(n:integer):astr;
    var s:astr;
    begin
      case n of
        0:s:='';
        1:s:='Alias';
        2:s:='Password';
        3:s:='Phone number';
        4:s:='System password';
        5:s:='Sysop password';
        6:s:='Msg Header';
        7:s:='SysOp Chat';
        8:s:='User Chat';
        9:s:='New User App.';
      end;
      stf:=cstr(n)+'. '+mln(s,20);
    end;

    procedure liststf;
    var c:integer;
    begin
      nl;
      for c:=1 to 9 do begin
        setc(7); prompt(stf(c));
        setc(systat.logoncols[ctyp][c]); print(dt(systat.logoncols[ctyp][c]));
      end;
    end;
  begin
    cls;
    ctyp:=true;
    setc(7);
    if (ctyp) then print('Set multiple Logon colors.') else print('Set B&W colors.');
    ch:='?'; done:=FALSE;
    repeat
      case ch of
        'Q':done:=TRUE;
        'L':liststf;
        '1'..'9':begin
              nl; setc(7); print('Current:'); nl;
              c1:=value(ch);
              setc(7); prompt(stf(c1));
              setc(systat.logoncols[ctyp][c1]); print(dt(systat.logoncols[ctyp,c1]));
              nl; setc(7); print('Colors:'); nl;
              for c:=0 to 7 do begin
                setc(7); prompt(cstr(c)+'. '); setc(c); prompt(mln(colo(c),12));
                setc(7); prompt(mrn(cstr(c+8),2)+'. '); setc(c+8); print(mln(colo(c)+'!',9));
              end;
              ocol:=systat.logoncols[ctyp][c1]; nl;
              prt('Foreground: '); input(s,2);
              if (s='') then mcol:=ocol and 7 else mcol:=value(s);
              prt('Background: '); input(s,2);
              if (s='') then
                mcol:=mcol or (ocol and 112)
              else
                mcol:=mcol or (value(s) shl 4);
              if pynq('Blinking (No)? ') then mcol:=mcol or 128;
              nl; setc(7); prompt(stf(c1)); setc(mcol); print(dt(mcol)); nl;
              if pynq('Is this correct (No)? ') then systat.logoncols[ctyp][c1]:=mcol;
            end;
      end;
      if (not done) then begin
        nl; prt('Colors: (1-9) (L)ist (Q)uit :'); onek(ch,'QL123456789');
      end;
    until done or hangup;
    done1:=TRUE;
  end;


procedure pocolors;
var u:userrec;
    c:char;
    done,col:boolean;
    counter:integer;
    temp:userrec;
begin
  reset(uf); seek(uf,0); read(uf,u); close(uf);
  col:=color in u.ac;
  done:=FALSE;
  repeat
    cls;
    sprint(#3#5+'Default color editor:');
    nl;
    print('A. Edit multiple System colors');
    print('B. Edit B&W colors');
    print('C. Edit multiple Chat colors');
    print('D. Edit multiple Logon colors');
    print('E. Mass user color change');
    nl;
    prt('Enter selection (A-E), [Q]uit : ');
    onek(c,'QABCDE');
    case c of
    'Q':done:=TRUE;
    'A':begin cls;
    u.ac:=u.ac+[color]; cstuff(21,3,u); end;
    'B':begin cls;
    u.ac:=u.ac-[color]; cstuff(21,3,u); end;
    'C':chatcolors;
    'D':logoncolors;
    'E':begin
            nl;
            if pynq('Change all user colors to default colors (No)?')
            then begin
            reset(uf);
            read(uf,u);
            thisuser.cols:=u.cols;
            for counter:=1 to filesize(uf)-1 do
                begin
                  seek(uf,counter);
                  read(uf,temp);
                  temp.cols:=u.cols;
                  seek(uf,counter);
                  write(uf,temp);
                end;
            end;
       end;
   end;
  until (done) or (hangup);
  if col then u.ac:=u.ac+[color] else u.ac:=u.ac-[color];
  reset(uf); seek(uf,0); write(uf,u); close(uf);
end;
end.
