{--------------------------------------------------------------------------}
{                         TechnoJock's Turbo Toolkit                       }
{                                                                          }
{                              Version   5.01                              }
{                                                                          }
{                                                                          }
{              Copyright 1986, 1989 TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                     {--------------------------------}
                     {       Unit:   WinTTT5          }
                     {--------------------------------}

{History:    03/05/89   5.00a  corrected Get_ScreenWord procedure
             04/01/89   5.01   added DOS errorlevel 10 on fatal
                               and corrected screen scroll
}

{$S-,R-,V-,D-}       

unit  WinTTT5;

interface

uses CRT,DOS,FastTTT5,KeyTTT5;

Type
 Direction = (Up, Down, Left, Right);
Const
    Shadow = 5;
Var
    Shadcolor    : byte;
    DisplayLines : byte;

Procedure MoveFromScreen(var Source,Dest;Length:Word);
Procedure MoveToScreen(var Source,Dest; Length:Word);
Procedure SizeCursor(Top,Bot:byte);
Procedure FindCursor(var X,Y,Top,Bot:byte);
Procedure PosCursor(X,Y: integer);
Procedure Fullcursor;
Procedure HalfCursor;
Procedure OnCursor;
Procedure OffCursor;
Procedure GotoXY(X,Y : byte);
Function  WhereX: byte;
Function  WhereY: byte;
Function  GetScreenChar(X,Y:byte):char;
Function  GetScreenAttr(X,Y:byte):byte;
Procedure GetScreenStr(X1,X2,Y:byte;var  St:StrScreen);
Procedure CreateScreen(Page:byte;Lines:byte);
Procedure SaveScreen(Page:byte);
Procedure RestoreScreen(Page:byte);
Procedure PartRestoreScreen(Page,X1,Y1,X2,Y2,X,Y:byte);
Procedure SlideRestoreScreen(Page:byte;Way:Direction);
Procedure PartSlideRestoreScreen(Page:byte;Way:Direction;X1,Y1,X2,Y2:byte);
Procedure DisposeScreen(Page:byte);
Procedure SetCondensedLines;
Procedure Set25Lines;
Procedure CopyScreenBlock(X1,Y1,X2,Y2,X,Y:byte);
Procedure MoveScreenBlock(X1,Y1,X2,Y2,X,Y:byte);
Procedure Scroll(Way:direction;X1,Y1,X2,Y2:byte);
Procedure PartSave(X1,Y1,X2,Y2:byte; VAR Dest);
Procedure PartRestore(X1,Y1,X2,Y2:byte; VAR Source);
Procedure Mkwin(x1,y1,x2,y2,F,B,boxtype:integer);
Procedure GrowMkwin(x1,y1,x2,y2,F,B,boxtype:integer);
Procedure Rmwin;
Procedure FillScreen(X1,Y1,X2,Y2:byte; F,B:byte; C:char);
Procedure TempMessageCh(X,Y,F,B:integer;St:strscreen;var Ch : char);
Procedure TempMessage(X,Y,F,B:integer;St:strscreen);
Procedure TempMessageBoxCh(X1,Y1,F,B,BoxType:integer;St:strscreen;var Ch : char);
Procedure TempMessageBox(X1,Y1,F,B,BoxType:integer;St:strscreen);
Procedure Activate_Visible_Screen;
Procedure Activate_Virtual_Screen(Page:byte);
Procedure Reset_StartUp_Mode;

Const
    Max_Windows = 10;          {Change this constant as necessary}
    Max_Screens = 10;          {Change this constant as necessary}
    WindowCounter : byte = 0;
    ScreenCounter : byte = 0;
    ActiveVScreen: byte = 0;

Type
    ScreenImage = record
                       CursorX : byte;
                       CursorY : byte;
                       ScanTop : byte;
                       ScanBot : byte;
                       SavedLines:byte;
                       ScreenPtr: pointer;
                  end;
    ScreenPtr = ^ScreenImage;
    WindowImage = record
                       ScreenPtr: Pointer;             {pointer to screen data}
                       Coord    : array[1..4] of byte; {window coords}
                       CursorX  : byte;                {cursor location}
                       CursorY  : byte;
                       ScanTop  : byte;                {cursor shape}
                       ScanBot  : byte;
                  end;
    WindowPtr = ^WindowImage;

Var
    Screen : array[1..Max_Screens] of ScreenPtr;
    Win    : array[1..Max_Windows] of WindowPtr;
    W_error: integer;     {Global error to report winTTT errors}
    W_fatal: boolean;

IMPLEMENTATION

CONST
    MonoAdr =$b000;
VAR
    StartTop,      {used to record initial screen state when program is run}
    StartBot   : Byte;
    StartMode  : word;

{$L WINTTT5}

{$F+}
  Procedure MoveFromScreen(var Source,Dest;Length:Word); external;
  Procedure MoveToScreen(var Source,Dest; Length:Word); external;
{$F-}

Procedure WinTTT_Error(No : byte);
{Updates W_error and optionally displays error message then halts program}
var Msg : String;
begin
    W_error := No;
    If W_fatal = true then
    begin
        Case No of
        1 :  Msg := 'Max screens exceeded';
        2 :  Msg := 'Max Windows Exceeded';
        3 :  Msg := 'Insufficient memory to create screen';
        4 :  Msg := 'Screen not saved cannot activate.';
        5 :  Msg := 'Screen has not been created - cannot activate';
        6 :  Msg := 'Screen has not been created - cannot dispose';
        7 :  Msg := 'Screen has not been created - cannot restore';
        8 :  Msg := 'Screen does not exist cannot clear';
        9 :  Msg := 'Insufficient memory for Screen Copy/Move';
        10:  Msg := 'Visible screen must be active for Window operations';
        11:  Msg := 'Visible screen must be active for Message operations';
        12:; {reserved for non-fatal error settings condensed mode}
        13:  Msg := 'Can only save 25 screen lines - check CONST SavedLines';
        else Msg := '?) -- Utterly confused';
        end; {Case}
        Msg := 'Fatal Error (WinTTT -- '+Msg;
        Writeln(Msg);
        Delay(5000);    {display long enough to read if child process}
        Halt(11);       {returns DOS ERRORLEVEL 11}
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                                                                     }
{     V I S I B L E    a n d    V I R T U A L  P R O C E D U R E S    }
{                                                                     }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure PartSave (X1,Y1,X2,Y2:byte; VAR Dest);
{transfers data from active virtual screen to Dest}
var
   I,width : byte;
   ScreenAdr: integer;
begin
    width := succ(X2- X1);
    For I :=  Y1 to Y2 do
    begin
     ScreenAdr := Vofs + Pred(I)*160 + Pred(X1)*2;
     MoveFromScreen(Mem[Vseg:ScreenAdr],
                    Mem[seg(Dest):ofs(dest)+(I-Y1)*width*2],
                    width);
    end;
end;

Procedure PartRestore (X1,Y1,X2,Y2:byte; VAR Source);
{restores data from Source and transfers to active virtual screen}
var
   I,width : byte;
   ScreenAdr: integer;
begin
    width := succ(X2- X1);
    For I :=  Y1 to Y2 do
    begin
     ScreenAdr := Vofs + Pred(I)*160 + Pred(X1)*2;
     MoveToScreen(Mem[Seg(Source):ofs(Source)+(I-Y1)*width*2],
                  Mem[Vseg:ScreenAdr],
                  width);
    end;
end;

Procedure FillScreen(X1,Y1,X2,Y2:byte; F,B:byte; C:char);
var
   I : integer;
   S : string;
begin
    W_error := 0;
    Attrib(X1,Y1,X2,Y2,F,B);
    S := Replicate(Succ(X2-x1),C);
    For I := Y1 to Y2 do
        PlainWrite(X1,I,S);
end;

Procedure GetScreenWord(X,Y:byte;var Attr:byte; var Ch : char);
{updates vars Attr and Ch with attribute and character bytes in screen
 location (X,Y) of the active screen}
Type
    ScreenWordRec = record
                         Ch   : char;   {5.00a}
                         Attr : byte;
                    end;
var
   ScreenAdr: integer;
   SW : ScreenWordRec;
begin
    ScreenAdr := Vofs + Pred(Y)*160 + Pred(X)*2;
    MoveFromScreen(Mem[Vseg:ScreenAdr],mem[seg(SW):ofs(SW)],1);
    Attr := SW.Attr;
    Ch   := SW.Ch;
end;

Function GetScreenChar(X,Y:byte):char;
var
   A : byte;
   C : char;
begin
    GetScreenWord(X,Y,A,C(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2C .PAS -  Written by Chris Hessing and David Heighton            <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "C" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2c;

interface

uses
  crt, dos, overlay,
  common;

procedure poslsettings;

implementation

function qq(s:string):string;
var ss:string[22];
begin
  ss:='"'+s+'"';
  if (length(ss)<16) then ss:=mln(ss,16);
  qq:=ss;
end;

procedure rc;
begin
     cl(1);
end;

procedure poslsettings;
var s:acstring;
    c:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System ACS settings'); rc;
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('A. Full SysOp         :'+qq(sop)+
               'B. Full Co-SysOp      :'+qq(csop),abort,next); rc;
      printacr('C. Message base SysOp :'+qq(msop)+
               'D. File base SysOp    :'+qq(fsop),abort,next); rc;
      printacr('E. SysOp PW at logon  :'+qq(spw)+
               'F. See PW''s remotely  :'+qq(seepw),abort,next); rc;
      printacr('G. Post public        :'+qq(normpubpost)+
               'H. Send e-mail        :'+qq(normprivpost),abort,next); rc;
      printacr('I. See anon pub post  :'+qq(anonpubread)+
               'J. See anon E-mail    :'+qq(anonprivread),abort,next); rc;
      printacr('K. Post anon ANY base :'+qq(anonpubpost)+
               'L. E-mail anon        :'+qq(anonprivpost),abort,next); rc;
      printacr('M. See unval. files   :'+qq(seeunval)+
               'N. DL unval. files    :'+qq(dlunval),abort,next); rc;
      printacr('O. No UL/DL ratio     :'+qq(nodlratio)+
               'P. No post/call ratio :'+qq(nopostratio),abort,next); rc;
      printacr('R. No file pt checking:'+qq(nofilepts)+
               'S. ULs auto-credited  :'+qq(ulvalreq),abort,next); rc;
      nl;
      prt('Enter selection (A-S) [Q]uit : '); rc;
      onek(c,'QABCDEFGHIJKLMNOPRS'^M);

      if (c='Q') then done:=TRUE;

      nl;
      if (not done) then
        if (c in ['A'..'P','R'..'S']) then begin
          prt('New ACS: '); inputl(s,20); rc;
          if (s<>'') then
            case c of
              'A':sop:=s;           'B':csop:=s;
              'C':msop:=s;          'D':fsop:=s;
              'E':spw:=s;           'F':seepw:=s;
              'G':normpubpost:=s;   'H':normprivpost:=s;
              'I':anonpubread:=s;   'J':anonprivread:=s;
              'K':anonpubpost:=s;   'L':anonprivpost:=s;
              'M':seeunval:=s;      'N':dlunval:=s;
              'O':nodlratio:=s;     'P':nopostratio:=s;
              'R':nofilepts:=s;     'S':ulvalreq:=s;
            end;
        end;
    end;
  until (done) or (hangup);
end;

end.
                                               7777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777 8  2  3P*CHESSM04.ZIP 1413 141 Chess Maniac 5 Billion and 1 [ 4/12]                                                                         P				



































                                                                                                                                                                                                                                                                                                  (*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2D .PAS -  Written by Chris Hessing and David Heighton            <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "D" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2d;

interface

uses
  crt, dos, overlay,
  common;

procedure pogenvar;

implementation

procedure rc;
begin
     cl(1);
end;

procedure pogenvar;
var c:char;
    i:integer;
    bbb:byte;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System variables'); rc;
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('A. Max private sent per call:'+mn(maxprivpost,3)+
        '  B. Max feedback sent per call:'+mn(maxfback,3),abort,next); rc;
      printacr('C. Max public posts per call:'+mn(maxpubpost,3)+
        '  D. Max chat attempts per call:'+mn(maxchat,3),abort,next); rc;
      printacr('E. Normal max mail waiting  :'+mn(maxwaiting,3)+
        '  F. CoSysOp max mail waiting  :'+mn(csmaxwaiting,3),abort,next); rc;
      printacr('G. Normal max lines/message :'+mn(maxlines,3)+
        '  H. CoSysOp max lines/message :'+mn(csmaxlines,3),abort,next); rc;
      printacr('I. Number of logon attempts :'+mn(maxlogontries,3)+
        '  J. Backspace delay           :'+mn(bsdelay,3),abort,next); rc;
      printacr('K. SysOp chat color         :'+mn(sysopcolor,3)+
        '  L. User chat color           :'+mn(usercolor,3),abort,next); rc;
      printacr('M. Min. space for posts     :'+mn(minspaceforpost,4)+
        ' N. Min. space for uploads    :'+mn(minspaceforupload,4),abort,next); rc;
      printacr('O. Back SysOp Log keep days :'+mn(backsysoplogs,3)+
        '  P. Blank WFC menu minutes    :'+mn(wfcblanktime,4),abort,next); rc;
      printacr('R. Default video line length:'+mn(linelen,3)+
        '  S. Default video page length :'+mn(pagelen,3),abort,next); rc;
      nl;
      prt('Enter selection (A-S) [Q]uit : '); rc;
      onek(c,'QABCDEFGHIJKLMNOPRS'^M); nl;

      case c of
        'Q':done:=TRUE;
        'A'..'P','R'..'S':
          begin
            prt('Range ');
            case c of
              'G','H':prt('(1-160)'); 
              'K','L':prt('(0-9)'); 
              'M','N':prt('(0-32767)'); 
              'O':prt('(1-99)'); 
              'R':prt('(32-132)'); 
              'S':prt('(4-50)'); 
            else
                  prt('(0-255)'); rc;
            end;
            nl; prt('New value: '); rc;
            case c of
              'M','N':inu(i); 
            else
                 ini(bbb); rc;
            end;
            if (not badini) then
              case c of
                'A':maxprivpost:=bbb;
                'B':maxfback:=bbb;
                'C':maxpubpost:=bbb;
                'D':maxchat:=bbb;
                'E':maxwaiting:=bbb;
                'F':csmaxwaiting:=bbb;
                'G':if (bbb in [1..160]) then maxlines:=bbb;
                'H':if (bbb in [1..160]) then csmaxlines:=bbb;
                'I':maxlogontries:=bbb;
                'J':bsdelay:=bbb;
                'K':if (bbb in [0..9]) then sysopcolor:=bbb;
                'L':if (bbb in [0..9]) then usercolor:=bbb;
                'M':if (i>0) then minspaceforpost:=i;
                'N':if (i>0) then minspaceforupload:=i;
                'O':if (bbb in [1..99]) then backsysoplogs:=bbb;
                'P':if (bbb in [0..255]) then wfcblanktime:=bbb;
                'R':if (bbb in [32..132]) then linelen:=bbb;
                'S':if (bbb in [4..50]) then pagelen:=bbb;
              end;
          end;
      end;
    end;
  until (done) or (hangup);
end;

end.
             GenericCC:Integer;
               TabC:Char;
               TabCC:Integer;
               MidC:Char;
               MidCC:Integer;
               LastC:Char;
               LastCC:Integer;
  end;

  OnePostRec=Record
                   OnePost:String[70];
                   Anon:String[80];
                   Name:String[80];
  end;
);
  end;
end;

end.
GRAFTABLCOM            (+    7  8P[ Scanning Games [2/2] for new files...                                                                                          P						                                                                                                                                                                                                                                                                                                   7 8P                                                                                                                                    P																																																																																                                                                                                                                                                                                                                                                                    8  9P                                                                                                                                    P                                                                                                                                                                                                                                                                                                  (*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2E .PAS -  Written by Chris Hessing and David Heighton            <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "E" command.           <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2e;

interface

uses
  crt, dos, overlay,
  common;

procedure poflagfunc;

implementation

function sltype(i:integer):string;
begin
  case i of
    0:sltype:='File only';
    1:sltype:='Printer & File';
    2:sltype:='Printer only';
  end;
end;

procedure rc;
begin
     cl(1);
end;

{$I REC04.PAS}

procedure poflagfunc;
var s:string[80];
    c,cc:char;
    nuu,i:integer;
    abort,next,done,pc:boolean;
    bbb:byte;
    Pause:File of PauseRec;
    PR:PauseRec;
begin
  PC:=FALSE;
  Assign(Pause,Systat.Gfilepath+'PAUSE.DAT');
  {$I-} Reset(Pause); {$I+}
  Read(Pause,PR);
  Close(Pause);
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System flagged functions');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('A. Use FOSSIL comm driver    :'+onoff(fossil)+
             '  B. Handles allowed on system:'+onoff(allowalias),abort,next); rc;
      printacr('C. Phone number in logon     :'+onoff(phonepw)+
             '  D. Local security protection:'+onoff(localsec),abort,next); rc;
      printacr('E. Local screen security     :'+onoff(localscreensec)+
             '  F. Global activity trapping :'+onoff(globaltrap),abort,next); rc;
      printacr('G. Auto chat buffer open     :'+onoff(autochatopen)+
             '  H. AutoMessage in logon     :'+onoff(autominlogon),abort,next); rc;
      printacr('I. Bulletins in logon        :'+onoff(bullinlogon)+
             '  J. Last few callers in logon:'+onoff(lcallinlogon),abort,next); rc;
      printacr('K. "Your info" in logon      :'+onoff(yourinfoinlogon)+
             '  L. Offhook in local logon   :'+onoff(offhooklocallogon),abort,next); rc;
      printacr('M. Mandatory voting          :'+onoff(forcevoting)+
             '  N. Compress file/msg numbers:'+onoff(compressbases),abort,next); rc;
      printacr('O. UL duplicate file search  :'+onoff(searchdup)+
             '  P. SysOp Log type           :'+sltype(slogtype),abort,next); rc;
      printacr('Q. Strip color off SysOp log :'+onoff(stripclog)+
             '  R. Use BIOS for video output:'+onoff(usebios),abort,next); rc;
      printacr('S. Suppress snow on CGA      :'+onoff(cgasnow)+
             '  T. Use EMS for overlay file :'+onoff(useems),abort,next); rc;
      printacr('U. Center Pause On Screen    :'+onoff(PR.CentPause)+
             '  V. Two-Way-Chat             :'+onoff(twowaychat),abort,next); rc;
      printacr('',abort,next);
      s:='1. New user message sent to :';
      if (newapp=-1) then s:=s+'Off' else s:=s+mn(newapp,3);
      s:=s+'  2. Guest user number         :';
      if (guestuser=-1) then s:=s+'Off' else s:=s+mn(guestuser,3);
      printacr(s,abort,next); rc;
      s:='3. Mins before timeout bell :';
      if (timeoutbell=-1) then s:=s+'Off' else s:=s+mn(timeoutbell,3);
      s:=s+'  4. Mins before timeout       :';
      if (timeout=-1) then s:=s+'Off' else s:=s+mn(timeout,3);
      printacr(s,abort,next); rc;
      nl;
      prt('Enter selection (A-X,1-4) [Q]uit : '); rc;
      onek(c,'QABCDEFGHIJKLMNOPRSTUV1234'^M); rc; nl;

      case c of
        'Q':done:=TRUE;
        'A':begin
              remove_port;
              fossil:=not fossil;
              iport;
            end;
        'B':allowalias:=not allowalias;
        'C':phonepw:=not phonepw;
        'D':localsec:=not localsec;
        'E':localscreensec:=not localscreensec;
        'F':globaltrap:=not globaltrap;
        'G':autochatopen:=not autochatopen;
        'H':autominlogon:=not autominlogon;
        'I':bullinlogon:=not bullinlogon;
        'J':lcallinlogon:=not lcallinlogon;
        'K':yourinfoinlogon:=not yourinfoinlogon;
        'L':offhooklocallogon:=not offhooklocallogon;
        'M':forcevoting:=not forcevoting;
        'N':begin
              compressbases:=not compressbases;
              nl;
              if (compressbases) then print('Compressing bases...') 
                else print('De-compressing bases...'); 
                rc;
              newcomptables;
            end;
        'O':searchdup:=not searchdup;
        'P':begin
              print('Current SysOp Log type: '+sltype(slogtype)); rc;
              nl;
              for i:=0 to 2 do print(cstr(i)+': '+sltype(i));
              nl;
              prt('New type: '); ini(bbb); rc;
              if ((not badini) and (bbb in [0..2])) then slogtype:=bbb;
            end;
        'Q':stripclog:=not stripclog;
        'R':begin
              usebios:=not usebios;
              directvideo:=not usebios;
            end;
        'S':begin
              cgasnow:=not cgasnow;
              checksnow:=cgasnow;
            end;
        'T':useems:=not useems;
        'U':Begin
                 PR.CentPause:=Not PR.CentPause;
                 PC:=TRUE;
            end;
        'V':twowaychat:=not twowaychat;
        '1'..'4':
          begin
            prt('[E]nable [D]isable this function: '); rc;
            onek(cc,'Q ED'^M);
            if cc in ['E','D'] then begin
              badini:=FALSE;
              case cc of
                'D':i:=-1;
                'E':begin
                      prt('Range '); rc;
                      case c of
                        '1','2':begin
                             reset(uf); nuu:=filesize(uf)-1; close(uf);
                             prt('(1-'+cstr(nuu)+')');
                           end;
                        '3','4':prt('(1-20)'); 
                      else
                           prt('(0-32767)'); 
                      end;
                      nl; prt('Enter value for this function: '); rc;
                      inu(i); rc;
                    end;
              end;
              if (not badini) then
                case c of
                  '1':if ((i>=1) and (i<=nuu)) or (cc='D') then newapp:=i;
                  '2':if ((i>=1) and (i<=nuu)) or (cc='D') then guestuser:=i;
                  '3':if ((i>=1) and (i<=20)) or (cc='D') then timeoutbell:=i;
                  '4':if ((i>=1) and (i<=20)) or (cc='D') then timeout:=i;
                end;
            end
            else print('No change.'); rc;
          end;
      end;
    end;
  If PC=TRUE then
     Begin
          {$I-} Rewrite(Pause); {$I+}
          Write(Pause,PR);
          Close(Pause);
     end;
  until (done) or (hangup);
end;

end.
f,filesize(f)-144);
  blockwrite(f,r,144,res);
  close(f);
end.
          (+O   ? @P*BCH4TDT4.ZIP 1404 140 Battle Chess 4000 [4/8]                                                                                      P				






















                                                                                                                                                                                                                                                                                    @  AP*BCH4TDT5.ZIP 1368 137 Battle Chess 4000 [5/8]                                                                                      P				






















                                                                                                                                                                                                                                                                                                  (*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2F .PAS -  Written by Chris Hessing and David Heighton            <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "F" command.           <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2f;

interface

uses
  crt, dos, overlay,
  sysop2fa,
  common;

procedure pofilesconfig;

implementation

procedure rc;
begin
     cl(1);
end;

procedure pofilesconfig;
var s:string[80];
    i:integer;
    c:char;
    b:byte;
    abort,next,done,changed:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'File section configuration'); rc;
      nl;
      abort:=FALSE;
      printacr(#3#3+'A. '+#3#1+'Archive configuration',abort,next); rc;
      printacr('B. Upload/download ratio          :'+aonoff(uldlratio,'Active','In-active'),abort,next); rc;
      printacr('C. Auto file point compensation   :'+aonoff(fileptratio,'Active','In-active'),abort,next); rc;
      printacr('D. File point compensation ratio  :'+cstr(fileptcomp)+' to 1',abort,next); rc;
      printacr('E. Base file size per 1 file point:'+cstr(fileptcompbasesize)+'k',abort,next); rc;
      printacr('F. Upload time refund percent     :'+cstr(ulrefund)+'%',abort,next); rc;
      s:='G. "To-SysOp" file base           :'; 
      if (tosysopdir=255) then s:=s+'*None*' else s:=s+cstr(tosysopdir);
      printacr(s,abort,next); rc;
      printacr('H. Auto-validate ALL files ULed?  :'+syn(validateallfiles),abort,next); rc;
      printacr('I. Remote DOS re-direction device :'+systat.remdevice,abort,next); rc;
      printacr('J. Max k-bytes allowed in TEMP\3\ :'+cstr(systat.maxintemp),abort,next); rc;
      printacr('K. Min k-bytes to save fo