Program Local_Login;

Uses CRT,GenTypes;

Const
  NumberofOptions = 5;
  LightBarOptions : Array[1..5] of String = (' Login to System ',
                                             ' Check if Validated ',
                                             ' Apply to System ',
                                             ' Attempt to Chat ',
                                             ' Disconnect');
  XCoordinates    : Array[1..5] of Byte = (31, 30, 31, 31, 34);
  YCoordinates    : Array[1..5] of Byte = (11, 12, 13, 14, 15);
  HighlightColor  = 1;
  NormalColor     = 0;

Var
  NumberofUsers,
  UserNumber     : Byte;
  UserHandles,
  UserPasswords  : Array[1..100] of MStr;
  PLDataDir      : MStr;
  RealUser,
  RealPassword   : Boolean;

{$I-}

Procedure GetDataDirectory(FileName : String);
Var
  FileCheck    : Byte;
  PLConfig     : ConfigSetType;
  PLConfigFile : File of ConfigSetType;
Begin
  Assign(PLConfigFile,FileName);
  Reset(PLConfigFile);
  FileCheck := IOResult;
  If FileCheck <> 0 Then Begin
                           ClrScr;
                           Write('The configuration file is missing!');
                           Halt(1);
                         End;
  Seek(PLConfigFile,0);
  Read(PLConfigFile,PLConfig);
  PLDataDir := PLConfig.DataDir;
  Close(PLConfigFile);
End;

Procedure ReadUserFile(FileName : String);
Var
  Counter,
  FileCheck      : Byte;
  UserRecord     : UserRec;
  UserRecordFile : File of UserRec;
Begin
  Assign(UserRecordFile,PLDataDir + FileName);
  Reset(UserRecordFile);
  FileCheck := IOResult;
  If FileCheck <> 0 Then Begin
                           ClrScr;
                           Write('The user file is missing!');
                           Halt(1);
                         End;
  Counter := 0;
  Repeat
    Begin
      Seek(UserRecordFile,Counter);
      Read(UserRecordFile,UserRecord);
      Inc(Counter);
      If Counter > 100 Then Begin
                              ClrScr;
                              Write('This demo only allows 100 users!');
                              Halt(1);
                            End;
      UserHandles[Counter]   := UserRecord.Handle;
      UserPasswords[Counter] := UserRecord.Password;
    End;
  Until EOF(UserRecordFile);
  Close(UserRecordFile);
  NumberofUsers := Counter + 1;
End;

{$I+}

Procedure AttemptLogin;
Var
  EnteredHandle,
  EnteredPassword : MStr;
  Counter         : Byte;
Begin
  Repeat
    Begin
      ClrScr;
      Write('Enter Handle   : ');
      ReadLn(EnteredHandle);
      For Counter := 1 to NumberofUsers Do
        Begin
          If EnteredHandle = UserHandles[Counter] Then
            Begin
              UserNumber := Counter;
              Write('Enter Password : ');
              ReadLn(EnteredPassword);
              If EnteredPassword = UserPasswords[UserNumber] Then
                Begin
                  ClrScr;
                  Write('Correct information entered, logining in...');
                  Halt(1);
                End
              Else
                Begin
                  If EnteredPassword <> UserPasswords[UserNumber] Then
                  Begin
                    WriteLn;
                    Write('Wrong Password entered!');
                    WriteLn;
                  End;
                End;
            End
          Else
            Begin
              WriteLn;
              Write('User not found!');
              WriteLn;
            End;
        End;
    End;
  Until (RealUser) and (RealPassword);
End;

Procedure Matrix;
Var
  Choice,
  Counter : Byte;
  Key     : Char;
  Done    : Boolean;
Begin
  ClrScr;

  For Counter := 1 to 5 Do
    Begin
      TextColor(15);
      TextBackGround(NormalColor);
      GotoXY(XCoordinates[Counter],YCoordinates[Counter]);
      Write(LightbarOptions[Counter]);
    End;

  Choice := 1;
  
  Repeat
    GotoXY(XCoordinates[Choice], YCoordinates[Choice]);
    TextColor(15);
    TextBackGround(HighlightColor);
    Write(LightBarOptions[Choice]);

    Key := Upcase(ReadKey);

    GotoXY(XCoordinates[Choice], YCoordinates[Choice]);
    TextColor(15);
    TextBackGround(NormalColor);
    Write(LightBarOptions[Choice]);

    Case Key of
       #0 : Begin
              Key := Upcase(ReadKey);
              Case Key of
                #72 : Dec(Choice);
                #80 : Inc(Choice);
              End;
            End;
      #27 : Begin
              ClrScr;
              Halt(1);
            End;
      #13 : Case Choice of
              01     : AttemptLogin;
              02..05 : Begin
                         ClrScr;
                         Write('Not yet implemented.');
                       End;
            End;
    End;

    If Choice > NumberofOptions Then Choice := 1;
    If Choice < 1 Then Choice := NumberofOptions;

    Done := False;
  Until Done;
End;

Begin
  GetDataDirectory('CONFIG.BBS');
  ReadUserFile('USERS.');
  Matrix;
End.

