{$X+}
(*
                Menu Editor routines for fELONY.
                Written by   : Cameron Booth.
                Modified     : 23/10/95

*)

Program MenuEd;
Uses DOS, Crt, FelANSI, FelANS, FelFX, GlobFel; {Scroll;}

Var
  FileNameMNU : String [8];
  MNU         : FelMNU;
  FileIndex   : Integer;
  MNUValue    : String [5];

Procedure InitMNU;
Begin
  MNU. MenuKey := ' ';
  MNU. MenuAction1 := 0;
  MNU. MenuAction2 := 0;
  MNU. ExecuteCommand := '                                        ';
  MNU. SecurityAccess := 'Normal         ';
  MNU. SecurityValue := '0    ';
End;

Procedure DrawMenuBox;
Var
  Loop : Byte;
Begin
  TextColor (White);
  TextBackground (0);
  Loop := 8;
  While Loop <> 14 Do
  Begin
    Inc (Loop);
    GotoXY (23, Loop);
    TextBackground (Black);
    Write (' ');
    TextBackground (0);
    TextColor (8);
    Write ('[ ]');
    TextColor (White);
    TextBackground (Black);
    Write ('');
    Write (' ');
    TextBackground (0);
    TextColor (Black);
    Write ('[                           ]');
    TextColor (5);
    TextBackground (Black);
    Write (' ');
  End;
  TextBackground (Black);
End;

Procedure DrawConfigFrame;
Var
  Loop : Byte;
Begin
  ClrScr;
  TextBackground (Black);
  {    TextColor(Blue);}
  TextColor (8);
  Write ('');
  {    TextColor(LightBlue);}
  TextColor (7);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (White);
  Write ('');
  TextColor (White);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('ķ');
  WriteLn;
  Write ('');
  TextBackground (0);
  Write ('                             ');
  TextBackground (Black);
  TextColor (9);
  Pipeparser ('|80f|70E|f0LONY Menu Edit|70o|80r |10v|9099', False);
  {Write('Menu Configuration');}
  TextBackground (0);
  TextColor (8);
  {Write('                              ');}
  TextBackground (0);
  Write ('                         ');
  WriteLn;
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('Ľ');
  WriteLn;
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('ķ');
  WriteLn;
  Write ('');
  TextBackground (0);
  Write ('                                                                             ');
  TextBackground (0);
  Write ('');
  WriteLn;
  For Loop := 1 To 17 Do
  Begin
    Write ('                                                                             ');
    WriteLn;
  End;
  Write ('');
  TextBackground (0);
  Write ('                                                                             ');
  TextBackground (0);
  Write ('');
  WriteLn;
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (8);
  Write ('Ľ');
  GotoXY (10, 21);
  TextColor (White);
  TextBackground (0);
  Write ('                                                           ');
  Show_FNYPNC_ANS;
End;

Procedure DrawMainFrame;
Var
  Index : Byte;
Begin
  GotoXY (22, 6);
  TextBackground (Black);
  TextColor (8);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (8);
  Write ('ķ');
  GotoXY (22, 7);
  TextColor (8);
  Write ('');
  TextColor (8);
  Write ('-');
  Pipeparser ('|80M|70a|f0in Me|70n|80u', False);
  TextColor (8);
  Write ('-');
  TextColor (8);
  Write ('');
  For Index := 8 To 15 Do
  Begin
    GotoXY (22, Index);
    Write ('');
    GotoXY (59, Index);
    Write ('');
  End;
  GotoXY (22, Index + 1);
  TextColor (8);
  Write ('');
  TextColor (0);
  Write ('');
  TextColor (8);
  Write ('');
  GotoXY (22, Index + 2);
  TextBackground (Black);
  TextColor (8);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (White);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (8);
  Write ('Ľ');
End;

Procedure GetMNUDetails;
Var
  Loop : Integer;
Begin
  TextBackground (Blue);
  TextColor (White);
  GotoXY (58, 12);
  MNU. MenuKey := RdStr (2);
  GotoXY (43, 15);
  MNU. ExecuteCommand := RdStr (31);
  {    MNU.SecurityAccess := GetSecurityMNULevel;}
  {    Get your security level here!}
  MNU. SecurityValue := MNUValue;
  TextBackground (Black);
  For Loop := 1 To 6 Do
  Begin
    GotoXY (14, 13 + Loop);
    Write ('               ');
  End;
End;

Function GetMenuProperty (Status : Integer) : Integer;
Var
  Loop, ScrollUp,
  ScrollDown, Start,
  Max                : Integer;
  Done               : Boolean;
  TempChar           : Char;
  PropArray          : Array [1..25] Of String [25];
  TempStr            : String [1];
Begin
  If Status = 1 Then
  Begin
    Max := 11;
    ScrollDown := Max - 6;
    PropArray [1]  := 'Wait for Menu Key        ';
    PropArray [2]  := 'Clear Screen             ';
    PropArray [3]  := 'Pause until Key is Hit   ';
    PropArray [4]  := 'Display Ansi File        ';
    PropArray [5]  := 'Display Ansi with Pause  ';
    PropArray [6]  := 'Display Ansi with Random ';
    PropArray [7]  := 'Page SysOp               ';
    PropArray [8]  := 'Goto to Screen           ';
    PropArray [9]  := 'Back to Previous Menu    ';
    PropArray [10] := 'Prompt for Ansi FileName ';
    PropArray [11] := 'Display Status Ansi      ';
  End
  Else If Status = 2 Then
  Begin
    Max := 12;
    ScrollDown := Max - 6;
    PropArray [1]  := 'Ask for System Password  ';
    PropArray [2]  := 'Ask for New User Password';
    PropArray [3]  := 'Change System Password   ';
    PropArray [4]  := 'Change NewUser Password  ';
    PropArray [5]  := 'Create Conference        ';
    PropArray [6]  := 'Create News Bulletin     ';
    PropArray [7]  := 'View fELONY Logs         ';
    PropArray [8]  := 'Execute Command          ';
    PropArray [9]  := 'Shell to DOS             ';
    PropArray [10] := 'LogOff User              ';
    PropArray [11] := 'LogOff, keep Carrier.    ';
    PropArray [12] := 'Access all BBS Functions ';
  End
  Else If Status = 3 Then
  Begin
    Max := 25;
    ScrollDown := Max - 6;
    PropArray [1]  := 'Create FileArea          ';
    PropArray [2]  := 'Delete FileArea          ';
    PropArray [3]  := 'Modify FileArea          ';
    PropArray [4]  := 'Change FileArea          ';
    PropArray [5]  := 'Change File Conference   ';
    PropArray [6]  := 'Move File from FileArea  ';
    PropArray [7]  := 'Upload File              ';
    PropArray [8]  := 'Download File            ';
    PropArray [9]  := 'Local Add Files          ';
    PropArray [10] := 'Delete File              ';
    PropArray [11] := 'Change File              ';
    PropArray [12] := 'Configure File Listing   ';
    PropArray [13] := 'Show File Information    ';
    PropArray [14] := 'Show File Listing        ';
    PropArray [15] := 'Add File to Batch        ';
    PropArray [16] := 'Show Batch Listing       ';
    PropArray [17] := 'Delete Batch Number      ';
    PropArray [18] := 'Delete Batch             ';
    PropArray [19] := 'Clean Up File Areas      ';
    PropArray [20] := 'Sort File Areas          ';
    PropArray [21] := 'Leech Week               ';
    PropArray [22] := 'Validate Uploaded Files  ';
    PropArray [23] := 'Generate File Listing    ';
    PropArray [24] := 'Local Mass Add of Files  ';
    PropArray [25] := 'File List with FileSpec  ';
  End
  Else If Status = 4 Then
  Begin
    Max := 13;
    ScrollDown := Max - 6;
    PropArray [1]  := 'Create MessageArea       ';
    PropArray [2]  := 'Delete MessageArea       ';
    PropArray [3]  := 'Modify MessageArea       ';
    PropArray [4]  := 'Change MessageArea       ';
    PropArray [5]  := 'Change Message Conference';
    PropArray [6]  := 'Compose Message          ';
    PropArray [7]  := 'Read Mail                ';
    PropArray [8]  := 'Delete Mail              ';
    PropArray [9]  := 'Scan for New Mail        ';
    PropArray [10] := 'fELONY Message Editor    ';
    PropArray [11] := 'FeedBack to SysOp        ';
    PropArray [12] := 'New User Message         ';
    PropArray [13] := 'Create AutoMessage       ';
  End
  Else If Status = 5 Then
  Begin
    Max := 11;
    ScrollDown := Max - 6;
    PropArray [1]  := 'Login User               ';
    PropArray [2]  := 'Check User Access        ';
    PropArray [3]  := 'Create New User          ';
    PropArray [4]  := 'Delete User              ';
    PropArray [5]  := 'Edit User Details        ';
    PropArray [6]  := 'Change User PassWord     ';
    PropArray [7]  := 'Change to different User ';
    PropArray [8]  := 'View User Listing        ';
    PropArray [9]  := 'Create/Edit AutoSig      ';
    PropArray [10] := 'Change Menu Sets         ';
    PropArray [11] := 'Add User to BlackList    ';
  End
  Else If Status = 6 Then
  Begin
    Max := 13;
    ScrollDown := Max - 6;
    PropArray [1]  := 'Execute OneLiners        ';
    PropArray [2]  := 'Add Rumour               ';
    PropArray [3]  := 'Delete Rumour            ';
    PropArray [4]  := 'Show Rumour              ';
    PropArray [5]  := 'Add BBS to BBS List      ';
    PropArray [6]  := 'Delete BBS from BBS List ';
    PropArray [7]  := 'Show BBS List            ';
    PropArray [8]  := 'Show News Bulletin       ';
    PropArray [9]  := 'Show Todays Callers      ';
    PropArray [10] := 'Show fELONY Information  ';
    PropArray [11] := 'fELONY TimeBank          ';
    PropArray [12] := 'Change Login Matrix      ';
    PropArray [13] := 'New User Voting          ';
  End
  Else If Status = 7 Then
  Begin
    Max := 8;
    ScrollDown := Max - 6;
    PropArray [1] := 'View Node Information     ';
    PropArray [2] := 'View Active Nodes         ';
    PropArray [3] := 'Chat with other User      ';
    PropArray [4] := 'Kick User off Node        ';
    PropArray [5] := 'Disable Node              ';
    PropArray [6] := 'Spy on another Node       ';
    PropArray [7] := 'Send file to another Node ';
    PropArray [8] := 'Display Ansi to Node      ';
  End;
  Done := False;
  ScrollUp := 0;
  Start := 1;
  TextColor (White);
  TextBackground (Blue);
  GotoXY (9, 14);
  Write (PropArray [1] );
  TextBackground (Black);
  For Loop := 2 To Max - ScrollDown Do
  Begin
    GotoXY (9, 13 + Loop);
    Write (PropArray [Loop] );
  End;
  Repeat
    TextBackground (Blue);
    GotoXY (44, 9);
    Write (PropArray [Start] );
    TempChar := ReadKey;
    TextBackground (Black);
    If TempChar = UpArrow Then
    Begin
      If (Start <> (ScrollUp + 1) )  And (Start <> 1) Then
      Begin
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (PropArray [Start] );
        Dec (Start);
        TextBackground (Blue);
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (PropArray [Start] );
      End
      Else If Start <> 1 Then
      Begin
        Dec (Start);
        Dec (ScrollUp);
        Inc (ScrollDown);
        TextBackground (Blue);
        GotoXY (9, 14);
        Write (PropArray [Start] );
        TextBackground (Black);
        For Loop := 2 To 6 Do
        Begin
          GotoXY (9, 13 + Loop);
          Write (PropArray [Loop + ScrollUp] );
        End;
      End;
    End
    Else If TempChar = DownArrow Then
    Begin
      If (Start <> (Max - ScrollDown) ) And (Start <> Max) Then
      Begin
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (PropArray [Start] );
        Inc (Start);
        TextBackground (Blue);
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (PropArray [Start] );
      End
      Else If Start <> Max Then
      Begin
        Inc (Start);
        Inc (ScrollUp);
        Dec (ScrollDown);
        For Loop := 1 To 5 Do
        Begin
          GotoXY (9, 13 + Loop);
          Write (PropArray [ScrollUp + Loop] );
        End;
        Inc (Loop);
        TextBackground (Blue);
        GotoXY (9, 13 + Loop);
        Write (PropArray [Start] );
      End;
    End
      Else If TempChar = ReturnKey Then
      Begin
        MNU. MenuAction1 := Status;
        MNU. MenuAction2 := Start;
        TextBackground (Black);
        For Loop := 1 To 6 Do
        Begin
          GotoXY (9, 13 + Loop);
          Write ('                         ');
        End;
        GetMNUDetails;
        Done := True;
        ScrollUp := 1;
      End
        Else If TempChar = ESCKey Then
        Begin
          GotoXY (44, 9);
          TextBackground (Blue);
          Write ('                            ');
          Done := True;
          ScrollUp := 0;
        End;
  Until Done = True;
  TextBackground (Black);
  GetMenuProperty := ScrollUp;
End;

Procedure GetMenuAction;
Var
  Loop, ScrollUp,
  ScrollDown, Start,
  Max                : Integer;
  Result, Done       : Boolean;
  TempChar           : Char;
  ConArray           : Array [1..7] Of String [25];
Begin
  ConArray [1] := 'fELONY Menu Commands     ';
  ConArray [2] := 'fELONY System Commands   ';
  ConArray [3] := 'fELONY File Commands     ';
  ConArray [4] := 'fELONY Mail Commands     ';
  ConArray [5] := 'fELONY User Commands     ';
  ConArray [6] := 'fELONY Utility Commands  ';
  ConArray [7] := 'fELONY Node Commands     ';
  Max := 7;
  Done := False;
  ScrollUp := 0;
  ScrollDown := 1;
  Start := 1;
  TextColor (White);
  TextBackground (Blue);
  GotoXY (9, 14);
  Write (ConArray [1] );
  TextBackground (Black);
  For Loop := 2 To 6 Do
  Begin
    GotoXY (9, 13 + Loop);
    Write (ConArray [Loop] );
  End;
  Repeat
    TempChar := ReadKey;
    TextBackground (Black);
    If TempChar = UpArrow Then
    Begin
      If (Start <> (ScrollUp + 1) )  And (Start <> 1) Then
      Begin
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (ConArray [Start] );
        Dec (Start);
        TextBackground (Blue);
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (ConArray [Start] );
      End
      Else If Start <> 1 Then
      Begin
        Dec (Start);
        Dec (ScrollUp);
        Inc (ScrollDown);
        TextBackground (Blue);
        GotoXY (9, 14);
        Write (ConArray [Start] );
        TextBackground (Black);
        For Loop := 2 To 6 Do
        Begin
          GotoXY (9, 13 + Loop);
          Write (ConArray [Loop + ScrollUp] );
        End;
      End;
    End
    Else If TempChar = DownArrow Then
    Begin
      If (Start <> (Max - ScrollDown) ) And (Start <> Max) Then
      Begin
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (ConArray [Start] );
        Inc (Start);
        TextBackground (Blue);
        GotoXY (9, 13 + (Start - ScrollUp) );
        Write (ConArray [Start] );
      End
      Else If Start <> Max Then
      Begin
        Inc (Start);
        Inc (ScrollUp);
        Dec (ScrollDown);
        For Loop := 1 To 5 Do
        Begin
          GotoXY (9, 13 + Loop);
          Write (ConArray [ScrollUp + Loop] );
        End;
        Inc (Loop);
        TextBackground (Blue);
        GotoXY (9, 13 + Loop);
        Write (ConArray [Start] );
      End;
    End
      Else If TempChar = ReturnKey Then
      Begin
        If GetMenuProperty (Start) = 0 Then
        Begin
          TextColor (White);
          TextBackground (Blue);
          GotoXY (9, 14);
          Write (ConArray [1] );
          TextBackground (Black);
          For Loop := 2 To 6 Do
          Begin
            GotoXY (9, 13 + Loop);
            Write (ConArray [Loop] );
          End;
        End
        Else
        Begin
          Done := True;
        End;
        Max := 7;
        Start := 1;
      End
        Else If TempChar = ESCKey Then
        Begin
          Done := True;
          Result := False;
        End;
  Until Done = True;
  TextBackground (Black);
  For Loop := 1 To 6 Do
  Begin
    GotoXY (9, 13 + Loop);
    Write ('                         ');
  End;
End;

Procedure SaveMNUDetails;
Begin
End;

Procedure AddOption;
Var
  MenuPos : Byte;
  Done    : Boolean;
  Input   : Char;
Begin
  TextColor (White);
  TextBackground (Black);
  GotoXY (8, 9);
  Write ('   Save   ');
  TextBackground (Blue);
  GotoXY (25, 9);
  Write ('New Option');
  TextBackground (Black);
  MenuPos := 1;
  Done := False;
  Repeat
    Input := ReadKey;
    If (Input = LeftArrow) Or (Input = RightArrow) Then
    Begin
      If MenuPos = 1 Then
      Begin
        MenuPos := 2;
        TextBackground (Blue);
        GotoXY (8, 9);
        Write ('   Save   ');
        TextBackground (Black);
        GotoXY (25, 9);
        Write ('New Option');
      End
      Else
      Begin
        MenuPos := 1;
        TextBackground (Black);
        GotoXY (8, 9);
        Write ('   Save   ');
        TextBackground (Blue);
        GotoXY (25, 9);
        Write ('New Option');
      End;
    End
    Else If Input = ESCKey Then
    Begin
      Done := True;
    End
      Else If Input = ReturnKey Then
      Begin
        If MenuPos = 1 Then
        Begin
          TextBackground (Blue);
          GotoXY (44, 9);
          Write ('                         ');
          GotoXY (58, 12);
          Write ('  ');
          GotoXY (43, 15);
          Write ('                               ');
          GotoXY (52, 18);
          Write ('               ');
          GetMenuAction;
        End
        Else
        Begin
          SaveMNUDetails;
          TextBackground (Blue);
          GotoXY (44, 9);
          Write ('                         ');
          GotoXY (58, 12);
          Write ('  ');
          GotoXY (43, 15);
          Write ('                               ');
          GotoXY (52, 18);
          Write ('               ');
        End;
      End;
  Until Done = True;
  TextBackground (Black);
End;

Procedure NewMNUFile;
Begin
  GotoXY (10, 7);
  TextBackground (Black);
  TextColor (8);
  Write ('[');
  TextColor (White);
  Write ('FileName');
  TextColor (7);
  Write (']ķ');
  GotoXY (5, 8);
  TextColor (White);
  Write ('                              ');
  GotoXY (5, 9);
  TextColor (7);
  Write ('     ');
  TextColor (White);
  Write ('');
  TextColor (8);
  Write ('Ľ     ');
  GotoXY (5, 10);
  Write ('                                ');
  GotoXY (15, 8);
  TextBackground (LightBlue);
  TextColor (White);
  Write ('        ');
  TextBackground (Black);
  Write ('.MNU');
  TextBackground (LightBlue);
  GotoXY (15, 8);
  FileNameMNU := RdStr (8);
  TextBackground (Black);
  TextColor (8);
  GotoXY (5, 7);
  Write ('                                ');
  GotoXY (5, 8);
  Write ('                                ');
  GotoXY (5, 9);
  Write ('                                ');
  GotoXY (6, 8);
  Write ('ͻ');
  GotoXY (6, 9);
  Write ('            ');
  GotoXY (6, 10);
  Write ('ͼ');
  GotoXY (23, 8);
  Write ('ͻ');
  GotoXY (23, 9);
  Write ('            ');
  GotoXY (23, 10);
  Write ('ͼ');
  AddOption;
End;

Function GetFileName : Boolean;
Var
  DirInfo          : SearchRec;
  Loop, ScrollUp,
  ScrollDown, Max,
  Start, Count     : Integer;
  Result, Done     : Boolean;
  TempChar         : Char;
  TempStr          : String [40];
  FileArray        : Array [1..50] Of String [12];
Begin
  Loop := 0;
  TempStr := AllTrim (CFG. MenuDir);
  { make sure you check the dir your menu files will be stored in!}
  FindFirst (TempStr + '*.MNU', Archive, DirInfo);
  While DosError = 0 Do
  Begin
    Inc (Loop);
    FindNext (DirInfo);
  End;
  If Loop = 0 Then
  Begin
    For Count := 1 To 17 Do
    Begin
      GotoXY (3, 5 + Count);
      Write ('Menu file doesnt exist!                                                                          ');
    End;
    {Display an error when the mnu file doesnt exist}
  End
  Else
  Begin
    Max := Loop;
    Done := False;
    ScrollUp := 0;
    If Max > 6 Then
    Begin
      ScrollDown := Max - 6;
    End
    Else
    Begin
      ScrollDown := 0;
    End;
    Start := 1;
    TextColor (White);
    TextBackground (Blue);
    GotoXY (16, 14);
    Write (FileArray [1] );
    TextBackground (Black);
    For Loop := 2 To Max - ScrollDown Do
    Begin
      GotoXY (16, 13 + Loop);
      Write (FileArray [Loop] );
    End;
    Repeat
      TempChar := ReadKey;
      TextBackground (Black);
      If TempChar = UpArrow Then
      Begin
        If (Start <> (ScrollUp + 1) )  And (Start <> 1) Then
        Begin
          GotoXY (16, 13 + (Start - ScrollUp) );
          Write (FileArray [Start] );
          Dec (Start);
          TextBackground (Blue);
          GotoXY (16, 13 + (Start - ScrollUp) );
          Write (FileArray [Start] );
        End
        Else If Start <> 1 Then
        Begin
          Dec (Start);
          Dec (ScrollUp);
          Inc (ScrollDown);
          TextBackground (Blue);
          GotoXY (16, 14);
          Write (FileArray [Start] );
          TextBackground (Black);
          For Loop := 2 To 6 Do
          Begin
            GotoXY (16, 13 + Loop);
            Write (FileArray [Loop + ScrollUp] );
          End;
        End;
      End
      Else If TempChar = DownArrow Then
      Begin
        If (Start <> (Max - ScrollDown) ) And (Start <> Max) Then
        Begin
          GotoXY (16, 13 + (Start - ScrollUp) );
          Write (FileArray [Start] );
          Inc (Start);
          TextBackground (Blue);
          GotoXY (16, 13 + (Start - ScrollUp) );
          Write (FileArray [Start] );
        End
        Else If Start <> Max Then
        Begin
          Inc (Start);
          Inc (ScrollUp);
          Dec (ScrollDown);
          For Loop := 1 To 5 Do
          Begin
            GotoXY (16, 13 + Loop);
            Write (FileArray [ScrollUp + Loop] );
          End;
          Inc (Loop);
          TextBackground (Blue);
          GotoXY (16, 13 + Loop);
          Write (FileArray [Start] );
        End;
      End
        Else If TempChar = ReturnKey Then
        Begin
          FileNameMNU := FileArray [Start];
          For Loop := 1 To 8 Do
          Begin
            If FileNameMNU [Loop] = '.' Then
            Begin
              For Loop := Loop To 8 Do
              Begin
                FileNameMNU [Loop] := ' ';
              End;
            End;
          End;
          Done := True;
          Result := True;
        End
          Else If TempChar = ESCKey Then
          Begin
            Done := True;
            Result := False;
          End;
    Until Done = True;
    TextBackground (Black);
    For Loop := 1 To 6 Do
    Begin
      GotoXY (14, 13 + Loop);
      Write ('                ');
    End;
    GetFileName := Result;
  End;
End;

Procedure DrawInputScreen;
Var
  Count : Byte;
Begin
  Show_FNYPNC_ANS;
  TextBackground (Black);
  TextColor (8);
  GotoXY (6, 8);
  TextColor (15);
  Write ('');
  GotoXY (6, 9);
  TextBackground (7);
  TextColor (0);
  Write ('              ');
  GotoXY (6, 10);
  TextBackground (0);
  TextColor (8);
  Write ('');
  GotoXY (23, 8);
  TextColor (15);
  Write ('');
  GotoXY (23, 9);
  TextBackground (7);
  TextColor (0);
  Write ('              ');
  GotoXY (23, 10);
  TextBackground (0);
  TextColor (8);
  Write ('');
  TextColor (White);
  TextBackground (Blue);
  GotoXY (8, 9);
  TextBackground (7);
  TextColor (0);
  Write ('New Option');
  TextBackground (7);
  TextColor (0);
  GotoXY (25, 9);
  Write (' New File ');
  TextBackground (0);
  GotoXY (40, 6);
  TextColor (8);
  Write ('');
  TextColor (7);
  Write ('[');
  TextColor (White);
  Write ('Menu Option');
  TextColor (7);
  Write (']');
  TextColor (8);
  Write ('ͻ');
  For Count := 0 To 13 Do
  Begin
    TextColor (8);
    GotoXY (40, 7 + Count);
    Write ('                                     ');
    GotoXY (76, 7 + Count);
    TextColor (8);
    Write ('');
  End;
  TextColor (8);
  GotoXY (40, 21);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (15);
  Write ('');
  TextColor (7);
  Write ('ͼ');
  TextColor (8);
  GotoXY (4, 12);
  Write ('');
  TextColor (7);
  Write ('[');
  TextColor (White);
  Write ('List');
  TextColor (7);
  Write (']');
  TextColor (8);
  Write ('ͻ');
  For Count := 0 To 7 Do
  Begin
    TextColor (8);
    GotoXY (4, 13 + Count);
    Write ('');
    GotoXY (38, 13 + Count);
    TextColor (8);
    Write ('');
  End;
  TextColor (8);
  GotoXY (4, 21);
  Write ('');
  TextColor (8);
  Write ('');
  TextColor (7);
  Write ('');
  TextColor (15);
  Write ('ͼ ');
  GotoXY (54, 8);
  Pipeparser ('|10M|30e|f0nu', False);
  Write (' ');
  Pipeparser ('|f0Acti|30o|10n', False);
  GotoXY (43, 9);
  TextColor (White);
  Write ('[');
  TextBackground (Blue);
  Write ('                             ');
  TextBackground (Black);
  Write (']');
  GotoXY (55, 11);
  Pipeparser ('|10M|30e|f0nu', False);
  Write (' ');
  Pipeparser ('|f0K|30e|10y', False);
  GotoXY (57, 12);
  TextColor (White);
  Write ('[');
  TextBackground (Blue);
  Write ('  ');
  TextBackground (Black);
  Write (']');
  GotoXY (52, 14);
  Pipeparser ('|10E|30x|f0ecute', False);
  Write (' ');
  Pipeparser ('|f0Comma|30n|10d', False);
  GotoXY (42, 15);
  TextColor (White);
  Write ('[');
  TextBackground (Blue);
  Write ('                               ');
  TextBackground (Black);
  Write (']');
  GotoXY (53, 17);
  Pipeparser ('|10S|30e|f0curity', False);
  Write (' ');
  Pipeparser ('|f0Lev|30e|10l', False);
  GotoXY (51, 18);
  TextColor (White);
  Write ('[');
  TextBackground (Blue);
  Write ('               ');
  TextBackground (Black);
  Write (']');
End;

Procedure MenuEditorOneData;
Var
  Count, Menu : Byte;
  Done        : Boolean;
  InputCh     : Char;
Begin
  DrawInputScreen;
  Menu := 1;
  Repeat
    InputCh := ReadKey;
    If (InputCh = RightArrow) Or (InputCh = LeftArrow) Then
    Begin
      If Menu = 1 Then
      Begin
        GotoXY (25, 9);
        TextBackground (7);
        TextColor (0);
        Write (' NEW FILE ');
        TextBackground (7);
        TextColor (0);
        GotoXY (8, 9);
        Write ('new option');
        Menu := 2;
      End
      Else
      Begin
        GotoXY (8, 9);
        TextBackground (7);
        TextColor (0);
        Write ('NEW OPTION');
        TextBackground (7);
        TextColor (0);
        GotoXY (25, 9);
        Write (' new file ');
        Menu := 1;
      End;
    End
    Else If InputCh = ReturnKey Then
    Begin
      If Menu = 1 Then
      Begin
        If GetFileName = True Then
        Begin
          AddOption;
        End;
      End
      Else
      Begin
        NewMNUFile;
      End;
      Done := True;
    End
      Else If InputCh = ESCKey Then
      Begin
        Done := True;
      End;
  Until Done = True;
  For Count := 1 To 17 Do
  Begin
    GotoXY (3, 5 + Count);
    Write ('                                                                          ');
  End;
  GotoXY (10, 21);
  TextColor (White);
  TextBackground (0);
  Write ('                                                           ');
End;

Function ExpandMenuAction (IntInput1, IntInput2 : Integer) : String;
Var
  PropArray : Array [1..25] Of String [25];
Begin
  If IntInput1 = 1 Then
  Begin
    PropArray [1]  := 'Wait for Menu Key        ';
    PropArray [2]  := 'Clear Screen             ';
    PropArray [3]  := 'Pause until Key is Hit   ';
    PropArray [4]  := 'Display Ansi File        ';
    PropArray [5]  := 'Display Ansi with Pause  ';
    PropArray [6]  := 'Display Ansi with Random ';
    PropArray [7]  := 'Page SysOp               ';
    PropArray [8]  := 'Goto to Screen           ';
    PropArray [9]  := 'Back to Previous Menu    ';
    PropArray [10] := 'Prompt for Ansi FileName ';
    PropArray [11] := 'Display Status Ansi      ';
  End
  Else If IntInput1 = 2 Then
  Begin
    PropArray [1]  := 'Ask for System Password  ';
    PropArray [2]  := 'Ask for New User Password';
    PropArray [3]  := 'Change System Password   ';
    PropArray [4]  := 'Change NewUser Password  ';
    PropArray [5]  := 'Create Conference        ';
    PropArray [6]  := 'Create News Bulletin     ';
    PropArray [7]  := 'View fELONY Logs         ';
    PropArray [8]  := 'Execute Command          ';
    PropArray [9]  := 'Shell to DOS             ';
    PropArray [10] := 'LogOff User              ';
    PropArray [11] := 'LogOff, keep Carrier.    ';
    PropArray [12] := 'Access all BBS Functions ';
  End
  Else If IntInput1 = 3 Then
  Begin
    PropArray [1]  := 'Create FileArea          ';
    PropArray [2]  := 'Delete FileArea          ';
    PropArray [3]  := 'Modify FileArea          ';
    PropArray [4]  := 'Change FileArea          ';
    PropArray [5]  := 'Change File Conference   ';
    PropArray [6]  := 'Move File from FileArea  ';
    PropArray [7]  := 'Upload File              ';
    PropArray [8]  := 'Download File            ';
    PropArray [9]  := 'Local Add Files          ';
    PropArray [10] := 'Delete File              ';
    PropArray [11] := 'Change File              ';
    PropArray [12] := 'Configure File Listing   ';
    PropArray [13] := 'Show File Information    ';
    PropArray [14] := 'Show File Listing        ';
    PropArray [15] := 'Add File to Batch        ';
    PropArray [16] := 'Show Batch Listing       ';
    PropArray [17] := 'Delete Batch Number      ';
    PropArray [18] := 'Delete Batch             ';
    PropArray [19] := 'Clean Up File Areas      ';
    PropArray [20] := 'Sort File Areas          ';
    PropArray [21] := 'Leech Week               ';
    PropArray [22] := 'Validate Uploaded Files  ';
    PropArray [23] := 'Generate File Listing    ';
    PropArray [24] := 'Local Mass Add of Files  ';
    PropArray [25] := 'File List with FileSpec  ';
  End
  Else If IntInput1 = 4 Then
  Begin
    PropArray [1]  := 'Create MessageArea       ';
    PropArray [2]  := 'Delete MessageArea       ';
    PropArray [3]  := 'Modify MessageArea       ';
    PropArray [4]  := 'Change MessageArea       ';
    PropArray [5]  := 'Change Message Conference';
    PropArray [6]  := 'Compose Message          ';
    PropArray [7]  := 'Read Mail                ';
    PropArray [8]  := 'Delete Mail              ';
    PropArray [9]  := 'Scan for New Mail        ';
    PropArray [10] := 'fELONY Message Editor    ';
    PropArray [11] := 'FeedBack to SysOp        ';
    PropArray [12] := 'New User Message         ';
    PropArray [13] := 'Create AutoMessage       ';
  End
  Else If IntInput1 = 5 Then
  Begin
    PropArray [1]  := 'Login User               ';
    PropArray [2]  := 'Check User Access        ';
    PropArray [3]  := 'Create New User          ';
    PropArray [4]  := 'Delete User              ';
    PropArray [5]  := 'Edit User Details        ';
    PropArray [6]  := 'Change User PassWord     ';
    PropArray [7]  := 'Change to different User ';
    PropArray [8]  := 'View User Listing        ';
    PropArray [9]  := 'Create/Edit AutoSig      ';
    PropArray [10] := 'Change Menu Sets         ';
    PropArray [11] := 'Add User to BlackList    ';
  End
  Else If IntInput1 = 6 Then
  Begin
    PropArray [1]  := 'Execute OneLiners        ';
    PropArray [2]  := 'Add Rumour               ';
    PropArray [3]  := 'Delete Rumour            ';
    PropArray [4]  := 'Show Rumour              ';
    PropArray [5]  := 'Add BBS to BBS List      ';
    PropArray [6]  := 'Delete BBS from BBS List ';
    PropArray [7]  := 'Show BBS List            ';
    PropArray [8]  := 'Show News Bulletin       ';
    PropArray [9]  := 'Show Todays Callers      ';
    PropArray [10] := 'Show fELONY Information  ';
    PropArray [11] := 'fELONY TimeBank          ';
    PropArray [12] := 'Change Login Matrix      ';
    PropArray [13] := 'New User Voting          ';
  End;
  ExpandMenuAction := PropArray [IntInput2];
End;

Procedure SaveEditMNUDetails;
Var
  TempDir          : String [40];
  Loop             : Byte;
  EditMNU, TempMNU : Text;
  TMP              : FelMNU;
Begin
  TempDir := AllTrim (CFG. MenuDir);
  {    Make sure you use the directory you want to save your menu files to}
  Assign (EditMNU, TempDir + FileNameMNU + '.MNU');
  Reset (EditMNU);
  TempDir := AllTrim (CFG. MenuDir);
  Assign (TempMNU, TempDir + 'MNUFILE.TMP');
  Rewrite (TempMNU);
  Loop := 1;
  While Loop <> FileIndex Do
  Begin
    ReadLn (EditMNU, TMP. MenuKey);
    ReadLn (EditMNU, TMP. MenuAction1);
    ReadLn (EditMNU, TMP. MenuAction2);
    ReadLn (EditMNU, TMP. ExecuteCommand);
    ReadLn (EditMNU, TMP. SecurityAccess);
    ReadLn (EditMNU, TMP. SecurityValue);
    WriteLn (TempMNU, TMP. MenuKey);
    WriteLn (TempMNU, TMP. MenuAction1);
    WriteLn (TempMNU, TMP. MenuAction2);
    WriteLn (TempMNU, TMP. ExecuteCommand);
    WriteLn (TempMNU, TMP. SecurityAccess);
    WriteLn (TempMNU, TMP. SecurityValue);
    Inc (Loop);
  End;
  ReadLn (EditMNU, TMP. MenuKey);
  ReadLn (EditMNU, TMP. MenuAction1);
  ReadLn (EditMNU, TMP. MenuAction2);
  ReadLn (EditMNU, TMP. ExecuteCommand);
  ReadLn (EditMNU, TMP. SecurityAccess);
  ReadLn (EditMNU, TMP. SecurityValue);
  WriteLn (TempMNU, MNU. MenuKey);
  WriteLn (TempMNU, MNU. MenuAction1);
  WriteLn (TempMNU, MNU. MenuAction2);
  WriteLn (TempMNU, MNU. ExecuteCommand);
  WriteLn (TempMNU, MNU. SecurityAccess);
  WriteLn (TempMNU, MNU. SecurityValue);
  If Not EoF (EditMNU) Then
  Begin
    Repeat
      ReadLn (EditMNU, TMP. MenuKey);
      ReadLn (EditMNU, TMP. MenuAction1);
      ReadLn (EditMNU, TMP. MenuAction2);
      ReadLn (EditMNU, TMP. ExecuteCommand);
      ReadLn (EditMNU, TMP. SecurityAccess);
      ReadLn (EditMNU, TMP. SecurityValue);
      WriteLn (TempMNU, TMP. MenuKey);
      WriteLn (TempMNU, TMP. MenuAction1);
      WriteLn (TempMNU, TMP. MenuAction2);
      WriteLn (TempMNU, TMP. ExecuteCommand);
      WriteLn (TempMNU, TMP. SecurityAccess);
      WriteLn (TempMNU, TMP. SecurityValue);
    Until EoF (EditMNU);
  End;
  Close (TempMNU);
  Close (EditMNU);
  {    TempDir := AllTrim(CFG.DataPath);}
  Assign (EditMNU, TempDir + FileNameMNU + '.MNU');
  Erase (EditMNU);
  {    TempDir := AllTrim(CFG.TempPath);}
  Assign (TempMNU, TempDir + 'MNUFILE.TMP');
  {    TempDir := AllTrim(CFG.DataPath);  }
  Rename (TempMNU, TempDir + FileNameMNU + '.MNU');
End;

Procedure EditMNUFileMenu;
Var
  MenuPos : Byte;
  Done    : Boolean;
  Input   : Char;
Begin
  TextColor (White);
  TextBackground (Black);
  GotoXY (8, 9);
  Write ('   Save   ');
  TextBackground (Blue);
  GotoXY (25, 9);
  Write ('Forget IT!');
  TextBackground (Black);
  MenuPos := 1;
  Done := False;
  Repeat
    Input := ReadKey;
    If (Input = LeftArrow) Or (Input = RightArrow) Then
    Begin
      If MenuPos = 1 Then
      Begin
        MenuPos := 2;
        TextBackground (Blue);
        GotoXY (8, 9);
        Write ('   Save   ');
        TextBackground (Black);
        GotoXY (25, 9);
        Write ('Forget IT!');
      End
      Else
      Begin
        MenuPos := 1;
        TextBackground (Black);
        GotoXY (8, 9);
        Write ('   Save   ');
        TextBackground (Blue);
        GotoXY (25, 9);
        Write ('Forget IT!');
      End;
    End
    Else If Input = ESCKey Then
    Begin
      Done := True;
    End
      Else If Input = ReturnKey Then
      Begin
        If MenuPos = 2 Then
        Begin
          SaveEditMNUDetails;
        End;
        Done := True;
      End;
  Until Done = True;
  TextBackground (Black);
End;

Procedure DeleteMNUFileOption;
Var
  TempDir          : String [40];
  Loop, Max        : Integer;
  EditMNU, TempMNU : Text;
  TMP              : FelMNU;
Begin
  TempDir := AllTrim (CFG. MenuDir);
  Assign (EditMNU, TempDir + FileNameMNU + '.MNU');
  If Max = 1 Then
  Begin
    Erase (EditMNU);
  End
  Else
  Begin
    Reset (EditMNU);
    TempDir := AllTrim (CFG. MenuDir);
    Assign (TempMNU, TempDir + 'MNUFILE.TMP');
    Rewrite (TempMNU);
    Loop := 1;
    While Loop <> FileIndex Do
    Begin
      ReadLn (EditMNU, TMP. MenuKey);
      ReadLn (EditMNU, TMP. MenuAction1);
      ReadLn (EditMNU, TMP. MenuAction2);
      ReadLn (EditMNU, TMP. ExecuteCommand);
      ReadLn (EditMNU, TMP. SecurityAccess);
      ReadLn (EditMNU, TMP. SecurityValue);
      WriteLn (TempMNU, TMP. MenuKey);
      WriteLn (TempMNU, TMP. MenuAction1);
      WriteLn (TempMNU, TMP. MenuAction2);
      WriteLn (TempMNU, TMP. ExecuteCommand);
      WriteLn (TempMNU, TMP. SecurityAccess);
      WriteLn (TempMNU, TMP. SecurityValue);
      Inc (Loop);
    End;
    ReadLn (EditMNU, TMP. MenuKey);
    ReadLn (EditMNU, TMP. MenuAction1);
    ReadLn (EditMNU, TMP. MenuAction2);
    ReadLn (EditMNU, TMP. ExecuteCommand);
    ReadLn (EditMNU, TMP. SecurityAccess);
    ReadLn (EditMNU, TMP. SecurityValue);
    If Not EoF (EditMNU) Then
    Begin
      Repeat
        ReadLn (EditMNU, TMP. MenuKey);
        ReadLn (EditMNU, TMP. MenuAction1);
        ReadLn (EditMNU, TMP. MenuAction2);
        ReadLn (EditMNU, TMP. ExecuteCommand);
        ReadLn (EditMNU, TMP. SecurityAccess);
        ReadLn (EditMNU, TMP. SecurityValue);
        WriteLn (TempMNU, TMP. MenuKey);
        WriteLn (TempMNU, TMP. MenuAction1);
        WriteLn (TempMNU, TMP. MenuAction2);
        WriteLn (TempMNU, TMP. ExecuteCommand);
        WriteLn (TempMNU, TMP. SecurityAccess);
        WriteLn (TempMNU, TMP. SecurityValue);
      Until EoF (EditMNU);
    End;
    Close (TempMNU);
    Close (EditMNU);
    TempDir := AllTrim (CFG. MenuDir);
    Assign (EditMNU, TempDir + FileNameMNU + '.MNU');
    Erase (EditMNU);
    TempDir := AllTrim (CFG. MenuDir);
    Assign (TempMNU, TempDir + 'MNUFILE.TMP');
    TempDir := AllTrim (CFG. MenuDir);
    Rename (TempMNU, TempDir + FileNameMNU + '.MNU');
  End;
End;

Procedure DeleteMNUOptionMenu;
Var
  MenuPos : Byte;
  Done    : Boolean;
  Input   : Char;
Begin
  TextColor (White);
  TextBackground (Black);
  GotoXY (8, 9);
  Write ('  Delete  ');
  TextBackground (Blue);
  GotoXY (25, 9);
  Write ('Forget IT!');
  TextBackground (Black);
  MenuPos := 1;
  Done := False;
  Repeat
    Input := ReadKey;
    If (Input = LeftArrow) Or (Input = RightArrow) Then
    Begin
      If MenuPos = 1 Then
      Begin
        MenuPos := 2;
        TextBackground (Blue);
        GotoXY (8, 9);
        Write ('  Delete  ');
        TextBackground (Black);
        GotoXY (25, 9);
        Write ('Forget IT!');
      End
      Else
      Begin
        MenuPos := 1;
        TextBackground (Black);
        GotoXY (8, 9);
        Write ('  Delete  ');
        TextBackground (Blue);
        GotoXY (25, 9);
        Write ('Forget IT!');
      End;
    End
    Else If Input = ESCKey Then
    Begin
      Done := True;
    End
      Else If Input = ReturnKey Then
      Begin
        If MenuPos = 2 Then
        Begin
          DeleteMNUFileOption;
        End;
        Done := True;
      End;
  Until Done = True;
  TextBackground (Black);
End;

(* 1 = Retreive, 2 = Delete *)
Procedure ReadMNUFile (Mode : Integer);
Var
  Loop, ScrollUp,
  ScrollDown, Start,
  Max                : Integer;
  MNUTextFile        : Text;
  Done               : Boolean;
  TempChar           : Char;
  OptionsArray       : Array [1..30] Of FelMNU;
  TempStr            : String [25];
  TempDir            : String [40];
Begin
  Loop := 0;
  TempDir := AllTrim (CFG. MenuDir);
  Assign (MNUTextFile, TempDir + FileNameMNU + '.MNU');
  Reset (MNUTextFile);
  Repeat
    Inc (Loop);
    ReadLn (MNUTextFile, OptionsArray [Loop].MenuKey);
    ReadLn (MNUTextFile, OptionsArray [Loop].MenuAction1);
    ReadLn (MNUTextFile, OptionsArray [Loop].MenuAction2);
    ReadLn (MNUTextFile, OptionsArray [Loop].ExecuteCommand);
    ReadLn (MNUTextFile, OptionsArray [Loop].SecurityAccess);
    ReadLn (MNUTextFile, OptionsArray [Loop].SecurityValue);
  Until (EoF (MNUTextFile) ) Or (Loop = 30);
  Close (MNUTextFile);
  Max := Loop;
  Done := False;
  ScrollUp := 0;
  If Max > 6 Then
  Begin
    ScrollDown := Max - 6;
  End
  Else
  Begin
    ScrollDown := 0;
  End;
  Start := 1;
  TextColor (White);
  TextBackground (Blue);
  GotoXY (9, 14);
  TempStr := ExpandMenuAction (OptionsArray [1].MenuAction1, OptionsArray [1].MenuAction2);
  Write (TempStr);
  TextBackground (Black);
  If Max > 6 Then
  Begin
    For Loop := 2 To 6 Do
    Begin
      GotoXY (9, 13 + Loop);
      TempStr := ExpandMenuAction (OptionsArray [Loop].MenuAction1, OptionsArray [Loop].MenuAction2);
      Write (TempStr);
    End;
  End
  Else
  Begin
    For Loop := 2 To Max Do
    Begin
      GotoXY (9, 13 + Loop);
      TempStr := ExpandMenuAction (OptionsArray [Loop].MenuAction1, OptionsArray [Loop].MenuAction2);
      Write (TempStr);
    End;
  End;
  Repeat
    TextBackground (Blue);
    TextColor (White);
    GotoXY (44, 9);
    TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
    Write (TempStr);
    GotoXY (58, 12);
    Write (OptionsArray [Start].MenuKey);
    GotoXY (43, 15);
    Write (OptionsArray [Start].ExecuteCommand);
    GotoXY (52, 18);
    Write (OptionsArray [Start].SecurityAccess);
    TempChar := ReadKey;
    TextBackground (Black);
    If TempChar = UpArrow Then
    Begin
      If (Start <> (ScrollUp + 1) )  And (Start <> 1) Then
      Begin
        GotoXY (9, 13 + (Start - ScrollUp) );
        TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
        Write (TempStr);
        Dec (Start);
        TextBackground (Blue);
        GotoXY (9, 13 + (Start - ScrollUp) );
        TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
        Write (TempStr);
      End
      Else If Start <> 1 Then
      Begin
        Dec (Start);
        Dec (ScrollUp);
        Inc (ScrollDown);
        TextBackground (Blue);
        GotoXY (9, 14);
        TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
        Write (TempStr);
        TextBackground (Black);
        For Loop := 2 To 6 Do
        Begin
          GotoXY (9, 13 + Loop);
          TempStr := ExpandMenuAction (OptionsArray [Loop + ScrollUp].MenuAction1, OptionsArray [Loop + ScrollUp].MenuAction2);
          Write (TempStr);
        End;
      End;
    End
    Else If TempChar = DownArrow Then
    Begin
      If (Start <> (Max - ScrollDown) ) And (Start <> Max) Then
      Begin
        GotoXY (9, 13 + (Start - ScrollUp) );
        TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
        Write (TempStr);
        Inc (Start);
        TextBackground (Blue);
        GotoXY (9, 13 + (Start - ScrollUp) );
        TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
        Write (TempStr);
      End
      Else If Start <> Max Then
      Begin
        Inc (Start);
        Inc (ScrollUp);
        Dec (ScrollDown);
        For Loop := 1 To 5 Do
        Begin
          GotoXY (9, 13 + Loop);
          TempStr := ExpandMenuAction (OptionsArray [ScrollUp + Loop].MenuAction1, OptionsArray [ScrollUp + Loop].MenuAction2);
          Write (TempStr);
        End;
        Inc (Loop);
        TextBackground (Blue);
        GotoXY (9, 13 + Loop);
        TempStr := ExpandMenuAction (OptionsArray [Start].MenuAction1, OptionsArray [Start].MenuAction2);
        Write (TempStr);
      End;
    End
      Else If TempChar = ReturnKey Then
      Begin
        FileIndex := Start;
        Done := True;
        If Mode = 1 Then
        Begin
          TextBackground (Blue);
          GotoXY (58, 12);
          Write ('  ');
          GotoXY (43, 15);
          Write ('                               ');
          GetMenuAction;
          EditMNUFileMenu;
        End
        Else
        Begin
          DeleteMNUOptionMenu;
        End;
      End
        Else If TempChar = ESCKey Then
        Begin
          Done := True;
        End;
  Until Done = True;
  TextBackground (Black);
  For Loop := 1 To 6 Do
  Begin
    GotoXY (9, 13 + Loop);
    Write ('                         ');
  End;
End;

Procedure EditMNUFile;
Var
  Count : Byte;
Begin
  DrawInputScreen;
  TextColor (White);
  TextBackground (Black);
  GotoXY (8, 9);
  Write ('   Save   ');
  TextBackground (Blue);
  GotoXY (25, 9);
  Write ('Forget IT!');
  TextBackground (Black);
  If GetFileName = True Then
  Begin
    ReadMNUFile (1);
  End;
  For Count := 1 To 17 Do
  Begin
    GotoXY (3, 5 + Count);
    Write ('                                                                          ');
  End;
End;

Procedure DeleteMNUOption;
Var
  Count : Byte;
Begin
  DrawInputScreen;
  TextColor (White);
  TextBackground (Black);
  GotoXY (8, 9);
  Write ('  Delete  ');
  TextBackground (Blue);
  GotoXY (25, 9);
  Write ('Forget IT!');
  TextBackground (Black);
  If GetFileName = True Then
  Begin
    ReadMNUFile (2);
  End;
  For Count := 1 To 17 Do
  Begin
    GotoXY (3, 5 + Count);
    Write ('                                                                          ');
  End;
End;

Procedure MenuEditorMain;
Var
  Done           : Boolean;
  MenuKey        : Char;
  MenuItem, Loop : Byte;
  SystemHlp      : Array [1..3] Of String [58];
Begin
  Done := False;
  DrawMenuBox;
  DrawMainFrame;
  GotoXY (10, 21);
  TextColor (13);
  TextBackground (0);
  Write ('                                                           ');
  MenuItem := 1;
  SystemHlp [1] := 'Create a New Menu File or a New Menu Option.              ';
  SystemHlp [2] := 'Edit an already existing Menu Option.                     ';
  SystemHlp [3] := 'Delete Option from Menu List.                             ';
  TextBackground (Black);
  TextColor (White);
  GotoXY (36, 7);
  Pipeparser ('|80M|70e|f0nu Edit|70o|80r', False);
  TextBackground (0);
  TextColor (Blue);
  GotoXY (30, 9);
  Pipeparser ('|10C|30r|f0eate New Me|30n|10u |80(|90F|10ile|80/|90O|10ption|80)', False);
  GotoXY (30, 10);
  Pipeparser ('|10E|30d|f0it Menu Opti|30o|10n', False);
  GotoXY (30, 11);
  Pipeparser ('|10D|30e|f0lete Menu Opti|30o|10n', False);
  TextBackground (Black);
  GotoXY (23, 12);
  Write ('                                    ');
  GotoXY (23, 13);
  Write ('                                    ');
  GotoXY (23, 14);
  Write ('                                    ');
  GotoXY (12, 21);
  TextBackground (0);
  TextColor (5);
  Write (SystemHlp [1] );
  GotoXY (25, 9);
  TextBackground (0);
  TextColor (1);
  Write ('');
  Repeat
    MenuKey := ReadKey;
    GotoXY (25, 8 + MenuItem);
    TextBackground (0);
    TextColor (Black);
    Write ('');
    TextBackground (Black);
    If MenuKey = DownArrow Then
    Begin
      Inc (MenuItem);
      If MenuItem = 4 Then
      Begin
        MenuItem := 1;
      End;
    End
    Else If MenuKey = UpArrow Then
    Begin
      Dec (MenuItem);
      If MenuItem = 0 Then
      Begin
        MenuItem := 3;
      End;
    End
      Else If MenuKey = ReturnKey Then
      Begin
        TextBackground (Black);
        For Loop := 1 To 12 Do
        Begin
          GotoXY (22, 5 + Loop);
          Write ('                                                ');
        End;
        If MenuItem = 1 Then
        Begin
          InitMNU;
          MenuEditorOneData;
        End
        Else If MenuItem = 2 Then
        Begin
          EditMNUFile;
        End
          Else If MenuItem = 3 Then
          Begin
            DeleteMNUOption;
          End;
        DrawMainFrame;
        DrawMenuBox;
        TextBackground (0);
        TextColor (Blue);
        GotoXY (30, 9);
        Write ('Create New Menu File/Option');
        GotoXY (30, 10);
        Write ('Edit Menu Option           ');
        GotoXY (30, 11);
        Write ('Delete Menu Option         ');
        TextBackground (Black);
        GotoXY (23, 12);
        Write ('                                    ');
        GotoXY (23, 13);
        Write ('                                    ');
        GotoXY (23, 14);
        Write ('                                    ');
        GotoXY (10, 21);
        TextColor (13);
        TextBackground (0);
        Write ('                                                           ');
        Show_FNYPNC_ANS;
        Drawconfigframe;
        DrawMainFrame;
        MenuEditorMain;
      End;
    GotoXY (25, 8 + MenuItem);
    TextBackground (0);
    TextColor (1);
    Write ('');
    TextBackground (Black);
    GotoXY (12, 21);
    TextBackground (0);
    TextColor (5);
    Write (SystemHlp [MenuItem] );
  Until menukey = #27;
End;

Procedure MenuEditor;
Begin
  DrawConfigFrame;
  MenuEditorMain;
End;

Begin
  Cursor_Off;
  TextBackground (Black);
  TextColor (White);
  ClrScr;
  ReadCFG;
  InitMNU;
  MenuEditor;
End.