{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: setup
 *
 * vbc 090308 -  updated preset params on log hist, archivers
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Init;

{$O+}

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div;


Procedure Purge;
Procedure ReIndex;
Procedure Rebuild_Areafile( fullscreen:boolean );
Procedure Rebuild_Nodefile( fullscreen:boolean );
Procedure NewSetup;
Function  ReadSetup(fullscreen:boolean) : Boolean;
Procedure FindSystempath;


Implementation

procedure del_sema;
var
  tmp : string;
begin
  if setup.semamode <> 0 then
    begin
      if setup.semaphorepath <> '' then
        tmp := setup.semaphorepath else tmp := systempath;
      delete_file(tmp+'FMBUSY.NOW');
    end;
end;


fUNCTION Check_Sema(fullscreen:boolean) : Boolean;  {false if couldn't created/other task busy}
var
  h, m,
  s, hund : Word;
  tmp : string;
  sr  : searchrec;
  mu, lu  : longint;
  Dt  : Datetime;
Begin
  If setup.semamode <> 0 {none} then
    Begin
      If setup.semaphorepath <> '' then
        begin
          if last(1,setup.semaphorepath) <> '\' then setup.semaphorepath := setup.semaphorepath + '\';
          tmp := setup.semaphorepath;
        end else tmp := systempath;
      If Exist(tmp+'FMBUSY.NOW') then
        Begin                                       { check for startup semaphore }
          FindFirst(tmp+'FMBUSY.NOW', archive, sr);
          If Doserror = 0 then
            Begin
              unpacktime(sr.time,dt);
              mu := getunixdate(dt);
              With dt do
                begin
                  GetTime (Hour, Min, Sec, hund);
                  GetDate (Year, Month, Day, hund);
                end;
              lu := GetUnixDate(dt);
              If (lu-mu) > (setup.maxwaittime*60) then
                Begin        { als ie te oud is deleten }
                  if fullscreen then
                    Askwindow('Semaphore is',int_to_str((lu-mu) div 60)+' minutes old,','deleted',[#13,#27,#32]) else
                      writeln('Semaphore is '+int_to_str((lu-mu) div 60)+' minutes old, deleted...');
                  Delete_file(tmp+'FMBUSY.NOW');
                  Create_File(tmp+'FMBUSY.NOW'); { en nieuwe creeren }
                End Else
                Begin       { anders wachten totdat maxwait op is }
                  if fullscreen then
                    Askwindow('','Other FileMgr task is busy','',[#13,#27,#32]) else
                      writeln('Other FileMgr task is busy');
                  check_sema := false;
                  Exit;
                  { als ie dan nog bestaat halt }
                End;
              While doserror = 0 do findnext(sr);
            End;
          check_sema := true;
        End Else
        Begin                           { if not found set startup semaphore zelf }
          Create_File(tmp+'FMBUSY.NOW');
          check_sema := true;
        End;
    End;
End;

Procedure Purge;
Var
  gfbak  : file of grouptype;
  bf     : file;
  afxinx : word;
  count,
  nfxinx : word;
  bol    : array[1..256] of boolean;
  found  : boolean;
Begin
  if not readsetup(false) then exit;

  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      Writeln('Not enough memory left'+#10#13);
      del_sema;
      Halt;
    End Else New(Sfxt);

  Writeln('Packing area database...');

  Assign(AFX,Systempath + 'AREAFILE.FMX');
  {$I-} Reset(AFX,1); {$I+}
  If Ioresult <> 0 then
    Begin
      Writeln('Cannot find '+upper(systempath)+'AREAFILE.FMX'+#10#13);
      del_sema;
      Halt;
    End;
  Close(Afx);

  ReadAreaIndex;

(*  Assign(af, Systempath+'AREAFILE.FM');
  {$I-} Reset(af,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot find '+upper(systempath)+'AREAFILE.FM'+#10#13);
      del_sema;
      Halt;
    End;
*)
  Assign(bf,Systempath+'AREAFILE.NEW');
  {$I-} Rewrite(bf,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot create '+upper(systempath)+'AREAFILE.NEW'+#10#13);
      del_sema;
      Halt;
    End;

  For afxinx := 1 to areaidx do
    Begin
      Seek (AF, Afxt^[afxinx].AreaRec);
      BlockRead (AF, AREA, SizeOf(AREA),count);
      if count = sizeof(area) then
        begin
          BlockRead (AF, sfxt^, AREA.ExportNr*SizeOf(ExportType));

          Write(expand(area.tag,20),#13);
          Afxt^[afxinx].AreaRec := filesize(bf);

          BlockWrite(BF, AREA, Sizeof(AREA));
          BlockWrite(BF, sfxt^, AREA.ExportNr*Sizeof(exporttype));
       end else writeln('Error reading '+afxt^[afxinx].tag);
    End;


  {$I-}
  Close(Af);
  Erase(af);
  {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Error closing '+systempath+'AREAFILE.FM'+#10#13);
      del_sema;
      Halt;
    End;

  {$I-} Close(bf); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Error closing '+systempath+'AREAFILE.NEW'+#10#13);
      del_Sema;
      Halt;
    End;

  {$I-} Rename(Bf,systempath+'AREAFILE.FM'); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Error renaming '+systempath+'AREAFILE.NEW to AREAFILE.FM'+#10#13);
      del_sema;
      Halt;
    End;

  Assign(Af,systempath+'AREAFILE.FM');
  {$I-} Reset(Af); {$I+}
  If ioresult <> 0 then {};

  WriteAreaIndex;
  Dispose(Sfxt);


{----}

  Writeln('Packing node database...');

  Assign(nFX,Systempath + 'NODEFILE.FMX');
  {$I-} Reset(nFX,1); {$I+}
  If Ioresult <> 0 then
    Begin
      Writeln('Cannot find '+upper(systempath)+'NODEFILE.FMX'+#10#13);
      del_sema;
      Halt;
    End;
  Close(nfx);

  ReadNodeIndex;

(*  Assign(nf, Systempath+'NODEFILE.FM');
  {$I-} Reset(nf,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot find '+upper(systempath)+'NODEFILE.FM'+#10#13);
      del_sema;
      Halt;
    End; *)

  Assign(bf,Systempath+'NODEFILE.NEW');
  {$I-} Rewrite(bf,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot create '+upper(systempath)+'NODEFILE.NEW'+#10#13);
      del_sema;
      Halt;
    End;

  For nfxinx := 1 to nodeidx do
    Begin
      Seek (nF, nfxt^[nfxinx].nodeRec);
      BlockRead (nF, node, SizeOf(node));

      Write(expand(node2str(node.address),20),#13);
      nfxt^[nfxinx].nodeRec := filesize(bf);

      BlockWrite(BF, node, Sizeof(node));
    End;


  {$I-}
  Close(nf);
  Erase(nf);
  Close(bf);
  Rename(Bf,systempath+'NODEFILE.FM');
  {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Error closing/renaming '+systempath+'NODEFILE.FM'+#10#13);
      del_sema;
      Halt;
    End;

  Assign(nf,systempath+'NODEFILE.FM');
  {$I-} Reset(nf); {$I+}
  If ioresult <> 0 then {};

  WriteNodeIndex;


{----}

  Writeln('Packing group database...');

  Assign(gF,Systempath + 'GROUPS.FM');
  {$I-} Reset(gF); {$I+}
  If Ioresult <> 0 then
    Begin
      Writeln('Cannot find '+upper(systempath)+'GROUPS.FM'+#10#13);
      del_sema;
      Halt;
    End;

  for afxinx := 1 to 256 do bol[afxinx] := false;

  while not eof(gf) do
    begin
      read(gf,group);
      bol[group.groupnr] := true;
    end;

  assign(gfbak,systempath+'GROUPS.NEW');
  {$I-} rewrite(gfbak); {$I+}
  if ioresult <> 0 then
    begin
      writeln('Cannot create '+upper(systempath)+'GROUPS.NEW'+#10#13);
      del_sema;
      halt;
    end;

  for afxinx := 1 to 256 do
    begin
      if bol[afxinx] then
        begin
          reset(gf);
          found := false;
          while not eof(gf) and not found do
            begin
              read(gf,group);
              if group.groupnr = afxinx then
                begin
                  found := true;
                  write(gfbak,group);
                  write(expand(group.groupname,40),#13);
                end;
            end;
        end;
    end;

  {$I-}
  close(gf);
  close(gfbak);
  erase(gf);
  rename(gfbak,systempath+'GROUPS.FM');
  {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Error closing/renaming '+systempath+'GROUPS.FM'+#10#13);
      del_sema;
      Halt;
    End;

  writeln(expand(' ',79));
  Writeln('Database files packed succesfully.');

  del_sema;
End;



Procedure Rebuild_Areafile( fullscreen:boolean );
Var
  Areax : Areaindextype;
  areawr : word;
  x : word;
Begin
  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      If fullscreen then
        AskWindow('','Not enough memory left','',[#13,#27,#32]) else
          Writeln('Not enough memory left');
      Exit;
    End Else New(Sfxt);

  If MaxAvail < SizeOf(Afxt^) then
    Begin
      if fullscreen then
        AskWindow('','Not enough memory left','',[#13,#27,#32]) else
          writeln('Not enough memory left');
      exit;
    End Else New(Afxt);

  areaidx := 0;
  Seek (AF,0);
  While (IOresult=0) and (not EOF(AF)) do
    Begin
      {$I-} BlockRead (AF, AREA, SizeOf(AREA)); {$I+}

      If Area.tag <> '' then
        Begin
          If fullscreen then writeat(1,25,7,0,expand(area.tag,79)) else
            write(expand(area.tag,30)+#13);

          Areax.AreaRec := FilePos(AF)-SizeOf(AREA);
          Areax.Tag     := AREA.TAG;
          Areax.Grp     := AREA.Grp;

          x := 1;
          while (x <= areaidx) and (upper(area.tag) <> upper(afxt^[x].tag)) do inc(x);
          if x > areaidx then
            begin
              inc(areaidx);
              afxt^[areaidx] := areax;
            end else
            begin
              afxt^[x] := areax;
            end;
        End;
      If area.exportnr > 0 then
        {$I-} BlockRead (Af, sfxt^, (Area.ExportNr*SizeOf(ExportType))); {$I+}
    End;

  {$I-} rewrite(Afx,1); {$I+}
  If ioresult <> 0 then
    Begin
      If fullscreen then
        AskWindow('','Cannot open/rewrite AREAFILE.FMX','',[#13,#27,#32])
          else writeln('Cannot open/rewrite AREAFILE.FMX');
      Exit;
    End;
  BlockWrite(Afx,Afxt^,AreaIdx*sizeof(areaindextype),AreaWr);
  If AreaWr <> (AreaIdx*sizeof(areaindextype)) then
    begin
      if fullscreen then AskWindow('','Cannot rewrite AREAFILE.FMX','',[#13,#27,#32])
        else writeln('Cannot rewrite AREAFILE.FMX');
    end;

  Dispose(Sfxt);
  dispose(afxt);

  If fullscreen then
      writeat(1,25,7,0,expand(' ',79));
End;



Procedure Rebuild_Nodefile(fullscreen:boolean);
Var
  Nodex : Nodeindextype;
Begin
  ReWrite (NFX,1);
  Seek (NF, 0);
  While (ioresult = 0) and not EOF(NF) do
    Begin
      {$I-} BlockRead (NF, NODE,sizeof(node)); {$I+}
      If (node.address.zone = 0) and (node.address.net = 0) and
         (node.address.node = 0) and (node.address.point = 0) then
           Begin
           End else
           Begin
             If fullscreen then writeat(1,25,7,0,expand(node2str(node.address),79)) else
               write(expand(node2str(node.address),30)+#13);

             Nodex.Address := NODE.Address;
             Nodex.NodeRec := FilePos(NF)-sizeof(node);
             {$I-} Blockwrite(NFX, NODEX, sizeof(nodex)); {$I+}
           End;
    End;
  If fullscreen then
    writeat(1,25,7,0,expand(' ',79));
End;



Procedure ReIndex;
Begin
  if not readsetup(false) then exit;

  Writeln('Creating new database index filesetup...');

  Assign(NF,Systempath + 'NODEFILE.FM');
  {$I-} Reset(NF,1); {$I+}
  If Ioresult <> 0 then
    Begin
      Writeln(Upper(Systempath)+'NODEFILE.FM not found');
      Exit;
    End;

  Assign(NFX,Systempath + 'NODEFILE.FMX');
  {$I-} Reset(NFX,1); {$I+}
  If ioresult <> 0 then rewrite(nfx,1);
  Rebuild_nodefile(false);
  Close(Nfx);
  Close(Nf);



  Assign(AF,Systempath + 'AREAFILE.FM');
  {$I-} Reset(AF,1); {$I+}
  If Ioresult <> 0 then
    Begin
      Writeln(Upper(Systempath)+'AREAFILE.FM not found');
      Exit;
    End;

  Assign(AFX,Systempath + 'AREAFILE.FMX');
  {$I-} Reset(AFX,1); {$I+}
  If ioresult <> 0 then rewrite(afx,1);
  Rebuild_areafile(false);
  Close(Afx);
  Close(Af);

  Writeln('New database index files created succesfully.');
  del_sema;
End;



Procedure NewSetup;
Begin
  FillChar (SETUP, SizeOf(SETUP), #0);

  setup.Version           := VERSIONNR;
  setup.SysopName         := 'System Operator';
  setup.SystemName        := 'System Name';
  setup.Days2Keep         := 21;
  setup.Touch             := True;
  setup.Replace           := False;
  setup.ForceIntl         := False;
  setup.KillRcvd          := True;
  setup.IgnUnknown        := 1;
  setup.LogFile           := Systempath + 'FILEMGR.LOG';
  setup.Mailer            := 01; {FrontDoor}
  setup.HistoryWeeks      := 52;
  setup.HistoryKb         := 128;  { vbc 090308 - updated preset params inc archvers }
  setup.PackerName[1]     := 'pkzip.exe';
  setup.packswitch[1]     := '%1 -r -P @%2';
  setup.bannerswitch[1]   := '%1 -z < %2';
  setup.PackerName[2]     := 'arj.exe';
  setup.packswitch[2]     := 'a -s %1 !%2';
  setup.bannerswitch[2]   := 'c -s %1 -z%2';
  setup.PackerName[3]     := 'lha.exe';
  setup.packswitch[3]     := 'a /x /p /m %1 @%2';
  setup.PackerName[4]     := 'pkarc.exe';
  setup.packswitch[4]     := '-a %1 @%2';
  setup.PackerName[8]     := 'rar.exe';
  setup.packswitch[8]     := 'a -tl -av -ep1 %1 !%2';
  setup.PackerName[11]    := 'gus.exe %1';
  setup.bannerswitch[8]   := 'c %1 =%2';
  setup.UnPackerName[1]   := 'pkunzip.exe';
  setup.unpackswitch[1]   := '-o -d %1';
  setup.UnPackerName[2]   := 'arj.exe';
  setup.unpackswitch[2]   := 'x -y %1';
  setup.UnPackerName[3]   := 'lha.exe';
  setup.unpackswitch[3]   := 'x %1';
  setup.UnPackerName[4]   := 'pkunpak.exe';
  setup.unpackswitch[4]   := '-e %1';
  setup.UnPackerName[8]   := 'unrar.exe';
  setup.unpackswitch[8]   := 'e -o+ c- %1';
  setup.DefaultPwd        := 'DEFAULT';
  setup.OrigLine[1]       := 'FileMgr -- The Ultimate File Processor';
  setup.alias[1]          := 'Filem*';
  setup.alias[2]          := 'Allfix';
  setup.alias[3]          := 'Raid';
  setup.alias[4]          := 'Filefix';
  setup.alias[5]          := 'tic*';
  setup.ShowPack          := True;
  setup.ShowSwapping      := True;
  setup.Showvirus         := true;
  setup.Showunpack        := true;
  setup.Virusparm         := '/BELL /NOMEM /NOPAUSE';
  setup.Logstatus         := [LFatal..LProcess];
  setup.swapmethode       := 583;
  setup.filebase          := 0;
  setup.timezone          := -1;
  setup.maxmsgsize        := 16;
  setup.descstart         := 14;
  setup.maxwaittime       := 180;
  setup.dupchecking       := 2;
  setup.FFkeylen          := 3;
  setup.FFmax             := 50;
  setup.FFmaxsize         := 16;

 setup.dayarray[1] := 'Sunday';
 setup.dayarray[2] := 'Monday';
 setup.dayarray[3] := 'Tuesday';
 setup.dayarray[4] := 'Wednesday';
 setup.dayarray[5] := 'Thursday';
 setup.dayarray[6] := 'Friday';
 setup.dayarray[7] := 'Saturday';

 setup.montharray[1] := 'January';
 setup.montharray[2] := 'February';
 setup.montharray[3] := 'March';
 setup.montharray[4] := 'April';
 setup.montharray[5] := 'May';
 setup.montharray[6] := 'June';
 setup.montharray[7] := 'July';
 setup.montharray[8] := 'August';
 setup.montharray[9] := 'September';
 setup.montharray[10] := 'October';
 setup.montharray[11] := 'November';
 setup.montharray[12] := 'December';

 setup.Readkey := 'R';
 setup.Scankey := 'S';
 setup.Yellkey := 'Y';
 setup.Helpkey := 'H';
 setup.Enterkey := 'E';
 setup.Quitkey := 'Q';
 setup.Logoffkey := '!';
 setup.Yelltime   := 20;
 setup.Mainfile   := 'FFMAIN';
 setup.Helpfile   := 'FFHELP';
 setup.Logofffile := 'FFBYE';
End;


Procedure FindSystempath;
Var sr : searchrec;
Begin
  Systempath := GetEnv('FILEMGR');
  If (systempath = '\') or (systempath = '') then
    Begin
      GetDir(0, SystemPath);
      If last(1,Systempath) <> '\' then SystemPath := Systempath + '\';
      Findfirst (systempath+'SETUP.FM',$0,sr);
      If DosError <> 0 then
        Begin
          Systempath := paramstr(0);
          Systempath := file_split(1,SystemPath);
        End;
    End;
  If last(1,Systempath) <> '\' then SystemPath := Systempath + '\';
End;


Function ReadSetup(fullscreen:boolean) : Boolean;
Var
  ch      : char;
  tmp     : string;
  ct      : longint;
  x       : byte;
Begin
  Filemode := 18;
  Assign (SF, SystemPath + 'SETUP.FM');
  {$I-} Reset (SF); {$I+}
  If IOresult <> 0 then
    Begin
      If not Exist(systempath+'SETUP.FM') then
        Begin
          Shadow := true;
          MkWin(20,10,60,16,11,0,2);
          Tmp := upper(systempath)+'SETUP.FM';
          Writeat(40-(length(tmp) div 2),12,7,0,tmp);
          Tmp := 'File or path not found!';
          Writeat(40-(length(tmp) div 2),14,7,0,tmp);
          Writeat(1,25,7,0,'Press SPACE to create or ESCAPE to abort');
          Writeat(7,25,14,0,'SPACE');
          Writeat(26,25,14,0,'ESCAPE');
          ch := #0;
          While not (ch in [#32,#27]) do ch := readkey;
          Rmwin;
          Shadow := false;
          If Ch = #32 then
            Begin
              ReWrite (SF);
              NewSetup;
              Write (SF, SETUP);
              Close(SF);

              create_file(systempath+'groups.fm');
              create_file(systempath+'nodefile.fm');
              create_file(systempath+'nodefile.fmx');
              create_file(systempath+'areafile.fm');
              create_file(systempath+'areafile.fmx');
              create_file(systempath+'messages.fm');
              create_file(systempath+'filefind.fm');
            End Else
            begin
              ReadSetup := False;
              Exit;
            end;
        End Else
        Begin
          AskWindow('','Cannot open SETUP.FM','',[#27,#13,#32]);
          ReadSetup := False;
          Exit;
        End;
    End Else
    Begin
      {$I-} Read (SF, SETUP); {$I+}
      If IOresult <> 0 then
        Begin
          Close(Sf);
          AskWindow('','Old FileMgr setup found, run UPGRADE.EXE first!','',[#27,#13,#32]);
          ReadSetup := False;
          Exit;
        End Else Close(Sf);
      If setup.version < versionnr then
        Begin
          AskWindow('Found','FileMgr v'+verstr(setup.version)+' setup','run UPGRADE.EXE to upgrade',[#27,#13,#32]);
          ReadSetup := False;
          Exit;
        End;
      If setup.version > versionnr then
        Begin
          Askwindow('Found FileMgr v'+verstr(setup.version)+'.','This setup program is','for version '
            +verstr(versionnr)+'!',[#27,#13,#32]);
          Readsetup := false;
          Exit;
        End;
    End;

  If not Check_sema(fullscreen) then
    begin
      readsetup := false;
      exit;
    end;

  Assign(GF,Systempath + 'GROUPS.FM');
  {$I-} Reset(GF); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'GROUPS.FM not found','Create new?','(Y/N)',['Y','y','N','n']) in ['y','Y'] then
        Begin
          Rewrite(Gf);
        End Else
        Begin
          ReadSetup := False;
          del_sema;
          Exit;
        End;
    End;
  Close(GF);


  Assign(sa,Systempath + 'FILEFIND.FM');
  {$I-} Reset(sa); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'FILEFIND.FM not found','Create new?','(Y/N)',['Y','y','N','n']) in ['y','Y'] then
        Begin
          Rewrite(sa);
        End Else
        Begin
          ReadSetup := False;
          del_sema;
          Exit;
        End;
    End;
  Close(sa);


  Assign(NF,Systempath + 'NODEFILE.FM');
  {$I-} Reset(NF,1); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'NODEFILE.FM not found','Create new?','(Y/N)',['Y','y','N','n']) in ['y','Y'] then
        Begin
          Rewrite(Nf,1);
          Delete_File(systempath+'NODEFILE.FMX');
        End Else
        Begin
          ReadSetup := False;
          del_sema;
          Exit;
        End;
    End;

  Assign(NFX,Systempath + 'NODEFILE.FMX');
  {$I-} Reset(NFX,1); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'NODEFILE.FMX not found','Rebuild from NODEFILE.FM?','(Y/N)',
        ['Y','y','N','n']) in ['y','Y'] then
        Begin
          Rebuild_nodefile(true);
        End Else
        Begin
          ReadSetup := False;
          del_sema;
          Exit;
        End;
    End;
  Close(Nfx);
  Close(Nf);


  Assign(mF,Systempath+'MESSAGES.FM');
  {$I-} Reset(mf); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'MESSAGES.FM not found','Create new?','(Y/N)',['Y','y','n','N']) in ['y','Y'] then
        Begin
          Rewrite(mf);
        End Else
        Begin
          ReadSetup := False;
          del_sema;
          Exit;
        End;
    End;
  Close(mf);

  Assign(AF,Systempath + 'AREAFILE.FM');
  {$I-} Reset(AF,1); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'AREAFILE.FM not found','Create new?','(Y/N)',['Y','y','N','n']) in ['y','Y'] then
        Begin
          Rewrite(af,1);
          Delete_file(systempath+'AREAFILE.FMX');
        End Else
        Begin
          ReadSetup := False;
          del_sema;
          Exit;
        End;
    End;

  Assign(AFX,Systempath + 'AREAFILE.FMX');
  {$I-} Reset(AFX,1); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'AREAFILE.FMX not found','Rebuild from AREAFILE.FM?','(Y/N)'
        ,['Y','y','N','n']) in ['y','Y'] then
        Begin
          Rebuild_areafile(true);
        End Else
        Begin
          ReadSetup := False;
          Del_Sema;
          Exit;
        End;
    End;
  Close(Afx);
  Close(Af);

  If MaxAvail < 40000 then
    Begin
      Askwindow('','Not enough memory left','',[#13,#27,#32]);
      del_sema;
      Halt(1);
    End;

  { -------- security password -------- }


  If setup.password <> '' then
    Begin
      With Mwin[1] do
        Begin
          x1 := 30;
          x2 := 10;
          y1 := 50;
          y2 := 14;
          st := ' Password ';
        End;
      Create_Window(1);
      Tmp := '';
      Writeat(1,25,7,0,'Security access password needed!');
      Read_password(32,12,17,22,tmp,c_all);
      Remove_Window(1);

      for x := 1 to length(setup.password) do
        setup.password[x] := chr(ord(setup.password[x])+30);

      if upper(setup.password) <> upper(tmp) then
        begin
          Askwindow('','Invalid password!','',[#13,#32,#27]);
          Del_sema;
          Halt;
        end;
    End;
End;

END.
