{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............:  setup
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:257/609
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Div;

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File, Fm_List, Fm_Exec;

{$I FMSETUP.STR}

{---------------------------------------------------------------------------}

Function  SameRec (var a, b; size : word) : Boolean;
Function  VerStr ( ver : word ) : String;
Function  Yesno  ( bol : boolean ) : String;
{$F+} Procedure Dummy(which:byte); {$F-}
{$F+} Procedure InfoScreen; {$F-}
{$F+} Procedure DosShell; {$F-}
Procedure SetPrompt( NewPrompt:String );
Function  GetBbsSystem : String;
Procedure CheckPath(VAR Str:string);
function checkepath(str:string;endslace:boolean):string;
Procedure ShowFlow( var flow:flowtype; var lastmonth:byte );
Procedure SortSystemList (Size : Byte);
Function GetUnixDate (DT : DateTime) : LongInt;

Procedure DecWin(win:byte);
Procedure IncWin(win:byte);

Function  Node2Str (N : NodeType) : String;
Procedure Str2Node (S : String; VAR N : NodeType; D : Nodetype; VAR Valid : Boolean);

Procedure WriteColor(line,normal,highc,backc:byte;str:string);
Procedure WriteAttribs(x,y:byte; len:byte; attrib:msgattribset; netmail:boolean);

Function  NextFrequency ( next:LongInt ) : String;
Function  NextDate (D : LongInt; IV : FrequencyType; Day : Byte) : LongInt;
Function  Is_Dup( exportnr:word; newnode:nodetype ) : Boolean;
Function  Node_Bits_Status( s : nodebitstype ) : String;
Function  WriteGroups(maxlength:byte; group:booleanset): String;
Function  WriteFrequency(freq:frequencytype; day:byte) : String;

Procedure ReadGroups;
Procedure ReadMessages;
Procedure ReadAreaIndex;
Procedure ReadNodeIndex;

Procedure WriteAreaIndex;
Procedure WriteNodeIndex;

Procedure Change_GlobalAreaStatus(window:byte; VAR status:statustype; VAR nostatus:statustype);

Procedure Select_Node_Systemlist ( window:byte; VAR Ex:ExportType; packchange:boolean; aka:byte );
Function  Select_Address(window,aka:byte;akamatch:boolean) : Byte;
Function  Select_Group(window,active:byte) : Byte;
Function  Select_Node(window,active:integer) : Integer;
Function  Select_Tpl(Window:byte; tpl:string; baronsite:boolean) : String;
Function  Select_Area(window:byte; active:word) : Word;
Function  Select_Origin(window:byte; active:byte) : Byte;
Function  Select_FileAreas(window:byte; onlyone:boolean; active:word) : Word;

Procedure Select_Groups(window:byte; VAR bolar : booleanset; MaxEen:Boolean);
Procedure Select_Messages(window:byte; VAR bolar : booleanset; MaxEen:Boolean);

Procedure Select_MailStatus(window:byte; VAR mail:mailstatustype);
Procedure Select_Rearchiving(window:byte; VAR rearchive:packertype;
                                          VAR Usearchiver:archivertype;
                                          VAR Usebanner:byte);
Procedure Select_Cleanup(window:byte; VAR Keepdays, KeepAmount : Word);
Procedure Select_CostSharing(window:byte; VAR CostPerBlock:Word; VAR Block:Byte;
                                          VAR AllLinks:Boolean; VAR AddPercent:Byte;
                                          VAR InclHost:Boolean; VAR InclUplink:Boolean);
Procedure Select_SystemStatus(window:byte; VAR status:systemstatustype);
Procedure Select_AreaStatus(window:byte; area:boolean; VAR status:statustype);
Procedure Select_Frequency(Window:Byte; Immalso:Boolean; VAR Freq:FrequencyType;VAR Day:Byte; VAR next:longint);
Procedure Select_MessageBase(window:byte; VAR msgbaseid:char; VAR status:msgstatustype;
                VAR msgbaseidstr:string;  VAR areatag:string; text : boolean );
Procedure Select_Attribs(window:byte; VAR attrib:msgattribset; netmail:boolean);

{---------------------------------------------------------------------------}

Implementation

{$F+} Procedure Dummy(which:byte); {$F-}
Begin
End;

const
  SecsSince1970 = 662688000; (* Seconds from 1/1/70 to 12/31/90 *)
  SecsInAYear = 31536000;  (* Seconds in a year *)
  LeapYears : Array[1..10] of Integer = (1992,1996,2000,2004,2008,2012,2016,2020,2024,2028);
  SecsInADay = 86400;  (* Number of seconds in a day. NOTE Leap Second is not counted *)
  DaysInMonths : Array[1..12] of Integer= (31,28,31,30,31,30,31,31,30,31,30,31);
  Extra        : Array[False..True] of Byte = (0,1);
  SecsInAnHour = 3600;


function checkepath(str:string;endslace:boolean):string;
var
  tmp,g,s1,s2 : string;
begin
  if pos('%',str) > 0 then
    begin
      tmp := last(length(str)-pos('%',str),str);
      if pos('%',str) > 1 then s1 := first(pos('%',str)-1,str) else s1 := '';
      if pos('%',tmp) > 0 then
        begin
          s2 := last(length(tmp)-pos('%',tmp),tmp);
          tmp := first(pos('%',tmp)-1,tmp);
          if length(tmp) > 0 then
            begin
              g := getenv(tmp);
              if g = '' then
                begin
                  askwindow('Environment variable',tmp+' (%'+tmp+'%)','not found!',[#13,#27,#32]);
                  checkepath := '';
                  exit;
                end else
                begin
                  str := s1 + g + s2;
                  if endslace then
                    begin
                      if (last(1,str) <> '\') and (length(str) > 2) then str := str + '\';
                    end;
                end;
            end;
        end;
    end;
  checkepath := str;
end;



Function Node_Bits_Status( s : nodebitstype ) : String;
Var Tmp : String;
Begin
  if export     in s then tmp := 'E' else tmp := '-';
  if import     in s then tmp := tmp + 'I' else tmp := tmp + '-';
  if mandatory  in s then tmp := tmp + 'M' else tmp := tmp + '-';
  if prerelease in s then tmp := tmp + 'P' else tmp := tmp + '-';
  node_bits_status := tmp;
End;


Function IsLeapYear(Year : Integer) : Boolean;
Var Yes : Boolean;
      I : Integer;
Begin
  Yes := False;
  For I := 1 to 10 do if Year = LeapYears[I] then Yes := True;
  IsLeapYear := Yes;
End;

Function dayofweek (Day,Month,Year : Integer) : byte;
Var A,B       : Integer;
    Year_Corr : Real;
    julian    : longint;
Begin
   B := 0;
   If Month <= 2 Then
      Begin
        Dec (Year);
        Inc (Month,12);
      End;
   If (Year * 10000.0 + Month * 100.0 + Day >= 15821015.0) Then
      Begin
        A := Year Div 100;
        B := 2 - A + A Div 4;
      End;
   If Year > 0 Then Year_Corr := 0.0
     Else Year_Corr := 0.75;
   Julian    := longint (Trunc((365.25 * Year - Year_Corr)) +
                         Trunc((30.6001 * (Month+1) + Day + 1720994 + B)));
   DayOfWeek := Integer ((julian+2) Mod 7);
End;



Function GetUnixDate (DT : DateTime) : LongInt;
VAR
  Secs : LongInt;
  I    : Integer;
begin
  With DT
  do begin
    { first the big stuff : yearz }

    Secs := SecsSince1970;
    For I := 1991 to Year-1
    do Secs := Secs + SecsInaYear + (Extra[IsLeapYear(I)] * SecsInADay);

    { now the months }

    For I := 1 to Month-1
    do Secs := Secs + SecsinAday * (DaysInMonths[I] + Byte(IsLeapYear(Year) and (I=2)));

    { the days }

    For I := 1 to Day-1
    do Secs := Secs + SecsInaDay;

    { hours }

    For I := 0 to Hour-1    do Secs := Secs + SecsInAnHour;

    { minutes }

    For I := 0 to Min-1     do Secs := Secs + 60;

    { secs :-) }

    Secs := Secs + Sec;

    GetUnixDate := Secs;
  end;
end;



Procedure GetDosDate (Secs : LongInt; VAR DT : DateTime);

begin
  FillChar (DT, SizeOf(DT), 0);
  With DT
  do begin
    { strip all year seconds }
    Secs := Secs - SecsSince1970;
    Year := 1991;

    While (Secs-SecsInAyear-(Byte(IsLeapYear(Year))*SecsInaDay)) >= 0
    do begin
      if IsLeapYear(Year)
      then Secs := Secs - SecsInADay - SecsInaYear
      else Secs := Secs - SecsInaYear;
      Inc (Year);
    end;

    { year is correct }
    Month := 1;

    While (Secs- (SecsInaDay*(DaysInMonths[Month] + Extra[(IsLeapYear(Year)) and (Month=2)])) >= 0)
    do begin
      Secs := Secs - (SecsInaDay*(DaysInMonths[Month] + Extra[(IsLeapYear(Year)) and (Month=2)]));
      Inc (Month);
    end;

    { month is correct, now day }
    Day := 1;

    While (Secs - SecsInADay) >= 0
    do begin
      Secs := Secs - SecsInaDay;
      Inc (Day);
    end;

    { day is correct, now hours }
    Hour := 0;

    While (Secs - SecsInAnHour) >= 0
    do begin
      Secs := Secs - SecsInAnHour;
      Inc (Hour);
    end;

    { hours OK, now minutezzz }
    Min := 0;
    While (Secs - 60) >= 0
    do begin
      Secs := Secs - 60;
      Inc (Min);
    end;

    { minutes are fine, the rest iz seconds }
    Sec := Secs;
  end;
end;



Function NextDate (D : LongInt; IV : FrequencyType; Day : Byte) : LongInt;
Const
  DS  = 60*60*24; { nr of sec's in day }
Var
  Dt  : DateTime;
  Dow : Word;
  New : Boolean;
Begin
  FillChar (DT, Sizeof(DT), 0);

  { if today is allowed, from FMSETUP }

  if D = 0 then
    begin
      new := True;
      GetDate (DT.Year, DT.Month, DT.Day, DOW);
      D := GetUnixDate(DT) - DS;
      if DOW > 0 then Dec(DOW) else DOW := 6;
    end else
    begin
      New := False;
      getdosdate (d, dt);
      dow := dayofweek (dt.day, dt.month, dt.year);
    end;

  case IV of
   Dayly   : d := d + ds;
   Weekly  : begin
               dec(day);
               if dow = day then inc(d,ds*7) else
                 while dow <> day do
                   begin
                     Inc (D, DS);
                     if DOW < 6 then Inc (DOW) else DOW := 0;
                   end;
             end;
   Weekly2 : begin
               dec(day);
               if not New then
                 begin
                   Inc (D, DS*8);  { next week }
                   if DOW < 6 then Inc (DOW) else DOW := 0;
                 end;
               repeat
                 Inc (D, DS);
                 if DOW < 6 then Inc (DOW) else DOW := 0;
               until DOW = Day;
             end;
   Monthly : repeat
               Inc(D, DS);
               GetDOSdate (D, DT);
             until Day = DT.Day;
   Monthly2: begin
               if not New then Inc (D, DS*31);  { next month }
               repeat
                 Inc(D, DS);
                 GetDOSdate (D, DT);
               until Day = DT.Day;
             end;
   Monthly3: begin
               if not New then Inc (D, DS*62);
               repeat
                 Inc(D, DS);
                 GetDOSdate (D, DT);
               until Day = DT.Day;
             end;
  end; {case}

  NextDate := D;
End;


Function Is_Dup( exportnr:word; newnode:nodetype ) : Boolean;
Var X     : Word;
    Found : Boolean;
Begin
  Found := False;
  For X := 1 to exportnr do
   Begin
     If samerec(sfxt^[x].a,newnode,sizeof(newnode)) then found := true;
   End;
  Is_Dup := Found;
End;


Function Select_Origin(window:byte; active:byte) : Byte;
Var
  Acbak : byte;
  Ar    : Array[1..15] of String[3];
  Tmp   : String;

  Procedure WriteOrigin;
  Var X : Byte;
  Begin
    For X := 1 to 15 do
      Begin
        If x = 1 then Writeat(14,7,foreentry,backentry,'Random') else
          WriteAt(14,6+x,foreentry,backentry,setup.origline[x-1]);
      End;
  End;

Begin
  with mwin[window] do
    begin
      x1 := 7;
      x2 := 5;
      y1 := 74;
      y2 := 23;
      st := ' OriginLines ';
    end;
  create_window(window);

  ar[1] := '#1 ';
  ar[2] := '#2 ';
  ar[3] := '#3 ';
  ar[4] := '#4 ';
  ar[5] := '#5 ';
  ar[6] := '#6 ';
  ar[7] := '#7 ';
  ar[8] := '#8 ';
  ar[9] := '#9 ';
  ar[10]:= '#10';
  ar[11]:= '#11';
  ar[12]:= '#12';
  ar[13]:= '#13';
  ar[14]:= '#14';
  ar[15]:= '#15';

  inc(active);
  acbak := active;
  writeorigin;
  choosehook := dummy;
  decwin(window);
  active := select_window(window,15,3,@ar,active,false);
  if active = 0 then active := acbak;
  incwin(window);
  remove_window(window);
  select_origin := active-1;
End;


Procedure Select_Frequency(Window:Byte; ImmAlso: Boolean;
          VAR Freq:FrequencyType; VAR Day:Byte; VAR Next:longint);
Const
  DispDay  : Array[1..7] of string[3] = (
             'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
Var
  Ch  : Char;
  Sel : Byte;

   Procedure WriteIt;
   Begin
     Case freq of
      imm       : if immalso then writeat(44,11,14,0,'');
      dayly     : writeat(44,12,14,0,'');
      weekly    : writeat(44,13,14,0,'');
      weekly2   : writeat(44,14,14,0,'');
      monthly   : writeat(44,15,14,0,'');
      monthly2  : writeat(44,16,14,0,'');
      monthly3  : writeat(44,17,14,0,'');
     End;
     If not (freq in [imm,dayly]) then
       begin
         if freq in [weekly,weekly2] then
           writeat(44,18,14,0,dispday[day]) else
             writeat(44,18,14,0,int_to_str(day));
       end;
   End;

   Procedure WriteFreq(sel:byte);
   Begin
     if immalso then Writeat(31,11,7,0,' Immediately  ');
     Writeat(31,12,7,0,' Daily        ');
     Writeat(31,13,7,0,' Weekly       ');
     Writeat(31,14,7,0,' 2-Weekly     ');
     Writeat(31,15,7,0,' Monthly      ');
     Writeat(31,16,7,0,' 2-Monthly    ');
     Writeat(31,17,7,0,' 3-Monthly    ');
     If not (freq in [imm,dayly]) then
       Writeat(31,18,7,0,' Day            ') else
         Writeat(31,18,7,0,'                ');
     Case sel of
      1 : if immalso then Writeat(31,11,kl4,kl5,' Immediately');
      2 : Writeat(31,12,kl4,kl5,' Daily      ');
      3 : Writeat(31,13,kl4,kl5,' Weekly     ');
      4 : Writeat(31,14,kl4,kl5,' 2-Weekly   ');
      5 : Writeat(31,15,kl4,kl5,' Monthly    ');
      6 : Writeat(31,16,kl4,kl5,' 2-Monthly  ');
      7 : Writeat(31,17,kl4,kl5,' 3-Monthly  ');
      8 : If not (freq in [imm,dayly]) then
            Writeat(31,18,kl4,kl5,' Day        ');
     End;
   End;

Begin
  With mwin[window] do
   Begin
     x1 := 30;
     if immalso then x2 := 9 else x2 := 10;
     y1 := 48;
     y2 := 20;
     st := ' Frequency ';
   End;
  Create_window(window);

  If immalso then Sel := 1 else sel := 2;
  Ch := #0;
  While Ch <> #27 do
    Begin
      WriteFreq(sel);
      WriteIt;
      Ch := readkey;
      Case Ch of
       #9  : infoscreen;
       #26 : dosshell;
       #13 : Begin
               if (sel <> 8) then
                 begin
                   freq := frequencytype(sel-1);
                   next := 0;
                   day := 1;
                 end else
                 begin
                   inc(day);
                   if day > 28 then day := 1;
                   if (day > 7) and (freq in [weekly,weekly2]) then day := 1;
                 end;
             End;
       #0 : Begin
              Ch := Readkey;
              Case Ch of
               #72 : {up} begin
                            if immalso then
                              begin
                                if sel > 1 then dec(sel) else
                                  if not (freq in [imm,dayly]) then sel := 8 else sel := 7;
                              end else
                              begin
                                if sel > 2 then dec(sel) else
                                  if not (freq in [dayly]) then sel := 8 else sel := 7;
                              end;
                          end;
               #80 : {dn} if not (freq in [imm,dayly]) then
                            begin
                              if sel < 8 then inc(sel) else if immalso then sel := 1 else sel := 2;
                            end else
                              if sel < 7 then inc(sel) else if immalso then sel := 1 else sel := 2;
               #73, #71 : if immalso then sel := 1 else sel := 2;
               #81, #79 : if not (freq in [imm,dayly]) then sel := 8 else sel := 7;
              End;
            End;
      End;
    End;
  Remove_Window(window);
End;


Procedure ShowFlow( var flow:flowtype; var lastmonth:byte );
Var
  Tmp,Tmp1,
  Tmp2     : string;
  dummy    : byte;
  months   : byte;
  avbytes,
  avfiles  : longint;
  ch : char;
begin
  months  := 0;
  avbytes := 0;
  avfiles := 0;

  for dummy := 1 to 12 do
    begin
      if flow[dummy].bytes >= 0 then
        begin
          avbytes := avbytes + flow[dummy].bytes;
          inc (months);
        end;
      if flow[dummy].files >= 0 then avfiles := avfiles + flow[dummy].files;
    end;
  if months = 0 then tmp := '' else
    begin
      avbytes  := round((avbytes/months)/1024);
      avfiles  := round(avfiles/months);
      tmp := int_to_str(avbytes)+' '+int_to_str(avfiles)+' '+int_to_str(months);
    end;

  If Tmp = '' then
    Begin
      AskWindow('',' No flow ','',[#27,#13,#32]);
    End Else
    Begin
      Tmp1 := Extractwords(1,1,Tmp)+'Kb in '+Extractwords(2,1,Tmp)+' files.';

      case lastmonth of
       0 : tmp2 := '-';
       1 : tmp2 := 'January';
       2 : tmp2 := 'February';
       3 : tmp2 := 'March';
       4 : tmp2 := 'April';
       5 : tmp2 := 'May';
       6 : tmp2 := 'June';
       7 : tmp2 := 'July';
       8 : tmp2 := 'August';
       9 : tmp2 := 'September';
      10 : tmp2 := 'October';
      11 : tmp2 := 'November';
      12 : tmp2 := 'December';
      end;

      tmp  := 'Average flow over '+extractwords(3,1,tmp)+' months:';
      tmp2 := 'Last month was: '+tmp2;

      Shadow := True;
      Mkwin(38-(length(tmp) div 2),9,42+(length(tmp) div 2),13,0,7,1);

      WriteAt(40-(length(tmp) div 2),10,0,7,tmp);
      WriteAt(40-(length(tmp1) div 2),11,0,7,tmp1);
      WriteAt(40-(length(tmp2) div 2),12,0,7,tmp2);

      Repeat
        Ch := Readkey;
      Until Ch in [#27,#13,#32];

      if askwindow('Reset the flow information','for this area to 0 ?','(Y/N)',['y','Y','n','N',#27])
        in ['y','Y'] then
        begin

          for dummy := 1 to 12 do
            begin
              flow[dummy].bytes := -1;
              flow[dummy].files := -1;
            end;
          lastmonth := 0;

        end;

      RmWin;
      Shadow := False;
    End;
End;



Procedure CheckPath(VAR str:string);
Var
  Currentpath : String;
  Bol         : Boolean;
  Tmp, tmp1   : String;
  g,s1,s2     : string;
  X           : Word;
  k : string;
Begin
  if str = '' then exit;

  k := str;
  If (last(1,str) <> '\') and (length(str) > 2) then str := str + '\';
  If last(1,k) = '\' then k := first(length(k)-1,k);
  If (length(k) < 4) and (pos(':',k) <> 0) then exit;

  if (pos(':',k) = 0) and (pos('%',k) = 0) then
    begin
      GetDir(0,tmp1);
      str := first(2,tmp1) + str;
    end;

  If exist(k) then exit;

  if pos('%',k) > 0 then
    begin
      tmp := last(length(k)-pos('%',k),k);
      if pos('%',k) > 1 then s1 := first(pos('%',k)-1,k) else s1 := '';
      if pos('%',tmp) > 0 then
        begin
          s2 := last(length(tmp)-pos('%',tmp),tmp);
          tmp := first(pos('%',tmp)-1,tmp);
          if length(tmp) > 0 then
            begin
              g := getenv(tmp);
              if g = '' then
                begin
                  askwindow('Environment variable',tmp,'does not exist!',[#13,#27,#32]);
                  exit;
                end else
                begin
                  k := s1 + g + s2;
                  If last(1,k) = '\' then k := first(length(k)-1,k);
                  If length(k) < 3 then exit;
                  If exist(k) then exit;
                end;
            end;
        end;
    end;

  If Askwindow(k,' does not exist, create ? ','(Y/N)',['y','Y','n','N',#27]) in ['y','Y'] then
    begin
      getdir(0,currentpath);

      x := 0;
      repeat
        tmp := k;
        bol := false;
        while not bol do
          begin
            tmp1 := tmp;
            {$I-} mkdir(tmp1); {$I+}
            if ioresult <> 0 then
              begin
                repeat
                  tmp := first(length(tmp)-1,tmp);
                until (last(1,tmp) = '\') or (length(Tmp) < 1);
                tmp := first(length(tmp)-1,tmp);
                if length(tmp) < 1 then bol := true;
              end else
                bol := true;
          end;
        inc(x);
      until x = 10;

      {$I-} chdir(k); {$I+}
      if ioresult <> 0 then askwindow('Cannot create',k,'Press [ENTER] to continue',[#13,#27,#32]);
      chdir(currentpath);
    end;
End;


Procedure SetPrompt(NewPrompt : string);
const
  OldEnvSize = 2048;
  EnvMemSize = OldEnvSize + 200;
type
  EnvMem     = array[0..EnvMemSize] of byte;
  SegPtr     = ^EnvMem;
var
  EnvSegment,
  NewEnvSeg  : word;
  prompt     : string;
  NewEnv     : SegPtr;
  EnvAddr    : record
     offset  : word;
     segment : word;
      end absolute NewEnv;
begin
  Prompt     := 'PROMPT=' + NewPrompt + #0;
  EnvSegment := MemW[PrefixSeg:$2C];
  GetMem(NewEnv,EnvMemSize);
  NewEnvSeg := EnvAddr.segment+2;
  move(Mem[EnvSegment-1:0],Mem[NewEnvSeg-1:0],16);
  MemW[NewEnvSeg-1:3] := EnvMemSize shr 4;
  move(Prompt[1],MemW[NewEnvSeg:0],length(Prompt));
  move(Mem[EnvSegment:0],Mem[NewEnvSeg:length(Prompt)],OldEnvSize);
  MemW[PrefixSeg:$2C] := NewEnvSeg;
end;


{$F+} Procedure DosShell; {$F-}
Var
  Dirstr : String;
  res    : word;
Begin
  GetDir(0,Dirstr);
  Savescreen;
  Textcolor(7);
  Textbackground(0);
  Clrscr;
  cursor_on;

  res := fmExec(getenv('COMSPEC'),' ', setup.SwapMethode, $ffff, false, setup.showswapping);

  cursor_off;
  ChDir(Dirstr);
  Restorescreen;
End;


{$F+} Procedure InfoScreen; {$F-}
Var
  Ch   : Char;
  Str  : String;
  HStr : String[80];
  X    : Byte;
Begin
  Mkwin(5,6,76,22,0,3,4);

  Hstr := '';
  For X := 1 to 80 do
    Begin
      Hstr := Hstr + Getscreenchar(x,25);
    End;
  writeat(1,25,7,0,expand('Information about FileMgr.',80));

  str := 'FileMgr Electronic File Processor '+verstr(versionnr)+Build+' '+version;
  writeat(40-(length(Str) div 2),8,1,3,str);
  str := copyright+'. All Rights Reserved';
  writeat(40-(length(str) div 2)+1,9,1,3,str);

  writeat(5,11,4,0,replicate(72,''));
  writeat(5,12,7,0,replicate(72,''));
  writeat(26,12,112,0,'M A D E   I N  T H E  U K');
  writeat(5,13,1,0,replicate(72,''));

  str := 'Developed using Borland Pascal 7.0, Turbo Assembler 3.2';
  writeat(40-(length(str) div 2),15,1,3,str);
  str := 'and Turbo Profiler 2.2.';
  writeat(40-(length(str) div 2),16,1,3,str);

  str := 'Authors: Vince Coen and Ron Huiskes)';
  writeat(40-(length(str) div 2),18,1,3,str);
  str := 'Original concept: Erick van Emmerik';
  writeat(40-(length(str) div 2),19,1,3,str);

  str := 'Memory available: '+int_to_str(maxavail);
  writeat(40-(length(str) div 2),21,1,3,str);

  if mono then writeat(65,21,1,3,'Mono');

  repeat ch := readkey until ch in [#13,#27,#32];
  rmwin;
  writeat(1,25,7,0,hstr);
End;



Function Select_Group(window,active:byte): Byte;
Var Ge : String;
    X  : Word;
Begin
  With Mwin[window] do
    Begin
      x1 := 30;
      x2 := 3;
      y1 := 70;
      y2 := 22;
      st := ' Select Group ';
    End;
  Create_Window(window);
  mwin[window].x2 := 5;
  writeat(33,4,7,0,'#     Group');
  writeat(31,5,1,0,replicate(39,''));
  Create_List;
  For x := 1 to 255 do
    Add_To_List(' '+Expand(int_to_Str(X),3)+'   '+Gfx[x].groupname);

  Ge := Show_List(window,true,true,2,active);
  Remove_List;
  mwin[window].x2 := 3;
  Remove_Window(window);

  if ge <> '' then
    Select_Group := Str_To_Int(Extractwords(1,1,Ge)) else select_group := active;
End;


Function Select_Node(window,active:integer) : Integer;
Var Ge    : String;
    X     : Word;
    Count : integer;
Begin
  With Mwin[window] do
    Begin
      x1 := 20;
      x2 := 3;
      y1 := 63;
      y2 := 22;
      st := ' Select Node ';
    End;

  Writeat(1,25,7,0,expand('Reading node database...',80));

  Create_List;
  For x := 1 to nodeidx do
    Begin
      Seek(nf,nfxt^[x].noderec);
      BlockRead(nf,node,sizeof(node),count);
      If count <> sizeof(node) then
        Begin
          Askwindow('','Error reading nodefile.fm','',[#13,#32,#27]);
          Exit;
        End;

      Add_To_List(Allign(int_to_Str(X),3)+' '+expand(first(20,node.sysopname),20)+' '+node2str(Nfxt^[x].address));
    End;

  Create_Window(window);

  Writeat(24,4,7,0,'# Sysop                Node');
  Writeat(21,5,1,0,replicate(42,''));
  Writeat(1,25,7,0,expand('Select a node',80));
  mwin[window].x2 := 5;

  Ge := Show_List(window,true,true,2,active);
  Remove_List;
  mwin[window].x2 := 3;
  Remove_Window(window);

  x := Str_To_Int(Extractwords(1,1,Ge));
  If x = 0 then Select_node := active else select_node := x;
End;


Function Select_Tpl(Window:byte; tpl:string; baronsite:boolean) : String;
Var
  DirInfo   : SearchRec;
  Ge        : String;
  Active, X : Word;
Begin
  With mwin[window] do
    Begin
      if baronsite then x1 := 60 else x1 := 35;
      x2 := 4;
      if baronsite then y1 := 80 else y1 := 55;
      y2 := 23;
      st := ' Select Tpl ';
    End;
  Create_window(window);
  Create_List;

  X := 0;
  active := 0;
  FindFirst(checkepath(setup.TplPath,true)+'*.TPL',Archive,DirInfo);
  While DosError = 0 do
    Begin
      Inc(x);
      If Upper(Tpl) = Dirinfo.Name then Active := x;
      Add_To_List(Dirinfo.name);
      FindNext(DirInfo);
    End;
  If Active = 0 then Active := 1;

  If x = 0 then
    begin
      remove_list;
      remove_window(Window);
      select_tpl := '';
      exit;
    end;

  Ge := Show_List(window,true,true,1,active);
  Remove_List;
  Remove_Window(window);

  Select_Tpl := Ge;
End;

Function  Select_Area(window:byte; active:word) : Word;
Var
  Ge : String;
  X  : Word;
Begin
  With mwin[window] do
    Begin
      x1 := 32;
      x2 := 3;
      y1 := 64;
      y2 := 22;
      st := ' Select Area ';
    End;
  Create_window(window);
  writeat(35,4,7,0,'#    Area             Group');
  writeat(33,5,1,0,replicate(31,''));
  mwin[window].x2 := 5;

  Create_List;

  X := 0;
  For X := 1 to AreaIdx do
    Add_To_List(' '+expand(int_to_str(x),4)+' '+expand(Afxt^[x].Tag,18)+' '
    +allign(int_to_str(afxt^[x].grp),3));
  If active = 0 then active := 1;

  Ge := Show_List(window,true,true,2,active);
  Remove_List;
  mwin[window].x2 := 3;
  Remove_Window(window);

  If Ge <> '' then ge := extractwords(1,1,ge);
  Select_Area := str_to_int(ge);
End;

Function  VerStr ( ver : word ) : String;
Var Tmp : String;
Begin
  Tmp := Int_to_str(ver);
  While length(tmp) < 3 do Tmp := '0' + Tmp;
  Verstr := First(1,tmp)+'.'+last(2,Tmp);
End;

Function Yesno ( bol : boolean ) : String;
Begin
  If Bol then Yesno := 'Yes' else
    Yesno := 'No ';
End;

Procedure ReadGroups;
Var Buf           : Array[1..10] of GroupType;
    F             : File;
    Tel, X, Rread : Word;
Begin
  Fillchar(Gfx,sizeof(Gfx),0);

  Assign(F,systempath+'GROUPS.FM');
  {$I-} Reset(F,1); {$I+}
  If ioresult <> 0 then Exit;

  Tel := 0;
  Repeat
    BlockRead(F,Buf,Sizeof(Buf),Rread);
    If Rread <> 0 then Rread := Rread div sizeof(grouptype);
    For X := 1 to Rread do
      Begin
        Gfx[ buf[x].groupnr ].Groupname := Buf[x].groupname;
        Gfx[ buf[x].groupnr ].RecNr     := X + tel;
      End;
    Inc(tel,Rread);
  Until RRead = 0;
  Close(F);
End;

Procedure ReadMessages;
Var Buf           : Array[1..10] of MessageType;
    F             : File;
    Tel, X, Rread : Word;
Begin
  Fillchar(mfx,sizeof(mfx),0);

  Assign(F,systempath+'MESSAGES.FM');
  {$I-} Reset(F,1); {$I+}
  If ioresult <> 0 then Exit;

  Tel := 0;
  Repeat
    BlockRead(F,Buf,Sizeof(Buf),Rread);
    If Rread <> 0 then Rread := Rread div sizeof(messagetype);
    For X := 1 to Rread do
      Begin
        mfx[ buf[x].messagenr ].Messagename := Buf[x].messagename;
        mfx[ buf[x].messagenr ].MessageNr   := X + tel;
      End;
    Inc(tel,Rread);
  Until RRead = 0;
  Close(F);
End;

Procedure ReadAreaIndex;
Begin
  If MaxAvail < SizeOf(Afxt^) then
    Begin
      AskWindow('','Not enough memory left','',[#13,#27,#32]);
      Halt;
    End Else New(Afxt);

  For AreaIdx := 1 to 2000 do FillChar(Afxt^[areaidx],sizeof(afxt^[areaidx]),#0);
  AreaIdx := 0;

  Assign(AFX,systempath+'AREAFILE.FMX');
  {$I-} Reset(AFX,1); {$I+}
  If ioresult = 0 then
    Begin
      BlockRead(Afx,AFXt^,2000*sizeof(areaindextype),areaIdx);
      Close(Afx);
      AreaIdx := AreaIdx div Sizeof(areaindextype);

      Assign(AF,systempath+'AREAFILE.FM');
      {$I-} reset(af,1); {$I+}
      If Ioresult <> 0 then
        Begin
          AskWindow('','Cannot open AREAFILE.FM','',[#13,#27,#32]);
          Halt;
        End;
    End Else
    Begin
      AskWindow('','Cannot open AREAFILE.FMX','',[#13,#27,#32]);
      Halt;
    End;
End;


Procedure WriteAreaIndex;
Var
  AreaWr : Word;
Begin
  Assign(Afx,systempath+'AREAFILE.FMX');
  {$I-} rewrite(Afx,1); {$I+}
  If ioresult <> 0 then
    Begin
      AskWindow('','Cannot open/rewrite AREAFILE.FMX','',[#13,#27,#32]);
      Exit;
    End;
  BlockWrite(Afx,Afxt^,AreaIdx*sizeof(areaindextype),AreaWr);
  If AreaWr <> (AreaIdx*sizeof(areaindextype)) then AskWindow('','Cannot rewrite AREAFILE.FMX','',[#13,#27,#32]);
  Close(Afx);
  Close(Af);
  Dispose(Afxt);
End;


Procedure Select_MailStatus(window:byte; VAR mail:mailstatustype);
Var
  ch : char;
  at : byte;

  Procedure WriteMail(activ:byte);
  Begin
    Writeat(36,12,7,0,' Crash  ');
    Writeat(36,13,7,0,' Hold   ');
    Writeat(36,14,7,0,' Direct ');
    Case Activ of
     1 : Writeat(36,12,kl4,kl5,' Crash  ');
     2 : Writeat(36,13,kl4,kl5,' Hold   ');
     3 : Writeat(36,14,kl4,kl5,' Direct ');
    End;
    If crash in mail then Writeat(45,12,foreentry,backentry,'Yes') else
      Writeat(45,12,foreentry,backentry,'No ');
    If hold in mail then writeat(45,13,foreentry,backentry,'Yes') else
      Writeat(45,13,foreentry,backentry,'No ');
    If direct in mail then writeat(45,14,foreentry,backentry,'Yes') else
      Writeat(45,14,foreentry,backentry,'No ');
  End;

Begin
  with mwin[window] do
   begin
    x1 := 35;
    x2 := 10;
    y1 := 49;
    y2 := 16;
    st := ' Status ';
   end;
  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writemail(at);
      Ch := readkey;
      Case Ch of
       #13 : Begin
               case At of
                 1 : if crash in mail then
                       mail := mail - [crash] else
                        begin
                          mail := mail + [crash];
                          mail := mail - [hold];
                        end;
                 2 : if hold in mail then
                       mail := mail - [hold] else
                         begin
                           mail := mail + [hold];
                           mail := mail - [crash];
                         end;
                 3 : if direct in mail then
                       mail := mail - [direct] else mail := mail + [direct];
               end;
             End;
       #9  : infoscreen;
       #26 : dosshell;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin if at = 1 then at := 4; dec(at); end;
                 #80 : {down}  begin inc(at); if at = 4 then at := 1; end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   at := 3;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;

Procedure Select_SystemStatus(window:byte; VAR status:systemstatustype);
Var
  ch : char;
  at : byte;

  Procedure WriteMail(activ:byte);
  Begin
    Writeat(36,10,7,0,' Remote  ');
    Writeat(36,11,7,0,' %From   ');
    Writeat(36,12,7,0,' Notify  ');
    Writeat(36,13,7,0,' Pause   ');
    Writeat(36,14,7,0,' Magic   ');
    Writeat(36,15,7,0,' ForwReq ');
    Writeat(36,16,7,0,' Addnew  ');
    Writeat(36,17,7,0,' Create  ');
    Writeat(36,18,7,0,' Netmail ');

    writeat(1,25,7,0,replicate(79,' '));
    Case Activ of
     1 : Writeat(1,25,7,0,'Is node allowed to perform remote maintenance for himself');
     2 : Writeat(1,25,7,0,'Is node allowed to perform remote maintenance for other nodes');
     3 : Writeat(1,25,7,0,'Send this node notify reports when using the notify command');
     4 : Writeat(1,25,7,0,'Is node inactive');
     5 : Writeat(1,25,7,0,'Process magic keywords in tic files from this node');
     6 : Writeat(1,25,7,0,'Forward requests from this node for unknown areas to your uplink');
     7 : Writeat(1,25,7,0,'Add this node to new areas in his default group');
     8 : Writeat(1,25,7,0,'Is this node allowed to create new areas');
     9 : Writeat(1,25,7,0,'Send netmail announcement messages to this node');
    End;

    Case Activ of
     1 : Writeat(36,10,kl4,kl5,' Remote  ');
     2 : Writeat(36,11,kl4,kl5,' %From   ');
     3 : Writeat(36,12,kl4,kl5,' Notify  ');
     4 : Writeat(36,13,kl4,kl5,' Pause   ');
     5 : Writeat(36,14,kl4,kl5,' Magic   ');
     6 : Writeat(36,15,kl4,kl5,' ForwReq ');
     7 : Writeat(36,16,kl4,kl5,' Addnew  ');
     8 : Writeat(36,17,kl4,kl5,' Create  ');
     9 : Writeat(36,18,kl4,kl5,' Netmail ');
    End;

    Writeat(46,10,foreentry,backentry,yesno(remote in status));
    Writeat(46,11,foreentry,backentry,yesno(from in status));
    Writeat(46,12,foreentry,backentry,yesno(donotify in status));
    Writeat(46,13,foreentry,backentry,yesno(pause in status));
    Writeat(46,14,foreentry,backentry,yesno(upmagic in status));
    Writeat(46,15,foreentry,backentry,yesno(forwreq in status));
    Writeat(46,16,foreentry,backentry,yesno(addnew in status));
    Writeat(46,17,foreentry,backentry,yesno(cancreate in status));
    Writeat(46,18,foreentry,backentry,yesno(netmail in status));
  End;

Begin
  with mwin[window] do
   begin
    x1 := 35;
    x2 := 8;
    y1 := 51;
    y2 := 20;
    st := ' Status ';
   end;
  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writemail(at);
      Ch := readkey;
      Case Ch of
       #9  : infoscreen;
       #26 : dosshell;
       #13 : Begin
               case At of
                 1 : if remote in status then
                       status := status - [remote] else status := status + [remote];
                 2 : if from in status then
                       status := status - [from] else status := status + [from];
                 3 : if donotify in status then
                       status := status - [donotify] else status := status + [donotify];
                 4 : if pause in status then
                       status := status - [pause] else status := status + [pause];
                 5 : if upmagic in status then
                       status := status - [upmagic] else status := status + [upmagic];
                 6 : if forwreq in status then
                       status := status - [forwreq] else status := status + [forwreq];
                       7 : if addnew in status then
                                status := status - [addnew] else status := status + [addnew];
                          8 : if cancreate in status then
                                status := status - [cancreate] else status := status + [cancreate];
                       9 : if netmail in status then
                                status := status - [netmail] else status := status + [netmail];
               end;
             End;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin if at = 1 then at := 10; dec(at); end;
                 #80 : {down}  begin inc(at); if at = 10 then at := 1; end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   at := 9;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;


Procedure Select_AreaStatus(window:byte; area:boolean; VAR status:statustype);
Var
  ch : char;
  at : byte;

  Procedure WriteMailLine(activ:byte);
  Begin
    writeat(1,25,7,0,replicate(79,' '));
    Case Activ of
      1 : Writeat(1,25,7,0,'Check every incomming file on a correct crc checksum');
      2 : Writeat(1,25,7,0,'Use dupchecking on every incomming file');
      3 : Writeat(1,25,7,0,'Use Fuzzy Dup Logic on every file (only look at filename without extension)');
      4 : Writeat(1,25,7,0,'Use tiny seen-bye lines in tick files');
      5 : Writeat(1,25,7,0,'Use secure mode for this area (only systems with import switch can send files)');
      6 : Writeat(1,25,7,0,'Backup every file in the outbound dir and send from there');
      7 : Writeat(1,25,7,0,'Hide this area in downlink reports');
      8 : Writeat(1,25,7,0,'Scan on virusses on every incomming file');
      9 : Writeat(1,25,7,0,'Import the file_id.diz file from every incomming file');
     10 : Writeat(1,25,7,0,'Use long descriptions if possible');
     11 : Writeat(1,25,7,0,'Announce every new file in this area (with FileMgr Newscan option)');
     12 : Writeat(1,25,7,0,'Hatch every new file in this area (with FileMgr Newscan option)');
     13 : Writeat(1,25,7,0,'Test every incomming file with the external file test program');
     14 : Writeat(1,25,7,0,'Is the sysop notified when this area is disconnected from uplink');
     15 : Writeat(1,25,7,0,'Is this area disconnect from uplink');
    End;
  End;

  Procedure WriteMail(activ:byte);
  Begin
    Writeat(36,7 ,7,0,' Crc        ');
    Writeat(36,8 ,7,0,' Dupcheck   ');
    Writeat(36,9 ,7,0,' FuzzyDup   ');
    Writeat(36,10,7,0,' Tiny       ');
    Writeat(36,11,7,0,' Secure     ');
    Writeat(36,12,7,0,' Backup     ');
    Writeat(36,13,7,0,' Hide       ');
    Writeat(36,14,7,0,' VirusScan  ');
    Writeat(36,15,7,0,' ImportDiz  ');
    Writeat(36,16,7,0,' LongDesc   ');
    Writeat(36,17,7,0,' AnnNew     ');
    Writeat(36,18,7,0,' HatchNew   ');
    If area then
      Begin
        Writeat(36,19,7,0,' Test file  ');
        Writeat(36,20,7,0,' Notified   ');
        Writeat(36,21,7,0,' Disconnect ');
      End;

    Case Activ of
      1 : Writeat(36,7 ,kl4,kl5,' Crc        ');
      2 : Writeat(36,8 ,kl4,kl5,' Dupcheck   ');
      3 : Writeat(36,9 ,kl4,kl5,' FuzzyDup   ');
      4 : Writeat(36,10,kl4,kl5,' Tiny       ');
      5 : Writeat(36,11,kl4,kl5,' Secure     ');
      6 : Writeat(36,12,kl4,kl5,' Backup     ');
      7 : Writeat(36,13,kl4,kl5,' Hide       ');
      8 : Writeat(36,14,kl4,kl5,' VirusScan  ');
      9 : Writeat(36,15,kl4,kl5,' ImportDiz  ');
     10 : Writeat(36,16,kl4,kl5,' LongDesc   ');
     11 : Writeat(36,17,kl4,kl5,' AnnNew     ');
     12 : Writeat(36,18,kl4,kl5,' HatchNew   ');
     13 : Writeat(36,19,kl4,kl5,' Test file  ');
     14 : Writeat(36,20,kl4,kl5,' Notified   ');
     15 : Writeat(36,21,kl4,kl5,' Disconnect ');
    End;

    Writeat(49,7,foreentry,backentry,yesno(crc in status));
    Writeat(49,8,foreentry,backentry,yesno(dupcheck in status));
    Writeat(49,9,foreentry,backentry,yesno(fuzzydup in status));
    Writeat(49,10,foreentry,backentry,yesno(tiny in status));
    Writeat(49,11,foreentry,backentry,yesno(secure in status));
    Writeat(49,12,foreentry,backentry,yesno(backup in status));
    Writeat(49,13,foreentry,backentry,yesno(hide in status));
    Writeat(49,14,foreentry,backentry,yesno(virus in status));
    Writeat(49,15,foreentry,backentry,yesno(importdiz in status));
    Writeat(49,16,foreentry,backentry,yesno(longdesc in status));
    Writeat(49,17,foreentry,backentry,yesno(annnew in status));
    Writeat(49,18,foreentry,backentry,yesno(hatchnew in status));
    if area then
      begin
        Writeat(49,19,foreentry,backentry,yesno(test in status));
        Writeat(49,20,foreentry,backentry,yesno(noti in status));
        Writeat(49,21,foreentry,backentry,yesno(disc in status));
      end;
  End;

Begin
  with mwin[window] do
   begin
    x1 := 35;
    x2 := 5;
    y1 := 53;
    y2 := 20;
    st := ' Status ';
   end;
  If area then mwin[window].y2 := 23;

  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writemail(at);
      WriteMailLine(at);
      Ch := readkey;
      Case Ch of
       #13 : Begin
               case At of
                 1 : if crc in status then
                       status := status - [crc] else status := status + [crc];
                 2 : begin
                       if dupcheck in status then
                         status := status - [dupcheck] else status := status + [dupcheck];
                       if not (dupcheck in status) then
                         status := status - [fuzzydup];
                     end;
                 3 : begin
                       if fuzzydup in status then
                         status := status - [fuzzydup] else status := status + [fuzzydup];
                       if fuzzydup in status then
                         status := status + [dupcheck];
                     end;
                 4 : if tiny in status then
                       status := status - [tiny] else status := status + [tiny];
                 5 : if secure in status then
                       status := status - [secure] else status := status + [secure];
                 6 : if backup in status then
                       status := status - [backup] else status := status + [backup];

                 7 : if hide in status then
                       status := status - [hide] else status := status + [hide];
                 8 : if virus in status then
                      status := status - [virus] else status := status + [virus];
                 9 : if importdiz in status then
                       status := status - [importdiz] else status := status + [importdiz];

                10 : if longdesc in status then
                       status := status - [longdesc] else status := status + [longdesc];
                11 : if annnew in status then
                      status := status - [annnew] else status := status + [annnew];
                12 : if hatchnew in status then
                       status := status - [hatchnew] else status := status + [hatchnew];

                13 : if test in status then
                      status := status - [test] else status := status + [test];
                14 : if noti in status then
                      status := status - [noti] else status := status + [noti];
                15 : if disc in status then
                       status := status - [disc] else status := status + [disc];


               end;
             End;
       #9  : infoscreen;
       #26 : dosshell;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin
                                 if at = 1 then
                                   begin
                                     if area then at := 16 else at := 13;
                                   end;
                                 dec(at);
                               end;
                 #80 : {down}  begin
                                 inc(at);
                                 if area then if at = 16 then at := 1;
                                 if not area then if at = 13 then at := 1;
                               end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   begin
                                 at := 12;
                                 if area then at := 15;
                               end;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;


Procedure Select_Rearchiving(window:byte; VAR rearchive:packertype;
                                          VAR Usearchiver:archivertype;
                                          VAR Usebanner:byte);
Var
  ch : char;
  at : byte;

  Procedure Writeinf(activ:byte);
  Begin
    Writeat(1,25,7,0,replicate(80,' '));
    Case activ of
      1 : Writeat(1,25,7,0,'Rearchive files during processing?');
      2 : Writeat(1,25,7,0,'Archiver to use');
      3 : Writeat(1,25,7,0,'Rearchive files even if files are in the correct archive format?');
      4 : Writeat(1,25,7,0,'Skip AV security archives, and do not re-archive them?');
      5 : Writeat(1,25,7,0,'Change strange extensions (eg. A01, Z02 etc) ?');
      6 : Writeat(1,25,7,0,'Add banner to archive');
    End;
  End;

  Procedure Writearch(activ:byte);
  Begin
    Writeat(30,11,7,0,' Re-archive       ');
    if setup.extarchiver = '' then
      begin
        Writeat(30,12,7,0,' Use archiver     ');
        Writeat(30,13,7,0,' Same archive     ');
        Writeat(30,14,7,0,' Skip AV files    ');
        Writeat(30,15,7,0,' Change extension ');
        Writeat(30,16,7,0,' Add banner       ');
      end else
        Writeat(30,12,7,0,' Add banner       ');

    Case Activ of
      1 : Writeat(30,11,kl4,kl5,' Re-archive       ');
      2 : Writeat(30,12,kl4,kl5,' Use archiver     ');
      3 : Writeat(30,13,kl4,kl5,' Same archive     ');
      4 : Writeat(30,14,kl4,kl5,' Skip AV files    ');
      5 : Writeat(30,15,kl4,kl5,' Change extension ');
      6 : if setup.extarchiver = '' then
            Writeat(30,16,kl4,kl5,' Add banner       ') else
              Writeat(30,12,kl4,kl5,' Add banner       ');
    End;
    Writeat(49,11,foreentry,backentry,yesno(convert in rearchive));
    if setup.extarchiver = '' then
      begin
        Writeat(49,12,foreentry,backentry,Zipstr[usearchiver]);
        Writeat(49,13,foreentry,backentry,yesno(samearchive in rearchive));
        Writeat(49,14,foreentry,backentry,yesno(avarchive in rearchive));
        Writeat(49,15,foreentry,backentry,yesno(extension in rearchive));
        if usebanner <> 0 then
          Writeat(49,16,foreentry,backentry,expand(int_to_str(usebanner),2)) else
            Writeat(49,16,foreentry,backentry,'No');
      end else
      begin
        if usebanner <> 0 then
          Writeat(49,12,foreentry,backentry,expand(int_to_str(usebanner),2)) else
            Writeat(49,12,foreentry,backentry,'No');
      end;
  End;

Begin
  with mwin[window] do
   begin
    x1 := 29;
    x2 := 9;
    y1 := 53;
    if setup.extarchiver = '' then
      y2 := 18 else y2 := 14;
    st := ' Re-archiving ';
   end;
  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writearch(at);
      writeinf(at);
      Ch := readkey;
      Case Ch of
       #13 : Begin
               case At of
                 1 : if convert in rearchive then
                       rearchive := rearchive - [convert] else
                         rearchive := rearchive + [convert];
                 2 : begin
                       inc(usearchiver);
                       if usearchiver = all then usearchiver := zip;
                     end;
                 3 : if samearchive in rearchive then
                       rearchive := rearchive - [samearchive] else
                         rearchive := rearchive + [samearchive];
                 4 : if avarchive in rearchive then
                       rearchive := rearchive - [avarchive] else
                         rearchive := rearchive + [avarchive];
                 5 : if extension in rearchive then
                       rearchive := rearchive - [extension] else
                         rearchive := rearchive + [extension];
                 6 : begin
                       inc(usebanner);
                       if usebanner > 15 then usebanner := 0;
                     end;
               end;
             End;
       #9  : infoscreen;
       #26 : dosshell;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin
                                 if setup.extarchiver = '' then
                                   begin
                                     if at = 1 then at := 7; dec(at);
                                   end else
                                   begin
                                     if at = 6 then at := 1 else at := 6;
                                   end;
                               end;
                 #80 : {down}  begin
                                 if setup.extarchiver = '' then
                                   begin
                                     inc(at); if at = 7 then at := 1;
                                   end else
                                   begin
                                     if at = 1 then at := 6 else at := 1;
                                   end;
                               end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   at := 6;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;


Procedure Select_Cleanup(window:byte; VAR Keepdays, KeepAmount: Word);
Var
  ch  : char;
  at  : byte;
  tmp : string;

  Procedure Writeinf(activ:byte);
  Begin
    Writeat(1,25,7,0,replicate(80,' '));
    Case activ of
      1 : Writeat(1,25,7,0,'Delete files after how many days (0 = disabled)');
      2 : Writeat(1,25,7,0,'Maximum amount of files to keep (0 = don''t care)');
    End;
  End;

  Procedure Writearch(activ:byte);
  Begin
    Writeat(30,13,7,0,' Keep Days   ');
    Writeat(30,14,7,0,' Keep Amount ');
    Case Activ of
      1 : Writeat(30,13,kl4,kl5,' Keep Days   ');
      2 : Writeat(30,14,kl4,kl5,' Keep Amount ');
    End;
    Writeat(44,13,foreentry,backentry,EXPAND(int_to_str(keepdays),5));
    Writeat(44,14,foreentry,backentry,expand(int_to_str(keepamount),5));
  End;

Begin
  with mwin[window] do
   begin
    x1 := 29;
    x2 := 11;
    y1 := 51;
    y2 := 16;
    st := ' Cleanup ';
   end;
  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writearch(at);
      writeinf(at);
      Ch := readkey;
      Case Ch of
       #13 : Begin
               case At of
                 1 : begin
                       tmp := int_to_str(keepdays);
                       read_string(44,13,5,5,tmp,c_all);
                       keepdays := str_to_int(tmp);
                     end;
                 2 : begin
                       tmp := int_to_str(keepamount);
                       read_string(44,14,5,5,tmp,c_all);
                       keepamount := str_to_int(tmp);
                     end;
               end;
             End;
       #9  : infoscreen;
       #26 : dosshell;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin if at = 1 then at := 3; dec(at); end;
                 #80 : {down}  begin inc(at); if at = 3 then at := 1; end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   at := 2;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;

Procedure Select_CostSharing(window:byte; VAR CostPerBlock:Word; VAR Block:Byte;
                                          VAR AllLinks:Boolean; VAR AddPercent:Byte;
                                          VAR InclHost:Boolean; VAR InclUplink:Boolean);
Var
  ch  : char;
  at  : byte;
  tmp : string;

  Procedure Writeics(activ:byte);
  Begin
    Writeat(1,25,7,0,replicate(80,' '));
    Case activ of
      1 : Writeat(1,25,7,0,'Include the costs the uplink charges for files');
      2 : Writeat(1,25,7,0,'Cost in units (cents) per block of files');
      3 : Writeat(1,25,7,0,'Unit representing block');
      4 : Writeat(1,25,7,0,'Include all downlinks in calculation, or only active cso links');
      5 : Writeat(1,25,7,0,'Include yourself (as host) in the calculation also');
      6 : Writeat(1,25,7,0,'Add percentage to total block amount');
    End;
  End;

  Procedure Writecso(activ:byte);
  Begin
    Writeat(30,12,7,0,' Incl. Uplink costs ');
    Writeat(30,14,7,0,' Cost per Block     ');
    Writeat(30,15,7,0,' Block              ');
    Writeat(30,16,7,0,' All Links          ');
    Writeat(30,17,7,0,' Host as Link       ');
    Writeat(30,18,7,0,' Add Percentage     ');
    Case Activ of
      1 : Writeat(30,12,kl4,kl5,' Incl. Uplink costs ');
      2 : Writeat(30,14,kl4,kl5,' Cost per Block     ');
      3 : Writeat(30,15,kl4,kl5,' Block              ');
      4 : Writeat(30,16,kl4,kl5,' All Links          ');
      5 : Writeat(30,17,kl4,kl5,' Host as Link       ');
      6 : Writeat(30,18,kl4,kl5,' Add Percentage     ');
    End;

    Writeat(51,12,foreentry,backentry,yesno(incluplink));
    Writeat(51,14,foreentry,backentry,expand(int_to_str(costperblock),8));
    case block of
      0 : Writeat(51,15,foreentry,backentry,'100 Kb  ');
      1 : Writeat(51,15,foreentry,backentry,'1024 Kb ');
      2 : Writeat(51,15,foreentry,backentry,'File    ');
    end;
    Writeat(51,16,foreentry,backentry,yesno(alllinks));
    Writeat(51,17,foreentry,backentry,yesno(inclhost));
    Writeat(51,18,foreentry,backentry,expand(int_to_str(addpercent),8));
  End;

Begin
  with mwin[window] do
   begin
    x1 := 29;
    x2 := 10;
    y1 := 61;
    y2 := 20;
    st := ' CostSharing ';
   end;
  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writecso(at);
      writeics(at);
      Ch := readkey;
      Case Ch of
       #13 : Begin
               case At of
                1 : begin
                      incluplink := not incluplink;
                    end;
                2 : begin
                      tmp := int_to_str(costperblock);
                      read_string(51,14,5,5,tmp,c_all);
                      costperblock := str_to_int(tmp);
                    end;
                3 : begin
                      inc(block); if block > 2 then block := 0;
                      if not (block in [0,1,2]) then block := 0;
                    end;
                4 : begin
                      alllinks := not alllinks;
                    end;
                5 : begin
                      inclhost := not inclhost;
                    end;
                6 : begin
                      tmp := int_to_str(addpercent);
                      read_string(51,18,5,5,tmp,c_all);
                      addpercent := str_to_int(tmp);
                    end;
               end;
             End;
       #9  : Infoscreen;
       #26 : Dosshell;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin if at = 1 then at := 7; dec(at); end;
                 #80 : {down}  begin inc(at); if at = 7 then at := 1; end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   at := 6;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;


Function WriteGroups( maxlength:byte; group:booleanset ) : String;
Var z   : integer;
    tmp,
    tmp1 : string;
Begin
  z := 1; tmp := '';
  While (length(tmp) < maxlength) and (z <= 255) do
   Begin
     if group[z] then
       begin
         if last(2,tmp) = '..' then
           begin
             if (z <= 254) and group[z+1] then {} else
               tmp := tmp + int_to_str(z);
           end else
         if (z <= 254) and group[z+1] and (z > 1) and (pos('..',extractwords(wordcnt(tmp),1,tmp)) = 0) then
           begin
             if length(tmp) > 0 then
               begin
                 tmp1 := extractwords(wordcnt(tmp),1,tmp);
                 if str_To_int(tmp1) = z-1 then tmp := tmp + '..' else
                   tmp := tmp + ', '+int_to_str(z);
               end else tmp := int_to_str(z);
           end else
           begin
             if (length(tmp) <> 0) and (last(2,tmp) <> ', ') then tmp := tmp + ', ';
             tmp := tmp + int_to_str(z);
           end;
       end;
     inc(z);
   End;
  If last(2,tmp) = '..' then tmp := tmp + int_to_str(z);
  WriteGroups := first(maxlength,Tmp);
End;


Function WriteFrequency(freq:frequencytype; day:byte) : string;
Const
  DispDay  : Array[1..7] of string[9] = (
             'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
  DispFreq : Array[frequencytype] of String[11] = (
             'Immediately','Daily', 'Weekly', '2-Weekly', 'Monthly', '2-Monthly', '3-Monthly');
Var
  S : string;
Begin
  S := strip('B',' ',dispfreq[freq]);
  If Freq in [Weekly, Weekly2] then
    S := S + ' on '+dispday[day];
  If Freq in [monthly,monthly2,monthly3] then
    S := S + ' on day '+int_to_str(day);

  writefrequency := s;
End;


Procedure WriteAttribs(x,y:byte; len:byte; attrib:msgattribset; netmail:boolean);
Var Tmp : String;
Begin
  Tmp := '';
  If netmail then
    Begin
      If holdmail in attrib then tmp := tmp + '[Hold] ';
      If directmail in attrib then tmp := tmp + '[Direct] ';
      If crashmail in attrib then tmp := tmp + '[Crash] ';
      If privat in attrib then tmp := tmp + '[Private] ';
      If killsent in attrib then tmp := tmp + '[Kill/Sent] ';
      If fattach in attrib then tmp := tmp + '[Fattach] ';
    End Else
    Begin
      If privat in attrib then tmp := tmp + '[Private] ';
    End;
  Writeat(x,y,foreentry,backentry,expand(tmp,len-x));
End;


Function NextFrequency ( next:LongInt ) : String;
Const
  Months : Array[1..12] of String[3] = ('Jan', 'Feb', 'Mar', 'Apr', 'May',
                                        'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
Var
  DT : DateTime;
  S  : String;
Begin
  GetDOSdate (next,Dt);
  S := '';
  With DT do
    begin
      If day < 10 then s := '0'+int_to_str(day) else s := int_to_str(day);
      s := s + ' '+months[month]+' ';
      s := s + int_to_str(year);
    end;
  Nextfrequency := s;
end;


Procedure WriteColor(line,normal,highc,backc:byte;str:string);
Var
  X,Y : integer;
  bol : boolean;
Begin
  writeat(1,line,7,0,replicate(80,' '));
  Y := 1; X := 0; bol := false;
  While y <= length(str) do
    Begin
      if str[y] <> '^' then
        begin
          inc(x);
          if bol then writeat(x,line,highc,backc,str[y]) else
            writeat(x,line,normal,backc,str[y]);
        end else bol := not bol;
      inc(y);
    End;
End;


Function GetBbsSystem : String;
Var
  Bf      : File;
  BbsName : String;
Begin
  BbsName := 'Unknown';
  If Exist(systempath+'FILEAREA.FM') then
    Begin
      Assign (BF, SystemPath + 'FILEAREA.FM');
      {$I-} Reset (BF,1); {$I+}
      If IOresult = 0 then
        Begin
          {$I-} BlockRead(BF,bbsname,20); {$I+}
          BbsName := Last(Length(BbsName)-2,BbsName);
          Close(Bf);
        End;
    End;
  GetBbsSystem := BbsName;
End;


Procedure DecWin(win:byte);
Begin
  inc(mwin[win].x2);
  dec(mwin[win].y2);
End;

Procedure IncWin(win:byte);
Begin
  dec(mwin[win].x2);
  inc(mwin[win].y2);
End;


Function Samerec (var a, b; size : word) : boolean; assembler;
  { You can use AnyRec for Rec1 and Rec2, as
    long as the correct size is given!!
    Recs of size 0 are considered to be equal. }
  ASM
        mov   DX,DS     { Fast save DS  }
        xor   AX,AX     { default False }
        lds   SI,a      { DS:SI -> Rec1 }
        les   DI,b      { ES:DI -> Rec2 }
        cld             { Comp forwards }
        mov   CX,size   { Size in Bytes }
        shr   CX,1      { Size in words }
        jnc   @Even     { Size is Even? }
        cmpsb           { Comp odd byte }
        jne   @End      { Equal bytes?  }
 @Even: repe  cmpsw     { Compare loop  }
        jne   @End      { Equal at end? }
        inc   AX        { Return: True  }
  @End: mov   DS,DX     { Restore DS    }
end {Compare};


Function Node2Str (N : NodeType) : String;
Var S : String[23];
begin
  S := '';
  With N do
    begin
      if Zone > 0 then S := int_to_Str(Zone) + ':';
      if Net > 0 then S := S + int_to_Str(Net) + '/' + int_to_str(Node)
        else if Node > 0 then S := S + int_to_str(Node);
      if Point > 0 then S := S + '.' + int_to_str(Point);
    end;
  Node2Str := S;
end;


Procedure Str2Node (S : String; VAR N : NodeType; D : Nodetype; VAR Valid : Boolean);
Var Error : Integer;
begin
  if S = '' then
    begin
      Valid := True;
      fillchar(n,sizeof(n),0);
    end else
    begin
      Valid := True;
      With N do
        begin
          if Pos('.',S) > 0 then
            begin
              Val (Copy(S,Pos('.',S)+1,Length(S)-Pos('.',S)), Point, Error);
              Valid := Error = 0;
              Delete (S, Pos('.',S), Length(S)-Pos('.',S)+1);
            end else Point := 0;

          if Pos(':',S) > 0 then
            begin
              Val (Copy(S,1,Pos(':',S)-1), Zone, Error);
              Valid := (Error = 0) and (Zone > 0);
              Delete (S, 1, Pos(':',S));
              If S = '' then Valid := False;
            end else Zone := D.Zone;

          if Pos('/',S) > 0 then
            begin
              Val (Copy(S,1,Pos('/',S)-1), Net, Error);
              Valid := (Error = 0) and (Net > 0);
              Delete (S, 1, Pos('/',S));
            end else Net := D.Net;

          if S <> '' then
            begin
              Val (S, Node, Error);
              Valid := Error = 0;
            end else Node := D.Node;

          if (Zone > 0) and (Net = 0) then Valid := False;
          if Zone = 0 then Zone := D.Zone;
        end;
    end;
end;


Function Select_Address( window, aka : byte; akamatch:boolean ) : Byte;
Var I,J  : Byte;
    Node : Array[1..22] of Byte;
    Ar   : Array[1..22] of string[23];
    bakaka,
    len  : byte;
Begin
  bakaka := aka;
  For J := 1 to 22 do Node[J] := 0;

  if akamatch then
    begin
      J := 1;
      ar[1] := 'Aka matching';
    end else j := 0;

  For I := 1 to 21 do
    Begin
      If setup.address[I].Zone > 0 then
        Begin
          Inc(J);
          node[j] := i;
          Ar[J] := Node2str(setup.address[i]);
        End;
    End;

  if not akamatch then
    if aka = 0 then aka := 1;

  i := 0;
  repeat
    inc(i);
  until aka = node[i];
  aka := i;

  len := 0;
  for i := 1 to j do
    if length(ar[i]) > len then len := length(ar[i]);

  If ((J = 1) and akamatch) or (j = 0) then
    Begin
      AskWindow('','No addresses defined','',[#27,#13,#32]);
      Select_Address := 0;
      Exit;
    End;

  With mwin[window] do
    Begin
      x1 := 30;
      if akamatch then x2 := 11-(j div 2) else x2 := 12-(j div 2);
      y1 := 33+len;
      y2 := x2+3+j;
      st := ' Addresses ';
    End;
  Create_window(window);
  choosehook := dummy;

  Decwin(window);
  I := Select_window(window,j,23,@ar,aka,false);
  Incwin(window);

  Remove_window(window);
  if i = 0 then select_Address := bakaka else
    select_address := node[i];
End;


Procedure Select_Groups(window:byte; VAR Bolar : Booleanset; MaxEen:Boolean);
Var
   Ch     : Char;
   Active,
   Top    : Integer;
   X      : Integer;

  Procedure WriteGroup(top,active:integer);
  Var X : Integer;
  Begin
    For X := top to top + 14 do
      Begin
        If X-(top-1) = active then
          Begin
            Writeat(26,7+x-top,kl4,kl5,+' '+expand(int_to_str(x),3)+' '+expand( Gfx[x].groupname ,28)+' ');
            if not maxeen then If bolar[x] then Writeat(30,7+x-top,kl4,kl5,'');
          End Else
          Begin
            Writeat(26,7+x-top,3,0,' '+expand(int_to_str(x),3)+' '+expand( Gfx[x].GroupName ,28)+' ');
            if not maxeen then If bolar[x] then Writeat(30,7+x-top,14,0,'');
          End;
      End;
  End;

Begin
  With mwin[window] do
    Begin
      x1 := 25;
      x2 := 6;
      y1 := 60;
      y2 := 22;
      st := ' Groups ';
    End;
  Create_window(window);

  if maxeen then
    begin

      top := 0;
      repeat
        inc(top);
      until bolar[top] or (top = 256);

      active := 1;
      if top > 241 then
        begin
          active := top-240;
          top := 241;
        end;
    end else
    begin
      Top := 1;
      Active := 1;
    end;

  Repeat
    writegroup(top,active);

    ch := readkey;
    case ch of
     #0  : begin
             ch := readkey;
             case ch of
               #72 : {up} if active > 1 then dec(active) else
                            if top > 1 then dec(top);
               #80 : {dn} if active < 15 then inc(active) else
                            if top+15 < 255 then inc(top);
               #73 : {pgup} if active <> 1 then active := 1 else
                              if top-15 > 0 then dec(top,15) else top := 1;
               #81 : {pgdn} if active < 15 then active := 15 else
                              if top+15 < 255 then inc(top,15) else top := 241;
               #71 : {home} begin top := 1; active := 1; end;
               #79 : {end}  begin top := 241; active := 15; end;
             end;
           end;
      #9  : infoscreen;
      #26 : dosshell;
      #13 : begin
              if maxeen then
                begin
                  for x := 1 to 255 do bolar[x] := false;
                  bolar[top+active-1] := true;
                  ch := #27;
                end else
                  bolar[top+active-1] := not bolar[top+active-1];

              if active < 15 then inc(active) else
                if top+15 < 255 then inc(top);

            end;
      #43 : {+} if not maxeen then for x := 1 to 255 do bolar[x] := true;
      #45 : {-} if not maxeen then for x := 1 to 255 do bolar[x] := false;
    end;
  Until Ch = #27;

  Remove_window(window);
End;

Procedure Select_MessageBase(window:byte; VAR msgbaseid:char; VAR status:msgstatustype;
                VAR msgbaseidstr:string;  VAR areatag:string; text : boolean );
Var
  Ch : Char;
  At : Byte;
  Lt : Boolean;

   Procedure Writeit;
   Begin
     if (msgbaseid <> 'T') then
       writeat(31,11,7,0,'  Squish      Echomail ') else
         writeat(31,11,7,0,'  Squish               ');
     if (msgbaseid <> 'T') then
       writeat(31,12,7,0,'  Hudson      Netmail  ') else
         writeat(31,12,7,0,'  Hudson               ');
     writeat(31,13,7,0,'  Fido   ');
     writeat(31,14,7,0,'  Jam    ');
     writeat(31,15,7,0,'  Ezycom ');
     if (echo in status) and (msgbaseid = 'P') then
       begin
         writeat(44,14,7,0,' Areatag  ');
         writeat(44,16,3,0,first(10,expand(areatag,10)));
       end else
     if (net in status) and (msgbaseid = 'P') then
       begin
         writeat(44,16,3,0,expand(' ',10));
         writeat(44,14,7,0,'         ');
      end else writeat(44,14,7,0,'         ');

     if text then
       begin
         writeat(31,16,7,0,'  Packet ');
         writeat(31,17,7,0,'  Text   ');
       end;

     case msgbaseid of
      'S' : writeat(31,11,14,0,'');
      'H' : writeat(31,12,14,0,'');
      'F' : writeat(31,13,14,0,'');
      'J' : writeat(31,14,14,0,'');
      'E' : writeat(31,15,14,0,'');
      'P' : if text then writeat(31,16,14,0,'');
      'T' : if text then writeat(31,17,14,0,'');
     end;

     if (msgbaseid <> 'T') then
       begin
         if net in status then writeat(43,12,14,0,'') else
            if echo in status then writeat(43,11,14,0,'');
       end;

     if lt then
       begin
         case at of
           1 : writeat(32,11,kl4,kl5,' Squish ');
           2 : writeat(32,12,kl4,kl5,' Hudson ');
           3 : writeat(32,13,kl4,kl5,' Fido   ');
           4 : writeat(32,14,kl4,kl5,' Jam    ');
           5 : writeat(32,15,kl4,kl5,' Ezycom ');
           6 : if text then writeat(32,16,kl4,kl5,' Packet ');
           7 : if text then writeat(32,17,kl4,kl5,' Text   ');
         end;
       end else
       begin
         case at of
           1 : writeat(44,11,kl4,kl5,' Echomail ');
           2 : writeat(44,12,kl4,kl5,' Netmail  ');
           3 : if echo in status then writeat(44,14,kl4,kl5,' Areatag  ');
         end;
       end;
   End;

Begin
  with mwin[window] do
    begin
      x1 := 29;
      x2 := 9;
      y1 := 56;
      if text then y2 := 19 else y2 := 17;
      st := ' Msgbase ';
    end;
  create_window(window);

  case msgbaseid of
   'S' : at := 1;
   'H' : at := 2;
   'F' : at := 3;
   'J' : at := 4;
   'E' : at := 5;
   'P' : at := 6;
   'T' : at := 7;
   else at := 1;
  end;
  ch := #0;
  lt := true;

  while ch <> #27 do
    begin
      writeit;
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                  #75,
                  #77 : {left} begin
                                 if (msgbaseid <> 'T') then
                                   begin
                                     lt := not lt;
                                     if not lt then
                                       begin
                                         if (msgbaseid = 'P') and (echo in status) then
                                           begin
                                             if at > 3 then at := 3;
                                           end else
                                           begin
                                             if at > 2 then at := 2;
                                           end;
                                       end;
                                   end;
                               end;
                  #72 : {up}   begin
                                 if lt then
                                   begin
                                     if at = 1 then
                                       begin
                                         if text then at := 8 else at := 6;
                                       end;
                                     dec(at);
                                   end else
                                   begin
                                     if at = 1 then
                                       begin
                                         if (echo in status) and (msgbaseid = 'P') then
                                           at := 3 else at := 2;
                                       end else
                                         dec(at);
                                   end;
                               end;
                  #80 : {down} begin
                                 if lt then
                                   begin
                                     inc(at);
                                     if text then
                                       begin
                                         if at = 8 then at := 1;
                                       end else
                                       begin
                                         if at = 6 then at := 1;
                                       end;
                                   end else
                                   begin
                                     if (msgbaseid = 'P') and (echo in status) then
                                       begin
                                         inc(at); if at = 4 then at := 1;
                                       end else
                                       begin
                                         inc(at); if at = 3 then at := 1;
                                       end;
                                   end;
                               end;
                end;
              end;
        #9  : infoscreen;
        #26 : dosshell;
        #13 : begin
                if lt then
                  begin
                    case at of
                      1 : msgbaseid := 'S';
                      2 : msgbaseid := 'H';
                      3 : msgbaseid := 'F';
                      4 : msgbaseid := 'J';
                      5 : msgbaseid := 'E';
                      6 : msgbaseid := 'P';
                      7 : msgbaseid := 'T';
                    end;
                  end else
                  begin
                    case at of
                     1 : begin
                           status := status + [echo];
                           status := status - [net];
                         end;
                     2 : begin
                           status := status - [echo];
                           status := status + [net];
                         end;
                     3 : begin
                           areatag := strip('B',' ',areatag);
                           read_string(44,16,10,15,areatag,c_all);
                         end;
                    end;
                  end;
              end;
      end;
    end;
  remove_window(window);
End;


Procedure Select_Messages(window:byte; VAR Bolar : Booleanset; MaxEen:Boolean);
Var
   Ch     : Char;
   Active,
   Top    : Integer;
   X      : Integer;

  Procedure WriteMessage(top,active:integer);
  Var X : Integer;
  Begin
    For X := top to top + 14 do
      Begin
        If X-(top-1) = active then
          Begin
            Writeat(26,7+x-top,kl4,kl5,+' '+expand(int_to_str(x),3)+' '+expand( mfx[x].messagename ,28)+' ');
            if not maxeen then If bolar[x] then Writeat(30,7+x-top,kl4,kl5,'');
          End Else
          Begin
            Writeat(26,7+x-top,3,0,' '+expand(int_to_str(x),3)+' '+expand( mfx[x].messageName ,28)+' ');
            if not maxeen then If bolar[x] then Writeat(30,7+x-top,14,0,'');
          End;
      End;
  End;

Begin
  With mwin[window] do
    Begin
      x1 := 25;
      x2 := 6;
      y1 := 60;
      y2 := 22;
      st := ' Messages ';
    End;
  Create_window(window);

  if maxeen then
    begin

      top := 0;
      repeat
        inc(top);
      until bolar[top] or (top = 256);

      active := 1;
      if top > 241 then
        begin
          active := top-240;
          top := 241;
        end;
    end else
    begin
      Top := 1;
      Active := 1;
    end;

  Repeat
    writemessage(top,active);

    ch := readkey;
    case ch of
     #0  : begin
             ch := readkey;
             case ch of
               #72 : {up} if active > 1 then dec(active) else
                            if top > 1 then dec(top);
               #80 : {dn} if active < 15 then inc(active) else
                            if top+15 < 255 then inc(top);
               #73 : {pgup} if active <> 1 then active := 1 else
                              if top-15 > 0 then dec(top,15) else top := 1;
               #81 : {pgdn} if active < 15 then active := 15 else
                              if top+15 < 255 then inc(top,15) else top := 241;
               #71 : {home} begin top := 1; active := 1; end;
               #79 : {end}  begin top := 241; active := 15; end;
             end;
           end;
      #9  : infoscreen;
      #26 : dosshell;
      #32, #13 : begin
              if maxeen then
                begin
                  for x := 1 to 255 do bolar[x] := false;
                  bolar[top+active-1] := true;
                  ch := #27;
                end else
                begin
                  bolar[top+active-1] := not bolar[top+active-1];
                  if active < 15 then inc(active) else
                    if top+15 < 255 then inc(top);
                end;
            end;
      #43 : {+} if not maxeen then for x := 1 to 255 do bolar[x] := true;
      #45 : {-} if not maxeen then for x := 1 to 255 do bolar[x] := false;
    end;
  Until Ch = #27;

  Remove_window(window);
End;


Procedure Select_Attribs(window:byte; VAR attrib:msgattribset; netmail:boolean);
Var
   Ar : array[1..6] of string[11];
   Ge : Byte;

   Procedure WriteAtt;
   Begin
     If netmail then
       Begin
         Writeat(35,12,foreentry,backentry,'Hold          ');
         Writeat(35,13,foreentry,backentry,'Direct        ');
         Writeat(35,14,foreentry,backentry,'Crash         ');
         Writeat(35,15,foreentry,backentry,'Private       ');
         Writeat(35,16,foreentry,backentry,'Kill/Sent     ');
         Writeat(35,17,foreentry,backentry,'File attach   ');
         If holdmail   in attrib then writeat(48,12,14,backentry,'');
         If directmail in attrib then writeat(48,13,14,backentry,'');
         If crashmail  in attrib then writeat(48,14,14,backentry,'');
         If privat     in attrib then writeat(48,15,14,backentry,'');
         If killsent   in attrib then writeat(48,16,14,backentry,'');
         If fattach    in attrib then writeat(48,17,14,backentry,'');
       End Else
       Begin
         Writeat(35,12,foreentry,backentry,'Private       ');
         If privat     in attrib then writeat(48,12,14,backentry,'');
       End;
   End;

Begin
  If netmail then
    begin
      with mwin[window] do
        begin
          x1 := 33;
          x2 := 10;
          y1 := 50;
          y2 := 19;
          st := ' Attribs ';
        end;
      ar[1] := 'Hold';
      ar[2] := 'Direct';
      ar[3] := 'Crash';
      ar[4] := 'Private';
      ar[5] := 'Kill/Sent';
      ar[6] := 'File attach';
    end else
    begin
      with mwin[window] do
        begin
          x1 := 33;
          x2 := 10;
          y1 := 50;
          y2 := 14;
          st := ' Attribs ';
        end;
      ar[1] := 'Private';
    end;
  create_Window(window);

  choosehook := dummy;
  decwin(window);
  ge := 1;
  while ge <> 0 do
    begin
      writeatt;
      if netmail then
        ge := select_window(window,6,11,@ar,ge,false) else
          ge := select_window(window,1,11,@ar,ge,false);
      if ge <> 0 then
        begin
          if netmail then
            begin
              case ge of
                1 : begin
                      if holdmail   in attrib then attrib := attrib - [holdmail] else
                        attrib := attrib + [holdmail];
                      attrib := attrib - [crashmail];
                    end;
                2 : if directmail in attrib then attrib := attrib - [directmail] else
                      attrib := attrib + [directmail];
                3 : begin
                      if crashmail  in attrib then attrib := attrib - [crashmail] else
                        attrib := attrib + [crashmail];
                      attrib := attrib - [holdmail];
                    end;
                4 : if privat     in attrib then attrib := attrib - [privat] else
                      attrib := attrib + [privat];
                5 : if killsent   in attrib then attrib := attrib - [killsent] else
                      attrib := attrib + [killsent];
                6 : if fattach    in attrib then attrib := attrib - [fattach] else
                      attrib := attrib + [fattach];
              end;
            end else
            begin
              case ge of
                1 : if privat in attrib then attrib := attrib - [privat] else
                      attrib := attrib + [privat];
              end;
            end;
        end;
    end;
  incwin(window);
  remove_window(window);
End;


Procedure SortSystemList (Size : Byte);
Var
  I, J : Byte;

  Procedure Swp (VAR X,Y : ExportType);
  Var T : ExportType;
  Begin
    Move (X, T, SizeOf(ExportType));
    Move (Y, X, SizeOf(ExportType));
    Move (T, Y, SizeOf(ExportType));
  End;

Begin
  for I := 1 to size do
    for J := 1 to size do
      Begin
        if sfxt^[i].A.Zone < sfxt^[J].A.Zone then Swp(sfxt^[I], sfxt^[J]) else
          if sfxt^[i].a.Zone = sfxt^[J].A.Zone then
            if sfxt^[i].a.Net < sfxt^[J].A.Net then Swp(sfxt^[I],sfxt^[J]) else
              if sfxt^[i].a.Net = sfxt^[J].A.Net then
                if sfxt^[i].a.Node < sfxt^[J].A.Node then Swp(sfxt^[I], sfxt^[J]) else
                  if sfxt^[i].a.Node = sfxt^[J].A.Node then
                    if sfxt^[i].a.Point < sfxt^[J].A.Point then Swp(sfxt^[I],sfxt^[J]);
      End;
End;


Procedure ReadNodeIndex;
Begin
  If MaxAvail < SizeOf(Nfxt^) then
    Begin
      AskWindow('','Not enough memory left','',[#13,#27,#32]);
      Halt;
    End Else New(Nfxt);

  For NodeIdx := 1 to 1000 do FillChar(Nfxt^[nodeidx],sizeof(nfxt^[nodeidx]),#0);
  NodeIdx := 0;

  Assign(NFX,systempath+'NODEFILE.FMX');
  {$I-} Reset(NFX,1); {$I+}
  If ioresult = 0 then
    Begin
      BlockRead(Nfx,NFXt^,1000*sizeof(nodeindextype),NodeIdx);
      Close(Nfx);
      NodeIdx := NodeIdx div Sizeof(nodeindextype);

      Assign(NF,systempath+'NODEFILE.FM');
      {$I-} reset(nf,1); {$I+}
      If Ioresult <> 0 then
        Begin
          AskWindow('','Cannot open NODEFILE.FM','',[#13,#27,#32]);
          Halt;
        End;
    End Else
    Begin
      AskWindow('','Cannot open NODEFILE.FMX','',[#13,#27,#32]);
      Halt;
    End;
End;


Procedure WriteNodeIndex;
Var
  NodeWr : Word;
Begin
  Assign(Nfx,systempath+'NODEFILE.FMX');
  {$I-} rewrite(Nfx,1); {$I+}
  If ioresult <> 0 then
    Begin
      AskWindow('','Cannot open/rewrite NODEFILE.FMX','',[#13,#27,#32]);
      Halt;
    End;

  BlockWrite(Nfx,Nfxt^,NodeIdx*sizeof(nodeindextype),NodeWr);
  If NodeWr <> (NodeIdx*sizeof(nodeindextype)) then AskWindow('','Cannot rewrite NODEFILE.FMX','',[#13,#27,#32]);
  Close(Nfx);
  Close(Nf);
  Dispose(Nfxt);
End;


Procedure Select_Node_Systemlist ( window:byte; VAR Ex:ExportType; packchange:boolean; aka:byte );
Var
  found    : boolean;
  y, count : integer;
  ch       : char;
  x,z      : byte;
  tmpbak,
  tmp      : string;

  Procedure Find_It;
  Var z : integer;
  Begin
    found := false;
    z := 1;
    while not found and (z <= nodeidx) do
      begin
        found := samerec(nfxt^[z].address,ex.a,sizeof(ex.a));
        inc(z);
      end;
    fillchar(node,sizeof(node),#0);
    if found then
      begin
        seek(nf,nfxt^[z-1].noderec);
        blockread(nf,node,sizeof(node),count);
        if count <> sizeof(node) then
          begin
            askwindow('','Error reading NODEFILE.FM','',[#13,#27,#32]);
            remove_window(4);
            exit;
          end;
      end;
  End;

  Procedure Write_Them;
  Begin
    Writeat(37,12,foreentry,backentry,expand(node2str(ex.a),26));
    Writeat(37,13,foreentry,backentry,first(27,expand(node.sysopname,26)));
    Writeat(37,14,foreentry,backentry,yesno(import in ex.s));
    Writeat(37,15,foreentry,backentry,yesno(export in ex.s));
    Writeat(37,16,foreentry,backentry,yesno(mandatory in ex.s));
    Writeat(37,17,foreentry,backentry,yesno(prerelease in ex.s));
    If (ex.m = []) or not packchange then
      Writeat(37,18,foreentry,backentry,'Default ') else
    If packtic in ex.m then
      Writeat(37,18,foreentry,backentry,'Pack tic') else
    If packfile in ex.m then
      Writeat(37,18,foreentry,backentry,'Pack all');
  End;

  Procedure Write_It ( activ:byte );
  Begin
    Writeat(24,12,7,0,' Node       ');
    Writeat(24,13,7,0,' Sysop      ');
    Writeat(24,14,7,0,' Import     ');
    Writeat(24,15,7,0,' Export     ');
    Writeat(24,16,7,0,' Mandatory  ');
    Writeat(24,17,7,0,' Prerelease ');
    Writeat(24,18,7,0,' Packing    ');
    Case activ of
      1 : Writeat(24,12,kl4,kl5,' Node       ');
      2 : Writeat(24,13,kl4,kl5,' Sysop      ');
      3 : Writeat(24,14,kl4,kl5,' Import     ');
      4 : Writeat(24,15,kl4,kl5,' Export     ');
      5 : Writeat(24,16,kl4,kl5,' Mandatory  ');
      6 : Writeat(24,17,kl4,kl5,' Prerelease ');
      7 : Writeat(24,18,kl4,kl5,' Packing    ');
    End;
  End;

Begin
  With mwin[window] do
    begin
      x1 := 23;
      x2 := 10;
      y1 := 63;
      y2 := 20;
      st := ' Connection ';
    end;
  create_window(window);

  find_it;

  ch := #0;
  x := 1;
  while ch <> #27 do
    begin
      write_it(x);
      write_them;
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                  #80 : {down}     if x < 7 then inc(X) else x := 1;
                  #72 : {up}       if x > 1 then dec(X) else x := 7;
                  #81 : {pagedown} X := 7;
                  #73 : {pageup}   X := 1;
                  #71 : {home}     X := 1;
                  #79 : {end}      X := 7;
                end;
              end;
        #9  : infoscreen;
        #26 : dosshell;
        #13 : begin
                case x of
                  1 : begin
                        tmp := node2str(ex.a);
                        tmpbak := tmp;
                        read_string(37,12,23,26,tmp,c_all);
                        if (ex.a.zone = 0) and (aka = 0) then aka := 1;
                        str2node(tmp,ex.a,setup.address[aka],found);
                        if not found then askwindow('','Invalid nodenumber entered','',[#32,#27,#13]);
                        if (tmp = tmpbak) or (tmp = '') then
                          begin
                            y := 0;
                            repeat
                              inc(y);
                            until samerec(nfxt^[y].address,ex.a,sizeof(ex.a)) or (y > nodeidx);
                            z := select_node(window+1,y);
                            if z <> y then ex.a := nfxt^[z].address;
                          end;
                        find_it;
                      end;
                  2 : begin
                        y := 0;
                        repeat
                          inc(y);
                        until samerec(nfxt^[y].address,ex.a,sizeof(ex.a)) or (y > nodeidx);
                        z := select_node(window+1,y);
                        if z <> y then ex.a := nfxt^[z].address;
                        find_it;
                      end;
                  3 : if import in ex.s then
                        ex.s := ex.s - [import] else ex.s := ex.s + [import];
                  4 : if export in ex.s then
                        ex.s := ex.s - [export] else ex.s := ex.s + [export];
                  5 : if mandatory in ex.s then
                        ex.s := ex.s - [mandatory] else ex.s := ex.s + [mandatory];
                  6 : if prerelease in ex.s then
                        ex.s := ex.s - [prerelease] else ex.s := ex.s + [prerelease];
                  7 : begin
                        if packchange then
                          begin
                            if ex.m = [] then ex.m := [packtic] else
                            if packtic in ex.m then ex.m := [packfile] else
                            if packfile in ex.m then ex.m := [];
                          end else write(#7);
                      end;
                end;
                write_them;
              end;
      end;
    end;
  remove_window(window);
End;


Function Select_FileAreas(window:byte; onlyone:boolean; active:word) : Word;
Var
  Stop    : Boolean;
  Ch      : Char;
  Top     : Longint;
  Index   : Longint;
  Z, Result : Word;
  Tmp     : String;
  FFMax   : Word;
  Br      : Array[1..15] of BbsAreaType;

  Procedure Arrow;
  Var Str : String;
  Begin
    Str := '';
    If 13 < ffmax then
      Begin
        If Top > 1 then Str := Chr(24);
        If Top+12 < ffmax then Str := Str + Chr(25);
      End;
    Writeat(60,22,11,0,Str+'');
  End;

  Procedure ShowList;
  Var X    : Integer;
      Y    : integer;
      Tmp2 : String[40];
      Tmp3 : String[10];
  Begin
    Seek(Bf,Sizeof(bbsarea)+20+((Top-1)*Sizeof(bbsarea)));
    {$i-} BlockRead(Bf,Br,Sizeof(Br)); {$I+}
    if ioresult <> 0 then {};

    if onlyone then y := 6 else y := 8;

    For X := 1 to z do
      Begin
        Tmp := expand(int_to_str(Top+X-1),5);

        if not onlyone then
          begin
            If Br[x].on and (ffmax >= x) then Tmp3 := ' ' else Tmp3 := '  ';
          end else
            if ffmax >= x then tmp3 := int_to_str(br[x].nr)+' -' else tmp3 := '';

        if ffmax >= x then
          Tmp2 := ' '+expand(Br[x].name,28) else tmp2 := '';

        If X = Index then
          Begin
            Writeat(26,y+x,kl4,kl5,' '+tmp+expand(tmp3+tmp2,31));
          End Else
          Begin
            Writeat(26,y+x,3,0,' '+Tmp);
            If onlyone then writeat(32,y+x,3,0,expand(tmp3+tmp2,31)) else
              Begin
                Writeat(32,y+x,14,0,tmp3);
                Writeat(34,y+x,3,0,tmp2);
              end;
          End;
      End;
  End;

  Procedure Change(bol:boolean);
  Var X : LongInt;
  Begin
    Shadow := true;
    Mkwin(30,10,50,14,0,7,1);
    Writeat(35,12,0,7,'Hold on...');
    For X := 1 to FfMax do
      Begin
        Seek(Bf,Sizeof(Bbsarea)+20 + (Sizeof(bbsarea)*(x-1)) );
        BlockRead(Bf,BbsArea,sizeof(bbsarea),result);
        BbsArea.on := bol;
        Seek(Bf,Sizeof(Bbsarea)+20 + (Sizeof(bbsarea)*(x-1)) );
        BlockWrite(Bf,BbsArea,sizeof(bbsarea),result);
      End;
    RmWin;
    Shadow := false;
  End;

Begin
  Assign(Bf,systempath+'FILEAREA.FM');
  {$I-} Reset(bf,1); {$I+}
  If ioresult <> 0 then
    Begin
      AskWindow('FILEAREA.FM','does not exist!','Run FMCONV',[#32,#13,#27]);
      Select_fileareas := 0;
      Exit;
    End;

  FFMax := ((Filesize(bF)-20) div sizeof(bbsarea))-1;
  If onlyone then z := 15 else z := 13;

  If (active = 0) or (active = 1) then
    begin
      Top := 1;
      Index := 1;
    end else
    begin
      Top := Active;
      Index := 1;
      while top+14 > ffmax do begin dec(top); inc(index); end;
    end;

  With mwin[window] do
    Begin
      X1 := 25;
      x2 := 6;
      y1 := 63;
      y2 := 22;
      st := ' Bbs Areas ';
    End;
  Create_Window(window);

  if not onlyone then
    begin
      Writeat(27,7,7,0,'#  Active  Area');
      Writeat(26,8,1,0,replicate(37,''));
    end;

  Stop := False;
  Repeat
    ShowList;
    Arrow;

    Ch := Readkey;
    If Ch = #9 then infoscreen;
    If Ch = #26 then dosshell;

    if not onlyone then
      begin
        If Ch = '+' then Change(true);
        If Ch = '-' then Change(false);
      end;

    If Ch = #27 then stop := true;

    If (Ch = #13) or (Ch = #32) then
      Begin
        if Onlyone then
          Begin
            Stop := True;
          End Else
          Begin
            Seek(Bf,Sizeof(Bbsarea)+20 + (Sizeof(bbsarea)*(Top+index-2)) );
            BlockRead(Bf,BbsArea,sizeof(bbsarea),result);
            BbsArea.on := not bbsarea.on;
            Seek(Bf,Sizeof(Bbsarea)+20 + (Sizeof(bbsarea)*(Top+index-2)) );
            BlockWrite(Bf,BbsArea,sizeof(bbsarea),result);
            if index < 13 then
              begin
                inc(index);
                if index > ffmax then index := ffmax;
              end else
                if top+12 < ffmax then inc(top);
          End;
      End;

    If Ch = #0 then
      Begin
        Ch := Readkey;
        Case Ch of
          #72 : begin  {up}
                  if index > 1 then dec(index) else
                    if top > 1 then dec(top);
                end;
          #80 : begin  {down}
                  if index < z then
                    begin
                      inc(index);
                      if index > ffmax then index := ffmax;
                    end else
                    if top+(z-1) < ffmax then inc(top);
                end;
          #71 : begin  {home}
                  index := 1;
                  top := 1;
                end;
          #79 : begin  {end}
                  index := z;
                  if index > ffmax then
                    begin
                      top := 1;
                      index := ffmax;
                    end else
                      top := ffmax-(z-1);
                end;
          #73 : begin  {pgup}
                  if index = 1 then
                    begin
                      dec(top,z);
                      if top < 1 then top := 1;
                    end else index := 1;
                end;
          #81 : begin  {pgdn}
                  if index = z then
                    begin
                      inc(top,z);
                      if top+(z-1) > ffmax then top := ffmax-(z-1);
                    end else index := z;
                  if index > ffmax then
                    begin
                      index := ffmax;
                      top := 1;
                    end;
                end;
        End;
      End;
  Until Stop;

  Close(Bf);
  Remove_Window(window);
  If onlyone then
    begin
      if ch = #32 then select_fileareas := 0 else
        select_fileareas := top+index-1;
      if ch = #27 then select_fileareas := 0;
    end else select_fileareas := 0;
End;


Procedure Change_GlobalAreaStatus(window:byte; VAR status:statustype; VAR nostatus:statustype);
Var
  ch : char;
  at : byte;

  Procedure WriteMail(activ:byte);
  Begin
    Writeat(36,7 ,7,0,' Fuzzydup   ');
    Writeat(36,8 ,7,0,' Crc        ');
    Writeat(36,9 ,7,0,' Dupcheck   ');
    Writeat(36,10,7,0,' Tiny       ');
    Writeat(36,11,7,0,' Secure     ');
    Writeat(36,12,7,0,' Backup     ');
    Writeat(36,13,7,0,' Hide       ');
    Writeat(36,14,7,0,' VirusScan  ');
    Writeat(36,15,7,0,' ImportDiz  ');
    Writeat(36,16,7,0,' LongDesc   ');
    Writeat(36,17,7,0,' AnnNew     ');
    Writeat(36,18,7,0,' HatchNew   ');
    Writeat(36,19,7,0,' Test file  ');
    Writeat(36,20,7,0,' Notified   ');
    Writeat(36,21,7,0,' Disconnect ');

    Case Activ of
      1 : Writeat(36,7 ,kl4,kl5,' Fuzzydup   ');
      2 : Writeat(36,8 ,kl4,kl5,' Crc        ');
      3 : Writeat(36,9 ,kl4,kl5,' Dupcheck   ');
      4 : Writeat(36,10,kl4,kl5,' Tiny       ');
      5 : Writeat(36,11,kl4,kl5,' Secure     ');
      6 : Writeat(36,12,kl4,kl5,' Backup     ');
      7 : Writeat(36,13,kl4,kl5,' Hide       ');
      8 : Writeat(36,14,kl4,kl5,' VirusScan  ');
      9 : Writeat(36,15,kl4,kl5,' ImportDiz  ');
     10 : Writeat(36,16,kl4,kl5,' LongDesc   ');
     11 : Writeat(36,17,kl4,kl5,' AnnNew     ');
     12 : Writeat(36,18,kl4,kl5,' HatchNew   ');
     13 : Writeat(36,19,kl4,kl5,' Test file  ');
     14 : Writeat(36,20,kl4,kl5,' Notified   ');
     15 : Writeat(36,21,kl4,kl5,' Disconnect ');
    End;

    If fuzzydup in status then
      Writeat(49,7,foreentry,backentry,'Yes') else
        if fuzzydup in nostatus then
             Writeat(49,7,foreentry,backentry,'No ') else
                  Writeat(49,7,foreentry,backentry,'   ');

    If crc in status then
      Writeat(49,8,foreentry,backentry,'Yes') else
           if crc in nostatus then
             Writeat(49,8,foreentry,backentry,'No ') else
                  Writeat(49,8,foreentry,backentry,'   ');

    If dupcheck in status then
      Writeat(49,9,foreentry,backentry,'Yes') else
           if dupcheck in nostatus then
             Writeat(49,9,foreentry,backentry,'No ') else
                  Writeat(49,9,foreentry,backentry,'   ');

    If tiny in status then
      Writeat(49,10,foreentry,backentry,'Yes') else
           if tiny in nostatus then
             writeat(49,10,foreentry,backentry,'No ') else
                  writeat(49,10,foreentry,backentry,'   ');

    If secure in status then
      Writeat(49,11,foreentry,backentry,'Yes') else
           if secure in nostatus then
             Writeat(49,11,foreentry,backentry,'No ') else
                  writeat(49,11,foreentry,backentry,'   ');

    if backup in status then
      writeat(49,12,foreentry,backentry,'Yes') else
           if backup in nostatus then
             writeat(49,12,foreentry,backentry,'No ') else
                  writeat(49,12,foreentry,backentry,'   ');

    if hide in status then
      writeat(49,13,foreentry,backentry,'Yes') else
           if hide in nostatus then
             writeat(49,13,foreentry,backentry,'No ') else
                   Writeat(49,13,foreentry,backentry,'   ');

    if virus in status then
      Writeat(49,14,foreentry,backentry,'Yes') else
           if virus in nostatus then
             writeat(49,14,foreentry,backentry,'No ') else
                  writeat(49,14,foreentry,backentry,'   ');

    if importdiz in status then
      Writeat(49,15,foreentry,backentry,'Yes') else
           if importdiz in nostatus then
             writeat(49,15,foreentry,backentry,'No ') else
                  writeat(49,15,foreentry,backentry,'   ');

    if longdesc in status then
      Writeat(49,16,foreentry,backentry,'Yes') else
           if longdesc in nostatus then
          writeat(49,16,foreentry,backentry,'No ') else
                  writeat(49,16,foreentry,backentry,'   ');

    if annnew in status then
      Writeat(49,17,foreentry,backentry,'Yes') else
           if annnew in nostatus then
          writeat(49,17,foreentry,backentry,'No ') else
                  writeat(49,17,foreentry,backentry,'   ');

    if hatchnew in status then
      Writeat(49,18,foreentry,backentry,'Yes') else
           if hatchnew in nostatus then
             writeat(49,18,foreentry,backentry,'No ') else
                  writeat(49,18,foreentry,backentry,'   ');

    if test in status then
      writeat(49,19,foreentry,backentry,'Yes') else
           if test in nostatus then
          Writeat(49,19,foreentry,backentry,'No ') else
                  writeat(49,19,foreentry,backentry,'   ');

    if noti in status then
      writeat(49,20,foreentry,backentry,'Yes') else
           if noti in nostatus then
          Writeat(49,20,foreentry,backentry,'No ') else
                  writeat(49,20,foreentry,backentry,'   ');

    if disc in status then
      writeat(49,21,foreentry,backentry,'Yes') else
           if disc in nostatus then
          Writeat(49,21,foreentry,backentry,'No ') else
                  writeat(49,21,foreentry,backentry,'   ');
  End;

Begin
  status := [];
  nostatus := [];

  with mwin[window] do
   begin
    x1 := 35;
    x2 := 5;
    y1 := 53;
    y2 := 23;
    st := ' Status ';
   end;
  Create_window(window);

  Ch := #0;
  At := 1;

  While ch <> #27 do
    Begin
      writemail(at);
      Ch := readkey;
      Case Ch of
       #13 : Begin
               case At of
                 1 : begin
                       if fuzzydup in status then
                         begin
                           status := status - [fuzzydup];
                           nostatus := nostatus + [fuzzydup];
                         end else
                       if fuzzydup in nostatus then
                           nostatus := nostatus - [fuzzydup] else
                                           status := status + [fuzzydup];
                     end;
                 2 : begin
                        if crc in status then
                         begin
                           status := status - [crc];
                           nostatus := nostatus + [crc];
                         end else
                           if crc in nostatus then
                              nostatus := nostatus - [crc] else
                              status := status + [crc];
                     end;
                 3 : begin
                       if dupcheck in status then
                         begin
                           status := status - [dupcheck];
                           nostatus := nostatus + [dupcheck];
                         end else
                           if    dupcheck in nostatus then
                                nostatus := nostatus - [dupcheck] else
                                status := status + [dupcheck];
                     end;
                 4 : begin
                       if tiny in status then
                         begin
                           status := status - [tiny];
                           nostatus := nostatus + [tiny];
                         end else
                           if tiny in nostatus then
                              nostatus := nostatus - [tiny] else
                              status := status + [tiny];
                     end;
                 5 : begin
                       if secure in status then
                         begin
                           status := status - [secure];
                           nostatus := nostatus + [secure];
                         end else
                           if secure in nostatus then
                              nostatus := nostatus - [secure] else
                              status := status + [secure];
                     end;
                 6 : begin
                       if backup in status then
                         begin
                           status := status - [backup];
                           nostatus := nostatus + [backup];
                         end else
                           if backup in nostatus then
                              nostatus := nostatus - [backup] else
                              status := status + [backup];
                     end;
                 7 : begin
                       if hide in status then
                          begin
                            status := status - [hide];
                            nostatus := nostatus + [hide];
                          end else
                            if hide in nostatus then
                               nostatus := nostatus - [hide] else
                               status := status + [hide];
                     end;
                 8 : begin
                       if virus in status then
                         begin
                           status := status - [virus];
                           nostatus := nostatus + [virus];
                         end else
                           if hide in nostatus then
                             nostatus := nostatus - [virus] else
                             status := status + [virus];
                     end;
                 9 : begin
                       if importdiz in status then
                         begin
                           status := status - [importdiz];
                           nostatus := nostatus + [importdiz];
                         end else
                           if importdiz in nostatus then
                             nostatus := nostatus - [importdiz] else
                             status := status + [importdiz];
                     end;
                10 : begin
                       if longdesc in status then
                         begin
                           status := status - [longdesc];
                           nostatus := nostatus + [longdesc];
                         end else
                           if longdesc in nostatus then
                              nostatus := nostatus - [longdesc] else
                              status := status + [longdesc];
                     end;
                11 : begin
                       if annnew in status then
                         begin
                            status := status - [annnew];
                            nostatus := nostatus + [annnew];
                         end else
                            if annnew in nostatus then
                              nostatus := nostatus - [annnew] else
                              status := status + [annnew];
                    end;
                12 : begin
                       if hatchnew in status then
                         begin
                           status := status - [hatchnew];
                           nostatus := nostatus + [hatchnew];
                         end else
                           if hatchnew in nostatus then
                             nostatus := nostatus - [hatchnew] else
                              status := status + [hatchnew];
                     end;
                13 : begin
                       if test in status then
                         begin
                           status := status - [test];
                           nostatus := nostatus + [test];
                         end else
                           if test in nostatus then
                             nostatus := nostatus - [test] else
                             status := status + [test];
                     end;
                14 : begin
                       if noti in status then
                         begin
                           status := status - [noti];
                           nostatus := nostatus + [noti];
                         end else
                           if noti in nostatus then
                              nostatus := nostatus - [noti] else
                              status := status + [noti];
                     end;
                15 : begin
                       if disc in status then
                          begin
                            status := status - [disc];
                            nostatus := nostatus + [disc];
                          end else
                            if disc in nostatus then
                               nostatus := nostatus - [disc] else
                               status := status + [disc];
                     end;
               end;
             End;
       #9  : infoscreen;
       #26 : dosshell;
       #0  : Begin
               Ch := Readkey;
               Case ch of
                 #72 : {up}    begin
                                 if at = 1 then at := 16;
                                 dec(at);
                               end;
                 #80 : {down}  begin
                                 inc(at);
                                 if at = 16 then at := 1;
                               end;
                 #73,  {pgup}
                 #71 : {home}  at := 1;
                 #81,  {pgdn}
                 #79 : {end}   at := 15;
               End;
             End;
      End;
    End;
  Remove_window(window);
End;


{---- Main -----}


Begin
  Infoscreenhook := infoscreen;
  Dosshellhook := dosshell;
End.

