{
 $Id$
}
{*****************************************************************************
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Var
  Aitfile : File of AreaIndexType;
  A       : AreaIndexType;
  Atfile  : File;
  At      : AreaType;
  Tel     : Word;
  Found   : Boolean;

Function Open_files:boolean;
var
  bol : boolean;
begin
  Bol := True;
  Assign(aitfile,'areafile.fmx');
  {$I-} reset(aitfile); {$I+}
  If ioresult <> 0 then
    Begin
      Assign(aitfile,spath+'areafile.fmx');
      {$I-} reset(aitfile); {$I+}
      If ioresult <> 0 then bol := false;
    End;

  Assign(atfile,'areafile.fm');
  {$I-} reset(atfile); {$I+}
  If ioresult <> 0 then
    Begin
      Assign(atfile,spath+'areafile.fm');
      {$I-} reset(atfile); {$I+}
      If ioresult <> 0 then Bol := False;
    End;

  Open_Files := Bol;
End;


Function GetBbsArea(directory:string) : Word; {0 if not found, anders rec nummer}
Var
  Found    : Boolean;
  Tel, Max : Word;
Begin
  getbbsarea := 0;

  FillChar(BbsArea,Sizeof(bbsarea),#0);
  If Exist('filearea.fm') then
    Begin
      Assign (bf, 'filearea.fm');
      {$I-} Reset (bf,1); {$I+}
      If ioresult <> 0 then exit;
    End Else
  If Exist(spath+'filearea.fm') then
    Begin
      Assign (bf, spath+'filearea.fm');
      {$I-} Reset (bf,1); {$I+}
      If ioresult <> 0 then exit;
    End Else
    Begin
      Writeln('Cannot find '+spath+'FILEAREA.FM');
      Halt;
    End;

  Max   := (Filesize(bF) div sizeof(bbsarea)) -2;
  Tel := 0;
  Found := False;
  If last(1,directory) <> '\' then directory := directory + '\';
  While not found and (tel <= Max) do
    Begin
      Seek(bF, (Tel * SizeOf(Bbsarea)) + sizeof(bbsarea) + 20);
      BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
      If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';

      If Upper(Directory) = Upper(Bbsarea.path) then
        Found := True;
      Inc(Tel);
    End;
  Close(bf);
  If found then GetBbsArea := Tel Else GeTbbsArea := 0;
End;


Function Close_Files : Boolean;
{-----------------------------}
Begin
  {$I-} Close(aitfile);
  Close(atfile); {$I+}
  If ioresult <> 0 then
    Close_Files := False
      Else Close_Files := True;
End;


Procedure Lees_Aitfile;
{---------------------}
Var
  Result : Integer;
  X      : Word;
  Found  : Boolean;
Begin
  While not Eof(aitfile) do
    Begin
      Read(aitfile,a);

      If strip('B',' ',a.tag) <> '' then
        begin

          Reset(atfile,1);
          Seek(atfile,a.arearec);
          BlockRead(atfile,at,sizeof(at),result);
          If result <> sizeof(at) then
            Begin
              Writeln(' Cannot read filemgr.fm file!');
              Halt;
            End;

          Write(expand(a.tag,50)+#13);

          At.areanr := GetBbsArea(at.directory);

          If at.areanr = 0 then at.listspec := at.directory + 'FILES.BBS';

          Seek(atfile,a.arearec);
          BlockWrite(atfile,at,sizeof(at),result);
          If result <> sizeof(at) then
            Begin
              Writeln(' Error writing to filemgr.fm file!');
              Halt;
            End;

        End;
    End;
End;

{----------------}

Procedure Convert;
Begin
  Writeln('Synchronizing FILEAREA.FM with FileMgr''s AREAFILE.FM.'+#10#13);

  Filemode := 18;

  If not exist(spath+'FILEAREA.FM') then
    Begin
      Writeln(' Cannot open '+spath+'FILEAREA.FM file.');
      exit;
    End;

  If not Open_Files then
    Begin
      Writeln(' Cannot open filemgr index files.');
      exit;
    End;

  Lees_Aitfile;

  If not Close_Files then
    Begin
      Writeln(' Cannot close filemgr index files.');
    End;

  Write('All done...'+expand(' ',40),#10#13);
End;

