PAGE  80,132
TITLE WRDR  Parse the Nth word from the RIGHT, Ver 6.20

; WRDR.ASM - WrdR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine extracts the Nth word from the RIGHT delimited by spaces.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdR
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+10]
S            EQU     DWORD PTR SS:[bx+6]
Nth          EQU     BYTE  PTR SS:[bx+4]

; WrdR - Parse the Nth word from the RIGHT.
; procedure WrdR (VAR Dest: string; S: string; Nth: byte);

WrdR         PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
; -- Evalute Nth --
       add   dl,Nth           ; Get Nth, Nth=0?
       jz    Null2            ;   yes, return null
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   cl,es:[di]       ; Get length
       jcxz  Null2             ; Exit if null string
; -- Set up constants --
       add   di,cx            ; To S[L]
       mov   al,' '           ; Get Space char to scan
       std                    ; Set DF to decrement
       EVEN                   ; Align for speed
L1:    repe  scasb            ; Scan for non-space
       je    Null1            ; All spaces
       dec   dx               ; Word found, dec count
       jz    Found            ; Exit if Nth word found
       repne scasb            ; Scan for space
       je    L1               ;   space found, look for next word
       jmp   SHORT Null1      ; Word not found.  CX=0
Found: mov   si,di            ; Save offset Wrd[L-1]
       inc   si               ; To Wrd[L]
       repne scasb            ; Scan for beginning of word
       jne   Inc0             ;   no space
       inc   di               ; To Wrd[0]
Inc0:  mov   cx,si            ; Get final offset
       sub   cx,di            ; Word length in CX
       mov   si,di            ; Make it the source
       inc   si               ; To Wrd[1]
; -- Reset pointers --
       mov   dx,es            ; Save ES
Null1: cld                    ; Set DF to increment
Null2: mov   ax,cx            ; Set length in AX
       les   di,Dest          ; Set up destination
       stosb                  ; Save length
       mov   bx,ds            ; Save Pascal's DS
       mov   ds,dx            ; Set source seg
       call  RepMovsB         ; Do fast move of bytes (Skip if CX=0)
       mov   ds,bx            ; Restore Pascal's DS
       ret   10               ; Clear all parameters
WrdR         ENDP

CODE   ENDS

       END
