PAGE  80,132
TITLE WRDPOSRX  Position word from RIGHT starting at a given index, Ver 6.20

; WRDPOSRX.ASM - WrdPosRX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine returns the position of the first word starting at a given index
; from a string delimited by spaces.  The routine searches starting at index
; from RIGHT to left to find the beginning of the first word found.

; If indeX=0, zero is returned.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdPosRX

S            EQU     DWORD PTR SS:[bx+6]
indeX        EQU     BYTE  PTR SS:[bx+4]

; WrdPosRX - Returns a word's position starting from RIGHT at a given indeX.
; function WrdPosRX (S: string; indeX: byte): byte;

WrdPosRX     PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   cl,es:[di]       ; Get length
; -- Evalute Index --
       mov   al,indeX         ; Get indeX
       cmp   al,cl            ; Index>Length?
       ja    AtEnd            ;   yes, use length
       mov   cl,al            ;   no,  use index
AtEnd: add   di,cx            ; Point to S[index]
       cmp   ch,cl            ; Index>0?
       jz    Exit             ;   Exit if null string or Index=0
       sbb   cl,ch            ;   yes, decrement
; -- Test first char --
       mov   al,' '           ; Get Space char to scan
       std                    ; Set DF to decrement
       scasb                  ; S[index]=space?
       jne   OnTop            ;   no, on top of word
; -- Search for a word --
       repe  scasb            ; Scan for non-space.
       je    Exit             ; All spaces
; -- Search left to beginning of word --
OnTop: repne scasb            ; Scan for space.
       jne   Inc1             ; At Wrd[0]
       inc   cx               ; Point to space
Inc1:  inc   cx               ; Point to 1st char
Exit:  xchg  ax,cx            ; Place result in AX
       ret   6                ; Clear all parameters

WrdPosRX     ENDP

CODE   ENDS

       END
