PAGE  80,132
TITLE WRDPOSLX  Position word from LEFT starting at a given index, Ver 6.20

; WRDPOSLX.ASM - WrdPosLX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine returns the position of the first word starting at a given index
; from a string delimited by spaces.  The routine searches starting at indeX
; and to the RIGHT to find the beginning of the first word found.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdPosLX

S            EQU     DWORD PTR SS:[bx+6]
indeX        EQU     BYTE  PTR SS:[bx+4]

; WrdPosLX - Position of word from LEFT starting at a given index.
; function WrdPosLX (S: string; indeX: byte): byte;
;
;   INDEX    START      MARKER  CHARS TO SCAN
;   -----    ---------  ------  -------------
;    0,1     S[1]       S[1]    L-(X-1)=L
;    2       S[X-1]     S[1]    L-(X-2)=L
;    X       S[X-1]     S[1]    L-(X-2)
;
;   ABORT SCAN IF X>L

WrdPosLX     PROC FAR

       mov   bx,sp            ; Set up stack base
       xor   ax,ax            ; Set AX=0
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   al,es:[di]       ; Get length
       mov   cx,ax            ; Set CX
       jcxz  Exit             ; Exit if null string
; -- Evalute Index --
       mov   si,di            ; Save marker at S[0]
       inc   si               ; Set marker at S[1]
       mov   al,indeX         ; Get indeX
; -- Convert 0 index to 1 --
       cmp   ah,al            ; Index=0?
       sbb   al,-1            ;   yes, increment
; -- Back up index 1 char --
       mov   dx,ax            ; Save a copy in DX
       cmp   al,2             ; Index>=2?
       adc   al,-1            ;   yes, decrement index
; -- Index within string length? --
       sub   cx,ax            ; Length<Index?
       jb    Null             ;   yes, exit with null
       inc   cx               ; add 1
; -- Test first char --
       add   di,ax            ; First char to scan
       mov   al,' '           ; Get Space char to scan
       cld                    ; Set DF to increment
       dec   dx               ; Index=1?
       je    aWord            ;   yes, hunt straight for word
; -- Search right to end of partial word --
       repne scasb            ; Scan for space.
       jne   Null             ; All non-spaces.
; -- Search for a word --
aWord: repe  scasb            ; Scan for non-space.
       je    Null             ; All spaces
       mov   ax,di            ; Get current DI
       sub   ax,si            ; Calc position
Exit:  ret   6                ; Clear all parameters

Null:  mov   al,ah            ; Set AL=0
       jmp   Exit             ; Finish up routine

WrdPosLX     ENDP


CODE   ENDS

       END
