PAGE  80,132
TITLE VALHEX  Hex String to Decimal Routine, Ver 6.20

; VALHEX.ASM - ValHex
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts hex strings to longint.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ValHex

Sofs         EQU     WORD  PTR [bp+10]
S            EQU     DWORD PTR [bp+10]
ErrCode      EQU     DWORD PTR [bp+6]
Place        EQU     BYTE  PTR [SI]


; ValHex - Converts hex strings to a longint.
;  . Leading spaces are permitted but not trailing ones.
;  . Leading zeros are also permitted.
;  . The leading '$' is optional!
;  . A non-zero error code points to the invalid character in the string.
;  . Numbers larger than $FFFFFFFF produce an error.
;  . ValHex salvages a value even if there is an error.
;  . Twice as fast as System.Val and uses much less code.
;  . Routine is more flexible as a function rather than the Val procedure
;    which is compiler dependent on the number type.
;
; function ValHex (S: string; VAR Code: integer): longint;

ValHex       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       lds   si,S             ; Point at S
       xor   ax,ax            ; Set AX=0
       cwd                    ; Set DX=0
       mov   bx,ax            ; Set BX=0
       cld                    ; Set DF to increment
       lodsb                  ; Get length in AL
       xchg  ax,cx            ; Place length in CX
       jcxz  Exit2            ; Exit if no length
; -- Skip leading spaces --
       EVEN                   ; Align for speed
L0:    cmp   Place,' '        ; Place char = space?
       jne   Eval1            ;   no, must be char
       inc   si               ; Go to next char
       loop  L0               ; Try again
       jmp   SHORT Exit2      ; Exit, no char found
; -- Calculate error position --
Exit1: dec   si               ; Point to bad char
Exit2: xchg  ax,si            ; Get offset
       sub   ax,Sofs          ; Calc bad position
       jmp   SHORT Exit3      ;
; -- Evaluate chars --
Eval1: cmp   Place,'$'        ; First char a '$'?
       jne   Eval2            ;   no, start testing
       inc   si               ;   yes, skip char
       dec   cx               ; Decrement chars left
       jz    Exit2            ; No hex digits to convert
Eval2: mov   ah,0Fh           ; Set AH to 15 (00001111b)
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get char
       cmp   dh,ah            ; DH>15?
       ja    Exit1            ;   yes, too many hex chars
       sub   al,'0'           ; char-'0'?
       jb    Exit1            ;   yes, bad char
       cmp   al,9             ; <=9?
       jbe   L2               ;   yes, 0-9 digit
       sub   al,'A'-'9'-1     ; Assume A..F
       cmp   al,0Ah           ; >=A?
       jb    Exit1            ;   no, bad char
       cmp   al,ah            ; <=F?
       jbe   L2               ;   yes, A..F digit
       ; -- check for possible lower case --
       sub   al,'a'-'A'       ; Assume a..f digit
       cmp   al,0Ah           ; >=a?
       jb    Exit1            ;   no, bad char
       cmp   al,ah            ; >f?
       ja    Exit1            ;   yes, bad char
       ; -- shift four bits (multiply by 16) --
L2:    mov   di,cx            ; Save count
       mov   cl,4             ; Set shift bits to 4
       rol   bx,cl            ; Rotate lo word bits
       shl   dx,cl            ; Shift hi word bits
       mov   cl,bl            ; Copy lo byte
       and   cl,ah            ; Isolate lo nibble
       add   dl,cl            ; Add to lo nibble of high word
       and   bl,11110000b     ; Set lo nibble=0
       or    bl,al            ; Add in new nibble
       mov   cx,di            ; Restore count
       loop  L1               ;
; -- Set results --
       xchg  ax,cx            ; Nullify error code AX=0
Exit3: les   di,ErrCode       ; Point to ErrCode
       stosw                  ; Save ErrCode
       xchg  ax,bx            ; Place BX in AX
       pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   8                ; Clear all parameters
ValHex       ENDP

CODE   ENDS

       END
