PAGE  80,132
TITLE STRMEMB  String Membership Routine, Ver 6.20

; STRMEMB.ASM - StrMemb
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Operates on a string by sorting it in ascending order.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrMemb

; StrMemb - Reduces a string to its members in ascending order.
;
; procedure StrMemb (VAR Dest: string; S: string);

Dest         EQU     DWORD PTR [bp+10]
DestOfs      EQU     WORD  PTR [bp+10]
S            EQU     DWORD PTR [bp+6]
Table        EQU     BYTE  PTR [bp-256]
Tally        EQU     BYTE  PTR es:[bx+di]

StrMemb      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       sub   sp,256           ; Allow space for table
       push  ds               ; Save Pascal's DS
; -- Get string length --
       lds   si,S             ; Point to string
       xor   ax,ax            ; Set AX=0
       cld                    ; Set DF to increment
       lodsb                  ; Set length
       cmp   al,1             ; L<=1?
       jbe   Exit0            ;  yes, quit
; -- Clear table --
       mov   dx,ax            ; Save length in DL
       mov   bx,ss            ; Move SS into ...
       mov   es,bx            ;  ... ES
       lea   di,Table         ; Point to table
       mov   bx,di            ; Also use as base
       mov   al,ah            ; Set AX=0
       mov   cx,128           ; Set CX=128
       rep   stosw            ; Clear table
; -- Make tally --
       mov   cx,dx            ; Get length again
       EVEN                   ; Align for speed
L3:    lodsb                  ; Get char
       mov   di,ax            ; Set offset
       inc   Tally            ; Tally occurrence
       loop  L3               ; Continue for all chars
; -- Set pointers to assemble membership string --
       lds   si,Dest          ; Point to Dest string
       inc   si               ; At Dest[1]
       mov   di,bx            ; Set DI at tally offset
       inc   bx               ; To calculate char #
       dec   cx               ; Set CX=0FFFFh
; -- Search for tally and assemble string --
       EVEN                   ; Align for speed
L4:    mov   al,dh            ; Set AL=0
       repe  scasb            ; Search for non-zero
       mov   ax,di            ; Get offset
       sub   ax,bx            ; Calc char #
       mov   [si],al          ; Assemble string
       inc   si               ; Next char
       sub   dl,es:[di-1]     ; Chars left
       jnz   L4               ; Continue if more chars
; -- Set string length --
       mov   ax,DestOfs       ; Get Dest offset
       xchg  ax,si            ; Swap offsets
       sub   ax,si            ; Calc length+1
       dec   ax               ; Calc length
       mov   [si],al          ; Set length
; -- Exit routine --
Exit:  pop   ds               ; Restore Pascal's DS
       mov   sp,bp            ; Clear local variable
       pop   bp               ; Restore Pascal's BP
       ret   8                ; Clear all parameters

; -- Nothing to do, just copy over string --
Exit0: les   di,Dest          ; Point to Dest string
       stosb                  ; Save length
       jb    Exit             ; Exit if 0 length
       movsb                  ; Copy only byte
       jmp   SHORT Exit       ;
StrMemb      ENDP

CODE   ENDS

       END
