PAGE  80,132
TITLE STRJ  String Justification Routines, Ver 6.20

; STRJ.ASM - StrJL, StrJR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; These two routines left or right justify strings in a field.  If the
; field is smaller than the orginal string, the string is simply returned.
; This routine saves from recopying the string to make it faster.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrJL, StrJR
        EXTRN   RepMovsB: NEAR
        EXTRN   RepStosB: NEAR

; StrJL - Left  justifies the string.
; StrJR - Right justifies the string.

Space        EQU     ' '
S            EQU     DWORD PTR [bp+8]
Field        EQU     BYTE  PTR [bp+6]
Result       EQU     DWORD PTR [bp+0Ch]

; StrJL - Left justifies a string in a field.
; function StrJL (S: string; Field: byte): string;

StrJL        PROC FAR
       clc                    ; Clear carry to left justify
       jmp   SHORT Start      ; Jump into routine


; StrJR - Right justifies a string in a field.
; function StrJR (S: string; Field: byte): string;

StrJR        PROC FAR
       stc                    ; Set carry to right justify
Start: push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       lahf                   ; Save carry flag
       les   di,Result        ; Point to function string
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Load S[0] in AL
       mov   cl,al            ; Save length in CL
       xor   ch,ch            ; Zero extend CL
       mov   al,Field         ; Get proposed FIELD length
       mov   bl,al            ; Copy FIELD in BL
       sub   bl,cl            ; Length>FIELD?
       ja    Fits             ;   no, add spaces
       mov   al,cl            ;   yes, string length in AL
       mov   bl,ch            ; Set spaces to zero
Fits:  stosb                  ; Set result length
       mov   al,Space         ; Set AL to space
       sahf                   ; Left or Right?
       jc    SR1              ;   Jump if Right
; -- Do Left justification --
       call  RepMovsB         ; Do fast move of bytes
       mov   cl,bl            ; Set space count
       call  RepStosB         ; Fast fill out spaces
       jmp   SHORT Exit
; -- Do Right justification --
SR1:   xchg  cl,bl            ; Set space count
       call  RepStosB         ; Fast fill out spaces
       mov   cl,bl            ; Set string count
       call  RepMovsB         ; Do fast move of bytes
Exit:  mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   6                ; Clear all parameters
StrJR        ENDP
StrJL        ENDP

CODE   ENDS

       END
