PAGE  80,132
TITLE STRFILL  String Fill Procedure, Ver 6.20

; STRFILL.ASM - StrFill
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine quickly fills a string with duplicate copies of a substring
; appended together and the length appropriately adjusted.
; As in all fill-type procedures, make sure your destination is large enough.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrFill
        EXTRN   RepMovsB: NEAR, RepStosB: NEAR

S            EQU     DWORD PTR [bp+14]
Fill         EQU     DWORD PTR [bp+10]
Count        EQU     BYTE  PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]

; StrFill - Fills a string with duplicate substrings.
; procedure StrFill (VAR S: string; Fill: string; Count,MaxLen: byte);

StrFill      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       les   di,S             ; Point to S
; -- Check Count>0 --
       xor   ax,ax            ; Zero extend AL
       add   al,Count         ; Get Count, Count=0?
       jz    Null             ;   yes, null string
       mov   bx,ax            ; Save in BX
; -- Check Fill length --
       lds   si,Fill          ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Get length  (SI+1)
       mov   cx,ax            ; Save in CX
       jcxz  Null             ; Quit if null string
; -- Get MaxLen --
       mov   al,MaxLen        ; Get MaxLen
       cmp   cl,1             ; A single character?
       je    ChrF             ;   yes, special case
; -- Save Fill parameters --
       mov   bh,cl            ; Save Fill[0]
       mov   dx,di            ; Save offset
       inc   di               ; Point to S[1]
       add   ax,di            ; Last offset
       sub   ax,cx            ; AX=offset of last full fill
; -- Loop the fill --
       EVEN                   ; Align for speed
L1:    cmp   ax,di            ; Last full fill?
       jb    trunc            ;   yes, truncate last fill
       call  RepMovsB         ; Do fast move of bytes
       mov   cl,bh            ; Reset counter
       sub   si,cx            ; Reset offset to Fill[1]
       dec   bl               ; Decrement dupes
       jnz   L1               ; Loop if more
; -- Set length --
Leng:  mov   ax,di            ; Set current offset
       sub   ax,dx            ; Length + 1
       dec   ax               ; Length
       mov   di,dx            ; Set to S[0]
Null:  stosb                  ; Save length
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   12               ; Clear all parameters

; -- Truncate last fill --
Trunc: add   cx,ax            ; Calc max count ...
       sub   cx,di            ;   remaining
       call  RepMovsB         ; Do fast move of bytes
       jmp   SHORT Leng       ; Finish routine

; -- Special one-character fill --
ChrF:  xchg  ax,bx            ; Place Count in AX
       cmp   al,bl            ; Count>MaxLen?
       ja    L2               ;   yes, MaxLen is shorter
       mov   bl,al            ; Copy Count to BL
L2:    mov   cx,bx            ; Move count back in CX
       mov   ax,cx            ;   and also AX
       stosb                  ; Save length
       lodsb                  ; Get Char
       call  RepStosB         ; Do fast fill of bytes
       jmp   SHORT Exit       ; All done

StrFill      ENDP

CODE   ENDS

       END
