PAGE  80,132
TITLE STRCPY  String Copy Procedure, Ver 6.20

; STRCPY.ASM - StrCpy
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine replaces Pascal's slow Copy routine by making it a procedure
; in lieu of a function.  It's up to 4 times faster.
; As in all move-type procedures, make sure your destination is large enough.
; The Source and Dest strings can be the same address.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrCpy
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+12]
S            EQU     DWORD PTR SS:[bx+8]
Index        EQU     BYTE  PTR SS:[bx+6]
Count        EQU     BYTE  PTR SS:[bx+4]

; StrCpy - Copies an array of characters in a string.
; procedure StrCpy (VAR Dest: string; S: string; Index,Count: byte);

; Quit if:
;   Count=0
;   Length=0
;   Index>Length

StrCpy       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Check S length --
       lds   si,S             ; Point to source string
       les   di,Dest          ; Point to Dest
       cld                    ; Set DF to increment
       lodsb                  ; Get length  (SI+1)
       xor   ah,ah            ; Zero extend AL
       mov   cx,ax            ; Save in CX
       jcxz  Exit4            ; Quit if null string
; -- Check Index>Length --
       mov   al,Index         ; Get index
       cmp   ah,al            ; indeX>0?
       sbb   al,ah            ;   yes, decrement
       sub   cx,ax            ; Index>Length?  (CX=Trailing length)
       jle   Exit3            ;   yes, null string
       add   si,ax            ; Source offset
; -- Check Count>0 --
       mov   al,Count         ; Get Count
       cmp   ax,cx            ; Count>=Trailing>?
       jge   Exit1            ;   yes, use trailing count
       xchg  ax,cx            ;   no, use Count
; -- Append trailing chars --
Exit1: mov   ax,cx            ; Copy count to AX
       stosb                  ; Save count
       call  RepMovsB         ; Do fast move of bytes
Exit2: mov   ds,dx            ; Restore Pascal's DS
       ret   12               ; Clear all parameters

Exit3: mov   al,ah            ; Set AL zero
Exit4: stosb                  ; Save count
       jmp   SHORT Exit2      ; Finish routine

StrCpy       ENDP

CODE   ENDS

       END
