PAGE  80,132
TITLE STRASC  ASCIIZ to String Routine, Ver 6.20

; STRASC.ASM - StrAsc
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts ASCIIZ strings to Pascal type strings.


DATA    SEGMENT WORD PUBLIC
        EXTRN   AscSrcPtr: WORD
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE, DS:DATA
        PUBLIC  StrAsc
        EXTRN   RepMovsBRev: NEAR

Dest         EQU     DWORD PTR [bp+12]
AscSrc       EQU     DWORD PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]


; StrAsc - Converts ASCIIZ string to Pascal string.  Source and destination
; can be the same.  Important: As all C programmers are aware, it is up to you
; to make sure the destination size is sufficient to fit the source.
; AscSrcPtr is great for sequential processing.  After StrAsc is executed,
; AscSrcPtr is set to the next source char or after the #00.

; procedure StrAsc (VAR Dest: string; VAR AscSrc);

StrAsc       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Scan for ASCIIZ null --
       les   di,AscSrc        ; Point to source AsciiZ string
       xor   ax,ax            ; Set AX=0 (AL=#00)
       mov   bx,ax            ; Set BX=0
       mov   bl,MaxLen        ; Set BL to MaxLen
       inc   bx               ; Scan past #00
       mov   cx,bx            ; Copy to CX
       cld                    ; Set DF to increment
       repne scasb            ; Search for null
; -- Point NextAsc after #00 or at next char --
       mov   si,di            ; Move to source
       sbb   di,ax            ; Decrement if not #00
       mov   AscSrcPtr,di     ; Save Ofs of next ASCIIZ pointer
; -- Calc char length --
       sub   bx,cx            ; Chars scanned
       dec   bx               ; String length
       mov   cx,bx            ; Set count
; -- Point to last ASCIIZ char --
       dec   si               ; Point to null
       dec   si               ; Point to last char
       mov   ax,es            ; Get seg
       mov   AscSrcPtr+2,ax   ; Save Seg of Next ASCIIZ pointer
       mov   ds,ax            ; Set source seg
; -- Point to last S char --
       les   di,Dest          ; Point to dest Pascal string
       add   di,bx            ; Offset to last char
       std                    ; Set DF to decrement
       call  RepMovsBRev      ; Do fast move of bytes in reverse
       xchg  ax,bx            ; Put string length in AL
       stosb                  ; Save length
       mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrAsc       ENDP

CODE   ENDS

       END
