PAGE  80,132
TITLE REPCMPSB  Fast Compare Algorithm for bytes, Ver 6.20

; REPCMPSB.ASM - RepCmpsB
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Algorithm compares bytes by a word at a time.  Self-aligning for
; alignment sensitive computers like the 8088, 8086, and 80386.
; Routine is good for a full segment.
; Uses 52 bytes.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  RepCmpsB

; RepCmpsB - compares and array of bytes by the fastest possible method.
; Used as a local routine for other STRS routines.  Assumes:
;   - Source and Dest are loaded
;   - CX has the byte count
;   - DF is set to increment
;   - !! AL is destroyed in process !!

RepCmpsB     PROC NEAR
       cmp   cx,10            ; At least 10 bytes?
       jae   Wrds             ;  yes,  words
       repe  cmpsb            ; Compare bytes
       ret                    ; Return to call
; -- To speed up comparisons at least line up the DI offset --
       EVEN                   ; Align for speed
Wrds:  test  di,1             ; DI even?
       jz    Evn              ;   yes, start with words
       dec   cx               ; Decrement the count
       cmpsb                  ;   no, compare odd byte
       jne   Exit             ; Exit if not equal
; -- Now compare by words --
       EVEN                   ; Align for speed
Evn:   xor   al,al            ; Set AL=0
       shr   cx,1             ; Bytes -> Words
       rcl   al,1             ; Save odd count
       repe  cmpsw            ; Compare contents by words
       jne   ReCmp            ; Test again if not equal
       mov   cl,al            ; Check for odd-byte
       rep   cmpsb            ; Compare remaining byte
Exit:  ret                    ; Return to call
; -- Find out which byte is not equal --
       EVEN                   ; Align for speed
ReCmp: inc   cx               ; Back up a word
       rcr   al,1             ; Test for odd-byte
       rcl   cx,1             ; Words -> Bytes (plus odd-byte)
       sub   di,2             ; Back up a word
       sub   si,2             ; Back up a word
       repe  cmpsb            ; Compare again
       ret                    ; Return to call
RepCmpsB     ENDP

CODE   ENDS

       END
