PAGE  80,132
TITLE CHRPOSL Position of Nth Char Routine, Ver 6.20

; CHRPOSL.ASM - ChrPosL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of Nth occurrence of a given character
; starting from the LEFT.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPosL

S            EQU     DWORD PTR ss:[bx+8]
Find         EQU     BYTE  PTR ss:[bx+6]
Nth          EQU     BYTE  PTR ss:[bx+4]

; ChrPosL - Position of Nth occurrence of Find.
; function ChrPosL (S: string; Find: char; Nth: byte): byte;

ChrPosL      PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Get and evaluate Nth --
       xor   dx,dx            ; Set DX=0
       mov   cx,dx            ; Set CX=0
       add   dl,Nth           ; Get count and test
       jz    Done             ; Exit if no count
; -- Get and evaluate string length --
       les   di,S             ; Point to dest string
       add   cl,es:[di]       ; Get length and test
       jz    Done             ; Exit if no count
       mov   al,Find          ; Get Find to scan
       inc   di               ; Start at S[1]
       mov   si,di            ; Save initial offset
       cld                    ; Set DF to increment
; -- Scan for Find --
       EVEN                   ; Align for speed
L1:    repne scasb            ; Scan
       jne   Done             ; Not found
       dec   dx               ; Adjust count
       jnz   L1               ; Loop if not finished
       mov   cx,di            ; Get final offset
       sub   cx,si            ; Calc position
Done:  xchg  ax,cx            ; Place result in AX
       ret   8                ; Clear all parameters
ChrPosL      ENDP

CODE   ENDS

       END
