PAGE  80,132
TITLE CHRPADL  String Pad Left Routine, Ver 6.20

; CHRPADL.ASM - ChrPadL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine pads characters on the LEFT  to fill out a field.
; If the field is smaller than the orginal string, the string is unaltered.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPadL
        EXTRN   RepStosBRev: NEAR
        EXTRN   RepMovsBRev: NEAR

S            EQU     DWORD PTR [bp+10]
Fill         EQU     BYTE  PTR [bp+8]
Field        EQU     BYTE  PTR [bp+6]

; ChrPadL - Pad a string on the LEFT to fill the field.
; procedure ChrPadL (S: string; Fill: char; Field: byte);

ChrPadL      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get S --
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; Point to source string
       mov   al,[si]          ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       mov   bx,ds            ; Move DS into ...
       mov   es,bx            ;  ... ES
; -- Compare Field and length --
       mov   al,Field         ; Get proposed FIELD length
       mov   bx,ax            ; Copy FIELD in CX
       sub   bx,cx            ; Length>=FIELD?
       jbe   Exit             ;   yes, no padding possible
; -- Save new length --
       std                    ; Set DF to decrement
       mov   [si],al          ; Set new length
; -- Shift string --
       mov   di,si            ; At S[0]
       add   si,cx            ; At S[L]
       add   di,ax            ; At S[NewLen]
       call  RepMovsBRev      ; Do fast move of bytes
; -- Pad leading chars --
       mov   al,Fill          ; Set AL to padding char
       mov   cl,bl            ; Set string count
       call  RepStosBRev      ; Fast fill of leading chars
Exit:  mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   8                ; Clear all parameters
ChrPadL      ENDP

CODE   ENDS

       END
