PAGE  80,132
TITLE ChrOvr  String Overwrite Routine, Ver 6.20

; ChrOvr.ASM - ChrOvr
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This procedure overwrites a string at a given index filling it with
; repeated characters
;   . The length is adjusted if the fill would make it longer.
;   . Any gap between the two strings is filled with spaces.
; This procedure is used to "blank-out" portions of a string.
; Caution: Just like Move and FillChar, this procedure does not check
; for end of string termination for the destination variable.  However,
; resulting strings are truncated at 255.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrOvr
        EXTRN   RepStosBRev: NEAR

S            EQU     DWORD PTR [bp+10]
Fill         EQU     BYTE  PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]
Count        EQU     BYTE  PTR [bp+4]
Space        EQU     ' '

; ChrOvr - Overwrites the contents of a string at a given index with a
; repeated character fill.  It also extends the length if needed and
; fills any gap with spaces.
; procedure ChrOvr (VAR S: string; Fill: char; Index,Count: byte);

ChrOvr       PROC FAR
       mov   bx,bp            ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
; -- Test Fill count --
       xor   ax,ax            ; Set AX=0
       mov   al,Count         ; Get proposed Count length
       mov   cx,ax            ; Set CX=Count
       jcxz  Exit             ; Quit if no count
; -- Get string length --
       les   di,S             ; Point to original string
       mov   al,es:[di]       ; Get length
       mov   dh,al            ; Save in DH
; -- Get index --
       mov   al,Index         ; Get index
       cmp   ah,al            ; indeX>0?
       sbb   al,ah            ;   yes, decrement for 0-based Index
       mov   dl,al            ; Copy Index0 to DL
; -- Check new length --
       add   al,cl            ; New length>255?
       jc    Cut              ;   yes, have to truncate fill
; -- Test if NewLength > OrigLength --
       cmp   al,dh            ; NewLength > OrigLength?
       jb    @@1              ;   no, don't modify
Save:  mov   es:[di],al       ;   yes, set new length
@@1:   std                    ; Set DF to decrement
       add   di,ax            ; Point to EoFill
       mov   al,Fill          ; Get fill char
       call  RepStosBRev      ; Fast fill of chars in reverse
; -- Test for gap --
OK:    sub   dl,dh            ; Index0>OrigLength?
       ja    Spcs             ;   yes, then fill with spaces
; -- Fill with spaces --
Exit:  mov   bp,bx            ; Restore Pascal's BP
       ret   10               ; Clear all parameters

Cut:   sub   cx,ax            ; reduce fill length
       dec   cx               ; 0-based
       mov   al,255           ; Set to Max length
       jmp   SHORT Save       ;

Spcs:  mov   cl,dl            ; Set space count
       mov   al,Space         ; Set to space char
       call  RepStosBRev      ; Fast fill of spaces in reverse
       jmp   SHORT Exit       ;

ChrOvr       ENDP

CODE   ENDS

       END
