{
 $Id$
}

   { 20/5/96   line 324, 'if file_size = 0' statement added }


 {*****************************************************************************
 *
 * Purpose:  scan and forward files
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


Unit Fm_Scan;

{$X+,V-}

Interface

Uses
  Dos, Crosslib, S_string, F_file,
  Nw_tpl, Nw_msg,
  fm_hex, fm_struct, fm_basic, fm_proc, fm_log, fm_rear, fm_exec,
  fm_proc2, fm_init;

Procedure Scan;

Implementation

Procedure Scan;
Const
  MASK     = '????????.';
Var
  securetel : word;
  securewor : word;
  { for packing }
  SR         : SearchRec;
  TMP        : File;
  { for unpacking }
  Currentdir : Pathstr;
  Packer     : ArchiverType;
  Error      : Word;
  match      : boolean;
Begin
  WriteLogCR(6,'SCAN');
  Getdir(0,currentdir);
  match := false;

  if exist(systempath+'import.xyz') then delete_file(systempath+'import.xyz');

  if strip('B',' ',setup.securepath) = '' then
    securewor := 1 else securewor := 2;

  for securetel := 1 to securewor do
    begin

      case securetel of
        1 : begin
              NotifyCr(8,'Scanning inbound path...');
            end;
        2 : begin
              NotifyCr(8,'Scanning secure inbound path...');
              Setup.inboundpath := setup.securepath;
            end;
      end;

      { unpack tickpack files }
      FindFirst (SETUP.InboundPath + '????????.YY?', $0, SR);
      While DOSerror = 0 do
        begin
          if UnpackTPbundle (SR.Name) then
            begin
              If not Delete_File(setup.inboundpath+sr.name) then
                NotifyCr(2,'Cannot delete '+setup.inboundpath+sr.name);
              match := true;
            end;
          FindNext (SR);
        end;

      { unpack TIZzer bundle }
      FindFirst (SETUP.InboundPath + '????????.TZ?', $0, SR);
      While DOSerror = 0 do
        Begin
          NotifyCR (8,'Unpacking TIZ bundle '+ SETUP.InBoundPath + SR.Name);
          If UnPackArc (setup.inboundpath+sr.name,true) then
            Begin { move to inbound }
              Getdir(0,currentdir);
              MoveToInBound(setup.temppath+unpackdir);
              chdir(currentdir);
              RemoveUnPackDir;
              match := true;
            End;
          FindNext(Sr);
        End;

      { unpack packed files, if there are }
      For Error := 0 to 16 do
        Begin
          For Packer := ZIP to DWC do
            Begin
              If Error = 16 then
                FindFirst (SETUP.InBoundPath + Mask + ArcExt[Packer], $0, SR) Else
                  FindFirst(Setup.inboundpath + Mask + first(1,arcExt[Packer])+strhex(error,1)+'c', $0, SR);
              While DosError = 0 do
                Begin
                  If file_size(setup.inboundpath+sr.name) <> 0 then
                    begin
                      NotifyCR (8,'Unpacking '+ SETUP.InBoundPath + SR.Name);
                      If UnPackArc (setup.inboundpath+sr.name,true) then
                        Begin { move to inbound }
                          Chdir(setup.temppath+unpackdir);
                          MoveToInBound('');
                          Chdir(currentdir);
                          RemoveUnPackDir;
                          match := true;
                        End;
                    end else
                      notifycr(2,'Zero byte package '+sr.name+' -> skipping');

                  FindNext(Sr);
                End;
            End;
        End;

      if match then notifycr(12,'');

      Check_The_Exceptions;

      { let's go. There might be some old forward info. }
      Assign (PF, SystemPath + 'PROCESS.FM');
      {$I-} Reset (PF); {$I+}
      if IOresult = 0 then
        begin

          Assign(Pfnew,systempath+'PROCESS.NEW');
          {$I-} reset(pfnew); {$I+}
          If ioresult <> 0 then rewrite(pfnew);
          Seek(pfnew,filesize(pfnew));

          While not EOF(PF) do
            begin
              Read (PF, INFO);

              If Date_Past (datestring(info.forwar)) then
                Begin
                  WriteSetupCfg;
                  ProcessFile;
                  if not (local in info.status) then
                    Begin
                      check_copy_exception;
                      copy_to_bad_dir_or_delete_tick(sr.name);
                    End;
                End Else
                  Write(pfnew,info);
            end;
          Close (PF);
          Erase (Pf);
          Close (Pfnew);
          Rename(pfnew,systempath+'PROCESS.FM');
          If file_size(systempath+'PROCESS.FM') = 0 then delete_file(systempath+'PROCESS.FM');
        end;

      { now process each TIC }
      Assign(Pf,systempath+'PROCESS.FM');
      {$I-} reset(pf); {$I+}
      If ioresult <> 0 then rewrite(pf);
      Seek(pf,filesize(pf));

      FindFirst (SETUP.InboundPath+'*.TIC', AnyFile, SR);
      While DosError = 0 do
        Begin
          if checkdiskspace and readtick(sr) then
            begin
              writesetupcfg;
              Inc (tFiles);

              match := exceptionMatch ( info.filespec, ex_delete, info.tag );
              If match then
                Begin
                  notifyCR (8,'Deleting '+info.filespec);
                  If not Delete_File(setup.inboundpath+info.filespec) then
                    NotifyCr(2,'Cannot delete '+setup.inboundpath+info.filespec);
                  If not delete_file(setup.inboundpath+sr.name) then
                    Notifycr(2,'Cannot delete '+setup.inboundpath+sr.name);
                End Else
                Begin
                  If Date_Past (datestring(info.forwar)) then
                    Begin
                      ProcessFile;    {fm_proc  }
                      check_copy_exception;
                      copy_to_bad_dir_or_delete_tick(sr.name);
                    End Else Write(pf,info);
                End;
            End;
          FindNext(SR);
        End;

      Close (Pf);
      If file_size(systempath+'PROCESS.FM') = 0 then delete_file(systempath+'PROCESS.FM');

      Check_adopt_exception;
    End;

  Trim_History;
  If exist(systempath+'FMSYSTMP.#$') then sendsysopmsg('FileMgr notification');

End;

End.

