{
 $Id$
}
{*****************************************************************************
 *
 * Purpose:  Pack / unpack archives for messages etc
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Rear;  {$O+,X+,V-}

Interface

Uses Dos, Compsys, CrossLib, F_File, S_String,
     Fm_Struct, Fm_Exec, Fm_Log, fm_basic;

{---------------------------------------------------------------------------}

Const
  Unpackdir = 'FMUNP';

Function  CreateTmp : Boolean;
Procedure RemoveUnPackDir;                          {verwijder de unpack dir}
Procedure EmptyUnPackDir(dir:string); {verwijder alle files in de unpack dir}
Procedure MoveToInBound(path:string);     {move alle files uit de unpack dir}

Function  UnPackArc (bundle : string; deletebundle : boolean) : boolean;
Function  PackArc (packlist:string; archivename:string; usearchiver:archivertype;pathsinarchive:boolean) : boolean;

{---------------------------------------------------------------------------}

Implementation


Function  PackArc (packlist:string; archivename:string; usearchiver:archivertype;pathsinarchive:boolean) : boolean;
Var
  Valcode : integer;
  CmdLine,
  CmdProg : String;
  T       : text;
  tmp,tmp1 : string;

  Procedure WriteDirInfo(dir:string);
  Var DirInfo : SearchRec;
      tmp : string;
  Begin
    FindFirst('*.*',archive+directory,dirinfo);
    While doserror = 0 do
      Begin

        if (dirinfo.Attr and Directory <> 0) and (dirinfo.name <> '.') and (dirinfo.name <> '..') then
        Begin
          {$I-} chdir(dirinfo.name); {$I+}
          if ioresult = 0 then
            begin
              writedirinfo(dir+'\'+dirinfo.name);       {recursive!}
              {$I-} chdir('..'); {$I+}
              If ioresult <> 0 then {};
            end;
        End;

        if (dirinfo.attr and directory = 0) and (dirinfo.name <> '.') and (dirinfo.name <> '..') then
          begin
            if dir = '' then writeln(t,dirinfo.name) else
              begin
                tmp := dir+'\'+DirInfo.Name;
                if first(1,tmp) = '\' then tmp := last(length(tmp)-1,tmp);
                writeln(t,tmp);
              end;
          end;
        Findnext(dirinfo);
      End;
  End;


Begin
  if packlist = '' then
    begin
      packlist := 'FM$$PACK.RH';
      assign(t,systempath+'FM$$PACK.RH');
      {$I-} rewrite(t); {$I+}
      If ioresult <> 0 then
        begin
          packarc := false;
          exit;
        end;
      Writedirinfo('');
      Close(t);
    end else
    begin
      assign(t,packlist);
    end;



  case usearchiver of
    ZIP : CmdProg := SETUP.PackerName[1];
    ARJ : CmdProg := SETUP.PackerName[2];
    LZH : CmdProg := SETUP.PackerName[3];
    ARC : CmdProg := SETUP.PackerName[4];
    PAK : CmdProg := SETUP.PackerName[5];
    ZOO : CmdProg := SETUP.PackerName[6];
    SQZ : CmdProg := SETUP.PackerName[7];
    RAR : CmdProg := SETUP.PackerName[8];
    HYP : CmdProg := SETUP.PackerName[9];
    DWC : CmdProg := SETUP.PackerName[10];
  end;

  case usearchiver of
    ZIP : CmdLine := SETUP.Packswitch[1];
    ARJ : CmdLine := SETUP.Packswitch[2];
    LZH : CmdLine := SETUP.Packswitch[3];
    ARC : CmdLine := SETUP.Packswitch[4];
    PAK : CmdLine := SETUP.Packswitch[5];
    ZOO : CmdLine := SETUP.Packswitch[6];
    SQZ : CmdLine := SETUP.Packswitch[7];
    RAR : CmdLine := SETUP.Packswitch[8];
    HYP : CmdLine := SETUP.Packswitch[9];
    DWC : CmdLine := SETUP.Packswitch[10];
  end;

  if (pos('-P',upper(cmdline)) <> 0) and not pathsinarchive then
   begin
    {-p eruit halen}
      if pos('-P',upper(cmdline)) <> 1 then
        tmp1 := first( pos('-P',upper(cmdline))-1 ,cmdline) else tmp1 := '';
      if pos('-P',upper(cmdline)) <> (length(cmdline)-1) then
        tmp := last(length(cmdline)-(pos('-P',upper(cmdline))+1),cmdline) else tmp := '';
      cmdline := tmp1 + tmp;
   end;

  if pos('%1',cmdline) <> 0 then
    begin
      if pos('%1',cmdline) <> 1 then
        tmp1 := first( pos('%1',cmdline)-1 ,cmdline) else tmp1 := '';
      if pos('%1',cmdline) <> (length(cmdline)-1) then
        tmp := last(length(cmdline)-(pos('%1',cmdline)+1),cmdline) else tmp := '';
      cmdline := tmp1 + archivename + tmp;
    end;
{  StrRepl (CmdLine, '%1', archivename, 1, 1, 255); }

  if pos('%2',cmdline) <> 0 then
    begin
      if pos('%2',cmdline) <> 1 then
        tmp1 := first( pos('%2',cmdline)-1 ,cmdline) else tmp1 := '';
      if pos('%2',cmdline) <> (length(cmdline)-1) then
        tmp := last(length(cmdline)-(pos('%2',cmdline)+1),cmdline) else tmp := '';
      cmdline := tmp1 + systempath+packlist + tmp;
    end;
{  StrRepl (CmdLine, '%2', systempath+packlist, 1, 1, 255); }

  if not SETUP.ShowPack then CmdLine := CmdLine + ' >NUL';
  valcode := fmexec (CmdProg,' '+CmdLine,setup.swapmethode, $4F00, false, setup.showswapping);

  if valcode = 0 then erase(t);

  filemode := 66;

  if ValCode = 0 then
    PackArc := True else
      PackArc := False;
End;




Procedure RemoveUnPackDir;
Var
  CurrentPath : PathStr;
  Tmp         : String;

  procedure doitnow;
  var dr : searchrec;
  Begin
    Findfirst('*.*',directory,dr);
    While doserror = 0 do
     Begin
       If (dr.Attr and Directory <> 0) and (dr.name <> '.') and (dr.name <> '..') then
         Begin
           {$I-} chdir(dr.name); {$I+}
           if ioresult = 0 then
             Begin
               doitnow; {recursive}
               {$I-} chdir('..');
               rmdir(dr.name); {$I+}
               If ioresult <> 0 then {};
             End;
        End;
       findnext(dr);
     End;
  End;

Begin
  tmp := setup.temppath;
  if last(1,tmp) = '\' then tmp := first(length(tmp)-1,tmp);

  GetDir (0, CurrentPath);
  if tmp <> '' then Chdir(tmp);

  {$i-} Rmdir (unpackdir); {$i+}
  If Ioresult <> 0 then
     begin {recursive}
       {$I-} chdir(unpackdir); {$I+}
       if ioresult = 0 then {hij bestaat}
         doitnow;
       chdir('..');
       {$I-} rmdir(unpackdir); {$I+}
       if ioresult <> 0 then {};
     end;                  {is ie er uberhaupt wel ?! :-)}
  ChDir (CurrentPath);
End;


Procedure EmptyUnPackDir(dir:string);
Var
  Sr : SearchRec;
  Tmp : File;
Begin

  FindFirst(dir+'\*.*',archive+directory,sr);
  While doserror = 0 do
    begin

      if (sr.Attr and Directory <> 0) and (sr.name <> '.') and (sr.name <> '..') then
        Begin
          {$I-} chdir(dir+'\'+sr.name); {$I+}
          if ioresult = 0 then
            begin
              emptyunpackdir(dir+'\'+sr.name);       {recursive!}
              {$I-} chdir(dir);
              rmdir(dir+'\'+sr.name); {$I+}
              If ioresult <> 0 then {};
            end;
        End;

      if (sr.attr and directory = 0) and (sr.name <> '.') and (sr.name <> '..') then
        Begin
          Assign(Tmp,dir+'\'+sr.name);
          {$I-} Erase(Tmp); {$I+}
          If ioresult <> 0 then
            begin {erase attribute and try again}
              {$I-} SetFAttr(Tmp, $00);
              Erase(Tmp); {$I+}
              If ioresult <> 0 then
                notify(2,'Cannot delete '+dir+'\'+sr.name);
            end;
        End;
      Findnext(sr);
    End;
End;


Procedure MoveToInBound(path:string);
Var
  Dr  : SearchRec;
  Tmp : File;
  Io  : Word;
Begin
  If path <> '' then chdir(path);

  Findfirst ('*.*', archive+directory, dr);
  while doserror=0 do
    Begin

      If (dr.Attr and Directory <> 0) and (dr.name <> '.') and (dr.name <> '..') then
        Begin
          {$I-} chdir(dr.name); {$I+}
          if ioresult = 0 then
            begin
              movetoinbound('');       {recursive!}
              {$I-} chdir('..'); {$I+}
              If ioresult <> 0 then {};
            end;
        End;

      If (dr.attr and directory = 0) and (dr.name <> '.') and (dr.name <> '..') then
        Begin
          assign (tmp, dr.name);
          {$i-} rename (tmp, setup.inboundpath + dr.name); {$i+}
          io := ioresult;
          If io > 0 then    {als niet gerenamed kan worden}
            Begin           {dan maar gewoon copieren}
              If copy_file ('', dr.name, dr.name, setup.inboundpath, false) then
                Begin
                  assign (tmp, dr.name);
                  {$i-} erase (tmp); {$i+}
                  if ioresult <> 0 then NotifyCR(2,'Unable to erase '+setup.temppath+unpackdir+'\'+dr.name);
                End Else
                  notifyCR (2,'Unable to move '+dr.name+' to inboundpath');
            End;
        End;

      findnext (dr);
    End;
End;

Function createTmp : Boolean;
var tmp : string;
    io  : word;
Begin
  tmp := setup.temppath;
  if (last(1,tmp) = '\') and (length(tmp) > 3) then
     tmp := first(length(tmp)-1,tmp);

  if tmp <> '' then
    begin
      {$I-} chdir(tmp); {$I+}
      If ioresult <> 0 then
        Begin
          Notifycr (2,'');
          notifyCR (2,'Cannot change directory to '+tmp+' ?!');
          setup.temppath := '';
        End;
    End;

  {$i-} mkdir (unpackdir);
  chdir(unpackdir); {$i+}
  io := ioresult;
  If (io = 0) or (io = 5) then
    Begin
      If io = 5 then
        Begin
          EmptyUnpackDir(setup.temppath+unpackdir);
        End;
      CreateTmp := True;
    End Else
      CreateTmp := False;
End;

Function UnPackArc (bundle : string; deletebundle:boolean) : boolean;
Var
{  io      : word; }
  cmdline : string;
  cmdprog : filename;
  error   : integer;
  t       : word;
  arci    : archivertype;
  CO      : CompressorType;
  currentdir : pathstr;
  tmp     : string;
  tm1, tm2 : string;
Begin
  Unpackarc := False;
  getdir(0,currentdir);

  if createtmp then
    begin
      UnPackArc := True;

      If DetectCompressor(extractwords(1,1,bundle),CO) then   { Find the compressor used }
        Begin
          CO^.CheckProtection;                  { Grab the info }
          filemode := 66;

          Tmp := CO^.WhichType;
          If Tmp = 'ARC' then Arci := ARC else
          If Tmp = 'PAK' then Arci := PAK else
          If Tmp = 'ARJ' then Arci := ARJ else
          If Tmp = 'DWC' then Arci := DWC else
          If Tmp = 'HYP' then Arci := HYP else
          If Tmp = 'LHA' then Arci := LZH else
          If Tmp = 'ZIP2' then Arci := ZIP else
          If Tmp = 'ZIP1' then Arci := ZIP else
          If Tmp = 'RAR' then Arci := RAR else
          If Tmp = 'SQZ' then Arci := SQZ else
          If Tmp = 'ZOO' then Arci := ZOO else
            Arci := All;
        End Else
          Arci := All;

      case arci of
       zip : t := 1;
       arj : t := 2;
       lzh : t := 3;
       arc : t := 4;
       pak : t := 5;
       zoo : t := 6;
       sqz : t := 7;
       rar : t := 8;
       hyp : t := 9;
       dwc : t := 10;
       else t := 11;
     end;

      if (arci = all) and (setup.packername[11] = '') then
        begin
          Notifycr (1,'');
          notifycr(1,'General unpacker program slot is empty!');
          unpackarc := false;
        end else
        begin

          If ((SETUP.PackerName[11] <> '') and (Arci = All)) or
             (strip('B',' ',setup.unpackername[t]) = '') then
            Begin
              CmdLine := SETUP.PackerName[11];
              if Pos('%1',CmdLine) > 0 then
                begin
                  if pos('%1',cmdline) <> 1 then
                    tm1 := first( pos('%1',cmdline)-1 ,cmdline) else tm1 := '';
                  if pos('%1',cmdline) <> (length(cmdline)-1) then
                    tm2 := last(length(cmdline)-(pos('%1',cmdline)+1),cmdline) else tm2 := '';
                  cmdline := tm1 + bundle + tm2;
{                  StrRepl (CmdLine, '%1', bundle, 1, 1, 255) }
                end else CmdLine := CmdLine + ' ' + bundle;
              cmdprog := extractwords(1,1,CmdLine);
              cmdline := extractwords(2,wordcnt(cmdline)-1,cmdline);
            End Else
            Begin
              cmdprog := setup.unpackername[t];
              cmdline := setup.unpackswitch[t];
              if Pos('%1',CmdLine) > 0 then
                begin
                  if pos('%1',cmdline) <> 1 then
                    tm1 := first( pos('%1',cmdline)-1 ,cmdline) else tm1 := '';
                  if pos('%1',cmdline) <> (length(cmdline)-1) then
                    tm2 := last(length(cmdline)-(pos('%1',cmdline)+1),cmdline) else tm2 := '';
                  cmdline := tm1 + bundle + tm2;

                  { StrRepl (CmdLine, '%1', bundle, 1, 1, 255) }
                end else CmdLine := CmdLine + ' ' + bundle;
            End;

          if not SETUP.ShowunPack then CmdLine := CmdLine + ' > NUL';

          if (strip('B',' ',setup.unpackswitch[t]) <> '') or (t = 11) then
            Begin

              Error := fmExec (CmdProg, CmdLine,setup.swapmethode, $3200, false, setup.showswapping);

              If Error <> 0 then
                Begin
                  If setup.showunpack then NotifyCR(2,'') else writelogcr(2,'');
                  If Error > 255
                    then NotifyCR (2,ExecError(Error)+' ('+int_to_str(Error)+')')
                      else NotifyCR (2,'(unpacker error '+int_to_str(Error)+')');

                  unpackarc := false;
                  emptyunpackdir(setup.temppath+unpackdir);
                End Else
                Begin
                  If DeleteBundle then
                    Begin
                      If not delete_file(bundle) then
                        Begin
                          Notifycr (1,'');
                          notifyCR (1,'Error removing '+bundle+': removing files to avoid dupes.');
                          emptyunpackdir(setup.temppath+unpackdir);
                        End;
                    End;
                End;
            End Else
            Begin
              Notifycr (1,'');
              Notifycr(1,'Unpacker switches slot for archive '+tmp+' is empty!');
              unpackarc := false;
            end;
        End;
    End Else
    Begin
      Notifycr (1,'');
      NotifyCR (1,'Error creating tmp path '+setup.temppath+unpackdir);
      unpackarc := false;
    End;
  Chdir(currentdir);
End;



End.
