{
 $Id$
}
{*****************************************************************************
 *
 * Purpose:   Date handling need to check for y2k compliance etc .
 *            Contains system calls for dos and assembler
 * vbc - 150208 - changed line 227 from year 1900 to 2000 in function date_past
 *                and in line 425 in function datestring
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit CrossLib;

{$O+}

Interface

USES
  Crt, Dos, Fm_Struct, FM_Log, S_String;

CONST
  SecsSince1970 = 662688000; (* Seconds from 1/1/70 to 12/31/90 *)
  SecsInAYear = 31536000;  (* Seconds in a year *)
  LeapYears : Array[1..10] of Integer = (1992,1996,2000,2004,2008,2012,2016,2020,2024,2028);
  SecsInADay = 86400;  (* Number of seconds in a day. NOTE Leap Second is not counted *)
  DaysInMonths : Array[1..12] of Integer= (31,28,31,30,31,30,31,31,30,31,30,31);
  Extra        : Array[False..True] of Byte = (0,1);
  SecsInAnHour = 3600;


Function  GetUnixDate (DT : DateTime) : LongInt;
Procedure GetDosDate (Secs : Longint; VAR DT : DateTime); { f & s gen}
Function  DateString (D : LongInt) : String; { f & s cross}
Function  IsLeapYear(Year : Integer) : Boolean;
Function  Daynumber : string;
Function  Date_Past (D:string) : Boolean;

Function  Node2Str (N : NodeType) : String;
Procedure Str2Node (S : String; VAR N : NodeType; D : Nodetype; VAR Valid : Boolean);
Function  NodeEQ (A,B : NodeType) : Boolean;
Function  SameRec (var a, b; size : word) : Boolean;

Function Copy_File (SD, S, NS, D : string; Touch : Boolean) : Boolean;


Implementation


Function DriveFree(d : byte) : Longint; { -1 not found, 1=>1 Giga }
Var
  R : Registers;
Begin
  With R Do
  Begin
    ah := $36;
    dl := d;
    Intr($21, R);
    If AX = $FFFF Then
    DriveFree := -1 { Drive not found }
    Else
    If (BX = $FFFF) or (Longint(ax) * bx * cx = 1073725440) Then
       drivefree := 1 else drivefree := longint(ax) * bx * cx;
  End;
End;




Function Copy_File (SD, S, NS, D : string; Touch : Boolean) : Boolean;
TYPE
  Buffer = Array[1..6000] of Byte;
VAR
  TS, TD : File;
  B      : ^Buffer;
  Rd     : Word;
  Tim    : LongInt;
  RAM    : Word;
  dsk    : longint;
  Error  : Boolean;
  io     : word;
Begin
  sd := fexpand(sd);
  d  := fexpand(d);

  if SD <> D then
    begin
      Error := True;    { default = failure }
      if MaxAvail >= SizeOf(Buffer) then
        RAM := SizeOf(Buffer)
          else RAM := MaxAvail;

      if (length(sd) > 0) and (last(1,sd) <> '\') then sd := sd + '\';
      if (length(d) > 0) and (last(1,d) <> '\') then d := d + '\';

      if RAM > 0 then                { check RAM first! }
        begin
          Assign (TS, SD+S);
          {$I-} Reset (TS,1); {$I+}
          io := ioresult;
          if (io = 0) and (filesize(ts) > 0) then
            begin
              if D[2] <> ':'
                then Dsk := 0
                  else Dsk := Ord(Upcase(D[1])) - 64;

              tim := DriveFree(dsk); { -1 not found, 1=>1 Giga }

              if (tim =1) or (tim >= FileSize (TS)) then
                begin
                  Assign (TD, D+NS);
                  {$I-} Rewrite (TD,1); {$I+}
                  io := ioresult;
                  if io = 0 then
                    begin
                      GetMem (B, RAM);
                      Repeat
                        BlockRead  (TS, B^[1], RAM, Rd);
                        BlockWrite (TD, B^[1], Rd);
                      until Rd < RAM;
                      FreeMem (B, RAM);

                      if NOT Touch then
                        begin
                          GetFTime (TS, Tim);
                          SetFTime (TD, Tim);
                        end;

                      Close (TD);
                      Error := False;
                    end else
                      NotifyCR (2,'Error ('+int_to_str(io)+') opening destination file '+D+S);
                end else
                begin
                  if DiskFree(Dsk) = -1 then
                    NotifyCR (1,'Invalid drive specification') else
                      NotifyCR (1,' Not enough free diskspace on destination drive');
                end;
              Close (TS);
            end else
              NotifyCR (2,'Error ('+int_to_str(io)+') opening source file '+SD+S);
        end else
          NotifyCR (1,' Error allocating memory for FileCopy buffer');
      Copy_File := NOT Error;
    end else
      Copy_File := True;
end;




Function  Daynumber : string;
var
  dt, du : datetime;
  tmp : string;
Begin
  getdate (today.year, today.month, today.day, today.dow);
  gettime (today.hour, today.min, today.sec, today.hs);

  fillchar (dt, sizeof(dt), 0);
  dt.year  := today.year;
  dt.month := today.month;
  dt.day   := today.day;
  fillchar (du, sizeof(du), 0);
  du.year  := dt.year;
  du.month := 1;
  du.day   := 1;
  tmp := int_to_str(round((getunixdate(dt)-getunixdate(du))/secsinaday)+1);
{  tmp := strlf(  round((getunixdate(dt)-getunixdate(du))/secsinaday)+1, 2);}
  tmp := replace(' ','0',tmp);
{  chrrepl (tmp, ' ', '0', 1, 3);}
  daynumber := tmp;
End;

Function Date_Past (D:string) : Boolean;
Var
  dt   : datetime;
  k, l : longint;
  day,
  month,
  year : string[2];
  dummy : word;
  tmp : string;
Begin
  FillChar (DT, SizeOf(DT), 0);
  With DT do GetDate(Year, Month, Day, dummy);
  k := GetUnixDate(DT);

  day := first(pos('-',d)-1,d);

  tmp := last(length(d)-pos('-',d), d);
  d := tmp;

  month := first(pos('-',d)-1,d);
  tmp := last(length(d)-pos('-',d), d);
  d := tmp;

  year := d;
  if (length(day) > 0) and (length(month) > 0) and (length(year) > 0) then
    begin
      dt.day := str_to_int(day);
      dt.month := str_to_int(month);
      dt.year := str_to_int(year);
      DT.Year := DT.Year + 2000;       { changed frm 1900 to 2000 y2k }

      l := getunixdate(dt);

      if l <= k then
        date_past := true else date_past := false;
    end else
      date_past := true; {incorrect datum: gewoon doen alsof}
End;




Function Samerec (var a, b; size : word) : boolean; assembler;
  { You can use AnyRec for Rec1 and Rec2, as
    long as the correct size is given!!
    Recs of size 0 are considered to be equal. }
  ASM
        mov   DX,DS     { Fast save DS  }
        xor   AX,AX     { default False }
        lds   SI,a      { DS:SI -> Rec1 }
        les   DI,b      { ES:DI -> Rec2 }
        cld             { Comp forwards }
        mov   CX,size   { Size in Bytes }
        shr   CX,1      { Size in words }
        jnc   @Even     { Size is Even? }
        cmpsb           { Comp odd byte }
        jne   @End      { Equal bytes?  }
 @Even: repe  cmpsw     { Compare loop  }
        jne   @End      { Equal at end? }
        inc   AX        { Return: True  }
  @End: mov   DS,DX     { Restore DS    }
end {Compare};


Function NodeEQ (A,B : NodeType) : Boolean;
begin
  if (A.Zone = B.Zone) and (A.Net = B.Net) and (A.Node = B.Node) and (A.Point = B.Point)
  then NodeEQ := True
  else NodeEQ := False;
end;

Function Node2Str (N : NodeType) : String;
VAR S : String[20];
begin
  S := '';
  With N
  do begin
    if Zone > 0 then S := int_to_Str(Zone) + ':';
    if Net > 0
    then S := S + int_to_Str(Net) + '/' + int_to_str(Node)
    else if Node > 0 then S := S + int_to_str(Node);
    if Point > 0 then S := S + '.' + int_to_str(Point);
  end;
  Node2Str := S;
end;

Procedure Str2Node (S : String; VAR N : NodeType; D : Nodetype; VAR Valid : Boolean);
VAR Error : Integer;
begin
  if S = ''
  then begin
    Valid := True;
    With N
    do begin
      Zone  := 0;
      Net   := 0;
      Node  := 0;
      Point := 0;
    end;
  end
  else begin
    Valid := True;
    With N
    do begin
      if Pos('.',S) > 0
      then begin
        Val (Copy(S,Pos('.',S)+1,Length(S)-Pos('.',S)), Point, Error);
        Valid := Error = 0;
        Delete (S, Pos('.',S), Length(S)-Pos('.',S)+1);
      end
      else Point := 0;

      if Pos(':',S) > 0
      then begin
        Val (Copy(S,1,Pos(':',S)-1), Zone, Error);
        Valid := (Error = 0) and (Zone > 0);
        Delete (S, 1, Pos(':',S));
        if S = '' then Valid := False;
      end
      else Zone := D.Zone;

      if Pos('/',S) > 0
      then begin
        Val (Copy(S,1,Pos('/',S)-1), Net, Error);
        Valid := (Error = 0) and (Net > 0);
        Delete (S, 1, Pos('/',S));
      end
      else Net := D.Net;

      if S <> ''
      then begin
        Val (S, Node, Error);
        Valid := Error = 0;
      end
      else Node := D.Node;

      if (Zone > 0) and (Net = 0) then Valid := False;
      if Zone = 0 then Zone := D.Zone;
    end;
  end;
end;

Procedure GetDosDate (Secs : LongInt; VAR DT : DateTime);
begin
  FillChar (DT, SizeOf(DT), 0);
  With DT
  do begin
    { strip all year seconds }

    Secs := Secs - SecsSince1970;
    Year := 1991;

    While (Secs-SecsInAyear-(Byte(IsLeapYear(Year))*SecsInaDay)) >= 0
    do begin
      if IsLeapYear(Year)
      then Secs := Secs - SecsInADay - SecsInaYear
      else Secs := Secs - SecsInaYear;
      Inc (Year);
    end;

    { year is correct }

    Month := 1;

    While (Secs- (SecsInaDay*(DaysInMonths[Month] + Extra[(IsLeapYear(Year)) and (Month=2)])) >= 0)
    do begin
      Secs := Secs - (SecsInaDay*(DaysInMonths[Month] + Extra[(IsLeapYear(Year)) and (Month=2)]));
      Inc (Month);
    end;

    { month is correct, now day }

    Day := 1;

    While (Secs - SecsInADay) >= 0
    do begin
      Secs := Secs - SecsInaDay;
      Inc (Day);
    end;

    { day is correct, now hours }

    Hour := 0;

    While (Secs - SecsInAnHour) >= 0
    do begin
      Secs := Secs - SecsInAnHour;
      Inc (Hour);
    end;

    { hours OK, now minutezzz }

    Min := 0;
    While (Secs - 60) >= 0
    do begin
      Secs := Secs - 60;
      Inc (Min);
    end;

    { minutes are fine, the rest iz seconds }

    Sec := Secs;
  end;
end;

Function IsLeapYear(Year : Integer) : Boolean;
Var Yes : Boolean;
      I : Integer;
Begin
  Yes := False;
  For I := 1 to 10 do if Year = LeapYears[I] then Yes := True;
  IsLeapYear := Yes;
End;


Function DateString (D : LongInt) : String;
VAR
  DT : DateTime;
  S  : String[8];
begin
  GetDosDate (D, DT);
  With DT do
    begin
      if day < 10 then s := '0'+int_to_str(day) else s := int_to_str(day);
      if month < 10 then s := s + '-0'+int_to_str(month) else s := s + '-'+int_to_str(month);
      if year < 2010 then s := s + '-0'+int_to_str(year-2000) else
      s := s + '-'+ int_to_str(year-2000);    { y2k changed 1900 to 2000 }
    end;                                     { & allow for year < 2010 }
  DateString := S;
end;


Function GetUnixDate (DT : DateTime) : LongInt;
VAR
  Secs : LongInt;
  I    : Integer;
begin
  With DT
  do begin
    { first the big stuff : yearz }

    Secs := SecsSince1970;
    For I := 1991 to Year-1
    do Secs := Secs + SecsInaYear + (Extra[IsLeapYear(I)] * SecsInADay);

    { now the months }

    For I := 1 to Month-1
    do Secs := Secs + SecsinAday * (DaysInMonths[I] + Byte(IsLeapYear(Year) and (I=2)));

    { the days }

    For I := 1 to Day-1
    do Secs := Secs + SecsInaDay;

    { hours }

    For I := 0 to Hour-1    do Secs := Secs + SecsInAnHour;

    { minutes }

    For I := 0 to Min-1     do Secs := Secs + 60;

    { secs :-) }

    Secs := Secs + Sec;

    GetUnixDate := Secs;
  end;
end;


END.
