{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Compressor (archive) system Main Unit
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}
Unit CompSys;     { Compressor System Main Unit }

{$O+}

Interface

Uses Dos,
     BSC,         { Basic compressed object     Always first! }

{    MAC_SIT,  } { Macintosh SIT! formaat      }

     IBM_PKZ,     { Pkzip                       }
     IBM_LHA,     { LHA/LZARC/LA                }
     IBM_ARJ,     { Arj                         }
     IBM_SQZ,     { SQZ                         }
     IBM_ARC,     { ARC/PAK/ARC7                }
     IBM_HYP,     { Hyper                       }
     IBM_DWC,     { DWC                         }
{     IBM_MDCD,}    { MDCD                        }
     IBM_ZOO,     { ZOO                         }
     IBM_RAR;     { RAR                         }


Type CompressorType = ^BasicCompressorObject;

Function DetectCompressor(    _Filename : ComStr;
                          Var _CO       : CompressorType):Boolean;



Implementation

Const BufferSize      = 25*1024;  { Make sure there is enough heap! }

Type CheckBuffer = Array[1..BufferSize] of Byte;
Var  Check       : ^CheckBuffer;

Function DetectCompressor(    _Filename : ComStr;
                          Var _CO       : CompressorType):Boolean;
Var F       : File;
    RR      : RR_Type;
    ThisOne : Byte;
    Found   : Boolean;

Begin
DetectCompressor:=False;
New(Check);
If Check=NIL
   Then Exit;
FillChar(Check^,SizeOf(Check^),#00);

Assign(F,_FileName);
Reset(F,1);
BlockRead(F,Check^,BufferSize,RR);
Close(F);
If (IoResult<>0) or
   (RR=0)
   Then Begin
        Dispose(Check);
        Exit;
        End;

ThisOne:=1;
Found:=False;
While (Not Found) And (ThisOne<=OPtr) Do
 Begin
 OList[ThisOne]^.FileName:=_FileName;
 Found:=OList[ThisOne]^.IsThisTypeFile(Check^,RR);
 If Not Found Then Inc(ThisOne);
 End;

If found
   Then Begin
        _CO:=OList[ThisOne];
        _CO^.Filename:=_FileName;
        End
   Else _CO:=NIL;

Dispose(Check);
DetectCompressor:=Found;
End;

End.

