{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit strategy;

interface

uses global{$IFDEF LINUX},linux{$ENDIF};

function checkunit : boolean;
function strgscitoname(science:byte):string;
procedure buildcity;
procedure managecity;
procedure citySave(var w : tcityRec);
function cityload(a:tcityrec) : boolean;
procedure cityAdd(var w : tcityRec);
procedure cityreset;
procedure strgstatus(spy,observer:boolean);
procedure strgredirect;
procedure strgchgsci(witchone:byte);

implementation

uses input, output, showfile, mudmisc, users,rrun,strproc, armys,news,bbuild;

procedure strgredirect;
begin
if (room^.city) > 0 then
  begin
  city^.number:=room^.city;
  cityload(city^);
  if upstr(user^.username) = upstr(city^.ownername) then managecity else
  owrite('You can''t do that yet!');
  end
  else
  buildcity;
end;

function checkunit : boolean;
var www:word;
begin
checkunit:=false;
for www:=1 to 16380 do
begin
if city2^.armystat[www] > 0 then begin checkunit:=true; break; end;

end;

end;

function cityload(a:tcityrec) : boolean;
var {$IFDEF LINUX} f:longint; {$ELSE} F : file;{$ENDIF}
begin
   cityload := False;
{$IFDEF LINUX}
   f := fdopen ('cities.dat', open_rdonly);
   if f <> 0 then Exit;
   fdSeek(F,(a.Number-1) * sizeof (tcityrec), seek_set);
   cityload := fdRead(F,city^,sizeof (tcityrec)) = sizeof (tcityrec);
   fdClose(F);
   f := fdopen ('cities2.dat', open_rdonly);
   if f <> 0 then Exit;
   fdSeek(F,(a.Number-1) * sizeof (tcity2rec), seek_set);
   cityload := fdRead(F,city2^,sizeof (tcity2rec)) = sizeof (tcity2rec);
   fdClose(F);
   f := fdopen ('cities3.dat', open_rdonly);
   if f <> 0 then Exit;
   fdSeek(F,(a.Number-1) * sizeof (tcity3rec), seek_set);
   cityload := fdRead(F,city3^,sizeof (tcity3rec)) = sizeof (tcity3rec);
   fdClose(F);

{$ELSE}
   Assign(F,'cities.dat');
   {$I-}
   Reset(F,SizeOf(tcityRec));
   {$I+}
   if ioResult <> 0 then Exit;
   Seek(F,a.Number-1);
   {$I-}
   BlockRead(F,city^,1);
   {$I+}
   cityload := ioResult = 0;
   Close(F);

   cityload := False;
   Assign(F,'cities2.dat');
   {$I-}
   Reset(F,SizeOf(tcity2Rec));
   {$I+}
   if ioResult <> 0 then Exit;
   Seek(F,a.Number-1);
   {$I-}
   BlockRead(F,city2^,1);
   {$I+}
   cityload := ioResult = 0;
   Close(F);

   cityload := False;
   Assign(F,'cities3.dat');
   {$I-}
   Reset(F,SizeOf(tcity3Rec));
   {$I+}
   if ioResult <> 0 then Exit;
   Seek(F,a.Number-1);
   {$I-}
   BlockRead(F,city3^,1);
   {$I+}
   cityload := ioResult = 0;
   Close(F);
{$ENDIF}
end;

procedure citySave(var w : tcityRec);
var F : file;
begin
   if w.Number < 1 then Exit;
   Assign(F,'cities.dat');
   {$I-}
   Reset(F,SizeOf(tcityRec));
   {$I+}
   if ioResult = 0 then
   begin
      Seek(F,w.Number-1);
      BlockWrite(F,city^,1);
      Close(F);
   end else cityadd(W);

   Assign(F,'cities2.dat');
   {$I-}
   Reset(F,SizeOf(tcityRec));
   {$I+}
   if ioResult = 0 then
   begin
      Seek(F,w.Number-1);
      BlockWrite(F,city2^,1);
      Close(F);
   end;
   Assign(F,'cities3.dat');
   {$I-}
   Reset(F,SizeOf(tcityRec));
   {$I+}
   if ioResult = 0 then
   begin
      Seek(F,w.Number-1);
      BlockWrite(F,city3^,1);
      Close(F);
   end;


end;

procedure cityAdd(var w : tcityRec);
var F : file of tcityRec; f2:file of tcity2rec; f3:file of tcity3rec;
    N : Word; T : tcityrec; Done : Boolean;
begin
   Assign(F,'cities.dat');
   Assign(f2,'cities2.dat');
   assign(f3,'cities3.dat');
   {$I-}
   Reset(F);
   Reset(f2);
   reset(f3);
   {$I+}
   if ioResult <> 0 then
   begin
      w.Number := 1;
      Rewrite(F);
      Rewrite(f2);
      rewrite(f3);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T); {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      w.Number := N+1;
      city2^.number:=n+1;
      city3^.number:=n+1;
   end;
   Write(F,w);
   Write(f2,city2^);
   write(f3,city3^);
   close(f3);
   close(f2);
   Close(F);
   cityload(w);
end;

procedure cityreset;
var aa:byte;
begin
with city^ do
begin
       fillchar(city^,sizeof(city^),0);
       size:=1;
       population:=100;
       prodpopulation:=10;
       prodconst := 2;
       decayfood   :=10;
       decaywater  :=5;
       decaylumber :=3;
       decayweapons  :=1;
       armybad       :=false;
       armywarning   :=true;
       storweapons :=100;
       storlumber:=50;
       stormetal:=50;
       storfood :=100;
       storwater:=100;
       storstone:=50;
       wilderness:=300;
       gouvtype:=1;
       scientists:=2;
       for aa:=1 to 8 do
       begin
       sciname[aa]:='';
       scineeded[aa]:=1;
       end;
       for aa:=1 to 15 do
       begin
       scilevel[aa]:=1;
       end;
       nowbldname:='';
       crime:=2;
       police:=2;
       fillchar(reserved,sizeof(reserved),0);
       fillchar(city2^,sizeof(city2^),0);
       fillchar(city3^,sizeof(city3^),0);
end;
end;

procedure buildcity;
var tmp1:boolean; tmp2:word;
begin
inforest:=false;
incombat:=false;
oclrscr;
for tmp2:=1 to 100 do
begin
  if user2^.city[tmp2]=0 then break;
end;
if tmp2 > 100 then begin
ocwrite('|12 You already got too much cities');
odnln(1);
exit;
end;
sfshowfile('city1.ans',ftnocode);
odnln(1);
ocwrite('|02Building the city will cost you |1210000 |02gold, do you accept? ');
odnln(1);
tmp1:=user^.gold >= 15000;
if not iyesno(tmp1) then exit;
odnln(1);
if user^.gold < 10000 then begin ocwriteln('|12Not enough money'); whpause; exit; end;
ocwriteln('|04Good Choice');
cityreset;
ocwrite('|09Enter city name: ');
city^.name:=ireadstring('',innormal,chnormal,'',40);
user^.gold:=user^.gold-10000;
city^.ownername:=user^.username;
city^.ownernumber:=user^.number;
cityadd(city^);
user2^.city[tmp2]:=city^.number;
room^.city:=city^.number;
usersave(user^);
saveroom(room^);
writenews('City of '+city^.name+' founded by '+user^.username,'global');
end;

procedure strgbuilding;
var chx:char;
begin
repeat
sfshowfile('builmgt.ans',ftnocode);
ogotoxy(16,19);
ocwrite(city^.nowbldname);
ogotoxy(16,21);
osetfore(3);
owrite(st(city^.constdone)+' / '+st(city^.constneeded));
odnln(2);
osetfore(9);
owrite('Choose your command: ');
repeat
chx:=upcase(ireadkey);
until chx in ['1'..'3','Q'];
case chx of
'1': builddisplaydone;
'2': buildlistavail;
'3': buildconstruction;
'Q': bool:=true;
end;
until bool;
bool:=false;
end;

procedure strgarmy;
begin
repeat
sfshowfile('armymgt2.ans',ftnocode);
ogotoxy(21,19);
osetcolor(5,0);
owrite(st(city^.storweapons));
ogotoxy(21,20);
osetcolor(14,0);
owrite(st(city^.bankdeposited+user^.gold));
repeat
cp:=upcase(ireadkey);
until cp in ['1'..'4','Q'];
case cp of
'1': armybuy;
'2': armymercbuy;
'3': armydisband;
'4': armylist;
'Q': bool:=true;
end;
until bool;
bool:=false;

end;

procedure strgwar;
begin
{repeat

until bool;}
bool:=false;

end;

procedure strgresearch;
var x:byte; ch:char;
begin
repeat
sfshowfile ('scimgt.ans',ftnocode);
for x:=1 to 8 do
begin
ogotoxy (14,6+x);
owrite(city^.sciname[x]);
ogotoxy (42,6+x);
owrite(st(city^.sciassigned[x]));
ogotoxy (57,6+x);
if city^.scineeded[x] = 0 then city^.scineeded[x] :=1;
owrite(st(round((city^.scidone[x] / city^.scineeded[x]) * 100)));
end;
repeat
ch:=upcase(ireadkey);
until ch in ['1'..'8','Q'];
case ch of
'1'..'8': strgchgsci(strtoint(ch));
'Q': bool:=true;
end;
until bool;
bool:=false;
end;

procedure strgchgsci(witchone:byte);
var w,y:byte; ch:char; assigned:string[3]; tmp:byte;
begin
sfshowfile('scichg.ans',ftnocode);
for y:=1 to 15 do
begin
ogotoxy(70,2+y);
owrite(st(city^.scilevel[y]));
end;
repeat
ch:=upcase(ireadkey);
until ch in ['1'..'9','A'..'F','N','Q'];
odnln(1);
ogotoxy(1,24);
ocwrite('|03Dedicate how much % of science production? ');
tmp:=100;
for w:=1 to 8 do
  tmp:=tmp-city^.sciassigned[w];
repeat
assigned:=ireadstring(st(tmp),inupper,chnumeric,'',3);
if (strtoint(assigned) > tmp) then owriteln('Must enter value below '+st(tmp));
until (strtoint(assigned) <= tmp);
case ch of
'1'..'9': begin
           city^.sciname[witchone]:=strgscitoname(strtoint(ch));
           city^.sciassigned[witchone]:=strtoint(assigned);
           city^.sciworking[witchone]:=strtoint(ch);
           city^.scineeded[witchone]:=city^.scilevel[strtoint(ch)]*3;
           city^.scidone[witchone]:=0;
          end;
'A'..'F': begin
           city^.sciname[witchone]:=strgscitoname(ord(ch)-55);
           city^.sciassigned[witchone]:=strtoint(assigned);
           city^.sciworking[witchone]:=(ord(ch)-55);
           city^.scineeded[witchone]:=city^.scilevel[ord(ch)-55]*3;
           city^.scidone[witchone]:=0;
             end;
'Q': begin end;
'N': begin city^.sciname[witchone]:='';
           city^.sciassigned[witchone]:=0;
           city^.scidone[witchone]:=0;
           city^.scineeded[witchone]:=0;
     end;
end;
citysave(city^);
end;

function strgscitoname(science:byte):string;
begin
case science of
1: strgscitoname:='Agriculture';
2: strgscitoname:='Biology';
3: strgscitoname:='Astronomy';
4: strgscitoname:='Mathematics';
5: strgscitoname:='Chemistry';
6: strgscitoname:='Weaponry';
7: strgscitoname:='Armors';
8: strgscitoname:='Physics';
9: strgscitoname:='Geology';
10:strgscitoname:='Philosophy';
11:strgscitoname:='Psychology';
12:strgscitoname:='Fire';
13:strgscitoname:='Communication';
14:strgscitoname:='Physiology';
15:strgscitoname:='Magic';
end;
end;
procedure strgequip;
begin
{repeat

until bool;}
bool:=false;

end;

procedure strgtrans;
begin
{repeat

until bool;}
bool:=false;

end;

procedure strgcouncil;
begin
{repeat

until bool;}
bool:=false;

end;

procedure writegouvtype;
begin
case city^.gouvtype of
1:owrite('Despotism');
2:owrite('Communism');
3:owrite('Democracy');
4:owrite('Republic');
5:owrite('Fundamentalism');
6:owrite('Anarchy');
end;
end;

procedure writectysize;
begin
case city^.size of
1: owrite('Small Village');
2: owrite('Medium Village');
3: owrite('Large Village');
4: owrite('Small City');
5: owrite('Medium City');
6: owrite('Large City');
7: owrite('Small Metropolis');
8: owrite('Medium Metropolis');
9: owrite('Large Metropolis');
10: owrite('Megapole');
end;
end;

procedure strgstatus (spy,observer:boolean);
begin
sfshowfile('ctystat.ans',ftnocode);
osetcolor(15,0);
ogotoxy(18,1);
ocwrite(city^.name);
osetfore(15);
ogotoxy(12,2);
ocwritE(city^.ownername);
osetfore(15);
ogotoxy(24,4);
writectysize;
ogotoxy(24,5);
owrite(st(city^.wilderness)+' acres free');
ogotoxy(24,6);
owrite(st(city^.numbuild));
ogotoxy(24,7);
owrite(st(city^.tax)+' %');
ogotoxy(24,8);
ocwrite(city^.nowbldname);
osetfore(15);
ogotoxy(59,4);
owrite(st(city^.totdef));
ogotoxy(59,5);
owrite(st(city^.totoff));
ogotoxy(59,6);
writegouvtype;
ogotoxy(59,7);
owrite(st(city^.techlevel));
ogotoxy(59,8);
owrite(st(city^.scientists));
ogotoxy(13,13);
owrite(st(city^.prodgold));
ogotoxy(13,15);
owrite(st(city^.bankdeposited));
ogotoxy(19,13);
owrite(st(city^.prodmetal));
ogotoxy(19,15);
owrite(st(city^.stormetal));
ogotoxy(27,13);
owrite(st(city^.prodstone));
ogotoxy(27,15);
owrite(st(city^.storstone));
ogotoxy(35,13);
owrite(st(city^.prodlumber));
ogotoxy(35,15);
owrite(st(city^.storlumber));
ogotoxy(35,17);
owrite(st(city^.decaylumber));
ogotoxy(44,13);
owrite(st(city^.prodfood));
ogotoxy(44,15);
owrite(st(city^.storfood));
ogotoxy(44,17);
owrite(st(city^.decayfood));
ogotoxy(51,13);
owrite(st(city^.prodwater));
ogotoxy(51,15);
owrite(st(city^.storwater));
ogotoxy(51,17);
owrite(st(city^.decaywater));
ogotoxy(72,13);
owrite(st(city^.prodweapons));
ogotoxy(72,15);
owrite(st(city^.storweapons));
ogotoxy(72,17);
owrite(st(city^.decayweapons));
ogotoxy(59,13);
owrite(st(city^.prodpopulation));
ogotoxy(59,15);
owrite(st(city^.population));
ogotoxy(1,19);

whpause;
end;

procedure managecity;
begin
inforest:=false;
incombat:=false;

bool:=false;
repeat
  sfshowfile('ctymgt.ans',ftnocode);
  osetcolor(4,0);
  if ((city^.spaceavail) <= 0) then city^.spaceavail:=1;
  statusbar(20,18,round((city^.spaceused / city^.spaceavail)*24));
{  osetcol(9);
  if ((city^.scineeded) <= 0) then city^.scineeded:=1;
  statusbar(20,19,round((city^.scidone / city^.scineeded)*24));}
  osetfore(2);
  if ((city^.engneeded) <= 0) then city^.engneeded:=1;
  statusbar(20,20,round((city^.engdone / city^.engneeded)*24));
  osetfore(11);
  if ((city^.constneeded) <= 0) then city^.constneeded:=1;
  statusbar(20,21,round((city^.constdone / city^.constneeded)*24));

  if checkunit then city^.armywarning:=false;

  if city^.armybad then begin
                           ogotoxy(59,18);
                           ocwrite('|08Ready Warning |12Problem');
                        end else
  if city^.armywarning then begin
                               ogotoxy(59,18);
                               ocwrite('|08Ready |14Warning |08Problem');
                            end else
                                                   begin
                                                      ogotoxy(59,18);
                                                      ocwrite('|10Ready |08Warning Problem');
                                                   end;
  ogotoxy(45,21);
  ocwrite('|09Choose your move : ');
  cp:=upcase(ireadkey);
  case cp of
   'B': strgbuilding;
   'A': strgarmy;
   'W': strgwar;
   'R': strgresearch;
   'E': strgequip;
   'T': strgtrans;
   'C': strgcouncil;
   'S': strgstatus(true,false);
   'Q': bool:=true;
  end;

until bool;


end;

end.