program setup;

uses crt,dos,app{$IFDEF LINUX}, linux {$ENDIF};

{$I constant.pas}
{$I maincfg.pas}
{$I mudvar.pas}

type
toldconfigrec = record
  comport:byte;
  doortype:byte;
  bbsname:string[40];
  sysopname:string[36];
  path:string[40];
  multinode:boolean;
end;

var
s:string; ch:char; cfg:^tconfigrec; lf:file of tlockfile;
x:integer; quit:boolean; fn:string; y:integer;
s2:string; ocfg:^toldconfigrec;
maintcfg:^tmaintrec;
{$IFDEF LINUX}
fa,f,fc,fo,file_room,file_room2:longint;
{$ELSE}
fa:file of tmaintrec; fc: file of tcfg3rec;
f:file of tconfigrec; fo:file of toldconfigrec;
file_room: file of troomrec;
file_room2:file of troomrec;
{$ENDIF}

procedure loadroom(r:troomrec);
var {$IFDEF LINUX} file_room : longint; {$else} file_room : file of troomrec; {$ENDIF}
begin
   if r.number < 1 then exit;

   {$IFDEF LINUX}
   fdSeek(File_room,(r.Number-1) * sizeof (troomrec), seek_set);
   fdRead(File_room,room^,sizeof (troomrec));
   {$ELSE}
   Seek(File_room,r.Number-1);
   {$I-}
   Read(File_room,room^);
   {$I+}
   {$ENDIF}
end;

procedure saveroom(r:troomrec);
begin
   if r.Number < 1 then Exit;
(*   Assign(F,'rooms.dat');
   {$I-}
   Reset(F,SizeOf(troomRec));
   {$I+}
   if ioResult <> 0 then begin logwrite('Error in room file'); owrite('MAJOR PROBLEM'); end else
   begin*)
   {$IFDEF LINUX}
   fdSeek(File_room,(r.Number-1) * sizeof (troomrec), seek_set);
   fdWrite(File_room,r,sizeof (troomrec));
   {$ELSE}
      Seek(File_room,r.Number-1);
      Write(File_room,room^);
   {$ENDIF}
(*      Close(F);
   end;*)
end;

function fDirExists(Dir: String) : Boolean;
var
   fHandle: file;
   wAttr: WORD;
begin
{$IFDEF LINUX}
     while Dir[Length(Dir)] = '/' do Dec( Dir[0] );
     Dir := Dir + '/.';
{$ELSE}
     while Dir[Length(Dir)] = '\' do Dec( Dir[0] );
     Dir := Dir + '\.';
{$ENDIF}
     Assign( fHandle, Dir );
     GetFAttr( fHandle, wAttr );
     fDirExists := ( (wAttr and Directory) = Directory );
end;

procedure fCreateDir(Target : String; Stay : Boolean);
var
  i,
  count   : Integer;
  dir,
  home,
  tempdir,
  Start : String;
  Slash : Array[1..20] of Integer;

begin
  Dir := Target;
  if Stay then GetDir(0,Start);
  {$IFDEF LINUX}
  if Dir[Length(Dir)] <> '/' then Dir := Dir + '/';
  {$ELSE}
  if Dir[Length(Dir)] <> '\' then Dir := Dir + '\';
  if Dir[2] = ':' then {$I-} ChDir(Copy(Dir, 1, 3)) {$I+} else
  begin
    GetDir(0, Home);
    if Dir[1] <> '\' then
      Dir := Home + '\' + Dir
    else
      Dir := Home + Dir;
  end;
  {$ENDIF}


  Count := 0;
  { search directory For slashed and Record them }
  For i := 1 to Length(Dir) do
  begin
    {$IFDEF LINUX}
    if Dir[i] = '/' then
    {$ELSE}
    if Dir[i] = '\' then
    {$ENDIF}
    begin
      Inc(Count);
      Slash[Count] := i;
    end;
  end;
  { For each step of the way, change to the directory }
  { if get error, assume it doesn't exist - make it }
  { then change to it }
  For i := 2 to Count do
  begin
    TempDir := Copy(Dir, 1, Slash[i] - 1);
    {$I-}
    ChDir(TempDir);
    if IOResult <> 0 then
    begin
      MkDir(TempDir);
      ChDir(TempDir);
    end;
  end;
  if Stay then ChDir(Start);
end;

function iyesno(s:string;def:boolean):boolean;
var chhh:char;
begin
  write(s);
  if def then
    write(' [Y/n]? ')
  else
    write(' [y/N]? ');
repeat
  chhh:=upcase(readkey);
until chhh in ['Y','N',#13,#27];

case chhh of
  'Y'    : iyesno:=true;
  'N',#27: iyesno:=false;
  #13    : iyesno:=def;
  end;
end;

procedure default;
begin
{$IFDEF LINUX}
  cfg^.comport:='/dev/ttyS1';
{$ELSE}
  cfg^.comport:=0;
{$ENDIF}
  cfg^.doortype:=1;
  cfg^.bbsname:='Your BBS';
  cfg^.sysopname:='You';
{$IFDEF LINUX}
  cfg^.path:='/home/bbs/doors/';
{$ELSE}
  cfg^.path:='c:\iniquity\door\';
{$ENDIF}
  cfg^.multinode:=true;
  cfg^.delay:=0;
  cfg^.daemon:=false;
  cfg^.altcommio:=false;
  cfg^.answer:='ATA';
  cfg^.inits:='ATZ';
  cfg^.sysopkeys:=false;
  fillchar(cfg^.reserved,sizeof(cfg^.reserved),#0);
end;

procedure defmaint;
begin
  maintcfg^.healall:=true;
  fillchar(maintcfg^.reserved,sizeof(maintcfg^.reserved),0);
end;

procedure defcfg3;
begin
  cfg3^.bp:='L:7';
  cfg3^.statbar:=false;
  cfg3^.manarec[1]:=10;
  cfg3^.manarec[2]:=5;
  cfg3^.manarec[3]:=7;
  cfg3^.manarec[4]:=15;
  cfg3^.manarec[5]:=2;
  cfg3^.hprec:=9;
  fillchar(cfg3^.reserved,sizeof(cfg3^.reserved),0);
end;

procedure savecfg;
begin
  str(i,s2);
{$IFDEF LINUX}
  f:=fdopen('dark'+s2+'.dat', open_rdwr OR open_creat, 436);
  fdwrite (f,cfg^, sizeof (cfg^));
  fdclose(f);
{$ELSE}
  assign(f,'dark'+s2+'.dat');
  rewrite(f);
  write(f,cfg^);
  close(f);
{$ENDIF}
end;

procedure savemaint;
begin
{$IFDEF LINUX}
  fa:=fdopen('maint.dat', open_rdwr OR open_creat, 436);
  fdwrite (fa, maintcfg^, sizeof (maintcfg^));
  fdclose(fa);
{$ELSE}
  assign(fa,'maint.dat');
  rewrite(fa);
  write(fa,maintcfg^);
  close(fa);
{$ENDIF}
end;

procedure savecfg3;
begin
{$IFDEF LINUX}
  fc:=fdopen('setup.dat', open_rdwr OR open_creat, 436);
  fdwrite (fc, cfg3^, sizeof (cfg3^));
  fdclose(fc);
{$ELSE}
  assign(fc,'setup.dat');
  rewrite(fc);
  write(fc,cfg3^);
  close(fc);
{$ENDIF}
end;

(*

{$I rtfm.inc}*)
procedure loadcfg;
var c:char;
begin
  str(i,s2);
{$IFDEF LINUX}
  f:=fdopen ('dark'+s2+'.dat', open_rdonly);
  if not ((fdread (f, cfg^, sizeof(tconfigrec))) = (sizeof(tconfigrec))) then
  begin
    fdclose (f);
    default; savecfg;
  end else
    fdclose (f);
{$ELSE}
  assign(f,'dark'+s2+'.dat');
{$I-}
  reset(f); {$I+}
  if ioresult<>0 then
  begin
    default;
    savecfg;
    exit;
  end;
{$I-}
  read(f,cfg^);
{$I+}
  close(f);
{$ENDIF}
end;

procedure loadmaint;
begin
{$IFDEF LINUX}
  fa:=fdopen ('maint.dat', open_rdonly);
  if not ((fdread (fa, maintcfg^, sizeof(tmaintrec))) = (sizeof(tmaintrec))) then
  begin
    fdclose (fa);
    defmaint;
    savemaint;
    exit;
  end else
    fdclose (fa);
{$ELSE}
  assign(fa,'maint.dat');
{$I-}reset(fa);{$I+}
  if ioresult <> 0 then
  begin
    defmaint;
    savemaint;
    exit;
  end else
  begin
    read(fa,maintcfg^);
    close(fa);
  end;
{$ENDIF}
end;

procedure loadcfg3;
begin
{$IFDEF LINUX}
  fc:=fdopen ('setup.dat', open_rdonly);
  if not ((fdread (fc, maintcfg^, sizeof(tcfg3rec))) = (sizeof(tcfg3rec))) then
  begin
    fdclose(fc);
    defcfg3;
    savecfg3;
    exit;
  end else
    fdclose (fc);
{$ELSE}
  assign(fc,'setup.dat');
{$I-}reset(fc);{$I+}
  if (ioresult <> 0) then begin defcfg3; savecfg3; exit; end else
  begin
    read(fc,cfg3^);
    close(fc);
  end;
{$ENDIF}
end;

procedure setdoor;
begin
clrscr;
textcolor(4);
writeln('Choose a door type...');
writeln;
textcolor(2);
write('1');
textcolor(4);
writeln(' Door.sys');
textcolor(2);
write('2');
textcolor(4);
writeln(' Doorfile.sr');
textcolor(2);
write('3');
textcolor(4);
writeln(' Local / Daemon');
textcolor(2);
write('4');
textcolor(4);
writeln(' Internal login system');

textcolor(12);
writeln;
repeat
  ch:=readkey;
until ch in ['1'..'4'];
case ch of
  '1': cfg^.doortype := 1;
  '2': cfg^.doortype := 2;
  '3': cfg^.doortype := 3;
  '4': cfg^.doortype := 4;
end;
if (cfg^.doortype <> 4) then cfg^.wfc:=false else cfg^.wfc:=true;
end;

procedure help;
begin
clrscr;
writeln('Usage:');
writeln('      Setup <cfgname>');
halt(255);
end;
function St(N : LongInt) : String;
var S : String;
begin
   System.Str(N, S);
   St := S;
end;

procedure resetall;
var {$IFDEF LINUX} f:longint; {$ELSE} f:file;{$ENDIF}
dirinfo:searchrec;
numroom:word; x:word;
begin
  numroom:=0;
  clrscr;
  write('Removing User files [  ]');
{$IFDEF LINUX}
  unlink ('users.dat');
{$ELSE}
  assign(f,'users.dat');
{$I-} reset(f); {$I+}
if ioresult=0 then
  begin
    close(f);
    erase(f);
  end;
{$ENDIF}
  gotoxy(22,1);
  write('.');
{$IFDEF LINUX}
  unlink ('users.idx');
{$ELSE}
  assign(f,'users.idx');
{$I-} reset(f); {$I+}
if ioresult=0 then
  begin
    close(f);
    erase(f);
  end;
{$ENDIF}
  writeln('.] Done');
  write('Removing E-Mails [   ]');
{$IFDEF LINUX}
  unlink('email.jdt');
  gotoxy(19,2);
  write('.');
  unlink('email.jdx');
  write('.');
  unlink('email.jhr');
  write('.');
  unlink('email.jlr');
{$ELSE}
  assign(f,'email.jdt');
{$I-} reset(f); {$I+}
if ioresult=0 then begin
                      close(f);
                      erase(f);
                   end;
gotoxy(19,2);
write('.');
assign(f,'email.jdx');
{$I-} reset(f); {$I+}
if ioresult=0 then begin
                      close(f);
                      erase(f);
                   end;
write('.');
assign(f,'email.jhr');
{$I-} reset(f); {$I+}
if ioresult=0 then begin
                      close(f);
                      erase(f);
                   end;
write('.');
assign(f,'email.jlr');
{$I-} reset(f); {$I+}
if ioresult=0 then begin
                      close(f);
                      erase(f);
                   end;
{$ENDIF}
write('.] ');
writeln('Done!');
write('Removing News Files [');
findfirst('*.nws',$3f,dirinfo);
repeat
{$IFDEF LINUX}
  unlink (dirinfo.name);
{$ELSE}
  assign(f,dirinfo.name);
{$I-}
  erase(f);
{$I+}
  if ioresult<>0 then break;
{$ENDIF}
  write('.');
  findnext(dirinfo);
until doserror<>0;
write('] ');
writeln('Done!');
write('Removing No Play Files [');
findfirst('*.npl',$3f,dirinfo);
repeat
{$IFDEF LINUX}
  unlink (dirinfo.name);
{$ELSE}
  assign(f,dirinfo.name);
{$I-}
  erase(f);
{$I+}
  if ioresult<>0 then break;
{$ENDIF}
  write('.');
  findnext(dirinfo);
until doserror<>0;
write('] ');
writeln('Done!');

write('Removing Cities files [');
findfirst('cities?.dat',$3f,dirinfo);
repeat
{$IFDEF LINUX}
  unlink (dirinfo.name);
{$ELSE}
  assign(f,dirinfo.name);
{$I-}
  erase(f);
{$I+}
  if ioresult<>0 then break;
{$ENDIF}
  write('.');
  findnext(dirinfo);
until doserror<>0;
write('] ');
writeln('Done!');
(*
{$IFDEF LINUX}
f := fdopen ('rooms.dat', open_rdonly);
if f < 0 then
begin
  writeln('Error opening rooms.dat');
  exit;
end;
numroom:=0;
while fdRead(F,room^,sizeof (troomrec)) = sizeof(troomrec)
do begin inc(numroom); end;
fdclose(f);
*)
(*
file_room := fdopen ('rooms.dat', open_rdonly);
if file_room < 0 then
begin
  writeln ('Error reading rooms.dat');
  exit;
end;
file_room2 :=fdopen ('rooms.tmp', open_rdwr OR open_creat);

if file_room2 < 0 then
begin
  writeln ('Error creating rooms.tmp');
  exit;
end;
  *)
(*{$ELSE}
assign(file_room,'rooms.dat');
reset(file_room);
numroom:=1;
writeln ('TEST-1');
while not EOF(File_room) do
begin
  read(file_room,room^);
  inc(numroom);
  gotoxy (1,1);
  write (numroom);
end;
close(file_room);*)
(*   assign (file_room, 'rooms.dat');
   reset (file_room);
   if ioresult <> 0 then
   begin
     writeln ('Erreur opening rooms.dat');
     exit;
   end;
*)
(*{$ENDIF}
   writeln ('TEST-2');
   write ('Cleaning up [');
   for x:=1 to numroom do
   begin
     room^.number := x;
     loadroom (room^);
     room^.city:=0;
     saveroom (room^);
     write ('.');
   end;
   write (']');*)
(*
{$IFDEF LINUX}
  fdclose (file_room);
{$ELSE}
  close (file_room);
{$ENDIF}
*)
end;



procedure ecrit;
begin
clrscr;
textbackground(0);
textcolor(2);
clrscr;
write('A');
textcolor(4);
write(' Sysop Name               ');
textcolor(15);
writeln(cfg^.sysopname);
textcolor(2);
write('B');
textcolor(4);
write(' BBS Name                 ');
textcolor(15);
writeln(cfg^.bbsname);
textcolor(2);
(*
{$IFDEF LINUX}
write('C');
textcolor(4);
write(' Com device               ');
textcolor(15);
writeln(cfg^.comport);
*)
{$IFNDEF LINUX}
write('C');
textcolor(4);
write(' Comport                  ');
textcolor(15);
str(cfg^.comport,s);
writeln(s);
{$ENDIF}
textcolor(2);
write('D');
textcolor(4);
write(' Doortype                 ');
textcolor(15);
if cfg^.doortype = 1 then writeln('Door.sys') else
if cfg^.doortype = 2 then writeln('Doorfile.sr') else
if cfg^.doortype = 3 then writeln('Local') else
if cfg^.doortype = 4 then writeln('Internal login system');
textcolor(2);
write('E');
textcolor(4);
write(' Door file path           ');
textcolor(15);
if cfg^.doortype < 3 then begin writeln(cfg^.path) end else writeln('Not needed');

textcolor(2);
write('F');
textcolor(4);
write(' Multinode?               ');
textcolor(15);
if cfg^.multinode then writeln('Yup!') else writeln('Nope!');

{$IFNDEF LINUX}
textcolor(2);
write('G');
textcolor(4);
write(' Wait for call (no bbs) ? ');
textcolor(15);
{if cfg^.doortype = 3 then begin writeln('Not needed') end else}
if cfg^.wfc then writeln('Yup!') else writeln('Nope!');


textcolor(2);
write('H');
textcolor(4);
write(' Modem answer string ?    ');
textcolor(15);
if cfg^.wfc then writeln(cfg^.answer) else begin writeln('Not needed'); cfg^.answer:=''; end;
textcolor(2);
write('I');
textcolor(4);
write(' Modem init string ?      ');
textcolor(15);
if cfg^.wfc then writeln(cfg^.inits) else begin writeln('Not needed'); cfg^.inits:=''; end;
textcolor(2);
{$ENDIF}
write('J');
textcolor(4);
write(' Daemon mode ?            ');
textcolor(15);
if cfg^.daemon then writeln('Yup!') else writeln('Nope!');
textcolor(2);
write('K');
textcolor(4);
write(' Time limit :             ');
textcolor(15);
str(cfg^.timemax,s);
writeln(s);


textcolor(2);
write('L');
textcolor(4);
writeln(' Local node ');

textcolor(2);
write('M');
textcolor(4);
write(' Enable sysop keys?       ');
textcolor(15);
if cfg^.sysopkeys then writeln('Yup!') else writeln('Nope!');

writeln;
textcolor(2);
write('[');
textcolor(15);
writeln(' Previous node');
textcolor(2);
write(']');
textcolor(15);
writeln(' Next node');
textcolor(2);
writeln;
write('Q');
textcolor(4);
writeln(' Quit');
writeln;
writeln;
write('Editing node: ');
str(i,s2);
write(s2);
writeln;
textcolor(8);
write('Dark Lands '+bbsversion+' Setup program');
end;

procedure node;
var q2:boolean;
begin
q2:=false;
repeat
ecrit;
repeat
ch:=readkey;
until upcase(ch) in ['A'..'M','Q',']','['];
case upcase(ch) of
'A' : begin gotoxy(27,1); {textbackground(1); textcolor(15);
            write('____________________________________');}
            strinput(33);
            gotoxy(28,1); readln(cfg^.sysopname);
            savecfg;
            end;   {sysop name}
'B' : begin gotoxy(27,2); {textbackground(1); textcolor(15);
            write('____________________________________');}
            strinput(33);
            gotoxy(28,2); readln(cfg^.bbsname);
            savecfg;
            end;   {bbs name}

{$IFNDEF LINUX}
'C' : begin gotoxy(27,3);{ textbackground(1); textcolor(15);
            write('__');  }
(*          {$IFDEF LINUX}
            strinput(20);
            readln(cfg^.comport);
            {$ELSE}*)
            strinput(2);
            gotoxy(28,3); readln(s); val(s,cfg^.comport,y);
(*            {$ENDIF}*)
            savecfg;
            end;   {comport}
{$ENDIF}

'D' : begin setdoor;
            savecfg;
            end;   {doortype}

'E' : begin gotoxy(27,5); {textbackground(1); textcolor(15);
            write('______________________________________');}
            strinput(33);
            gotoxy(28,5); readln(s);

            {$IFDEF LINUX}
            if s[Length(s)] <> '/' then
             s := s+'/';
            {$ELSE}
            if s[Length(s)] <> '\' then
             s := s+'\';
            {$ENDIF}

            cfg^.path:=copy(s,1,40);
            if (not fdirexists(cfg^.path)) and iyesno('Create directory?',true) then fcreatedir(cfg^.path,true);

            savecfg;
            end;

'F' : begin cfg^.multinode:=not cfg^.multinode; savecfg; end;
{$IFNDEF LINUX}
'G' : begin cfg^.wfc:=not cfg^.wfc; if cfg^.wfc then cfg^.doortype:=4; savecfg; end;
'H' : begin gotoxy (27,8); strinput(20); gotoxy (28,8); readln(cfg^.answer); end;
'I' : begin gotoxy (27,9); strinput(20); gotoxy (28,9); readln(cfg^.inits); end;
{$ENDIF}
'J' : begin cfg^.daemon:=not cfg^.daemon; savecfg; end;
'K' : begin gotoxy(27,11);{ textbackground(1); textcolor(15);
            write('__');  }
            strinput(5);
            gotoxy(28,11); readln(s); val(s,cfg^.timemax,y);
            savecfg;
            end;
'L' : begin cfg^.doortype:=3; cfg^.wfc:=false; savecfg; end;
'M' : begin cfg^.sysopkeys := not cfg^.sysopkeys; savecfg; end;

'Q' : begin clrscr; q2:=true; savecfg; end;
'[' : begin savecfg; dec(i); if i<0 then inc(i); loadcfg; end;
']' : begin savecfg; inc(i); if i>9999 then dec(i); loadcfg; end;
end;
until q2;
end;

procedure ecrit2;
begin
clrscr;
textbackground(0);
textcolor(15);
writeln('Maintenance Stuff');
textcolor(2);
write('A');
textcolor(4);
write(' Heal Everything?    ');
textcolor(15);
if maintcfg^.healall then writeln('True') else writeln('False');
writeln;
writeln;
textcolor(2);
write('Q');
textcolor(4);
write(' Quit                ');
end;

procedure maint;
var q3:boolean;
begin
q3:=false;
repeat
ecrit2;
repeat
ch:=upcase(readkey);
until ch in ['A','Q'];
case ch of
'A': begin maintcfg^.healall:=not maintcfg^.healall; savemaint; end;
'Q': q3:=true;
end;
until q3;
end;

procedure ecrit4;
var q4:boolean;
begin
q4:=false;
repeat
clrscr;
textcolor(2);
write('A');
textcolor(4);
write(' Build Points formula   ');
textcolor(15); gotoxy(26,1); writeln(cfg3^.bp);
textcolor(2);
write('B');
textcolor(4);
write(' Stat Bar               ');
textcolor(15);
if cfg3^.statbar then writeln('Yup!') else writeln('Nope!');
textcolor(2);
write('C');
textcolor(4);
write(' Normal Mana recovery   ');
textcolor(15);
str(cfg3^.manarec[1],s); s:=s+' s';writeln(s);
textcolor(2);
write('D');
textcolor(4);
write(' mp recovery at temple  ');
textcolor(15);
str(cfg3^.manarec[2],s); s:=s+' s';writeln(s);
textcolor(2);
write('E');
textcolor(4);
write(' Same alignement temple ');
textcolor(15);
str(cfg3^.manarec[3],s); s:=s+' s';writeln(s);
textcolor(2);
write('F');
textcolor(4);
write(' Different aln temple   ');
textcolor(15);
str(cfg3^.manarec[4],s); s:=s+' s';writeln(s);
textcolor(2);
write('G');
textcolor(4);
write(' MP rec at real temple  ');
textcolor(15);
str(cfg3^.manarec[5],s); s:=s+' s';writeln(s);
textcolor(2);
write('H');
textcolor(4);
write(' Hit Points recovery    ');
textcolor(15);
str(cfg3^.hprec,s); s:=s+' s'; writeln(s);

writeln;
textcolor(2);
write('Q');
textcolor(4);
writeln(' Quit   ');
repeat
ch:=upcase(readkey);
until ch in ['A'..'H','Q',#27];
case ch of
'A': begin gotoxy(1,22); writeln('Form: First number : second number');
           writeln('Variables: L = user level');
           writeln('The first number is divided by the second one');
           write('To multiply, write: ''cL'' or ''Lc'' where c is a constant');
           gotoxy(26,1);
           strinput(40);
           gotoxy(27,1);
           readln(cfg3^.bp);
           savecfg3;
           end;
'B'    : begin cfg3^.statbar:=not cfg3^.statbar; savecfg3; end;
'C'    : begin gotoxy(1,24); write('Normal Mana recovery. Number of seconds before a user gain one mp');
               gotoxy(1,25); write('from 0 to 255. 0 to disable recovery');
               repeat
               gotoxy(26,3); strinput(3);
               gotoxy(27,3);
               readln(s);
               val(s,cfg3^.manarec[1],x);
               until ((cfg3^.manarec[1])<=255) and ((cfg3^.manarec[1])>=0);
               savecfg3;
               end;
'D'    : begin gotoxy(1,24); write('Mana recovery in worshipped god place (circle,temple,...) in seconds');
               gotoxy(1,25); write('from 0 to 255. 0 to disable recovery');
               repeat
               gotoxy(26,4); strinput(3);
               gotoxy(27,4);
               readln(s);
               val(s,cfg3^.manarec[2],x);
               until ((cfg3^.manarec[2])<=255) and ((cfg3^.manarec[2])>=0);
               savecfg3;
               end;
'E'    : begin gotoxy(1,24); write('Mana recovery when in the place of a god of the same alignement');
               gotoxy(1,25); write('from 0 to 255. 0 to disable recovery');
               repeat
               gotoxy(26,5); strinput(3);
               gotoxy(27,5);
               readln(s);
               val(s,cfg3^.manarec[3],x);
               until ((cfg3^.manarec[3])<=255) and ((cfg3^.manarec[3])>=0);
               savecfg3;
               end;
'F'    : begin gotoxy(1,24); write('Mana recovery in a place for a god of opposite alignement');
               gotoxy(1,25); write('from 0 to 255. 0 to disable recovery');
               repeat
               gotoxy(26,6); strinput(3);
               gotoxy(27,6);
               readln(s);
               val(s,cfg3^.manarec[4],x);
               until ((cfg3^.manarec[4])<=255) and ((cfg3^.manarec[4])>=0);
               savecfg3;
               end;
'G'    : begin gotoxy(1,24); write('Mana recovery when user is in a place for his real god.');
               gotoxy(1,25); write('from 0 to 255. 0 to disable recovery');
               repeat
               gotoxy(26,7); strinput(3);
               gotoxy(27,7);
               readln(s);
               val(s,cfg3^.manarec[5],x);
               until ((cfg3^.manarec[5])<=255) and ((cfg3^.manarec[5])>=0);
               savecfg3;
               end;
'H'    : begin gotoxy(1,24); write('Normal Hitpoints recovery. Number of seconds before a user gain one hp');
               gotoxy(1,25); write('from 0 to 255. 0 to disable recovery');
               repeat
               gotoxy(26,8); strinput(3);
               gotoxy(27,8);
               readln(s);
               val(s,cfg3^.hprec,x);
               until ((cfg3^.hprec)<=255) and ((cfg3^.hprec)>=0);
               savecfg3;
               end;

#27,'Q': q4:=true;
end;
until q4;
end;

procedure ecrit3;
begin
clrscr;
textcolor(2);
write('A');
textcolor(4);
writeln(' Node configuration  ');
textcolor(2);
write('B');
textcolor(4);
writeln(' Maintenance configuration   ');
textcolor(2);
write('G');
textcolor(4);
writeln(' Game configuration   ');
textcolor(2);
write('L');
textcolor(4);
writeln(' Redo lockfile ');
textcolor(2);
write('R');
textcolor(4);
writeln(' Reset Game');
textcolor(2);
write('D');
textcolor(4);
write(' Delay instead of pause? ');
str(cfg^.delay,s);
textcolor(15);
if cfg^.delay=0 then writeln('Nope!') else writeln(s+' ms');


writeln;
textcolor(2);
write('Q');
textcolor(4);
writeln(' Quit                ');
writeln;

textcolor(8);
write('Dark Lands '+bbsversion+' Setup program');
end;

procedure updatelockfile;
var x:byte; f:file; 
begin
clrscr;
for x:=0 to 255 do
begin
  str (x, s2);
  gotoxy(1,1);
  write('Progress: '+s2+'/255');


  assign(f,'dark'+s2+'.dat');
  {$I-}
    reset(f);
  {$I+}
if ioresult=0 then
begin
  lockfile^.locked[x]:=true;
  close(f);
  end else
  lockfile^.locked[x]:=false;


end;
assign(lf, 'lockfile.lck');
rewrite(lf);
write(lf, lockfile^);
close(lf);
writeln;
write('Done! Press any key to continue...');
readkey;

end;

begin
new(cfg);
new(ocfg);
new(maintcfg);
new(cfg3);
new(lockfile);
fillchar(lockfile^,sizeof(lockfile^),0);
fillchar(maintcfg^,sizeof(maintcfg^),0);
fillchar(ocfg^,sizeof(ocfg^),0);
fillchar(cfg^,sizeof(cfg^),0);
fillchar(cfg3^,sizeof(cfg3^),0);
textcolor(7);
textbackground(0);
quit:=false;
if ((paramstr(1) = '?') or (paramstr(1) = 'help')) then begin help end;
s2:=paramstr(1);
fn:='dark'+paramstr(1)+'.dat';
val(paramstr(1),i,y);
loadcfg;
loadmaint;
loadcfg3;
assign(lf, 'lockfile.lck');
{$I-}
reset(lf);
{$I+}
if ioresult <> 0 then begin rewrite(lf); write(lf, lockfile^); reset(lf); end;
read(lf, lockfile^);
repeat
ecrit3;
repeat
ch:=upcase(readkey);
until ch in ['A','B','Q','R','D','G','L'];
case ch of
'A':begin ecrit; node; end;
'B':begin ecrit2; maint; end;
'D' : begin gotoxy(27,4);{ textbackground(1); textcolor(15);
            write('_____ ms');}
            strinput(5); write(' ms');
            gotoxy(28,4); readln(s);
            val(s,cfg^.delay,y);
            savecfg;
            end;
'G':begin ecrit4; end;
'L':begin updatelockfile; end;
'R' : begin resetall; end;


'Q':quit:=true;
end;
until quit;
textcolor(7);
textbackground(0);
dispose(cfg);
dispose(ocfg);
dispose(maintcfg);
dispose(cfg3);
end.
