unit fstream;

interface

type tFileStream = object
     f       : file;
     InMem   : boolean;
     FileBuf : pointer;
     BufSize : longint;
     BufPos  : longint;
     procedure assign(filename : string; LoadToMem : Boolean);
     procedure reset;
     procedure seek(newpos : longint);
     function blockread(var Buf; Count: Word) : Word;
     function Size : longint;
     function Pos  : longint;
     function Eof  : boolean;
     procedure Close;
     end;

implementation

procedure tFileStream.assign(filename : string; LoadToMem : Boolean);
begin;
InMem := LoadToMem;
system.assign(f,filename);
if InMem then
 begin;
 {$I-}
 system.reset(f,1);
 {$I+}
 if (ioResult = 0) then
  begin;
   BufSize := filesize(f);
   FileBuf := nil;
   GetMem(FileBuf,BufSize);
   if (FileBuf = nil) then
    InMem := false else
    system.blockread(f,FileBuf^,BufSize);
  end else InMem := false;
 end;
end;

procedure tFileStream.reset;
begin;
if InMem then
 BufPos := 0 else
  system.reset(f,1);
end;

procedure tFileStream.seek(newpos : longint);
begin;
if InMem then
 BufPos := newpos else
  system.seek(f,newpos);
end;

function tFileStream.blockread(var Buf; Count: Word) : Word;
var P : pointer;
    Result : word;
begin;
if InMem then
 begin;
 P := FileBuf;
 inc(longint(P),BufPos);
 move(P^,Buf,Count);
 Result := Count;
 inc(BufPos,Result);
 end else
  system.blockread(f,Buf,Count,Result);
blockread := result;
end;

function tFileStream.Size : longint;
begin;
if InMem then
 Size := BufSize else
 Size := filesize(f);
end;

function tFileStream.Pos : longint;
begin;
if InMem then
 Pos := BufPos else
 Pos := filePos(f);
end;

function tFileStream.Eof  : boolean;
begin;
if InMem then
 Eof := BufPos >= BufSize else
 Eof := system.eof(F);
end;

procedure tFileStream.Close;
begin;
if InMem then
 freemem(FileBuf,BufSize);
system.close(F);
end;

end.