{$IFDEF OVERLAY} {$O-} {$ENDIF}
unit FastIO;

interface

uses
   {$IFDEF OS2} OS2base, {$ENDIF}
   Crt,
   Global, Misc, Emulate;

const
  NormalCursor = $0D0E; (* Might be different on some systems *)
  BlankCursor  = $2000;
  maxWin       = 4;
  Blank : record C : Char; A : Byte end = (C:' ';A:$07);

type
  tPage   = array[0..2047] of Word;
  pScreen = ^tScreen;
  tScreen = array[0..7] of tPage;
  pWins   = ^tWins;
  tWins   = array[1..maxWin] of tPage;

var
  Screen : pScreen;
  ioWin  : pWins;
  textbufsize : word;
  pageAct, pageVis, tmode : Byte;
  {$IFNDEF OVERLAY}
  Frg, Bkg : byte;
  {$ENDIF}
  posUpdate : Boolean;

procedure ioClrDown;
procedure ioClrEol;
procedure ioClrScr;
procedure ioClrUp;
procedure ioCwrite(s : String);
procedure ioCwriteLn(s : String);
function  ioGetAttr(F,B : Byte; Blink : Boolean) : Byte;
procedure ioGetColor(Color : Byte; Var BackGr : Byte; Var ForeGr : Byte; var Bl : Boolean);
procedure ioGotoXY(X,Y : Byte);
procedure ioHighVideo;
procedure ioInitFastIO;
procedure ioLowVideo;
procedure ioPageActive(Page : Byte);
procedure ioPageVisual(Page : Byte);
procedure ioScreenOn;
procedure ioScrollDown;
procedure ioScrollUp;
procedure ioTextAttr(Color : Byte);
procedure ioTextBack(Back : Byte);
procedure ioTextBlink(Blink : Boolean);
procedure ioTextColor(F,B : Byte; Bl : Boolean);
procedure ioTextColRec(C : tColorRec);
procedure ioTextFore(Fore : Byte);
procedure ioTextMode;
procedure ioUpdatePos;
function  ioWhereX : Byte;
function  ioWhereY : Byte;
procedure ioWrite(S : String);
procedure ioWriteLn(S : String);
procedure ioWriteChar(Ch : Char);
procedure SetPage(Page : Byte);
{$IFNDEF LINUX}
function extractchar (x,y:byte) : char;
function extractattrib (x,y:byte) :byte;
{$ENDIF}
implementation

{$IFDEF OVERLAY} {Changed cause ppc386 can't do objs}
{$L FASTIO_2.OBJ} (* Fast IO External Assembler functions *)
{$ENDIF}

uses
   Dos;

const
   VIO    = $10;
                       {Changed cause ppc386 can't do objs}
procedure SetPage(Page : Byte); {$IFNDEF OVERLAY} begin end; {$ELSE} External;{$ENDIF}
{$IFDEF OVERLAY}
function ioGetMode : Byte;
{$IFDEF OS2}
begin
   RunError(241);
{$ELSE}
var Regs : Registers;
begin
   with Regs do
   begin
      Ax := $0F00;
      Intr($10,Regs);
      ioGetMode := Al;
   end;
{$ENDIF}
end;
{$ENDIF}
procedure ioTextMode;
begin
{$IFDEF OS2}
   TextMode(co80);
{$ELSE}
   TextMode(co80);
{$ENDIF}
end;

procedure ioInitFastIO;
begin
   textbufsize := 4000;
{$IFDEF OS2}
   vioGetBuf(pointer(screen),textbufsize,0);
   selToFlat(pointer(screen));
   tmode := co80;
{$ELSE}
{$IFNDEF OVERLAY}
{$ELSE}
   tmode := ioGetMode;
   screen := @mem[textvidseg:0000];
{$ENDIF}
{$ENDIF}
   posX := whereX;
   posY := whereY;
   Col.Fore := 7;
   Col.Back := 0;
   Col.Blink := False;
   colAttr := $07;
   posUpdate := True;
   ioScreenOn;
end;

procedure ioScreenOn;
begin
   ioPageActive(0);
   ioPageVisual(0);
   ScreenOff := False;
end;

procedure ioPageActive(Page : Byte);
begin
   {$IFNDEF OVERLAY}
   pageAct := Page;
   {$ENDIF}
end;

procedure ioPageVisual(Page : Byte);
begin
   {$IFNDEF OVERLAY}
   pageVis := Page;
   {$IFDEF OS2}
{  vioSetCp(0,page,0);}
   {$ELSE}
     SetPage(Page);
(*   asm
     MOV AH, $05
     MOV AL, Page
     Int VIO
   end; *)
   {$ENDIF}
   ioGotoXY(posX,posY);
   {$ENDIF}
end;

procedure ioClrScr;
{$IFDEF OS2}
var cell : SmallWord;
begin
   cell := 32 + colattr shl 8;
   vioScrollUp(Hi(WindMin),Lo(WindMin),Hi(WindMax),Lo(WindMax),Hi(WindMax)-Hi(WindMin)+1,cell,0);
{$ELSE}
{$IFNDEF OVERLAY}
begin
clrscr;
{$ELSE}
var N : Byte; Blank : record C : Char; A : Byte end;
begin
   begin
      Blank.C := ' '; Blank.A := colAttr;
      for N := Hi(windMin) to Hi(windMax) do
          mFillWord(Screen^[pageAct,N*80],80,Word(Blank));
   end;
{$ENDIF}
{$ENDIF}
   posX := 1;
   posY := 1;
   ioGotoXY(1,1);
end;

procedure ioClrEol;
{$IFDEF OS2}
var cell : SmallWord;
begin
   cell := 32 + colattr shl 8;
   vioScrollUp(posY-1,posX-1,posY-1,Lo(WindMax),1,cell,0);
{$ELSE}
{$IFNDEF OVERLAY}
begin
clreol;
{$ELSE}
begin
   mFillWord(screen^[pageAct,(posY-1)*80+(posX-1)],80-posX+1,Word(Blank));
{$ENDIF}
{$ENDIF}
end;

procedure ioClrDown;
var y : Byte;
begin
{$IFDEF OS2}
   ioClrScr;
{$ELSE}
{$IFNDEF OVERLAY}
   ioClrScr;
{$ELSE}
   for y := posY to Hi(windMax) do mFillWord(screen^[pageAct,(y-1)*80],80,Word(Blank));
{$ENDIF}
{$ENDIF}
end;

procedure ioClrUp;
var y : Byte;
begin
{$IFDEF OS2}
   ioClrScr;
{$ELSE}
{$IFNDEF OVERLAY}
   ioClrScr;
{$ELSE}
   for y := posY downto Hi(windMin) do mFillWord(screen^[pageAct,(y-1)*80],80,Word(Blank));
{$ENDIF}
{$ENDIF}
end;

procedure ioUpdatePos;
begin
{   posUpdate := True;
   ioGotoXY(posX,posY);}
end;

procedure ioWriteChar(Ch : Char);
var Cl : record C : Char; A : Byte; end;
 procedure dwDown;
 begin
    Inc(posY);
    if posY > 25 then
    begin
       posY:=25;
       ioScrollDown; {mScroll(Lo(WindMin)+1,Hi(WindMin)+1,Lo(WindMax)+1,Hi(WindMax)+1,-1);}
    end;
 end;
begin
   case Ch of
     #13 : posX := 1;
     #10 : dwDown;
     #8  : ioGotoXY(posX-1,posY);
     else begin
             Cl.C := Ch;
             Cl.A := colAttr;
             {$IFDEF OS2}
             vioWrtCellStr(@cl,2,hi(windmin)+posY-1,lo(windmin)+posx-1,0);
             {$ELSE}
             {$IFDEF OVERLAY}
             screen^[pageAct,(Hi(WindMin)+posY-1)*80+(lo(windmin)+posX-1)] := Word(Cl);
             {$ELSE}
             if col.back > 7 then col.back:=0;
             textbackground (col.back);
             if col.fore > 15 then col.fore := 0;
             textcolor(col.fore);
             write(ch);
             {$ENDIF}
             {$ENDIF}
             Inc(posX);
             if posX > 80 then
             begin
                if vt100 then Dec(posX) else
                begin
                   posX := 1;
                   dwDown;
                end;
             end;
          end;
   end;
   ioGotoXY(posX,posY);
end;

procedure ioWrite(S : String);
var Z : Byte;
begin
   posUpdate := False;
   for Z := 1 to byte(s[0]) do ioWriteChar(S[Z]);
   ioUpdatePos;
end;

procedure ioCwrite(s : String);
var C1, C2 : Char; N, CP : Integer; CS : String; upd : Boolean;
begin
   upd := posUpdate;
   posUpdate := False;
   CP := 0; C1 := ' '; C2 := ' '; CS := '';
   for N := 1 to Length(S) do
   begin
      case S[N] of
        '|' : CP := 1;
        else if CP = 0 then ioWriteChar(S[N]) else
             if CP = 1 then
             begin
                C1 := S[N];
                Inc(CP);
             end else
             if CP = 2 then
             begin
                C2 := S[N];
                CS := C1+C2;
                if CS = '00' then ioTextAttr($00) else
                if CS = '01' then ioTextAttr($01) else
                if CS = '02' then ioTextAttr($02) else
                if CS = '03' then ioTextAttr($03) else
                if CS = '04' then ioTextAttr($04) else
                if CS = '05' then ioTextAttr($05) else
                if CS = '06' then ioTextAttr($06) else
                if CS = '07' then ioTextAttr($07) else
                if CS = '08' then ioTextAttr($08) else
                if CS = '09' then ioTextAttr($09) else
                if CS = '10' then ioTextAttr($0A) else
                if CS = '11' then ioTextAttr($0B) else
                if CS = '12' then ioTextAttr($0C) else
                if CS = '13' then ioTextAttr($0D) else
                if CS = '14' then ioTextAttr($0E) else
                if CS = '15' then ioTextAttr($0F) else
                ioWrite('|'+CS);
                CP := 0;
             end;
      end;
   end;
   posUpdate := upd;
end;

procedure ioCwriteLn(s : String);
begin
   ioCwrite(s);
   ioWrite(#13#10);
end;

procedure ioScrollDown;
var N : Word; {$IFNDEF OVERLAY}x,y:byte;{$ENDIF}
begin
{$IFDEF OS2}
   vioScrollUp(hi(windmin),lo(windmin),hi(windmax),lo(windmax),1,smallword(blank),0);
{$ELSE}
{$IFNDEF OVERLAY}
{   iogotoxy (1, 25);
   insline;          }
   x:=posx;
   y:=posy;
   iogotoxy (1,1);
   delline;
   iogotoxy (x,y);
{$ELSE}
   for N := Hi(WindMin) to Hi(WindMax)-1 do
       Move(screen^[pageAct,(N+1)*80],screen^[pageAct,N*80],160);
   mFillWord(screen^[pageAct,Hi(windMax)*80],80,Word(Blank));
{$ENDIF}
{$ENDIF}
end;

procedure ioScrollUp;
var N : Word;
begin
{$IFDEF OS2}
   vioScrollDn(hi(windmin),lo(windmin),hi(windmax),lo(windmax),1,smallword(blank),0);
{$ELSE}
{$IFNDEF OVERLAY}
   iogotoxy (1,1);
   insline;
{$ELSE}
   for N := Hi(WindMax) downto Hi(WindMin)+1 do
       Move(screen^[pageAct,(N-1)*80],screen^[pageAct,N*80],160);
   mFillWord(screen^[pageAct,Hi(windMin)*80],80,Word(Blank));
{$ENDIF}
{$ENDIF}
end;

procedure ioWriteLn(S : String);
begin
   ioWrite(S+#13#10);
end;

procedure ioGotoXY(X,Y : Byte);
begin
  posX := X;
  posY := Y;
{  if posUpdate then}
{$IFDEF OS2}
    vioSetCurPos(y-1,x-1,0);
{$ELSE}
    gotoxy(x,y);

(*  asm
    MOV DH, Y    { DH = Row (Y) }
    MOV DL, X    { DL = Column (X) }
    DEC DH       { Adjust For Zero-based Bios routines }
    DEC DL       { Turbo Crt.GotoXY is 1-based }
    MOV BH,pageAct     { Display page 0 }
    MOV AH,2     { Call For SET CURSOR POSITION }
    INT 10h
  end; *)
{$ENDIF}
end;

function ioWhereX : Byte;
(*
asm
  MOV     AH,3      {Ask For current cursor position}
  MOV     BH,pageAct      { On page 0 }
  INT     10h       { Return inFormation in DX }
  INC     DL        { Bios Assumes Zero-based. Crt.WhereX Uses 1 based }
  MOV     AL, DL    { Return X position in AL For use in Byte Result }
*)
begin
   ioWhereX := WhereX;
end;

function ioWhereY : Byte;
(*
asm
  MOV     AH,3     {Ask For current cursor position}
  MOV     BH,pageAct     { On page 0 }
  INT     10h      { Return inFormation in DX }
  INC     DH       { Bios Assumes Zero-based. Crt.WhereY Uses 1 based }
  MOV     AL, DH   { Return Y position in AL For use in Byte Result }
  *)
begin
   ioWhereY := WhereY;
end;

procedure ioGetColor(Color : Byte; Var BackGr : Byte; Var ForeGr : Byte; var Bl : Boolean);
begin
  BackGr := Color shr 4;
  ForeGr := Color xor (BackGr shl 4);
  if BackGr > 7 then
  begin
     Dec(BackGr,8);
     Bl := True;
  end else Bl := False;
  (*
  {$IFNDEF OVERLAY}
  bkg:=Backgr;
  frg:=ForeGr+8;
  {$ENDIF}
  *)
end;

function ioGetAttr(F,B : Byte; Blink : Boolean) : Byte;
begin
   if Blink then Inc(B,8);
(*   {$IFNDEF OVERLAY}
   frg:=f;
   bkg:=b;
   {$ENDIF}*)
   ioGetAttr := (B Shl 4) or F;
end;

procedure ioTextAttr(Color : Byte);
begin
   colAttr := Color;
   ioGetColor(Color,Col.Back,Col.Fore,Col.Blink);
end;

procedure ioHighVideo;
begin
   if Col.Fore < 8 then begin Inc(Col.Fore,8); {$IFNDEF OVERLAY} inc (frg, 8);{$ENDIF} end;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioLowVideo;
begin
   if Col.Fore > 7 then Dec(Col.Fore,8);
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextFore(Fore : Byte);
begin
   Col.Fore := Fore;
   {$IFNDEF OVERLAY}
   frg:=Fore;
   {$ENDIF}
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextBack(Back : Byte);
begin
   Col.Back := Back;
(*   {$IFNDEF OVERLAY}
   bkg:=back;
   {$ENDIF}*)
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextBlink(Blink : Boolean);
begin
   Col.Blink := Blink;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextColor(F,B : Byte; Bl : Boolean);
begin
   Col.Fore := F;
   Col.Back := B;
   Col.Blink := Bl;
(*   {$IFNDEF OVERLAY}
   bkg:=b;
   frg:=f;
   {$ENDIF}*)
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextColRec(C : tColorRec);
begin
   Col := C;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;
{$IFNDEF LINUX}
function extractchar (x,y:byte) : char;
var temp:char; oldx, oldy:byte;
begin
   oldx:=wherex;
   oldy:=wherey;
   iogotoxy (x,y);
   asm
     mov ah, $08
     mov bh, Pageact
     int $10
     mov temp, al
   end;
   extractchar := temp;
   iogotoxy (oldx,oldy);
end;

function extractattrib (x,y:byte) : byte;
var temp:byte; oldx, oldy:byte;
begin
   oldx:=wherex;
   oldy:=wherey;
   iogotoxy (x,y);
   asm
     mov ah, $08
     mov bh, Pageact
     int $10
     mov temp, ah
   end;
   extractattrib := temp;
   iogotoxy (oldx,oldy);
end;
{$ENDIF}
end.

