program wearmcfg;

uses crt,dos,app3 {$IFDEF LINUX}, linux {$ENDIF};

{$I mudvar.pas}

var numarmor,numweapon,numroom,numitem,nummonster,numevent:word;


procedure cwrite(s:string);
var n:byte; cs:string;
begin
   for N := 1 to Length(S) do
   begin
      case S[N] of
        '|' : if (UpCase(S[N+1]) in ['0'..'9','B','U']) and
                 (S[N+2] in ['0'..'9']) then
                 begin;
                 CS := Upcase(S[N+1]) + upcase(S[N+2]);
                 if CS = '00' then textcolor(0) else
                 if CS = '01' then textcolor(1) else
                 if CS = '02' then textcolor(2) else
                 if CS = '03' then textcolor(3) else
                 if CS = '04' then textcolor(4) else
                 if CS = '05' then textcolor(5) else
                 if CS = '06' then textcolor(6) else
                 if CS = '07' then textcolor(7) else
                 if CS = '08' then textcolor(8) else
                 if CS = '09' then textcolor(9) else
                 if CS = '10' then textcolor(10) else
                 if CS = '11' then textcolor(11) else
                 if CS = '12' then textcolor(12) else
                 if CS = '13' then textcolor(13) else
                 if CS = '14' then textcolor(14) else
                 if CS = '15' then textcolor(15) else
                 if CS = '16' then textbackground(0) else
                 if CS = '17' then textbackground(1) else
                 if CS = '18' then textbackground(2) else
                 if CS = '19' then textbackground(3) else
                 if CS = '20' then textbackground(4) else
                 if CS = '21' then textbackground(5) else
                 if CS = '22' then textbackground(6) else
                 if CS = '23' then textbackground(7) else
                 if CS = 'B0' then textbackground(0) else
                 if CS = 'B1' then textbackground(1) else
                 if CS = 'B2' then textbackground(2) else
                 if CS = 'B3' then textbackground(3) else
                 if CS = 'B4' then textbackground(4) else
                 if CS = 'B5' then textbackground(5) else
                 if CS = 'B6' then textbackground(6) else
                 if CS = 'B7' then textbackground(7) else
                 Write('|'+CS);
                 inc(N,2);
                 end;
        else Write(S[N]);
      end;
   end;
end;
procedure cwriteln(s:string);
begin
cwrite(s+#10#13);
end;

procedure detnum;
{$IFDEF LINUX}
var f:longint;
{$ELSE}
var fa:file of tarmorrec; fw:file of tweaponrec;
var fi:file of titemrec; fm:file of tmonsterrec;
var fr:file of troomrec;
var fe:file of teventrec;
{$ENDIF}
begin
{$IFDEF LINUX}
   f := fdopen ('armors.dat', open_rdonly);
   while fdRead(F,armor^,sizeof (tarmorrec)) = sizeof(tarmorrec);
   do begin inc(numarmor); end;
   fdClose(F);
   f := fdopen ('weapons.dat', open_rdonly);
   while fdRead(F,weapon^,sizeof (tweaponrec)) = sizeof(tweaponrec);
   do begin inc(numweapon); end;
   fdClose(F);
   f := fdopen ('rooms.dat', open_rdonly);
   while fdRead(F,room^,sizeof (troomrec)) = sizeof(troomrec);
   do begin inc(numroom); end;
   fdClose(F);
   f := fdopen ('items.dat', open_rdonly);
   while fdRead(F,item^,sizeof (titemrec)) = sizeof(titemrec);
   do begin inc(numitem); end;
   fdClose(F);
   f := fdopen ('events.dat', open_rdonly);
   while fdRead(F,event^,sizeof (teventrec)) = sizeof(teventrec);
   do begin inc(numevent); end;
   fdClose(F);
   f := fdopen ('monsters.dat', open_rdonly);
   while fdRead(F,monster^,sizeof (tmonsterrec)) = sizeof(tmonsterrec);
   do begin inc(nummonster); end;
   fdClose(F);
{$ELSE}
assign(fa,'armors.dat');
reset(fa);
while not EOF(Fa) do begin read(fa,armor^); inc(numarmor); end;
close(fa);
assign(fw,'weapons.dat');
reset(fw);
while not EOF(Fw) do begin read(fw,weapon^); inc(numweapon); end;
close(fw);
assign(fr,'rooms.dat');
reset(fr);
while not EOF(Fr) do begin read(fr,room^); inc(numroom); end;
close(fr);
assign(fi,'items.dat');
reset(fi);
while not EOF(Fi) do begin read(fi,item^); inc(numitem); end;
close(fi);
assign(fm,'monsters.dat');
reset(fm);
while not EOF(Fm) do begin read(fm,monster^); inc(nummonster); end;
close(fm);
assign(fe,'events.dat');
reset(fe);
while not EOF(Fe) do begin read(fe,event^); inc(numevent); end;
close(fe);
{$ENDIF}
end;

procedure defaultweapon(n:word);
begin
 with weapon^ do begin
 number:=n;
 name:='Dummy Weapon';
 numberofdmgdice:=0;
 dicetype:=0;
 flag:=[];
 value:=0;
 vslarge:=1;
         FillChar(Reserved,SizeOf(Reserved),0);
           end;
end;

procedure defaultitem(n:word);
begin
 with item^ do begin
 number:=n;
 name:='Dummy item';
 effect:=[];
 dicetype:=0;
 numberdice:=0;
 effectstring:='nothing';
 value:=0;
 buyable:=true;
 sellable:=true;
 itype:=[tclothe];
 usefile:='';
         FillChar(Reserved,SizeOf(Reserved),0);
           end;
end;

procedure defaultevent(n:longint);
begin
event^.number:=0;
event^.multiple:=false;
event^.desc[1]:='';
event^.desc[2]:='';
event^.desc[3]:='';
event^.desc[4]:='';
event^.desc[5]:='';
event^.desc[6]:='';
event^.desc[7]:='';
event^.givemoney:=0;
event^.giveweapon:=0;
event^.givearmor:=0;
event^.giveitem:=0;
event^.givexp:=0;
event^.giveortake[1]:=true;
event^.giveortake[2]:=true;
event^.giveortake[3]:=true;
event^.givehowmuchitem:=0;
event^.str:=0;
event^.int:=0;
event^.con:=0;
event^.dex:=0;
event^.cha:=0;
event^.wis:=0;
event^.com:=0;
event^.strm:=true;
event^.intm:=true;
event^.conm:=true;
event^.dexm:=true;
event^.cham:=true;
event^.wism:=true;
event^.comm:=true;
event^.cruN:=true;
event^.nextevent :=0;
event^.combatmonster:=0;
event^.nummonster:=0;
event^.failure:=0;
event^.eventdid:=0;
event^.instantdeath:=false;
event^.deathstring:='';
         FillChar(event^.Reserved,SizeOf(event^.Reserved),0);
end;

procedure defaultroom(n:word);
begin
 with room^ do begin
 number:=n;
 name:='Dummy Room';
 event:=0;
 flag:=['N','S','E','W','C','A','Q','I'];
 hardcodedspecial:=false;
 critter:=0;
 critterlevel:=0;
 monsterchance:=10;
 city:=0;
         FillChar(Reserved,SizeOf(Reserved),0);
     end;
end;

procedure defaultarmor(n:word);
begin
 with armor^ do begin
 number:=n;
 name:='Dummy Armor';
 acprot:=0;
 flag:=[];
 value:=0;
         FillChar(Reserved,SizeOf(Reserved),0);
 end;
end;


procedure resetweapon;
begin
 cwrite('Weapon.');
 fillchar(weapon^,sizeof(tweaponrec),#0);
 with weapon^ do begin
 number:=0;
 name:='Dummy Weapon';
 numberofdmgdice:=0;
 dicetype:=0;
 flag:=[];
 value:=0;
         FillChar(Reserved,SizeOf(Reserved),0);
 end;
cwriteln('end');
end;

procedure resetarmor;
begin
 cwrite('Armor.');
 fillchar(armor^,sizeof(tarmorrec),#0);
{with armor^ do begin}
 armor^.number:=0;
 armor^.name:='Dummy Armor';
 armor^.acprot:=0;
 armor^.flag:=[];
 armor^.value:=0;
          FillChar(armor^.Reserved,SizeOf(armor^.Reserved),0);
cwriteln('end');
end;

procedure armorAdd(var a : tarmorRec);
var F : file of tarmorRec;
    N : Word; T : tarmorrec; Done : Boolean;
begin
 Assign(F,'armors.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      a.Number := 1;
      Rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T);  {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      a.Number := N;
      if not Eof(F) then Seek(F,N-1) else a.Number := N+1;
   end;
   write(F,a);
 inc(numarmor);
   Close(F);
end;

procedure weaponAdd(var w : tweaponRec);
var F : file of tweaponRec;
    N : Word; T : tweaponrec; Done : Boolean;
begin
   Assign(F,'weapons.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      w.Number := 1;
      rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T); {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      w.Number := N;
      if not Eof(F) then Seek(F,N-1) else w.Number := N+1;
   end;
   write(F,w);
    inc(numweapon);
   Close(F);
end;
procedure eventAdd(var e : teventRec);
var F : file of teventRec;
    N : Word; T : teventrec; Done : Boolean;
begin
   Assign(F,'events.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      e.Number := 1;
      rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T); {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      e.Number := N;
      if not Eof(F) then Seek(F,N-1) else e.Number := N+1;
   end;
   write(F,e);
   inc(numevent);
   Close(F);
end;

procedure roomAdd(var r : troomRec);
var F : file of troomRec;
    N : Word; T : troomrec; Done : Boolean;
begin
   Assign(F,'rooms.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      r.Number := 1;
      rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T); {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      r.Number := N;
      if not Eof(F) then Seek(F,N-1) else r.Number := N+1;
   end;

   write(F,r);
   inc(numroom);
   Close(F);
end;

procedure itemAdd(var i : titemRec);
var F : file of titemRec;
    N : Word; T : titemrec; Done : Boolean;
begin
  Assign(F,'items.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      i.Number := 1;
      rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T);  {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      i.Number := N;
      if not Eof(F) then Seek(F,N-1) else i.Number := N+1;
   end;
   write(F,i);
   inc(numitem);
   Close(F);
end;

procedure weaponSave(var w : tweaponRec);
var F : file;
begin
   if w.Number < 1 then Exit;
   Assign(F,'weapons.dat');
   {$I-}
   Reset(F,SizeOf(tweaponRec));
   {$I+}
   if ioResult <> 0 then weaponAdd(w) else
   begin
      Seek(F,w.Number-1);
      Blockwrite(F,weapon^,1);
      Close(F);
   end;
end;
procedure eventSave(var w : teventRec);
var F : file;
begin
   if w.Number < 1 then Exit;
   Assign(F,'events.dat');
   {$I-}
   Reset(F,SizeOf(teventRec));
   {$I+}
   if ioResult <> 0 then eventAdd(w) else
   begin
      Seek(F,w.Number-1);
      Blockwrite(F,event^,1);
      Close(F);
   end;
end;

procedure roomSave(var r : troomRec);
var F : file;
begin
   if r.Number < 1 then Exit;
   Assign(F,'rooms.dat');
   {$I-}
   Reset(F,SizeOf(troomRec));
   {$I+}
   if ioResult <> 0 then roomAdd(r) else
   begin
      Seek(F,r.Number-1);
      Blockwrite(F,room^,1);
      Close(F);
   end;
end;
procedure itemSave(var i : titemRec);
var F : file;
begin
   if i.Number < 1 then Exit;
   Assign(F,'items.dat');
   {$I-}
   Reset(F,SizeOf(titemRec));
   {$I+}
   if ioResult <> 0 then itemAdd(i) else
   begin
      Seek(F,i.Number-1);
      Blockwrite(F,item^,1);
      Close(F);
   end;
end;

procedure armorSave(var a : tarmorRec);
var F : file;
begin
   if a.Number < 1 then Exit;
   Assign(F,'armors.dat');
   {$I-}
   Reset(F,SizeOf(tarmorRec));
   {$I+}
   if ioResult <> 0 then armorAdd(a) else
   begin
      Seek(F,a.Number-1);
      Blockwrite(F,armor^,1);
      Close(F);
   end;
end;


function weaponload(w:tweaponrec):boolean;
var F : file;
begin
   weaponload:=true;
   if W.Number < 1 then Exit;
   Assign(F,'weapons.dat');
   {$I-}
   Reset(F,SizeOf(tweaponRec));
   {$I+}
   if ioResult <> 0 then Exit;
{   numWeapon := FileSize(F);}
   Seek(F,w.Number-1);
   {$I-}
   BlockRead(F,weapon^,1);
   {$I+}
{   if ioresult <> 0 then defaultweapon(w.number);}
   if ioresult <> 0 then begin weaponload:=false; end else
   Close(F);
end;

function loadroom(r:troomrec):boolean;
var F : file;
begin
   loadroom:=true;
   if r.Number < 1 then Exit;
   Assign(F,'rooms.dat');
   {$I-}
   Reset(F,SizeOf(troomRec));
   {$I+}
   if ioResult <> 0 then Exit;
{   numroom := FileSize(F);}
   Seek(F,r.Number-1);
   {$I-}
   BlockRead(F,room^,1);
   {$I+}
{   if ioresult <> 0 then defaultweapon(w.number);}
   if ioresult <> 0 then begin loadroom:=false; end else
   Close(F);
end;
function loadevent(r:teventrec):boolean;
var F : file;
begin
   loadevent:=true;
   if r.Number < 1 then Exit;
   Assign(F,'events.dat');
   {$I-}
   Reset(F,SizeOf(teventRec));
   {$I+}
   if ioResult <> 0 then Exit;
{   numevent := FileSize(F);}
   Seek(F,r.Number-1);
   {$I-}
   BlockRead(F,event^,1);
   {$I+}
{   if ioresult <> 0 then defaultweapon(w.number);}
   if ioresult <> 0 then begin loadevent:=false; end else
   Close(F);
end;

function loaditem(i:titemrec):boolean;
var F : file;
begin
   loaditem:=true;
   if i.Number < 1 then Exit;
   Assign(F,'items.dat');
   {$I-}
   Reset(F,SizeOf(titemRec));
   {$I+}
   if ioResult <> 0 then Exit;
{   numitem := FileSize(F);}
   Seek(F,i.Number-1);
   {$I-}
   BlockRead(F,item^,1);
   {$I+}
{   if ioresult <> 0 then defaultweapon(w.number);}
   if ioresult <> 0 then begin loaditem:=false; end else
   Close(F);
end;

function loadarmor(a:tarmorrec) :boolean;
var F : file;
begin
   loadarmor:=true;
   if a.Number < 1 then Exit;
   Assign(F,'armors.dat');
   {$I-}
   Reset(F,SizeOf(tarmorRec));
   {$I+}
   if ioResult <> 0 then Exit;
{   numarmor := FileSize(F);}
{$I-}   Seek(F,a.Number-1); {$I+}
   {$I-}
   BlockRead(F,armor^,1);
   {$I+}
   if ioresult <> 0 then begin loadarmor:=false; end else
   Close(F);
end;
{$I armo.PAS}
{$I weap.PAS}
{$I roomedit.pas}
{$I edit2.pas}
procedure armorflags;
var ch:char; quit : boolean;
begin
quit:=false;
repeat
clrscr;
textcolor(15); cwrite('['); textcolor(14); cwrite('1'); textcolor(15); cwrite(']');
cwrite(' ');
if mag1 in armor^.flag then textcolor(15) else textcolor(8);cwriteln('+1 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('2'); textcolor(15); cwrite(']');
cwrite(' ');
if mag2 in armor^.flag then textcolor(15) else textcolor(8);cwriteln('+2 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('3'); textcolor(15); cwrite(']');
cwrite(' ');
if mag3 in armor^.flag then textcolor(15) else textcolor(8);cwriteln('+3 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('4'); textcolor(15); cwrite(']');
cwrite(' ');
if mag4 in armor^.flag then textcolor(15) else textcolor(8);cwriteln('+4 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('5'); textcolor(15); cwrite(']');
cwrite(' ');
if mag5 in armor^.flag then textcolor(15) else textcolor(8);cwriteln('+5 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('A'); textcolor(15); cwrite(']');
cwrite(' ');
if cursed in armor^.flag then textcolor(15) else textcolor(8); cwriteln('cursed ');
textcolor(15); cwrite('['); textcolor(14); cwrite('B'); textcolor(15); cwrite(']');
cwrite(' ');
if fire in armor^.flag then textcolor(15) else textcolor(8);cwriteln('fire ');
textcolor(15); cwrite('['); textcolor(14); cwrite('C'); textcolor(15); cwrite(']');
cwrite(' ');
if cold in armor^.flag then textcolor(15) else textcolor(8); cwriteln('cold ');
textcolor(15); cwrite('['); textcolor(14); cwrite('D'); textcolor(15); cwrite(']');
cwrite(' ');
if ice in armor^.flag then textcolor(15) else textcolor(8); cwriteln('ice ');
textcolor(15); cwrite('['); textcolor(14); cwrite('E'); textcolor(15); cwrite(']');
cwrite(' ');
if poisond in armor^.flag then textcolor(15) else textcolor(8);cwriteln('poison ');
textcolor(7);
cwriteln('');
cwriteln('Enter the number/letter of the one to change, Q to end...');
repeat
ch:=readkey;
until upcase(ch) in ['1'..'5','A'..'E','Q'];
case upcase(ch) of
'1': begin
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1] else
                                        armor^.flag:=armor^.flag+[mag1];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5]; end;
'2': begin
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2] else
                                        armor^.flag:=armor^.flag+[mag2];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5];
end;
'3': begin
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3] else
                                        armor^.flag:=armor^.flag+[mag3];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5];
end;

'4': begin
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4] else
                                        armor^.flag:=armor^.flag+[mag4];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5];
end;

'5': begin
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5] else
                                        armor^.flag:=armor^.flag+[mag5];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
end;

'A': begin
           if cursed in armor^.flag then armor^.flag:=armor^.flag-[cursed] else
                                        armor^.flag:=armor^.flag+[cursed];
end;
'B': begin
           if fire in armor^.flag then armor^.flag:=armor^.flag-[fire] else
                                        armor^.flag:=armor^.flag+[fire];
end;
'C': begin
           if cold in armor^.flag then armor^.flag:=armor^.flag-[cold] else
                                        armor^.flag:=armor^.flag+[cold];
end;
'D': begin
           if ice in armor^.flag then armor^.flag:=armor^.flag-[ice] else
                                        armor^.flag:=armor^.flag+[ice];
end;
'E': begin
           if poisond in armor^.flag then armor^.flag:=armor^.flag-[poisond] else
                                        armor^.flag:=armor^.flag+[poisond];
end;
'Q': quit:=true;
end;
until quit;
quit:=false;
armorsave(armor^);
end;

procedure editarmor;
var s:string; ch:char; quit:boolean; b:byte; y:integer;
begin;
quit:=false;
repeat
loadarmor(armor^);
clrscr;
{move(armor_edit,mem[$b800:0000],1600); textcolor(15);}
gotoxy(7,1); str(armor^.number,s); cwrite(s); textcolor(7); cwrite(' of ');
textcolor(15); str(numarmor,s); cwrite(s);
gotoxy(16,3); cwrite(armor^.name);
gotoxy(16,4); str(armor^.acprot,s); cwrite(s);
gotoxy(16,5); textcolor(15);
if mag1 in armor^.flag then begin gotoxy(16,5); cwrite('+1'); end;
if mag2 in armor^.flag then begin gotoxy(19,5); cwrite('+2'); end;
if mag3 in armor^.flag then begin gotoxy(22,5); cwrite('+3'); end;
if mag4 in armor^.flag then begin gotoxy(25,5); cwrite('+4'); end;
if mag5 in armor^.flag then begin gotoxy(28,5); cwrite('+5'); end;
if cursed in armor^.flag then begin gotoxy(31,5); cwrite('cursed'); end;
if fire in armor^.flag then begin gotoxy(38,5); cwrite('fire'); end;
if cold in armor^.flag then begin gotoxy(43,5); cwrite('cold'); end;
if ice in armor^.flag then begin gotoxy(48,5); cwrite('ice'); end;
if poisond in armor^.flag then begin gotoxy(52,5); cwrite('poison'); end;
gotoxy(16,6); str(armor^.value,s); cwrite(s);
gotoxy(1,12); textcolor(15);cwrite('[');textcolor(14);cwrite('[');textcolor(15);cwrite(']');
textcolor(14); cwrite('Previous');
gotoxy(1,13); textcolor(15);cwrite('[');textcolor(14);cwrite(']');textcolor(15);cwrite(']');
textcolor(14); cwrite('Next');
repeat
ch:=readkey;
until upcase(ch) in ['N','A','F','V','[',']','R','S','Q','#','-'];
case upcase(ch) of
'N': begin gotoxy(15,3); cwrite('____________________'); readln(armor^.name); armorsave(armor^); end;
'A': begin readln(s); val(s,armor^.acprot,y); armorsave(armor^); end;
'F': begin armorsave(armor^); armorflags; end;
'V': begin readln(s); val(s,armor^.value,y); armorsave(armor^);end;
'[': begin gotoxy(1,12); dec(armor^.number); if armor^.number=0 then inc(armor^.number);
           loadarmor(armor^); end;
']': begin gotoxy(1,13); inc(armor^.number); if armor^.number=0 then dec(armor^.number);
           if not loadarmor(armor^) then begin defaultarmor(armor^.number); armoradd(armor^); end; end;
'-': begin dec(armor^.number); loadarmor(armor^); inc(armor^.number); armorsave(armor^); end;
'R': loadarmor(armor^);
'S': armorsave(armor^);
'Q': quit:=true;
'#': begin readln(s); val(s,armor^.number,y); if not loadarmor(armor^) then armor^.number:=1; end;

end;
until quit;
end;

procedure weaponflags;
var ch:char; quit : boolean;
begin
quit:=false;
repeat
clrscr;
textcolor(15); cwrite('['); textcolor(14); cwrite('1'); textcolor(15); cwrite(']');
cwrite(' ');
if mag1 in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('+1 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('2'); textcolor(15); cwrite(']');
cwrite(' ');
if mag2 in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('+2 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('3'); textcolor(15); cwrite(']');
cwrite(' ');
if mag3 in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('+3 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('4'); textcolor(15); cwrite(']');
cwrite(' ');
if mag4 in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('+4 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('5'); textcolor(15); cwrite(']');
cwrite(' ');
if mag5 in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('+5 ');
textcolor(15); cwrite('['); textcolor(14); cwrite('A'); textcolor(15); cwrite(']');
cwrite(' ');
if cursed in weapon^.flag then textcolor(15) else textcolor(8); cwriteln('cursed ');
textcolor(15); cwrite('['); textcolor(14); cwrite('B'); textcolor(15); cwrite(']');
cwrite(' ');
if fire in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('fire ');
textcolor(15); cwrite('['); textcolor(14); cwrite('C'); textcolor(15); cwrite(']');
cwrite(' ');
if cold in weapon^.flag then textcolor(15) else textcolor(8); cwriteln('cold ');
textcolor(15); cwrite('['); textcolor(14); cwrite('D'); textcolor(15); cwrite(']');
cwrite(' ');
if ice in weapon^.flag then textcolor(15) else textcolor(8); cwriteln('ice ');
textcolor(15); cwrite('['); textcolor(14); cwrite('E'); textcolor(15); cwrite(']');
cwrite(' ');
if poisond in weapon^.flag then textcolor(15) else textcolor(8);cwriteln('poison ');
textcolor(7);
cwriteln('');
cwriteln('Enter the number/letter of the one to change, Q to end...');
repeat
ch:=readkey;
until upcase(ch) in ['1'..'5','A'..'E','Q'];
case upcase(ch) of
'1': begin
           if mag1 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag1] else
                                        weapon^.flag:=weapon^.flag+[mag1];
           if mag2 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag2];
           if mag3 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag3];
           if mag4 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag4];
           if mag5 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag5]; end;
'2': begin
           if mag2 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag2] else
                                        weapon^.flag:=weapon^.flag+[mag2];
           if mag1 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag1];
           if mag3 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag3];
           if mag4 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag4];
           if mag5 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag5];
end;
'3': begin
           if mag3 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag3] else
                                        weapon^.flag:=weapon^.flag+[mag3];
           if mag2 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag2];
           if mag1 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag1];
           if mag4 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag4];
           if mag5 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag5];
end;

'4': begin
           if mag4 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag4] else
                                        weapon^.flag:=weapon^.flag+[mag4];
           if mag2 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag2];
           if mag3 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag3];
           if mag1 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag1];
           if mag5 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag5];
end;

'5': begin
           if mag5 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag5] else
                                        weapon^.flag:=weapon^.flag+[mag5];
           if mag2 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag2];
           if mag3 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag3];
           if mag4 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag4];
           if mag1 in weapon^.flag then weapon^.flag:=weapon^.flag-[mag1];
end;

'A': begin
           if cursed in weapon^.flag then weapon^.flag:=weapon^.flag-[cursed] else
                                        weapon^.flag:=weapon^.flag+[cursed];
end;
'B': begin
           if fire in weapon^.flag then weapon^.flag:=weapon^.flag-[fire] else
                                        weapon^.flag:=weapon^.flag+[fire];
end;
'C': begin
           if cold in weapon^.flag then weapon^.flag:=weapon^.flag-[cold] else
                                        weapon^.flag:=weapon^.flag+[cold];
end;
'D': begin
           if ice in weapon^.flag then weapon^.flag:=weapon^.flag-[ice] else
                                        weapon^.flag:=weapon^.flag+[ice];
end;
'E': begin
           if poisond in weapon^.flag then weapon^.flag:=weapon^.flag-[poisond] else
                                        weapon^.flag:=weapon^.flag+[poisond];
end;
'Q': quit:=true;
end;
until quit;
quit:=false;
weaponsave(weapon^);
end;

procedure editweapontype;
var y:integer;
begin
clrscr;
if weapon^.wtype=1 then textcolor(15) else textcolor(8); writeln('1 Short Sword');
if weapon^.wtype=2 then textcolor(15) else textcolor(8); writeln('2 Long Sword');
if weapon^.wtype=3 then textcolor(15) else textcolor(8); writeln('3 Polearm');
if weapon^.wtype=4 then textcolor(15) else textcolor(8); writeln('4 Bow');
if weapon^.wtype=5 then textcolor(15) else textcolor(8); writeln('5 X-Bow');
if weapon^.wtype=6 then textcolor(15) else textcolor(8); writeln('6 2-h sword');
if weapon^.wtype=7 then textcolor(15) else textcolor(8); writeln('7 Bludgeoning');
if weapon^.wtype=8 then textcolor(15) else textcolor(8); writeln('8 Piercing');
if weapon^.wtype=9 then textcolor(15) else textcolor(8); writeln('9 Slashing');
readln(sp);
val(sp,weapon^.wtype,y);
end;

function weapontype:string;
begin
case weapon^.wtype of
1:weapontype:='Short Sword';
2:weapontype:='Long Sword';
3:weapontype:='Polearm';
4:weapontype:='Bow';
5:weapontype:='X-Bow';
6:weapontype:='2-h sword';
7:weapontype:='Bludgeoning';
8:weapontype:='Piercing';
9:weapontype:='Slashing';
else weapontype:='Error!'; end;
end;

procedure editweapon;
var s:string; ch:char; quit:boolean; b:byte; y:integer;
begin;
quit:=false;
repeat
weaponload(weapon^);
clrscr;
{move(weapon_edit,mem[$b800:0000],1760); textcolor(15);}
gotoxy(8,1); str(weapon^.number,s); cwrite(s); textcolor(7); cwrite(' of ');
textcolor(15); str(numweapon,s); cwrite(s);
gotoxy(16,3); cwrite(weapon^.name);
gotoxy(16,4); str(weapon^.numberofdmgdice,s); cwrite(s);
gotoxy(30,4); textcolor(15); cwrite('['); textcolor(9); cwrite('L'); textcolor(15); cwrite(']');
textcolor(1); cwrite('arge dmg '); str(weapon^.vslarge,s); cwrite(s);
gotoxy(30,6); cwrite('|15[|091|15]|01Weapon Range '); str(weapon^.wrange,s); cwrite(s);
gotoxy(30,7); cwrite('|15[|092|15]|01Weapon Type '); cwrite(weapontype);
gotoxy(16,5); textcolor(15);
if mag1 in weapon^.flag then begin gotoxy(16,5); cwrite('+1'); end;
if mag2 in weapon^.flag then begin gotoxy(19,5); cwrite('+2'); end;
if mag3 in weapon^.flag then begin gotoxy(22,5); cwrite('+3'); end;
if mag4 in weapon^.flag then begin gotoxy(25,5); cwrite('+4'); end;
if mag5 in weapon^.flag then begin gotoxy(28,5); cwrite('+5'); end;
if cursed in weapon^.flag then begin gotoxy(31,5); cwrite('cursed'); end;
if fire in weapon^.flag then begin gotoxy(38,5); cwrite('fire'); end;
if cold in weapon^.flag then begin gotoxy(43,5); cwrite('cold'); end;
if ice in weapon^.flag then begin gotoxy(48,5); cwrite('ice'); end;
if poisond in weapon^.flag then begin gotoxy(52,5); cwrite('poison'); end;
gotoxy(16,6); str(weapon^.dicetype,s); cwrite(s);
gotoxy(16,7); str(weapon^.value,s); cwrite(s);
gotoxy(1,13); textcolor(15);cwrite('[');textcolor(14);cwrite('[');textcolor(15);cwrite(']');
textcolor(14); cwrite('Previous');
gotoxy(1,14); textcolor(15);cwrite('[');textcolor(14);cwrite(']');textcolor(15);cwrite(']');
textcolor(14); cwrite('Next');
repeat
ch:=readkey;
until upcase(ch) in ['N','A','F','V','I','[',']','R','S','Q','L','#','-','1','2'];
case upcase(ch) of
'N': begin gotoxy(15,3); cwrite('____________________'); readln(weapon^.name); weaponsave(weapon^); end;
'A': begin readln(s); val(s,weapon^.numberofdmgdice,y); weaponsave(weapon^); end;
'F': begin weaponsave(weapon^); weaponflags; end;
'1': begin readln(s); val(s,weapon^.wrange,y); weaponsave(weapon^); end;
'2': begin editweapontype; weaponsave(weapon^); end;
'V': begin readln(s); val(s,weapon^.value,y); weaponsave(weapon^);end;
'I': begin readln(s); val(s,weapon^.dicetype,y); weaponsave(weapon^);end;
'L': begin readln(s); val(s,weapon^.vslarge,y); weaponsave(weapon^); end;

'[': begin gotoxy(1,12); dec(weapon^.number); if weapon^.number=0 then inc(weapon^.number);
           weaponload(weapon^); end;
']': begin gotoxy(1,13); inc(weapon^.number); if weapon^.number=0 then dec(weapon^.number);
           if not weaponload(weapon^) then begin defaultweapon(weapon^.number); weaponadd(weapon^); end; end;

'R': weaponload(weapon^);
'S': weaponsave(weapon^);
'Q': quit:=true;
'#': begin readln(s); val(s,weapon^.number,y); if not weaponload(weapon^) then weapon^.number:=1; end;
'-': begin dec(weapon^.number); weaponload(weapon^); inc(weapon^.number); weaponsave(weapon^); end;
end;
until quit;

end;


function strRight(S : String; Len : Integer) : String;
var Stt : String; N : Integer;
begin
   Stt := '';
   for N := 1 to Len-(Length(S)) do Stt := Stt + ' ';
   Insert(Stt,S,1);
   strRight := S;
end;

function strLeft(S : String; Len : Integer) : String;
var Stt : String; N : Integer;
begin
   Stt := '';
   for N := 1 to (Length(S)) do if s[1]=' ' then delete(s,1,1);
   strleft := S;
end;
function strCenter(S : String; Len : Integer) : String;
var Stt : String; N : Integer;
begin
   Stt := '';
   s:=strleft(s,len);
   for N := 1 to (Len div 2)-(Length(S) div 2) do Stt := Stt + ' ';
   Insert(Stt,S,1);
   strCenter := S;
end;

procedure roomdesc;
var olddesc:array[1..7] of string; oldnum:word; x,z:byte; y:integer;
begin
bool:=false;
repeat
clrscr;
gotoxy(1,1); cwrite('1 '); cwrite(room^.desc[1]);
gotoxy(1,2); cwrite('2 '); cwrite(room^.desc[2]);
gotoxy(1,3); cwrite('3 '); cwrite(room^.desc[3]);
gotoxy(1,4); cwrite('4 '); cwrite(room^.desc[4]);
gotoxy(1,5); cwrite('5 '); cwrite(room^.desc[5]);
gotoxy(1,6); cwrite('6 '); cwrite(room^.desc[6]);
gotoxy(1,7); cwrite('7 '); cwrite(room^.desc[7]);
gotoxy(1,10); cwrite('Center a line');
gotoxy(1,11); cwrite('Right a line');
gotoxy(1,12); cwrite('Left a line');
gotoxy(1,13); cwrite('Move line');
gotoxy(1,14); cwrite('Use preceding room description');
gotoxy(1,15); cwrite('Quit');


repeat
cp:=readkey;
until upcase(cp) in ['1'..'7','Q','U','C','R','L','M'];
case upcase(cp) of
'1' : begin gotoxy(1,1); display(78); room^.desc[1]:=getinput(2,1); end;
'2' : begin gotoxy(1,2); display(78); room^.desc[2]:=getinput(2,2); end;
'3' : begin gotoxy(1,3); display(78); room^.desc[3]:=getinput(2,3); end;
'4' : begin gotoxy(1,4); display(78); room^.desc[4]:=getinput(2,4); end;
'5' : begin gotoxy(1,5); display(78); room^.desc[5]:=getinput(2,5); end;
'6' : begin gotoxy(1,6); display(78); room^.desc[6]:=getinput(2,6); end;
'7' : begin gotoxy(1,7); display(78); room^.desc[7]:=getinput(2,7); end;
'U' : begin oldnum:=room^.number; roomsave(room^); room^.number:=oldnum-1;
            loadroom(room^);
            for x:=1 to 7 do olddesc[x]:=room^.desc[x];
            room^.number:=oldnum; loadroom(room^);
            for x:=1 to 7 do room^.desc[x]:=olddesc[x];
            end;
'C' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','A','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y); room^.desc[x]:=strcenter(room^.desc[x],78); end;
            if cp = 'A' then for x:=1 to 7 do room^.desc[x]:=strcenter(room^.desc[x],78);
            end;
'R' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','A','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y); room^.desc[x]:=strright(room^.desc[x],78); end;
            if cp = 'A' then for x:=1 to 7 do room^.desc[x]:=strright(room^.desc[x],78);
            end;
'L' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','A','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y); room^.desc[x]:=strleft(room^.desc[x],78); end;
            if cp = 'A' then for x:=1 to 7 do room^.desc[x]:=strleft(room^.desc[x],78);
            end;
'M' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y);
            repeat cp:=upcase(readkey); until cp in ['1'..'7','0'];
            if cp in ['1'..'7'] then begin
              val(cp,z,y);
               room^.desc[z]:=room^.desc[x]; end; end;
            end;
'Q' : begin roomsave(room^); bool:=true; end;
end;

until bool;
end;

procedure roomconnect;
begin
bool:=false;
repeat
clrscr;
gotoxy(1,1); cwrite('1 (North) '); str(room^.connect[1],sp); cwrite(sp);
gotoxy(1,2); cwrite('2 (South) '); str(room^.connect[2],sp); cwrite(sp);
gotoxy(1,3); cwrite('3 (West)  '); str(room^.connect[3],sp); cwrite(sp);
gotoxy(1,4); cwrite('4 (East)  '); str(room^.connect[4],sp); cwrite(sp);
gotoxy(1,5); cwrite('5 (Up)    '); str(room^.connect[5],sp); cwrite(sp);
gotoxy(1,6); cwrite('6 (Down)  '); str(room^.connect[6],sp); cwrite(sp);
repeat
cp:=readkey;
until upcase(cp) in ['1'..'6','Q'];
case upcase(cp) of

'1' : begin   readln(sp); val(sp,room^.connect[1],yp);
       end;
'2' : begin   readln(sp); val(sp,room^.connect[2],yp);
       end;
'3' : begin   readln(sp); val(sp,room^.connect[3],yp);
       end;
'4' : begin   readln(sp); val(sp,room^.connect[4],yp);
       end;
'5' : begin   readln(sp); val(sp,room^.connect[5],yp);
       end;
'6' : begin   readln(sp); val(sp,room^.connect[6],yp);
     end;
'Q':begin bool:=true; end;
end;
until bool;
if (room^.connect[1])=0 then room^.flag:=room^.flag-['N'] else room^.flag:=room^.flag+['N'];
if (room^.connect[2])=0 then room^.flag:=room^.flag-['S'] else room^.flag:=room^.flag+['S'];
if (room^.connect[3])=0 then room^.flag:=room^.flag-['W'] else room^.flag:=room^.flag+['W'];
if (room^.connect[4])=0 then room^.flag:=room^.flag-['E'] else room^.flag:=room^.flag+['E'];
if (room^.connect[5])=0 then room^.flag:=room^.flag-['U'] else room^.flag:=room^.flag+['U'];
if (room^.connect[6])=0 then room^.flag:=room^.flag-['D'] else room^.flag:=room^.flag+['D'];
roomsave(room^);
end;

procedure roomflags;
begin
clrscr;
bool:=false;
repeat
if 'Q' in room^.flag then begin end else room^.flag:=room^.flag+['Q'];
if 'N' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,1); cwrite('North');
if 'S' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,2); cwrite('South');
if 'W' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,3); cwrite('West');
if 'E' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,4); cwrite('East');
if 'U' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,5); cwrite('Up');
if 'D' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,6); cwrite('Down');
if 'A' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,7); cwrite('Attack');
if 'C' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,8); cwrite('Cast spell');
if 'R' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,9); cwrite('eat/dRink');
if 'T' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,10); cwrite('Take item');
if 'I' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,11); cwrite('use Item');
if 'H' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,12); cwrite('Help');
if 'Q' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,13); cwrite('Quit');
if 'Y' in room^.flag then begin textcolor(15); end else begin textcolor(8); end; gotoxy(1,14); cwrite('citY');
repeat
cp:=readkey;
until upcase(cp) in ['N','S','W','E','U','D','A','C','R','T','I','H','Q','Y'];
case upcase(cp) of
'N': if 'N' in room^.flag then begin  room^.flag:=room^.flag-['N']; end else begin
room^.flag:=room^.flag+['N']; end;
'S': if 'S' in room^.flag then begin  room^.flag:=room^.flag-['S']; end else begin
room^.flag:=room^.flag+['S']; end;
'W': if 'W' in room^.flag then begin  room^.flag:=room^.flag-['W']; end else begin
room^.flag:=room^.flag+['W']; end;
'E': if 'E' in room^.flag then begin  room^.flag:=room^.flag-['E']; end else begin
room^.flag:=room^.flag+['E']; end;
'U': if 'U' in room^.flag then begin  room^.flag:=room^.flag-['U']; end else begin
room^.flag:=room^.flag+['U']; end;
'D': if 'D' in room^.flag then begin  room^.flag:=room^.flag-['D']; end else begin
room^.flag:=room^.flag+['D']; end;
'A': if 'A' in room^.flag then begin  room^.flag:=room^.flag-['A']; end else begin
room^.flag:=room^.flag+['A']; end;
'C': if 'C' in room^.flag then begin  room^.flag:=room^.flag-['C']; end else begin
room^.flag:=room^.flag+['C']; end;
'R': if 'R' in room^.flag then begin  room^.flag:=room^.flag-['R']; end else begin
room^.flag:=room^.flag+['R']; end;
'T': if 'T' in room^.flag then begin  room^.flag:=room^.flag-['T']; end else begin
room^.flag:=room^.flag+['T']; end;
'I': if 'I' in room^.flag then begin  room^.flag:=room^.flag-['I']; end else begin
room^.flag:=room^.flag+['I']; end;
'Y': if 'Y' in room^.flag then begin  room^.flag:=room^.flag-['Y']; end else begin
room^.flag:=room^.flag+['Y']; end;
'Q': begin  roomsave(room^); bool:=true; end;
end;
until bool;
end;

procedure roomterrain;
var s:string; x,y:integer;
begin
clrscr;
if (room^.terrain=0) then textcolor(15) else textcolor(8);   cwrite('0 forest          ');
if (room^.terrain=1) then textcolor(15) else textcolor(8); cwriteln('1 desert          ');
if (room^.terrain=2) then textcolor(15) else textcolor(8);   cwrite('2 artic           ');
if (room^.terrain=3) then textcolor(15) else textcolor(8); cwriteln('3 toundra         ');
if (room^.terrain=4) then textcolor(15) else textcolor(8);   cwrite('4 mountains       ');
if (room^.terrain=5) then textcolor(15) else textcolor(8); cwriteln('5 hills           ');
if (room^.terrain=6) then textcolor(15) else textcolor(8);   cwrite('6 grasslands      ');
if (room^.terrain=7) then textcolor(15) else textcolor(8); cwriteln('7 plain           ');
if (room^.terrain=8) then textcolor(15) else textcolor(8);   cwrite('8 water           ');
if (room^.terrain=9) then textcolor(15) else textcolor(8); cwriteln('9 beach           ');
if (room^.terrain=10) then textcolor(15) else textcolor(8);   cwrite('10 forest(fly)    ');
if (room^.terrain=11) then textcolor(15) else textcolor(8); cwriteln('11 desert(fly)    ');
if (room^.terrain=12) then textcolor(15) else textcolor(8);   cwrite('12 artic(fly)     ');
if (room^.terrain=13) then textcolor(15) else textcolor(8); cwriteln('13 toundra(fly)   ');
if (room^.terrain=14) then textcolor(15) else textcolor(8);   cwrite('14 mountains(fly) ');
if (room^.terrain=15) then textcolor(15) else textcolor(8); cwriteln('15 hills(fly)     ');
if (room^.terrain=16) then textcolor(15) else textcolor(8);   cwrite('16 grasslands(fly)');
if (room^.terrain=17) then textcolor(15) else textcolor(8); cwriteln('17 plain(fly)     ');
if (room^.terrain=18) then textcolor(15) else textcolor(8);   cwrite('18 water(fly)     ');
if (room^.terrain=19) then textcolor(15) else textcolor(8); cwriteln('19 beach(fly)     ');
if (room^.terrain=20) then textcolor(15) else textcolor(8);   cwrite('20 caves          ');
if (room^.terrain=21) then textcolor(15) else textcolor(8); cwriteln('21 underground    ');
if (room^.terrain=22) then textcolor(15) else textcolor(8);   cwrite('22 underdark      ');
if (room^.terrain=23) then textcolor(15) else textcolor(8); cwriteln('23 large cave     ');
if (room^.terrain=24) then textcolor(15) else textcolor(8);   cwrite('24 underwater     ');
if (room^.terrain=25) then textcolor(15) else textcolor(8); cwriteln('25 deep underwater');
if (room^.terrain=26) then textcolor(15) else textcolor(8);   cwrite('26 swamp          ');
if (room^.terrain=27) then textcolor(15) else textcolor(8); cwriteln('27 water          ');
if (room^.terrain=28) then textcolor(15) else textcolor(8);   cwrite('28 salt water     ');

if (room^.terrain=255) then textcolor(15) else textcolor(8);   cwrite('255 Dark Ville    ');
repeat
readln(s);
val(s,x,y);
until x in [0..28,255];
room^.terrain:=x;
roomsave(room^);
end;

procedure roomcircle;
var s:string[2]; x:integer;
begin
clrscr;
cwriteln('0  None');
cwriteln('1  Honor');
cwriteln('2  Health');
cwriteln('3  Love');
cwriteln('4  White Magic');
cwriteln('5  Nature');
cwriteln('6  Death');
cwriteln('7  Life');
cwriteln('8  Neutral Magic');
cwriteln('9  War');
cwriteln('10 Greed');
cwriteln('11 Treachery');
cwriteln('12 Dark Magic');
cwriteln('13 Atheist');
cwriteln('');
repeat
readln(s);
val(s,room^.circle,x);
until (room^.circle) in [0..13];
end;

procedure editROOM;
var s:string; ch:char; quit:boolean; b:byte; y:integer;
begin;
quit:=false;
repeat
loadroom(room^);
clrscr;
{move(room_editor,mem[$b800:0000],2400); textcolor(15);}
gotoxy(6,1); str(room^.number,s); cwrite(s); textcolor(7); cwrite(' of ');
textcolor(15); str(numroom,s); cwrite(s);
gotoxy(22,3); cwrite(room^.name);
gotoxy(22,4); str(room^.event,s); cwrite(s);
gotoxy(22,7); textcolor(15);
room^.city:=0;
gotoxy(22,8); if room^.hardcodedspecial then cwrite('true') else cwrite('false');
gotoxy(22,5); str(room^.critter,s); cwrite(s);
gotoxy(22,6); str(room^.critterlevel,s); cwrite(s);
gotoxy(22,9);
gotoxy(22,10);
gotoxy(1,11); cwrite('Monster Chance');
gotoxy(22,11); str(room^.monsterchance,s); cwrite(s);
textcolor(12);
gotoxy(28,8); cwrite('1 Clear Text?');
textcolor(15);
gotoxy(49,8);
if room^.cleartext then cwrite('true') else cwrite('false');

gotoxy(1,15); cwrite('2 Terrain type: ');
textcolor(15);
case room^.terrain of
0 : cwriteln('forest');
1 : cwriteln('desert');
2 : cwriteln('artic');
3 : cwriteln('toundra');
4 : cwriteln('mountains');
5 : cwriteln('hills');
6 : cwriteln('grasslands');
7 : cwriteln('plain');
8 : cwriteln('water');
9 : cwriteln('beach');
10: cwriteln('forest(fly)');
11: cwriteln('desert(fly)');
12: cwriteln('artic(fly)');
13: cwriteln('toundra(fly)');
14: cwriteln('mountains(fly)');
15: cwriteln('hills(fly)');
16: cwriteln('grasslands(fly)');
17: cwriteln('plain(fly)');
18: cwriteln('water(fly)');
19: cwriteln('beach(fly)');
20: cwriteln('caves');
21: cwriteln('underground');
22: cwriteln('underdark');
23: cwriteln('large cave');
24: cwriteln('underwater');
25: cwriteln('deep underwater');
26: cwriteln('swamp');
27: cwriteln('water');
28: cwriteln('salt water');

255: cwriteln('Dark Ville');
else
begin
room^.terrain:=0;
roomsave(room^);
cwriteln('Reload!');
end;
end;
gotoxy(1,16);
cwrite('4 City present ');
str(room^.city,s); cwrite(s);
textcolor(12);
gotoxy(28,9); cwrite('3 Circle deity ');
textcolor(15);
gotoxy(49,9);
case room^.circle of
0:cwriteln('None');
1:cwriteln('Honor');
2:cwriteln('Health');
3:cwriteln('Love');
4:cwriteln('White Magic');
5:cwriteln('Nature');
6:cwriteln('Death');
7:cwriteln('Life');
8:cwriteln('Neutral Magic');
9:cwriteln('War');
10:cwriteln('Greed');
11:cwriteln('Treachery');
12:cwriteln('Dark Magic');
13:cwriteln('Atheist');
end;
repeat
ch:=readkey;
until upcase(ch) in ['N','E','C','L','F','H','T','D','[',']','R','S','Q','M','1'..'4','#','-'];
case upcase(ch) of
'-': begin dec(room^.number); loadroom(room^); inc(room^.number); roomsave(room^); end;
'N': begin gotoxy(22,3); cwrite('____________________'); readln(room^.name); roomsave(room^); end;
'E': begin readln(s); val(s,room^.event,y); roomsave(room^); end;
'F': begin roomsave(room^); roomflags; end;
'C': begin readln(s); val(s,room^.critter,y); roomsave(room^);end;
'L': begin readln(s); val(s,room^.critterlevel,y); roomsave(room^);end;
'H': begin if room^.hardcodedspecial then room^.hardcodedspecial:=false else room^.hardcodedspecial:=true; roomsave(room^);
 end;
'T': begin roomsave(room^); ROOMCONNECT; end;
'D': begin roomsave(room^); roomdesc; end;
'M': begin roomsave(room^); readln(s); val(s,room^.monsterchance,y); roomsave(room^); end;
'[': begin gotoxy(1,12); dec(room^.number); if room^.number=0 then inc(room^.number);
           loadroom(room^); end;
']': begin roomsave(room^); gotoxy(1,13); inc(room^.number); if room^.number=0 then dec(room^.number);
           if not loadroom(room^) then begin defaultroom(room^.number); roomadd(room^); end; end;
'R': loadroom(room^);
'S': roomsave(room^);
'Q': quit:=true;
'1': begin room^.cleartext:=not room^.cleartext; roomsave(room^); end;
'#': begin readln(s); val(s,room^.number,y); if not loadroom(room^) then room^.number:=1; end;
'2': begin roomterrain; roomsave(room^); end;
'3': begin roomcircle; roomsave(room^); end;
'4': begin readln(S); val(s,room^.city,y); roomsave(room^); end;
end;
until quit;
end;



procedure editeventdesc;
var olddesc:array[1..7] of string; oldnum:word; x,z:byte; y:integer;
begin
bool:=false;
repeat
clrscr;
gotoxy(1,1); cwrite('1 '); cwrite(event^.desc[1]);
gotoxy(1,2); cwrite('2 '); cwrite(event^.desc[2]);
gotoxy(1,3); cwrite('3 '); cwrite(event^.desc[3]);
gotoxy(1,4); cwrite('4 '); cwrite(event^.desc[4]);
gotoxy(1,5); cwrite('5 '); cwrite(event^.desc[5]);
gotoxy(1,6); cwrite('6 '); cwrite(event^.desc[6]);
gotoxy(1,7); cwrite('7 '); cwrite(event^.desc[7]);
gotoxy(1,10); cwrite('Center a line');
gotoxy(1,11); cwrite('Right a line');
gotoxy(1,12); cwrite('Left a line');
gotoxy(1,13); cwrite('Move line');
gotoxy(1,14); cwrite('Use preceding event description');
gotoxy(1,15); cwrite('Quit');


repeat
cp:=readkey;
until upcase(cp) in ['1'..'7','Q','U','C','R','L','M'];
case upcase(cp) of
'1' : begin gotoxy(1,1); display(78); event^.desc[1]:=getinput(2,1); end;
'2' : begin gotoxy(1,2); display(78); event^.desc[2]:=getinput(2,2); end;
'3' : begin gotoxy(1,3); display(78); event^.desc[3]:=getinput(2,3); end;
'4' : begin gotoxy(1,4); display(78); event^.desc[4]:=getinput(2,4); end;
'5' : begin gotoxy(1,5); display(78); event^.desc[5]:=getinput(2,5); end;
'6' : begin gotoxy(1,6); display(78); event^.desc[6]:=getinput(2,6); end;
'7' : begin gotoxy(1,7); display(78); event^.desc[7]:=getinput(2,7); end;
'U' : begin oldnum:=event^.number; eventsave(event^); event^.number:=oldnum-1;
            loadevent(event^);
            for x:=1 to 7 do olddesc[x]:=event^.desc[x];
            event^.number:=oldnum; loadevent(event^);
            for x:=1 to 7 do event^.desc[x]:=olddesc[x];
            end;
'C' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','A','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y); event^.desc[x]:=strcenter(event^.desc[x],78); end;
            if cp = 'A' then for x:=1 to 7 do event^.desc[x]:=strcenter(event^.desc[x],78);
            end;
'R' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','A','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y); event^.desc[x]:=strright(event^.desc[x],78); end;
            if cp = 'A' then for x:=1 to 7 do event^.desc[x]:=strright(event^.desc[x],78);
            end;
'L' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','A','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y); event^.desc[x]:=strleft(event^.desc[x],78); end;
            if cp = 'A' then for x:=1 to 7 do event^.desc[x]:=strleft(event^.desc[x],78);
            end;
'M' : begin repeat cp:=upcase(readkey); until cp in ['1'..'7','0'];
            if cp in ['1'..'7'] then begin
              val(cp,x,y);
            repeat cp:=upcase(readkey); until cp in ['1'..'7','0'];
            if cp in ['1'..'7'] then begin
              val(cp,z,y);
               event^.desc[z]:=event^.desc[x]; end; end;
            end;
'Q' : begin eventsave(event^); bool:=true; end;
end;

until bool;

end;

procedure editeventchecks;
var qt:boolean; st:string; yt:integer;
begin

qt:=false;
{
}
repeat
clrscr;
{move(edit2,mem[$b800:0000],1440); textcolor(15);}

textcolor(15);
gotoxy(23,1); if event^.strm then cwrite('Yup!') else cwrite('Nope!');
gotoxy(23,2); if event^.dexm then cwriteln('Yup!') else cwriteln('Nope!');
gotoxy(23,3); if event^.intm then cwriteln('Yup!') else cwriteln('Nope!');
gotoxy(23,4); if event^.conm then cwrite('Yup!') else cwrite('Nope!');
gotoxy(57,1); if event^.wism then cwriteln('Yup!') else cwriteln('Nope!');
gotoxy(57,2); if event^.cham then cwrite('Yup!') else cwrite('Nope!');
gotoxy(57,3); if event^.comm then cwrite('Yup!') else cwrite('Nope!');
gotoxy(23,6); str(event^.str,st); cwrite(st);
gotoxy(23,7); str(event^.dex,st); cwrite(st);
gotoxy(23,8); str(event^.int,st); cwrite(st);
gotoxy(23,9); str(event^.con,st); cwrite(st);
gotoxy(57,6); str(event^.wis,st); cwrite(st);
gotoxy(57,7); str(event^.cha,st); cwrite(st);
gotoxy(57,8); str(event^.com,st); cwrite(st);

repeat
cp:=readkey;
until upcase(cp) in ['A'..'G','1'..'7','Q','!'];
case upcase(cp) of
'1': begin  if event^.STRm THen event^.strm:=false else event^.strm:=true;
eventsave(event^); end;
'2': begin  if event^.dexm then event^.dexm:=false else event^.dexm:=true;
eventsave(event^); end;
'3': begin  if event^.intm then event^.intm:=false else event^.intm:=true;
eventsave(event^); end;
'4': begin  if event^.conm then event^.conm:=false else event^.conm:=true;
eventsave(event^); end;
'5': begin  if event^.wism then event^.wism:=false else event^.wism:=true;
eventsave(event^); end;
'6': begin  if event^.cham then event^.cham:=false else event^.cham:=true;
eventsave(event^); end;
'7': begin  if event^.comm then event^.comm:=false else event^.comm:=true;
eventsave(event^); end;
'A': begin  readln(st); val(st,event^.str,yt); eventsave(event^); end;
'B': begin  readln(st); val(st,event^.dex,yt); eventsave(event^); end;
'C': begin  readln(st); val(st,event^.int,yt); eventsave(event^); end;
'D': begin  readln(st); val(st,event^.con,yt); eventsave(event^); end;
'E': begin  readln(st); val(st,event^.wis,yt); eventsave(event^); end;
'F': begin  readln(st); val(st,event^.cha,yt); eventsave(event^); end;
'G': begin  readln(st); val(st,event^.com,yt); eventsave(event^); end;
'Q': begin  qt:=true; end;
'!': begin
event^.strm:=true;
event^.dexm:=true;
event^.conm:=true;
event^.comm:=true;
event^.cham:=true;
event^.wism:=true;
event^.intm:=true;
eventsave(event^);
                  end;
end;

until qt;

{dispose(sp); }

end;

procedure editevent;
var s:string; quit:boolean; n:integer; y:integer;
begin
quit:=false; n:=1;
repeat
if not loadevent(event^) then begin defaultevent(event^.number); eventadd(event^); end;
clrscr;
cwrite('Event '); str(event^.number,s); cwrite(s+' of '); str(numevent,s); cwriteln(s);
cwriteln('');
cwrite('M Can this event occur multiple times? '); if not event^.multiple then cwriteln('True') else cwriteln('False');
cwriteln('0 edit description');
cwrite('1 Give money           '); str(event^.givemoney,s); cwrite(s);  cwrite('          '); cwrite('A Increase Deity Rank ');
              if event^.incrank then cwriteln('Yeah') else cwriteln('Nope');
cwrite('2 Give weapon          '); str(event^.giveweapon,s); cwriteln(s);
cwrite('3 Give armor           '); str(event^.givearmor,s); cwriteln(s);
cwrite('4 Give item            '); str(event^.giveitem,s); cwriteln(s);
cwrite('5 Give xp              '); str(event^.givexp,s); cwriteln(s);
cwrite('6 Take or Give armor?  '); if event^.giveortake[1] then cwriteln('Give') else cwriteln('Take');
cwrite('7 Take or Give weapon? '); if event^.giveortake[2] then cwriteln('Give') else cwriteln('Take');
cwrite('8 Take or Give item?   '); if event^.giveortake[3] then cwriteln('Give') else cwriteln('Take');
cwrite('9 Quantity of item?    '); str(event^.givehowmuchitem,s); cwriteln(s);
cwrite('H Chain with event #   '); str(event^.nextevent,s); cwriteln(s);
cwrite('I Chain with combat    '); str(event^.combatmonster,s); cwrite(s);
cwrite('            ');
cwrite('J Number of Monster    '); str(event^.nummonster,s); cwriteln(s);
cwrite('O Death String         '); cwriteln(event^.deathstring);
cwrite('P Instant Death        '); if event^.instantdeath then cwrite('Yup!      ') else cwrite('Nope!     ');
cwrite('K Check fail event     '); str(event^.failure,s); cwriteln(s);
cwrite('R Clear text           '); if event^.cleartext then cwrite('Yup!      ') else cwrite('Nope!     ');
cwrite('L If event did event   '); str(event^.eventdid,s); cwriteln(s);
cwrite('N HP change            '); str(event^.hpvar,s); cwriteln(s);
cwrite('G Checks               ');
cwrite('F Run from combat allowed'); if event^.crun then cwriteln('Yup') else cwriteln('Nope!');
cwriteln('');
cwriteln('Q quit');

repeat
cp:=readkey;
until upcase(cp) in ['0'..'9','F'..'R','[',']','#','A','-'];
case upcase(cp) of
'-': begin dec(event^.number); loadevent(event^); inc(event^.number); eventsave(event^); end;
'A': begin  event^.incrank:=not event^.incrank; eventsave(event^); end;
'M': begin  if event^.multiple then event^.multiple:=false else event^.multiple:=true; eventsave(event^); end;
'0': begin  editeventdesc; end;
'1': begin  readln(s); val(s,event^.givemoney,y); eventsave(event^); end;
'2': begin  readln(s); val(s,event^.giveweapon,y); eventsave(event^); end;
'3': begin  readln(s); val(s,event^.givearmor,y); eventsave(event^); end;
'4': begin  readln(s); val(s,event^.giveitem,y); eventsave(event^); end;
'5': begin  readln(s); val(s,event^.givexp,y); eventsave(event^); end;
'6': begin  if event^.giveortake[1] then event^.giveortake[1]:=false else event^.giveortake[1]:=true;
eventsave(event^); end;
'7': begin  if event^.giveortake[2] then event^.giveortake[2]:=false else event^.giveortake[2]:=true;
eventsave(event^); end;
'8': begin  if event^.giveortake[3] then event^.giveortake[3]:=false else event^.giveortake[3]:=true;
eventsave(event^); end;
'9': begin  readln(s); val(s,event^.givehowmuchitem,y); eventsave(event^); end;

'G': begin  editeventchecks; eventsave(event^); end;
'H': begin  readln(s); val(s,event^.nextevent,y); eventsave(event^); end;
'I': begin  readln(s); val(s,event^.combatmonster,y); eventsave(event^); end;
'J': begin  readln(s); val(s,event^.nummonster,y); eventsave(event^); end;
'K': begin  readln(s); val(s,event^.failure,y); eventsave(event^); end;
'N': begin  readln(s); val(s,event^.hpvar,y); eventsave(event^); end;
'O': begin  readln(event^.deathstring); eventsave(event^); end;
'P': begin  if event^.instantdeath then event^.instantdeath:=false else event^.instantdeath:=true;
eventsave(event^); end;
'Q': begin  quit:=true; end;
'L': begin  readln(s); val(s,event^.eventdid,y); eventsave(event^); end;
'R': begin  event^.cleartext:=not event^.cleartext; eventsave(event^); end;
']': begin  eventsave(event^); if not (event^.number=2147483647) then inc(event^.number); end;
'[': begin  eventsave(event^); if not (event^.number<=1) then dec(event^.number); end;
'F': begin  event^.crun:=not event^.crun; eventsave(event^); end;
'#': begin  readln(s); val(s,event^.number,y); if not loadevent(event^) then event^.number:=1; end;
end;
until (quit);
end;

procedure setitemtype;
var ch2:char; quit:boolean;
begin
quit:=false;
repeat
clrscr;
if tclothe in item^.itype then textcolor(15) else textcolor(8);
cwriteln('1 clothe');
if tmisc in item^.itype then textcolor(15) else textcolor(8);
cwriteln('2 misc');
if trod in item^.itype then textcolor(15) else textcolor(8);
cwriteln('3 rod');
if twand in item^.itype then textcolor(15) else textcolor(8);
cwriteln('4 wand');
if tamulet in item^.itype then textcolor(15) else textcolor(8);
cwriteln('5 amulet');
if tpotion in item^.itype then textcolor(15) else textcolor(8);
cwriteln('6 potion');
if tscroll in item^.itype then textcolor(15) else textcolor(8);
cwriteln('7 scroll');
if tmagicitem in item^.itype then textcolor(15) else textcolor(8);
cwriteln('8 magic item');
if tidentify in item^.itype then textcolor(15) else textcolor(8);
cwriteln('9 needs identification');
if tmap in item^.itype then textcolor(15) else textcolor(8);
cwriteln('0 map');


repeat
ch2:=readkey;
until upcase(ch2) in ['0'..'9','Q'];
case upcase(ch2) of
'1': item^.itype:=[tclothe];
'2': item^.itype:=[tmisc];
'3': item^.itype:=[trod];
'4': item^.itype:=[twand];
'5': item^.itype:=[tamulet];
'6': item^.itype:=[tpotion];
'7': item^.itype:=[tscroll];
'8': if tmagicitem in item^.itype then item^.itype:=item^.itype-[tmagicitem] else item^.itype:=item^.itype+[tmagicitem];
'9': if tidentify in item^.itype then item^.itype:=item^.itype-[tidentify] else item^.itype:=item^.itype+[tidentify];
'0': item^.itype:=[tmap];
'Q': quit:=true;
end;
until quit;
itemsave(item^);
end;

procedure setitemeffect;
var ch2:char; quit:boolean;
begin
quit:=false;
repeat
clrscr;
if item^.effect=[] then item^.effect:=[efnone];
if efheal in item^.effect then textcolor(15) else textcolor(8);
cwriteln('1 heal');
if eftransport in item^.effect then textcolor(15) else textcolor(8);
cwriteln('2 transport');
if efdamage in item^.effect then textcolor(15) else textcolor(8);
cwriteln('3 damage');
if efpoison in item^.effect then textcolor(15) else textcolor(8);
cwriteln('4 poison');
if efnone in item^.effect then textcolor(15) else textcolor(8);
cwriteln('5 none');
repeat
ch2:=readkey;
until upcase(ch2) in ['1'..'5','Q'];
case upcase(ch2) of
'1': begin if efheal in item^.effect then item^.effect:=item^.effect-[efheal] else begin item^.effect:=item^.effect-[efnone];
item^.effect:=item^.effect+[efheal]; end; end;

'2': begin if eftransport in item^.effect then item^.effect:=item^.effect-[eftransport] else begin
item^.effect:=item^.effect-[efnone];
item^.effect:=item^.effect+[eftransport]; end; end;

'3': begin if efdamage in item^.effect then item^.effect:=item^.effect-[efdamage] else begin
item^.effect:=item^.effect-[efnone];
item^.effect:=item^.effect+[efdamage]; end; end;

'4': begin if efpoison in item^.effect then item^.effect:=item^.effect-[efpoison] else begin
item^.effect:=item^.effect-[efnone];
item^.effect:=item^.effect+[efpoison]; end; end;

'5': begin if efnone in item^.effect then begin end else item^.effect:=[efnone]; end;

'Q':quit:=true;
end;
until quit;
itemsave(item^);
end;

procedure edititem;
var ch:char; s:string; y:integer;
begin

bool:=false;
repeat
if not loaditem(item^) then begin defaultitem(item^.number); itemadd(item^); end;
clrscr;
str(item^.number,s);
cwrite('Item '+s+' of ');
str(numitem,s);
cwriteln(s);
cwriteln('');
textcolor(14); cwrite('N'); textcolor(9); cwrite(' Item Name       '); textcolor(12); cwriteln(item^.name);
textcolor(14); cwrite('E'); textcolor(9); cwriteln(' Effect type     '); textcolor(12);
if not (eftransport in item^.effect) then begin
textcolor(14); cwrite('D'); textcolor(9); cwrite(' Dice            '); textcolor(12); str(item^.dicetype,s); cwriteln(s); end
else
begin
textcolor(14); cwrite('D'); textcolor(9); cwrite(' Destination     '); textcolor(12); str(item^.dicetype,s); cwriteln(s); end;
textcolor(14); cwrite('U'); textcolor(9); cwrite(' Number of Dice  '); textcolor(12); str(item^.numberdice,s); cwriteln(s);
textcolor(14); cwrite('1'); textcolor(9); cwrite(' Item Effect str '); textcolor(12); cwriteln(item^.effectstring);
textcolor(14); cwrite('2'); textcolor(9); cwrite(' Item Value      '); textcolor(12); str(item^.value,s); cwriteln(s);
textcolor(14); cwrite('3'); textcolor(9); cwrite(' Can buy item?   '); textcolor(12); if item^.buyable then cwriteln('Yeah!')
else
 cwriteln('Nope!');
textcolor(14); cwrite('4'); textcolor(9); cwrite(' Can sell item?  '); textcolor(12); if item^.sellable then cwriteln('Yeah!')
else cwriteln('Nope!');
textcolor(14); cwrite('5'); textcolor(9); cwriteln(' Item type       '); textcolor(12);
textcolor(14); cwrite('6'); textcolor(9); cwrite(' # of charge     '); textcolor(12); str(item^.charges,s); cwriteln(s);
textcolor(14); cwrite('7'); textcolor(9); cwrite(' File to display '); textcolor(12); cwriteln(item^.usefile);
cwriteln('');
repeat
ch:=readkey;
until upcase(ch) in ['N','E','D','U','1'..'7','[',']','Q','#','-'];
case upcase(ch) of
'-': begin dec(item^.number); loaditem(item^); inc(item^.number); itemsave(item^); end;
'N': begin readln(item^.name); itemsave(item^); end;
'E': setitemeffect;
'D': begin readln(s); val(s,item^.dicetype,y); itemsave(item^); end;
'U': begin readln(s); val(s,item^.numberdice,y); itemsave(item^); end;
'1': begin readln(item^.effectstring); itemsave(item^); end;
'2': begin readln(S); val(s,item^.value,y); itemsave(item^); end;
'3': begin if item^.buyable then item^.buyable:=false else item^.buyable:=true; itemsave(item^); end;
'4': begin if item^.sellable then item^.sellable:=false else item^.sellable:=true; itemsave(item^); end;
'5': setitemtype;
'6': begin readln(s); val(s,item^.charges,y); itemsave(item^); end;
'7': begin readln(s); item^.usefile:=s; itemsave(item^); end;
']': begin itemsave(item^); if not (item^.number=255) then inc(item^.number); end;
'[': begin itemsave(item^); if not (item^.number=1) then dec(item^.number); end;
'Q': bool:=true;
'#': begin readln(s); val(s,item^.number,y); if not loaditem(item^) then item^.number:=1; end;

end;

until bool;
end;


procedure defaultmonster(n:word);
begin
 with monster^ do begin
 number:=n;
 name:='Dummy monster';
 ac:=0;
skills:=[];
disadvan:=[];
level:=1;
thac0:=1;
minhitpoints:=1;
maxhitpoints:=10;
 xp:=0;
 numberofdmgdice:=1;
 dicetype:=8;
 vslarge:=1;
 select:=true;
 speed:=3;
         FillChar(Reserved,SizeOf(Reserved),0);
 end;
end;

procedure monsterAdd(var m : tmonsterRec);
var F : file of tmonsterRec;
    N : Word; T : tmonsterrec; Done : Boolean;
begin
   Assign(F,'monsters.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      m.Number := 1;
      rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
{$I-}         Read(F,T);  {$I+}
         Inc(N,1);
         Done := Eof(F);
      end;
      m.Number := N;
      if not Eof(F) then Seek(F,N-1) else m.Number := N+1;
   end;
   write(F,m);
      inc(nummonster);
   Close(F);
end;

procedure monsterSave(var m : tmonsterRec);
var F : file;
begin
   if m.Number < 1 then Exit;
   Assign(F,'monsters.dat');
   {$I-}
   Reset(F,SizeOf(tmonsterRec));
   {$I+}
   if ioResult <> 0 then monsterAdd(m) else
   begin
      Seek(F,m.Number-1);
      Blockwrite(F,monster^,1);
      Close(F);
   end;
end;

function loadmonster(m:tmonsterrec):boolean;
var F : file;
begin
   loadmonster:=true;
   if m.Number < 1 then Exit;
   Assign(F,'monsters.dat');
   {$I-}
   Reset(F,SizeOf(tmonsterRec));
   {$I+}
   if ioResult <> 0 then Exit;
   Seek(F,m.Number-1);
   {$I-}
   BlockRead(F,monster^,1);
   {$I+}
{   if ioresult <> 0 then defaultweapon(w.number);}
   if ioresult <> 0 then begin loadmonster:=false; end else
   Close(F);
end;
procedure monsterdisadvan;
var j:char; quit:BOOLEAN;
begin
   quit:=false;
   repeat
   clrscr;
   if daquaticbreathe in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('1 Can not remain at the surface');
   if dbrightlight in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('2 Disavantaged in bright light');
   if dunderdark in monster^.disadvan then textcolor(15) else textcolor(8);
   cwriteln('3 Must return Underground for some time');
   if dclaustrophobic in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('4 Claustrophobic');
   if dsylvan in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('5 Hates everything except forest');
   if dlimitedair in monster^.disadvan then textcolor(15) else textcolor(8);
      cwriteln('6 Can only remain limited time at the surface');
   if dnomagic in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('7 Partly resistant to magic');
   if dcoldsleep in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('8 Will fall in sleep if dtoo cold');
   if dvsgas in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('9 -2 Malus against Gas attacks');
   if dlarge in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('A Damage received as large');
   if dnolevel in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('B Can not level up');
   if daquaticonly in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('C Can only live in Water');
   if dnoclass in monster^.disadvan then textcolor(15) else textcolor(8); cwriteln('D Can not choose a class');
   repeat
   j:=readkey;
   until upcase(j) in ['1'..'9','A'..'D','Q'];
   case upcase(j) of
   '1' : if daquaticbreathe in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[daquaticbreathe] else
   monster^.disadvan:=monster^.disadvan+[daquaticbreathe];
   '2' : if dbrightlight in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dbrightlight] else
   monster^.disadvan:=monster^.disadvan+[dbrightlight];
   '3' : if dunderdark in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dunderdark] else
   monster^.disadvan:=monster^.disadvan+[dunderdark];
   '4' : if dclaustrophobic in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dclaustrophobic] else
   monster^.disadvan:=monster^.disadvan+[dclaustrophobic];
   '5' : if dsylvan in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dsylvan] else
   monster^.disadvan:=monster^.disadvan+[dsylvan];
   '6' : if dlimitedair in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dlimitedair] else
   monster^.disadvan:=monster^.disadvan+[dlimitedair];
   '7' : if dnomagic in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dnomagic] else
   monster^.disadvan:=monster^.disadvan+[dnomagic];
   '8' : if dcoldsleep in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dcoldsleep] else
   monster^.disadvan:=monster^.disadvan+[dcoldsleep];
   '9' : if dvsgas in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dvsgas] else
   monster^.disadvan:=monster^.disadvan+[dvsgas];
   'A' : if dlarge in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dlarge] else
   monster^.disadvan:=monster^.disadvan+[dlarge];
   'B' : if dnolevel in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dnolevel] else
   monster^.disadvan:=monster^.disadvan+[dnolevel];
   'C' : if daquaticonly in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[daquaticonly] else
   monster^.disadvan:=monster^.disadvan+[daquaticonly];
   'D' : if dnoclass in monster^.disadvan then monster^.disadvan:=monster^.disadvan-[dnoclass] else
   monster^.disadvan:=monster^.disadvan+[dnoclass];
   'Q' : begin monstersave(monster^); quit:=true; end;
   end;
   until quit;
end;


{$I mono.pas}
function attacktype  : string;
begin
case (monster^.atype) of
0: attacktype:='normal';
1: attacktype:='Gas';
2: attacktype:='Cold';
3: attacktype:='Electricity';
4: attacktype:='Acid';
5: attacktype:='Poison';
6: attacktype:='Natural Cold';
7: attacktype:='Light';
8: attacktype:='Sound';
9: attacktype:='Fear';
10:attacktype:='Web';
11:attacktype:='Force';
12:attacktype:='Magical Fire';
13:attacktype:='Silver';
14:attacktype:='Normal Fire';
100: attacktype:='normal, ranged';
101: attacktype:='Gas, ranged';
102: attacktype:='Cold, ranged';
103: attacktype:='Electricity, ranged';
104: attacktype:='Acid, ranged';
105: attacktype:='Poison, ranged';
106: attacktype:='Natural Cold, ranged';
107: attacktype:='Light, ranged';
108: attacktype:='Sound, ranged';
109: attacktype:='Fear, ranged';
110:attacktype:='Web, ranged';
111:attacktype:='Force, ranged';
112:attacktype:='Magical Fire, ranged';
113:attacktype:='Silver, ranged';
114:attacktype:='Normal Fire, ranged';
else attacktype:='error'; end;
end;

function monstertype : string;
begin
case monster^.mtype of
1: monstertype:='Orc';
2: monstertype:='Half-Orc';
3: monstertype:='Goblin';
4: monstertype:='HobGoblins';
5: monstertype:='Kobold';
50: monstertype:='Underground';

100: monstertype:='WoodLand';
101: monstertype:='Ratling';
102: monstertype:='Wolf-Kin';

150: monstertype:='Aquatic';
151: monstertype:='Fish';

200: monstertype:='Dragon';
201: monstertype:='Dragon, Evil';
202: monstertype:='Dragon, Good';
203: monstertype:='Dragon, Neutral';
else monstertype:='error'; end;

end;

procedure editmonstype;
var y:integer;
begin
clrscr;
if monster^.mtype=1 then textcolor(15) else textcolor(8); writeln('1 Orc');
if monster^.mtype=2 then textcolor(15) else textcolor(8); writeln('2 Half-Orc');
if monster^.mtype=3 then textcolor(15) else textcolor(8); writeln('3 Goblin');
if monster^.mtype=4 then textcolor(15) else textcolor(8); writeln('4 HobGoblins');
if monster^.mtype=5 then textcolor(15) else textcolor(8); writeln('5 Kobold');

if monster^.mtype=50 then textcolor(15) else textcolor(8); writeln('50 Underground');

if monster^.mtype=100 then textcolor(15) else textcolor(8); writeln('100 WoodLand');
if monster^.mtype=101 then textcolor(15) else textcolor(8); writeln('101 Ratling');
if monster^.mtype=102 then textcolor(15) else textcolor(8); writeln('102 Wolf-Kin');

if monster^.mtype=150 then textcolor(15) else textcolor(8); writeln('150 Aquatic');
if monster^.mtype=151 then textcolor(15) else textcolor(8); writeln('151 Fish');

if monster^.mtype=200 then textcolor(15) else textcolor(8); writeln('200 Dragon');
if monster^.mtype=201 then textcolor(15) else textcolor(8); writeln('201 Dragon, Evil');
if monster^.mtype=202 then textcolor(15) else textcolor(8); writeln('202 Dragon, Good');
if monster^.mtype=203 then textcolor(15) else textcolor(8); writeln('203 Dragon, Neutral');

readln(sp);
val(sp,monster^.mtype,y);
monstersave(monster^);
end;

procedure editattatype;
var y:integer;
begin
clrscr;
if monster^.atype=0 then textcolor(15) else textcolor(8); writeln('0  Normal');
if monster^.atype=1 then textcolor(15) else textcolor(8); writeln('1  Gas');
if monster^.atype=2 then textcolor(15) else textcolor(8); writeln('2  Cold');
if monster^.atype=3 then textcolor(15) else textcolor(8); writeln('3  Electricity');
if monster^.atype=4 then textcolor(15) else textcolor(8); writeln('4  Acid');
if monster^.atype=5 then textcolor(15) else textcolor(8); writeln('5  Poison');
if monster^.atype=6 then textcolor(15) else textcolor(8); writeln('6  Natural Cold');
if monster^.atype=7 then textcolor(15) else textcolor(8); writeln('7  Light');
if monster^.atype=8 then textcolor(15) else textcolor(8); writeln('8  Sound');
if monster^.atype=9 then textcolor(15) else textcolor(8); writeln('9  Fear');
if monster^.atype=10 then textcolor(15) else textcolor(8); writeln('10 Web');
if monster^.atype=11 then textcolor(15) else textcolor(8); writeln('11 Force');
if monster^.atype=12 then textcolor(15) else textcolor(8); writeln('12 Magical Fire');
if monster^.atype=13 then textcolor(15) else textcolor(8); writeln('13 Silver');
if monster^.atype=14 then textcolor(15) else textcolor(8); writeln('14 Normal Fire');
readln(sp);
val(sp,monster^.atype,y);
cp:=upcase(readkey);
if cp='Y' then inc(monster^.atype,100);
monstersave(monster^);
end;

procedure editmonster;
var s:string; ch:char; y:integer;
begin;

bool:=false;
repeat
loadmonster(monster^);
clrscr;
{move(monster_edit,mem[$b800:0000],2400); textcolor(15);}
gotoxy(10,1); str(monster^.number,s); cwrite(s); textcolor(7); cwrite(' of ');
textcolor(15); str(nummonster,s); cwrite(s);
gotoxy(18,3); cwrite(monster^.name);
gotoxy(18,4); str(monster^.maxhitpoints,s); cwrite(s);
gotoxy(18,5); str(monster^.minhitpoints,s); cwrite(s);
gotoxy(1,11); cwrite('L Level');
gotoxy(18,8); str(monster^.thac0,s); cwrite(s);
gotoxy(18,9); str(monster^.ac,s); cwrite(s);
gotoxy(18,10); str(monster^.xp,s); cwrite(s);
gotoxy(18,11); str(monster^.level,s); cwrite(s);
gotoxy(30,9);  cwrite('V Vs Large Bonus        '); str(monster^.vslarge,s); cwrite(s);
gotoxy(30,10); cwrite('O Number of damage dice '); str(monster^.numberofdmgdice,s); cwrite(s);
gotoxy(30,11); cwrite('P Dice type             '); str(monster^.dicetype,s); cwrite(s);
gotoxy(30,8);  cwrite('R Selectable?           '); if monster^.select then cwrite('Yup!') else cwrite('Nope!');
gotoxy(30,7);  cwrite('C Speed                 '); str(monster^.speed,s); cwrite(s);
gotoxy(30,6);  cwrite('1 Monster Type          '); cwrite(monstertype);
gotoxy(30,5);  cwrite('2 Attack Type           '); cwrite(attacktype);
gotoxy(30,4);  cwrite('3 Range                 '); str(monster^.range,s); write(s);
repeat
ch:=readkey;
until upcase(ch) in ['N','M','I','T','A','D','X','[',']','Q','L','O','P','V','R','#','-','C','1','2','3'];
case upcase(ch) of
'-': begin dec(monster^.number); loadmonster(monster^); inc(monster^.number); monstersave(monster^); end;
'1': begin monstersave(monster^); editmonstype; end;
'2': begin monstersave(monster^); editattatype; end;
'3': begin readln(s); val(s,monster^.range,y); monstersave(monster^); end;
'N': begin readln(monster^.name); monstersave(monster^); end;
'M': begin readln(s); val(s,monster^.maxhitpoints,y); monstersave(monster^); end;
'I': begin readln(s); val(s,monster^.minhitpoints,y); monstersave(monster^); end;
'T': begin readln(s); val(s,monster^.thac0,y); monstersave(monster^);end;
'A': begin readln(s); val(s,monster^.ac,y); monstersave(monster^);end;
{'S': begin monstersave(monster^); monsterskills; end;}
'C': begin readln(s); val(s,monster^.speed,y); monstersave(monster^); end;
'D': begin monstersave(monster^); monsterdisadvan; end;
'X': begin readln(s); val(s,monster^.xp,y) ;monstersave(monster^); end;
'L': begin readln(s); val(s,monster^.level,y) ;monstersave(monster^); end;
'O': begin readln(s); val(s,monster^.numberofdmgdice,y); monstersave(monster^);end;
'P': begin readln(s); val(s,monster^.dicetype,y); monstersave(monster^);end;
'V': begin readln(s); val(s,monster^.vslarge,y); monstersave(monster^);end;
'[': begin gotoxy(1,12); dec(monster^.number); if monster^.number=0 then inc(monster^.number);
           loadmonster(monster^); end;
']': begin gotoxy(1,13); inc(monster^.number); if monster^.number=0 then dec(monster^.number);
           if not loadmonster(monster^) then begin defaultmonster(monster^.number); monsteradd(monster^); end; end;
'Q': bool:=true;
'R': begin monster^.select:=not monster^.select; monstersave(monster^); end;
'#': begin readln(s); val(s,monster^.number,y); if not loadmonster(monster^) then monster^.number:=1; end;
end;
until bool;
end;

procedure menu1;
var ch:char;
begin
clrscr;
textcolor(14); cwrite('A'); textcolor(13); cwriteln(' Armor editor');
textcolor(14); cwrite('W'); textcolor(13); cwriteln(' Weapon editor');
textcolor(14); cwrite('I'); textcolor(13); cwriteln(' Item editor');
textcolor(14); cwrite('M'); textcolor(13); cwriteln(' Monster editor');
textcolor(14); cwrite('R'); textcolor(13); cwriteln(' Room editor');
textcolor(14); cwrite('E'); textcolor(13); cwriteln(' Event editor');

cwriteln('');
{textcolor(14); cwrite('D'); textcolor(13); cwriteln(' Reset to scratch');}
textcolor(14); cwrite('Q'); textcolor(13); cwriteln(' Quit');
{textcolor(13); cwrite('K'); textcolor(13); cwriteln(' Show map');}
repeat
ch:=readkey;
until upcase(ch) in ['A','W','R','Q','M','I','E','L'];
case upcase(ch) of
'A': begin armor^.number:=1;editarmor;menu1; end;
'W': begin weapon^.number:=1;editweapon;menu1; end;
'R': begin room^.number:=1;editroom;menu1; end;
'M': begin monster^.number:=1;editmonster;menu1; end;
'E': begin event^.number:=1; editevent; menu1; end;
'I': begin item^.number:=1;edititem; menu1; end;
'Q': halt(0);
end;
end;

begin
new(armor);
new(weapon);
new(room);
new(item);
new(monster);
new(event);
defaultevent(1);
resetweapon;
resetarmor;
defaultmonster(1);
defaultitem(1);
{detnum;}
clrscr;
menu1;
dispose(room);
dispose(armor);
dispose(weapon);
dispose(item);
dispose(monster);
dispose(event);
textcolor(7);
end.