program convert;

uses crt, {$IFDEF LINUX}linux{$ELSE}dos{$ENDIF}, strings;

{$I mudvar.pas}
procedure saveroom(r:troomrec);
{Note that ideally it should save to another file that should be deleted in resets.
This procedure is used when building a city}
var F : file;
begin
   if r.Number < 1 then Exit;
   Assign(F,'rooms.dat');
   {$I-}
   Reset(F,SizeOf(troomRec));
   {$I+}
   if ioResult <> 0 then begin writeln('MAJOR PROBLEM'); halt(255); end else
   begin
      Seek(F,r.Number-1);
      Blockwrite(F,room^,1);
      Close(F);
   end;
end;

function St(N : LongInt) : String;
var S : String;
begin
   System.Str(N, S);
   St := S;
end;

procedure loadroom(r:troomrec);
var {$IFDEF LINUX}f:longint; bool:boolean; {$ELSE}f:file;{$ENDIF}
begin

   if r.Number < 1 then
   begin
     room^.number:=0;
     room^.name:='';
     exit;
   end;
   {$IFDEF LINUX}
   f := fdopen ('rooms.dat', open_rdonly);
   if f <> 0 then Exit;
   fdSeek(F,(r.Number-1) * sizeof (troomrec), seek_set);
   fdRead(F,r,sizeof (troomrec));
   fdClose(F);
   {$ELSE}
   Assign(F,'rooms.dat');
   {$I-}
   Reset(F,SizeOf(troomRec));
   {$I+}
   if ioResult <> 0 then Exit;
   {numroom := FileSize(F);}

   Seek(F,r.Number-1);
   {$I-}
   BlockRead(F,room^,1);
   {$I+}
   Close(F);
   {$ENDIF}
end;
function StrToInt(S : String) : LongInt;
var i : LongInt;
    j : Integer;
begin
  Val(S,I,J);
  StrToInt := i;
  if (s = '') then StrToInt := 0;
end;

var numroom:word;
    direction:boolean;
    x:word;
    y:word;
    b:byte;
    tempstr:array [1..26] of char;
    tempstr2:string[26];
    line:string;
    ch:char;
var fr:file of troomrec;
    t:text;

begin
new(room);
numroom:=0;
assign(fr,'rooms.dat');
{$I-}
reset(fr);
{$I+}
if ioresult = 0 then begin
while not EOF(Fr) do begin read(fr,room^); inc(numroom); end;
close(fr);
end;

  writeln ('Conversion a un fichier texte?');
  direction := upcase (readkey) = 'Y';
  if direction then
  begin
    if (numroom = 0) then begin writeln('No data to convert!'); halt(255); end;
    assign (t, 'room.txt');
    rewrite(t);
    for x:=1 to numroom do
    begin
      gotoxy(1,wherey);
      write (st(x)+'/'+st(numroom));
      room^.number:=x;
      loadroom (room^);
      writeln(t, st(room^.number));
      writeln(t, room^.name);
      writeln(t, st(room^.event));
      writeln(t, st(room^.critter));
      writeln(t, st(room^.critterlevel));

      for b:=1 to 26 do
        if chr(b+ord('A')) in room^.flag then tempstr [b] := chr(b+ord('A')) else tempstr[b] := '0';
      writeln(t, tempstr);
      if room^.hardcodedspecial then writeln(t, 'True') else writeln(t,'False');
      for y:=1 to 6 do writeln(t, st(room^.connect[y]));
      for y:=1 to 7 do writeln(t, room^.desc[y]);
      writeln(t,st(room^.monsterchance));
      if room^.needillumination then writeln(t, 'True') else writeln(t,'False');
      if room^.cleartext then writeln(t, 'True') else writeln(t,'False');
      writeln(t,st(room^.terrain));
      if room^.igm then writeln(t, 'True') else writeln(t,'False');
      writeln(t,st(room^.igmconnect));
      writeln(t,room^.igmext);
      writeln(t,st(room^.circle));
      writeln(t,st(room^.city));
    end;
    close(t);
  end else
  begin
    assign (t, 'room.txt');
    {$I-}
    reset(t);
    {$I+}
    if ioresult <>0 then begin writeln('Data file not found'); halt(255); end;

    while not eof (t) do
    begin
      fillchar(room^, sizeof(room^), 0);
      readln(t, line);
      room^.number:=strtoint (line);
      readln(t, line);
      room^.name:=line;
      readln(t, line);
      room^.event:=strtoint(line);
      readln(t, line);
      room^.critter := strtoint(line);
      readln(t, line);
      room^.critterlevel := strtoint(line);

      readln(t,tempstr2);

      for b:=1 to 26 do
      begin
        if tempstr2 [b]<> '0' then room^.flag := room^.flag + [tempstr2[b]];
      end;
      {BOOKMARK!}
      readln(t,line);
      if line = 'True' then room^.hardcodedspecial:=true else room^.hardcodedspecial:=false;

      for y:=1 to 6 do begin readln(t, line); room^.connect[y]:=strtoint(line); end;
      for y:=1 to 7 do begin readln(t, room^.desc[y]); end;
      readln(t,line);
      room^.monsterchance:=strtoint(line);
      readln(t,line);
      if line = 'True' then room^.needillumination:=true else room^.needillumination:=false;
      readln(t,line);
      if line = 'True' then room^.cleartext:=true else room^.cleartext:=false;
      readln(t,line);
      room^.terrain:=strtoint(line);
      readln(t,line);
      if line = 'True' then room^.igm:=true else room^.igm:=false;

      readln(t,line);
      room^.igmconnect:=strtoint(line);
      readln(t,room^.igmext);

      readln(t,line);
      room^.circle:=strtoint(line);
      readln(t,line);
      room^.city:=strtoint(line);
      saveroom(room^);
    end;

    close(t);
  end;


end.
