{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit ChatMode;

interface

procedure chatBeep;
procedure chatNormal;
procedure chatPage(Matrix : Boolean);
procedure chatSplitScreen;

implementation

uses
   Crt, Global, Comm, Output, Input, StrProc, ShowFile, Emulate,
   Logs, Misc, DateTime, Email, Doors;

procedure chatNormal;
const
   maxLineLen = 80;
var
   WordLine  : String[maxLineLen];
   Index1    : Byte;
   Index2    : Byte;
   InputChar : Char;
   Ok, Down  : Boolean;
   Done      : Boolean;
   dt1,dt2,dt3
             : DateTimeRec;
   S, P      : String;

begin
begin
   ChatModeOn := True;
   emuScreenToANSi(1);
   logWrite('*Chat mode initiated');
   if Cfg^.LogLineChat then
   begin
      logChatWrite('');
      logChatWrite('-- Line chat with user: '+User^.Username+' ('+User^.RealName+')');
      logChatWrite('   at '+dtTimeStr12+', '+dtDateString);
      logChatWrite(sRepeat('',79));
   end;
   dtGetDateTime(dt1);
   WordLine  := '';
   Index1    := 0;
   Index2    := 0;
   InputChar := ' ';
   oStringLn(strChatInitiate);
   oSetCol(colInfo);
   Done      := False;
   mCursor(True);
   repeat
      InputChar := iReadKey;
      if extKey <> #0 then
      case extKey of
         AltC : if LocKey then Done := True;
         LfArrow  : oMoveLeft(1);
         RtArrow  : oMoveRight(1);
         DnArrow  : oMoveDown(1);
         UpArrow  : oMoveUp(1);
      end else
      if (InputChar = #8) and (Length(WordLine) > 0) then
      begin
         oBackspace(' ');
         Delete(WordLine,Length(WordLine),1)
      end else
      if InputChar = #13 then
      begin
         if Cfg^.LogLineChat then logChatWrite(WordLine);
         Ok := True;
         Down := True;
         if (Length(WordLine) >= 2) and (WordLine[1] = '/') then
         begin
            S := CleanUp(UpStr(Copy(WordLine,2,255)));
            if Pos(' ',S) > 0 then
            begin
               P := Copy(S,Pos(' ',S)+1,255);
               Delete(S,Pos(' ',S),255);
            end else P := '';
            if {(acsOk(cfg^.acsSysop)) or} (locKey) then
            begin
               if (S = 'TYPE') and (P <> '') then begin oDnLn(1); sfShowTextFile(P,ftNormal) end else
{               if (S = 'SEND') and (P <> '') then xferSend(P,[protActive],False) else
               if (S = 'RECEIVE') and (P <> '') then xferReceive(P,[protActive]) else}
               if (S = 'ACS') and (P <> '') then
               begin
                  oMoveLeft(maxLineLen);
                  if acsOk(P) then oStrLn('|U2-- |U1Access |U3ok|U2.') else
                                   oStrLn('|U2-- |U1Access |U3denied|U2.');
                  Down := False;
               end;
            end;
            if S = 'PAGE' then begin chatBeep; oWriteRem(#7#7); end else
{            if S = 'TETRIS' then itPlayTetris else}
            if S = 'TIME' then
            begin
               oMoveLeft(maxLineLen);
               dtGetDateTime(dt2);
               dtTimeDiff(dt3,dt1,dt2);
                oStrLn('|U2-- |U1Current time|U2: |U3'+dtTimeStr12+'|U2, |U1date|U2: |U3'+dtDateString);
               oStrLn('   |U1Chatting for|U2: |U3'+dtTimeRecStr(dt3));
               Down := False;
            end else
            if S = 'CLS' then begin Down := False; oClrScr; end else
            if S = 'BYE' then HangUp := True else
            if (S = 'Q') or (S = 'QUIT') then Done := True else
            if (S = '?') or (S = 'HELP') then sfShowTextFile(txChatHelp,ftNormal);
         end;
         if Down then oDnLn(1);
         if Ok then WordLine := '';
      end else if not (InputChar in [#0..#31,#255]) then
      begin
        if LocKey then oSetCol(colInfoHi) else oSetCol(colInfo);
        oWriteChar(InputChar);
        WordLine := (WordLine+InputChar);
        if (Length(WordLine) >= (maxLineLen-1)) then
        begin
           Index1 := (maxLineLen-1);
           while ((WordLine[Index1] <> ' ') and (WordLine[Index1] <> '-')
                 and (Index1 <> 0)) do Dec(Index1);
           if (Index1 = 0) then Index1 := (maxLineLen - 1);
           if Cfg^.LogLineChat then logChatWrite(Copy(WordLine,1,Index1));
           Delete(WordLine,1,Index1);
           for Index2 := 1 to Length(WordLine) do oBackspace(' ');
           oDnLn(1);
           oWrite(WordLine);
        end;
      end;
   until (HangUp) or (Done);
   if (Cfg^.LogLineChat) and (WordLine <> '') then logChatWrite(WordLine);
   ChatModeOn := False;
   dtGetDateTime(dt2);
   dtTimeDiff(dt3,dt1,dt2);
{   if Cfg^.RestoreChatTime then} timeFree := timeFree+dtDateToReal(dt3);
   logWrite('*Chat mode terminated.');
   if Hangup then Exit;
   oStringLn(strChatTerminate);
   emuANSitoScreen(1);
end;
end;
procedure chatSplitScreen;
type
   tWindow = record
      x1,y1,x2,y2,x,y : Byte;
      Col : tColorRec;
      Word : String;
   end;
var
   InputChar   : Char;
   A           : Byte;
   Key         : Byte;
   Des         : Boolean;
   Win         : array[1..2] of tWindow;
   oldPos      : Pointer;
   dt1,dt2,dt3 : DateTimeRec;
 procedure CheckWindows;
 begin
    if (Key <> A) then
    begin
       A := Key;
       oGotoXY(Win[A].x1+Win[A].x-1,Win[A].y1+Win[A].y-1);
       oSetColRec(Win[A].Col);
    end;
 end;
 procedure ClearWin(Z : Byte);
 var N : Byte; S : String;
 begin
    S := '';
    for N := Win[Z].x1 to Win[Z].x2 do S := S + ' ';
    for N := Win[Z].y1 to Win[Z].y2 do
    begin
       oGotoXY(Win[Z].x1,N);
       oWrite(S);
    end;
    oGotoXY(Win[Z].x1,Win[Z].y1);
    Win[Z].x := 1; Win[Z].y := 1;
    if Des then Win[Z].Word := '';
    A := Z;
 end;
 procedure LogWord(A : Byte; X : String);
 var S : String;
 begin
    case A of 1: S := Cfg^.SysOpname; 2: S := User^.UserName; end;
    if S = '' then S := '??';
    if Cfg^.LogSplitChat then logChatWrite(mInitials(S)+'> '+X);
 end;

 procedure DoEnter(reDraw : Boolean);
 var S : String;
 begin
    CheckWindows;
    Inc(Win[A].y,1);
    Win[A].x := 1;
   {if Win[A].x > Win[A].x2-Win[A].x1 then DoEnter;}
    if Win[A].y > Win[A].y2-Win[A].y1+1 then
    begin
       S := Win[A].Word;
       ClearWin(A);
       if (reDraw) and (CleanUp(S) <> '') then
       begin
          oCWrite(S);
          Win[A].y := 2;
          Win[A].x := 1;
       end;
    end;
    if des then Win[A].Word := '';
    oGotoXY(Win[A].x1+Win[A].x-1,Win[A].y1+Win[A].y-1);
 end;
 procedure WriteIt(S : String);
 begin
    CheckWindows;
    oCWrite(S);
    Inc(Win[A].x,Length(S));
 end;
 procedure DoBackspace;
 begin
    CheckWindows;
    if Length(Win[A].Word) < 1 then Exit;
    oBackspace(' ');
    if des then Delete(Win[A].Word,Length(Win[A].Word),1);
    Dec(Win[A].x);
 end;
 procedure CheckWrap;
 var Mx, Z, V : Byte;
 begin
    Win[A].Word := (Win[A].Word+InputChar);
    Mx := Win[A].x2-Win[A].x1;
    if (Length(Win[A].Word) >= (Mx-1)) then
    begin
       Des := False;
       Z := (Mx-1);
       while (not (Win[A].Word[Z] in [' ','-'])) and (Z <> 0) do Dec(Z,1);
       if Z = 0 then Z := Mx-1;
       LogWord(A,Copy(Win[A].Word,1,Z));
       Delete(Win[A].Word,1,Z);
       for V := 1 to Length(Win[A].Word) do DoBackspace;
       DoEnter(False);
       WriteIt(Win[A].Word);
       Des := True;
    end;
 end;
begin
   if sfGetTextFile(txChatMode,ftChatMode) = '' then
   begin
      logWrite('xSplit-screen chat attempted, but template did not exist.');
      chatNormal;
      Exit;
   end;

   if Cfg^.LogSplitChat then
   begin
      logChatWrite('');
      logChatWrite('-- SplitScreen chat with user: '+User^.Username+' ('+User^.RealName+')');
      logChatWrite('   at '+dtTimeStr12+', '+dtDateString);
      logChatWrite(sRepeat('',79));
   end;
   dtGetDateTime(dt1);

   GetMem(oldPos,SizeOf(sfPos));
   Move(sfPos,oldPos^,SizeOf(sfPos));

   ChatModeOn := True;
   emuScreenToANSi(1);
   InputChar  := #0;

   sfShowTextFile(txChatMode,ftChatMode);

   A          := 1;
   fillchar(win, sizeof(win), 0); {dink}
   des:=true;
   Win[1].x1  := sfPos[1].X;
   Win[1].y1  := sfPos[1].Y;
   Win[1].x2  := sfPos[2].X;
   Win[1].y2  := sfPos[2].Y;
   Win[1].Col := sfPos[1].C;
   Win[1].x   := 1;
   Win[1].y   := 1;

   Win[2].x1  := sfPos[3].X;
   Win[2].y1  := sfPos[3].Y;
   Win[2].x2  := sfPos[4].X;
   Win[2].y2  := sfPos[4].Y;
   Win[2].Col := sfPos[3].C;
   Win[2].x   := 1;
   Win[2].y   := 1;

   ClearWin(2);
   ClearWin(1);
   oSetColRec(Win[A].Col);
   mCursor(True);
   repeat
      InputChar := iReadKey;
      if LocKey then Key := 1 else Key := 2;
      if extKey = #0 then
      case InputChar of
          #32..#254 : begin
             CheckWindows;
             WriteIt(InputChar);
             CheckWrap;
          end;
          #8  : DoBackspace;
          #13 : begin
             LogWord(Key,Win[Key].Word);
             DoEnter(True);
          end;
          else cCheckUser;
      end;
   until (HangUp) or ((locKey) and (extKey = altc));
   if Win[1].Word <> '' then LogWord(1,Win[1].Word) else
   if Win[2].Word <> '' then LogWord(2,Win[2].Word);
   ChatModeOn := False;
   dtGetDateTime(dt2);
   dtTimeDiff(dt3,dt1,dt2);
{   if Cfg^.RestoreChatTime then} timeFree := timeFree+dtDateToReal(dt3);
   Move(oldPos^,sfPos,SizeOf(sfPos));
   FreeMem(oldPos,SizeOf(sfPos));
   logWrite('*Split-screen chat terminated.');
   if Hangup then Exit;
   emuANSitoScreen(1);
end;

procedure chatBeep;
var Z : Word;
begin
   for Z := 32 downto 1 do
   begin
      playsound(Z*100,5);
      playsound(Z*60,4);
   end;
   for Z := 1 to 15 do
   begin
      playsound(Z*40,3);
      playsound(Z*80,4);
      playsound(Z*70,2);
   end;
   for Z := 15 downto 1 do
   begin
      playsound(Z*20,3);
      playsound(Z*40,1);
      playsound(Z*50,2);
   end;
   Delay(80);
   for z := 2000 downto 1500 do if z mod 10 = 0 then
      playsound(z,1);
   Delay(80);
   for z := 2000 downto 1500 do if z mod 20 = 0 then
      playsound(z,1);
   Delay(80);
end;

procedure chatPage(Matrix : Boolean);
begin
end;

end.
