{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit armors;

interface
uses global;
function loadarmor(a:tarmorrec) : boolean;

implementation

{$IFDEF LINUX} uses linux; {$ENDIF}

function loadarmor(a:tarmorrec) : boolean;
{$IFNDEF LINUX}
var F : file;
begin
   loadarmor := False;
   if a.Number < 1 then begin armor^.number:=0; armor^.name:='No Armor';
   armor^.acprot:=0; armor^.flag:=[]; armor^.value:=0; Exit; end;
   Assign(F,'armors.dat');
   {$I-}
   Reset(F,SizeOf(tarmorRec));
   {$I+}
   if ioResult <> 0 then Exit;
   numarmor := FileSize(F);
   Seek(F,a.Number-1);
   {$I-}
   BlockRead(F,armor^,1);
   {$I+}
   loadarmor := ioResult = 0;
   Close(F);
{$ELSE}
var Fd : longint;
begin
   loadarmor := False;
   if a.Number < 1 then Exit;
   fd := fdopen ('armors.dat', open_rdonly);
   if fd <> 0 then Exit;
   fdSeek(Fd,(a.Number-1) * sizeof (tarmorrec), seek_set);
   loadarmor := fdRead(Fd,a,sizeof (tarmorrec)) = sizeof (tarmorrec);
   fdClose(Fd);

{$ENDIF}
end;

end.
