/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.time;

import java.util.Date;

/**
 * Time manipulation utility methods.
 * 
 * @author Christos KK Loverdos
 *
 */
public final class TimeUtil
{
    private TimeUtil() {}

    public static String timeInfo(long millis)
    {
        long seconds = millis / 1000L;
        millis -= seconds * 1000L;
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;

        StringBuffer sb = new StringBuffer();
        if(days > 0)
        {
            sb.append(days);
            sb.append(' ');
            sb.append("day");
            if(days > 1)
            {
                sb.append('s');
            }
            sb.append(", ");
        }

        if(hours < 10)
        {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');

        if(minutes < 10)
        {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');

        if(seconds < 10)
        {
            sb.append('0');
        }
        sb.append(seconds);
        sb.append('.');

        if(millis < 100)
        {
            sb.append('0');
            if(millis < 10)
            {
                sb.append('0');
            }
        }
        sb.append(millis);

        return sb.toString();
    }

    public static long datePlusDays(long millis, long days)
	{
		return millis + 1000L * 60 * 60 * 24 * days;  
	}
	
	public static long datePlusHours(long millis, long hours)
	{
		return millis + 1000L * 60 * 60 * hours;  
	}
	
	public static long datePlusMinutes(long millis, long minutes)
	{
		return millis + 1000L * 60 * minutes;  
	}
	
	public static long dateMinusDays(long millis, long days)
	{
		return millis - 1000L * 60 * 60 * 24 * days;  
	}
	
	public static long dateMinusHours(long millis, long hours)
	{
		return millis - 1000L * 60 * 60 * hours;  
	}
	
	public static long dateMinusMinutes(long millis, long minutes)
	{
		return millis - 1000L * 60 * minutes;  
	}
	/////////////////
	public static long nowPlusDays(long days)
	{
		return System.currentTimeMillis() + 1000L * 60 * 60 * 24 * days;  
	}
	
	public static long nowPlusHours(long hours)
	{
		return System.currentTimeMillis() + 1000L * 60 * 60 * hours;  
	}
	
	public static long nowPlusMinutes(long minutes)
	{
		return System.currentTimeMillis() + 1000L * 60 * minutes;  
	}
	
	public static long nowMinusDays(long days)
	{
		return System.currentTimeMillis() - 1000L * 60 * 60 * 24 * days;  
	}
	
	public static long nowMinusHours(long hours)
	{
		return System.currentTimeMillis() - 1000L * 60 * 60 * hours;  
	}
	
	public static long nowMinusMinutes(long minutes)
	{
		return System.currentTimeMillis() - 1000L * 60 * minutes;  
	}
	////////////
	public static long now()
	{
		return System.currentTimeMillis();
	}
	
	public static Date nowDate()
	{
		return new Date();
	}
	
	public static Date nowSqlDate()
	{
		return new java.sql.Date(now());
	}
	
	public static long today()
	{
		return System.currentTimeMillis();
	}
	
	public static Date todayDate()
	{
		return new Date();
	}
	
	public static Date todaySqlDate()
	{
		return new java.sql.Date(now());
	}

	public static long yesterday()
	{
		return nowMinusDays(1);
	}
	
	public static Date yesterdayDate()
	{
		return new Date(yesterday());
	}
	
	public static java.sql.Date yesterdaySqlDate()
	{
		return new java.sql.Date(yesterday());
	}
	
	public static long tomorrow()
	{
		return nowPlusDays(1);
	}
	
	public static Date tomorrowDate()
	{
		return new Date(tomorrow());
	}
	
	public static Date tomorrowSqlDate()
	{
		return new java.sql.Date(tomorrow());
	}

    /*
    public static String formatDateTime(long millis)
	{
		return formatDateTime(millis, "-", ":", " ");
	}
	
	public static String formatDateTime(Date date)
	{
		return formatDateTime(date.getTime());
	}

    public static String formatDateTime(long millis, String dateDelim, String dateTimeDelim, String timeDelim)
	{
		StringBuilder sb = new StringBuilder();
		sb.append("%1$tY");
		sb.append(dateDelim);
		sb.append("%1$tm");
		sb.append(dateDelim);
		sb.append("%1$td");
		sb.append(dateTimeDelim);
		sb.append("%1$tH");
		sb.append(timeDelim);
		sb.append("%1$tM");
		sb.append(timeDelim);
		sb.append("%1$tS");
		return String.format(sb.toString(), millis);
	}
	
	public static String formatDateTime(Date date, String dateDelim, String dateTimeDelim, String timeDelim)
	{
		return formatDateTime(date.getTime(), dateDelim, dateTimeDelim, timeDelim);
	}
	
	public static String formatDate(long millis, String dateDelim)
	{
		StringBuilder sb = new StringBuilder();
		sb.append("%1$tY");
		sb.append(dateDelim);
		sb.append("%1$tm");
		sb.append(dateDelim);
		sb.append("%1$td");
		return String.format(sb.toString(), millis);
	}
	
	public static String formatDate(Date date, String dateDelim)
	{
		return formatDate(date.getTime(), dateDelim);
	}
	
	public static String formatTime(long millis, String timeDelim)
	{
		StringBuilder sb = new StringBuilder();
		sb.append("%1$tH");
		sb.append(timeDelim);
		sb.append("%1$tM");
		sb.append(timeDelim);
		sb.append("%1$tS");
		return String.format(sb.toString(), millis);
	}
	
	public static String formatTime(Date date, String timeDelim)
	{
		return formatTime(date.getTime(), timeDelim);
	}
	*/
}
