/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.string;

/**
 * Helper subclass of {@link org.ckkloverdos.string.ToString} to handle key-value pairs.
 *
 * @author Christos KK Loverdos
 *
 */
public class KVToString extends ToString
{
	public KVToString()
	{
		this(false);
	}

	public KVToString(boolean multiline)
	{
		super(null, multiline);
	}

	public KVToString(String k, Object v)
	{
		this();
		add(k, v);
	}

    public KVToString(String k, boolean v)
	{
		this();
		add(k, v);
	}

    public KVToString add(String k1, Object v1, String k2, Object v2)
	{
		add(k1, v1);
		add(k2, v2);
		return this;
	}
	public KVToString(String k1, Object v1, String k2, Object v2)
	{
		this();
		add(k1, v1, k2, v2);
	}

	public KVToString add(String k1, Object v1, String k2, Object v2, String k3, Object v3)
	{
		add(k1, v1);
		add(k2, v2);
		add(k3, v3);
		return this;
	}

	public KVToString(String k1, Object v1, String k2, Object v2, String k3, Object v3)
	{
		this();
		add(k1, v1, k2, v2, k3, v3);
	}

	public KVToString add(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4)
	{
		add(k1, v1);
		add(k2, v2);
		add(k3, v3);
		add(k4, v4);
		return this;
	}

	public KVToString(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4)
	{
		this();
		add(k1, v1, k2, v2, k3, v3, k4, v4);
	}

	public KVToString add(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5)
	{
		add(k1, v1);
		add(k2, v2);
		add(k3, v3);
		add(k4, v4);
		add(k5, v5);
		return this;
	}

	public KVToString add(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6)
	{
		add(k1, v1);
		add(k2, v2);
		add(k3, v3);
		add(k4, v4);
		add(k5, v5);
		add(k6, v6);
		return this;
	}

	public KVToString(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5)
	{
		this();
		add(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
	}

	public KVToString(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6)
	{
		this();
		add(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
	}
}

