/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.source;

import org.ckkloverdos.io.IOUtil;

import java.io.File;
import java.io.IOException;

/**
 * Utility methods for sources.
 * 
 * @author Christos KK Loverdos
 */
public final class SourceUtil
{
    private SourceUtil() {}

    public static SourceType getFileSourceType(File file, SourceTypeRegistry r) throws IOException
    {
        String ext = IOUtil.getFileExtension(file);
        return r.getTypeFromExt(ext);
    }

    public static SourceType getFileSourceType(String filename, SourceTypeRegistry r) throws IOException
    {
        String ext = IOUtil.getFileExtension(filename);
        return r.getTypeFromExt(ext);
    }
}