/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.source;

/**
 * Sample static {@link org.ckkloverdos.source.SourceTypeRegistry} singleton.
 *
 * @author Christos KK Loverdos
 *
 * @see org.ckkloverdos.source.SourceTypeRegistry
 */
public final class SourceTypes
{
    private static final SourceTypeRegistry r = new SourceTypeRegistry();

    public static final SourceType JAR = r.register("JAR", "jar");
    public static final SourceType CLASS = r.register("CLASS", ".class");
    
    public static final SourceType TXT = r.register("text/plain", "txt");
    public static final SourceType XML = r.register("text/xml", "xml");

    private SourceTypes()
    {
    }

    public static SourceTypeRegistry getRegistry()
    {
        return r;
    }

    public static SourceType register(String name, String ext)
    {
        return register(name, new String[]{ext});
    }

    public static SourceType register(String name, String[] ext)
    {
        return r.register(name, ext);
    }
}