/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.source;

import org.ckkloverdos.util.ClassUtil;

import java.io.IOException;

/**
 * An implementation of {@link org.ckkloverdos.source.ISource} for which the
 * source contents come from a named resource.
 * 
 * @author Christos KK Loverdos
 *
 * @see Class#getResource(String)
 * @see org.ckkloverdos.util.ClassUtil#getFileOrResource(String) 
 */
public class RcSource extends SourceSkeleton
{
    public RcSource(String name, SourceTypeRegistry r) throws IOException
    {
        this(name, SourceUtil.getFileSourceType(name, r));
    }

    public RcSource(String name, SourceType type) throws IOException
    {
        super(name, type, ClassUtil.getFileOrResourceAsStream(name));
        setValid(null != is);
    }
}