/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * A {@link java.io.File}- based source implementation.
 *
 * <p/>
 * In the {@link #FileSource(java.io.File, SourceTypeRegistry) constructor} with a
 * {@link org.ckkloverdos.source.SourceTypeRegistry}, the registry is used to obtain the
 * {@link org.ckkloverdos.source.SourceType} from the file's extension.
 *
 * @author Christos KK Loverdos
 *
 */
public class FileSource extends SourceSkeleton
{
    public FileSource(File file, SourceTypeRegistry r) throws IOException
    {
        this(file, SourceUtil.getFileSourceType(file, r));
    }

    public FileSource(File file, SourceType type) throws FileNotFoundException
    {
        super(file.getName(), type, new FileInputStream(file));
        this.valid = file.isFile();
    }
}