/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.hint;

/**
 * Generic marker interface to be used for hints.
 *
 * <p/>
 * A hint is a generic parameter to be passed to methods and used
 * according to context. Its role is to generalize the behaviour
 * of the method. Usually, a method will have a hint as the last
 * parameter.
 * I think of the support for hints as a <em>micro-pattern</em>.
 *
 * <p/>
 * An implementation supporting hints, should specify the exact semantics.
 * 
 * <p/>
 * It is noted that not all hints must implement this interface.
 * It is only provided for implementation convenience.
 * 
 * @author Christos KK Loverdos
 *
 * @see org.ckkloverdos.hint.BinaryHint
 * @see org.ckkloverdos.filter.IFilter
 * @see org.ckkloverdos.filter.IFilter#accept(Object, Object)
 * @see org.ckkloverdos.filter.AndFilter#accept(Object, Object)
 */
public interface IHint
{
}
