/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.error;

import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.util.Util;

/**
 * An implementation of {@link org.ckkloverdos.error.IErrorHandler}
 * that delegates to {@link StdLog}.
 * 
 * @author Christos KK Loverdos
 */
public class StdLogErrorHandler implements IErrorHandler
{
    public boolean handleError(Throwable t, Object where, Object problematic, Object hints)
    {
        ToString ts = new ToString(this, true);

        if(null != t)
        {
            ts.add("error", t.getClass().getName());
            ts.addIf("errorMsg", t.getMessage(), !Util.emptySafe(t.getMessage()));
        }

        ts.addIfNotNull("where", where);
        ts.addIfNotNull("problematic", problematic);
        ts.addIfNotNull("hints", hints);

        if(null != t)
        {
            ts.add("trace", Util.getStackTrace(t));
        }

        System.out.println(ts);
        return true;
    }
}
