/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos;

import org.ckkloverdos.string.ToString;

/**
 * Exception subclass accepting {@link ToString} in the constructors.
 * 
 * @author Christos KK Loverdos
 */
public class ToStringException extends Exception
{
    private static final long serialVersionUID = -6112069311668375648L;

    public ToStringException()
    {
    }

    public ToStringException(String message)
    {
        super(message);
    }

    public ToStringException(ToString message)
    {
        super(message.toString());
    }

    public ToStringException(Throwable cause)
    {
        super(cause);
    }

    public ToStringException(String message, Throwable cause)
    {
        super(message, cause);
    }

    public ToStringException(ToString message, Throwable cause)
    {
        super(message.toString(), cause);
    }
}
